#ifndef __SMSLIDER

#define __SMSLIDER

#include <math.h>

class Slider
{
public:
  void  Start(float fTime, bool bFadeIn=true);
  bool  GetValue(float fTime, float* fOut);   

protected:
  bool  m_bFadeIn;
  float m_fStartTime;
};

class LinearSlider : public Slider
{
public:
  void  Init    (float fLength, bool bFadeIn=true)
  {
    m_fLength=fLength;
    m_bFadeIn=bFadeIn;
  }

  void  Start   (float fTime)
  {
    m_fStartTime=fTime;
  }

  bool  GetAbsValue(float fTime, float* fOut)
  {
    *fOut=(fTime-m_fStartTime)/m_fLength;
    return true;
  }

  bool  GetValue(float fTime, float* fOut)
  {
    if (fTime>=m_fStartTime+m_fLength)
    {
      *fOut=m_bFadeIn?1.0f:0.0f;
      return false;
    }
    else
    {
      *fOut=(fTime-m_fStartTime)/m_fLength;
      if (!m_bFadeIn) *fOut=1.0f-*fOut;
      return true;
    }
  }

//protected:
  float m_fLength;
};


class ExpSlider : public Slider
{
public:
  void  Init    (float fLength, bool bFadeIn=true)
  {
    m_fLength=fLength;
    m_bFadeIn=bFadeIn;
  }

  void  Start   (float fTime)
  {
    m_fStartTime=fTime;
  }

  bool  GetValue(float fTime, float* fOut)
  {
    if (fTime>=m_fStartTime+m_fLength || m_fLength==0.0f)
    {
      *fOut=m_bFadeIn?1.0f:0.0f;
      return false;
    }
    else
    {      
      *fOut=1.0f/(1.0f+(float)expf(-(3.0f*(-0.15f+(fTime-m_fStartTime)))));
      if (!m_bFadeIn) *fOut=1.0f-*fOut;
      return true;
    }
  }

//protected:
  float m_fLength;
};



#endif