#ifndef SM_D3DMESH

#define SM_D3DMESH

#include "SM_Renderable.h"
#include "SM_D3DGeometry.h"
#include "SM_Vector3D.h"
#include "SM_Quaternion.h"
#include "SM_KFAnimable.h"
#include <vector>

struct KeyFrameSequence;

class D3DMesh : public IRenderable , public IKFAnimable
{
public:
                  D3DMesh       ();
                  ~D3DMesh      ();

  int             Init          ();
  int             Shutdown      ();

  
  virtual void    Render        (RenderContext* pRenderContext, unsigned uOutcode);
  void            SetGeometry   (D3DGeometry* pD3DGeometry)
  {
    m_pD3DGeometry=pD3DGeometry;
  }

  D3DGeometry*    GetGeometry   ()
  {
    return (m_pD3DGeometry);
  }

  void            SetPosition(Vector3D*   pPosition)
  {
    m_Position=*pPosition;
  }

  void            SetRotation(Quaternion* pRotation)
  {
    m_Quaternion=*pRotation;
  }

  void            SetPivotPosition(Vector3D*   pPosition)
  {
    m_PivotPosition=*pPosition;
  }

  void            SetPivotRotation(Quaternion* pRotation)
  {
    m_PivotQuaternion=*pRotation;
  }

  void            SetParent(D3DMesh* pParent)
  {
    m_pParent=pParent;
  }

  void            AddSon(D3DMesh* pSon)
  {
    m_Sons.push_back(pSon);
  }

  void            GetKeyFrame(float fTime, Vector3D* pV3d, Quaternion* pQ);

  
//protected:  
  bool                       m_bVisible;
  D3DGeometry*               m_pD3DGeometry;
  Vector3D                   m_Position;
  Quaternion                 m_Quaternion;    
  Vector3D                   m_PivotPosition;
  Quaternion                 m_PivotQuaternion;    
  std::vector<D3DMesh*>      m_Sons;
  D3DMesh*                   m_pParent;
  Matrix4X4                  m_WorldTransform;
};

#endif