#include "SM_Engine3DPCH.h"
#include "SM_D3DLight.h"
#include "SM_KeyFrameSequence.h"
#include "SM_KeyFrame.h"
#include "MVFS.h"


int D3DLight::Load(MVFSFILE* f)
{
  int iReturn=(MVFS::fread(&m_Light, sizeof(m_Light), 1, f)==1?0:-1);
  m_Light.Ambient.r=0.5f;
  m_Light.Ambient.g=0.5f;
  m_Light.Ambient.b=0.5f;
  return iReturn;
}

int D3DLight::Save(MVFSFILE* f)
{
  return (MVFS::fwrite(&m_Light, sizeof(m_Light), 1, f)==1?0:-1);
}


void D3DLight::SetPosition(Vector3D*   pPosition)
{ 
  m_Light.Position.x=pPosition->x;
  m_Light.Position.y=pPosition->y;
  m_Light.Position.z=pPosition->z;
}

void  D3DLight::SetRotation(Quaternion* pRotation)
{  
}

void  D3DLight::Update()
{  
  if (m_pKeyFrameSequence)
  {
    KeyFrame CurrentKeyFrame;    
    m_pKeyFrameSequence->GetKeyFrame(Timer::GetTime(), m_fKeyFrameSequenceStartTime, &CurrentKeyFrame);

    m_Light.Position.x=CurrentKeyFrame.m_Position.x;
    m_Light.Position.y=CurrentKeyFrame.m_Position.y;
    m_Light.Position.z=CurrentKeyFrame.m_Position.z;
  }
  else
  {    
  }
}
  
