#include "SM_Engine3DPCH.h"
#include "SM_D3DGeometry.h"
#include "SM_Mesh.h"
#include "NvTriStripObjects.h"


#define VBTHRESHOLD 32768
#define OPTIMIZEIB  0

void OptimizeIndexList(unsigned short* usDest, unsigned short* usSource, unsigned short usIndices)
{
  int          i,j;
  NvStripifier Stripifier;

  WordVec Indices;
  
  for (i=0 ; i<usIndices ; i++)
  {
    Indices.push_back(usSource[i]);
  }

  NvStripInfoVec Strips;
  NvFaceInfoVec  Faces;

  Stripifier.Stripify(Indices, 10, 0, Strips, Faces);

  unsigned uOffset=0;

  for(i=0; i <Strips.size(); i++)
	{
	  for(j=0; j<Strips[i]->m_faces.size(); j++)
	  {
      usDest[uOffset++]=Strips[i]->m_faces[j]->m_v0;
      usDest[uOffset++]=Strips[i]->m_faces[j]->m_v1;
      usDest[uOffset++]=Strips[i]->m_faces[j]->m_v2;		  
	  }				
  }
			
  //now, make a VB for the leftOver faces
	for(i = 0; i < Faces.size(); i++)
	{
		usDest[uOffset++]=Faces[i]->m_v0;		
		usDest[uOffset++]=Faces[i]->m_v1;		
		usDest[uOffset++]=Faces[i]->m_v2;		
	}	

  assert(uOffset==usIndices);
}


D3DGeometry::D3DGeometry()
{
  m_pcName       =0;
  m_iVertexBuffer=-1;
  m_iIndexBuffer =-1;
  m_pVertices    =0;
  m_pIndices     =0;
}

D3DGeometry::~D3DGeometry()
{
  Shutdown();
}

int D3DGeometry::Init(RenderMesh* pRenderMesh)
{
  #ifdef USESTATICBUFFERS 
  IDirect3DVertexBuffer8*   pVertexBuffer=0; 
  FVF_PosNormalDiffuseTex1* pVertices=0;
  IDirect3DIndexBuffer8*    pIndexBuffer=0; 
  unsigned short*           pIndices=0;    
  #endif

  assert(m_iVertexBuffer==-1);
  assert(m_iIndexBuffer ==-1);

  unsigned uVertex,uIndex;

  assert(pRenderMesh->m_pcName);

  m_pcName=new char[strlen(pRenderMesh->m_pcName)+1];
  strcpy(m_pcName, pRenderMesh->m_pcName);

  m_uMeshElements=pRenderMesh->m_uElements;  
  if (!m_uMeshElements)
  {
    assert(!"D3DGeometry::Init() passing an empty mesh");
    return (-1);
  }

  m_pMeshElements=new MeshElement[m_uMeshElements];
  if (!m_pMeshElements)
  {
    return (-1);
  }

  int i,j;
  unsigned uVertices=0;
  unsigned uIndices =0;
  

  // Count vertices and indices
  for (i=0 ; i<pRenderMesh->m_uElements ; i++)
  {
    uVertices+=pRenderMesh->m_pElements[i].m_uVertices;
    uIndices +=pRenderMesh->m_pElements[i].m_uIndices;
  }

  bool bUseVBIB=uVertices*sizeof(FVF_PosNormalDiffuseTex1)>=VBTHRESHOLD;

  // Create VB/IB
  #ifdef USESTATICBUFFERS
  if (bUseVBIB)
  {
    m_iVertexBuffer=ResourceManager::CreateVertexBuffer(
            uVertices*sizeof(FVF_PosNormalDiffuseTex1), 
            D3DUSAGE_WRITEONLY, 
            FVF_POSNORMALDIFFUSETEX1, 
            D3DPOOL_DEFAULT);

    m_iIndexBuffer=ResourceManager::CreateIndexBuffer(
              uIndices*sizeof(unsigned short), 
              D3DUSAGE_WRITEONLY , 
              D3DFMT_INDEX16, 
              D3DPOOL_DEFAULT);

    if (m_iVertexBuffer==-1 || m_iIndexBuffer==-1)
    {
      goto HASERROR;
    }
  }
  #endif


  for (i=0 ; i<pRenderMesh->m_uElements ; i++)
  {
    #ifdef USESTATICBUFFERS
    if (bUseVBIB)
    {
      m_pMeshElements[i].m_iIB=m_iIndexBuffer;
      m_pMeshElements[i].m_iVB=m_iVertexBuffer;    
    }
    else
    {
      m_pMeshElements[i].m_iIB=-1;
      m_pMeshElements[i].m_iVB=-1;    
    }
    #else
    m_pMeshElements[i].m_iIB=-1;
    m_pMeshElements[i].m_iVB=-1;
    #endif
    m_pMeshElements[i].m_iShader=pRenderMesh->m_pElements[i].m_iMaterial;
  }

  // Fill VB/IB
  #ifdef USESTATICBUFFERS  
  if (bUseVBIB)
  {
    
    pVertexBuffer=ResourceManager::GetVertexBufferFromID(m_iVertexBuffer);
    pVertexBuffer->Lock(0, sizeof(FVF_PosNormalDiffuseTex1)*uVertices, (BYTE**) &pVertices, 0);
  }
  #endif


  uVertex=0;
  for (i=0 ; i<pRenderMesh->m_uElements ; i++)
  {
    uVertex+=pRenderMesh->m_pElements[i].m_uVertices;
  }

  m_pVertices=new FVF_PosNormalDiffuseTex1[uVertex];
  if (!m_pVertices)
  {
    goto HASERROR;
  }

  uVertex=0;
  for (i=0 ; i<pRenderMesh->m_uElements ; i++)
  {
    m_pMeshElements[i].m_uStartVertex=uVertex;
    m_pMeshElements[i].m_uVertices=pRenderMesh->m_pElements[i].m_uVertices;
    m_pMeshElements[i].m_pVertices=m_pVertices+uVertex;               

    for (j=0 ; j<pRenderMesh->m_pElements[i].m_uVertices ; j++)
    {
      #ifdef USESTATICBUFFERS
      if (bUseVBIB)
      {
        pVertices[uVertex].x=pRenderMesh->m_pElements[i].m_pRenderVertices[j].x;
        pVertices[uVertex].y=pRenderMesh->m_pElements[i].m_pRenderVertices[j].y;
        pVertices[uVertex].z=pRenderMesh->m_pElements[i].m_pRenderVertices[j].z;
        pVertices[uVertex].diffuse=pRenderMesh->m_pElements[i].m_pRenderVertices[j].diffuse;
        pVertices[uVertex].u=pRenderMesh->m_pElements[i].m_pRenderVertices[j].u;
        pVertices[uVertex].v=-pRenderMesh->m_pElements[i].m_pRenderVertices[j].v;
        pVertices[uVertex].nx=pRenderMesh->m_pElements[i].m_pRenderVertices[j].nx;
        pVertices[uVertex].ny=pRenderMesh->m_pElements[i].m_pRenderVertices[j].ny;
        pVertices[uVertex].nz=pRenderMesh->m_pElements[i].m_pRenderVertices[j].nz;
      }
      #endif

      m_pVertices[uVertex].x=pRenderMesh->m_pElements[i].m_pRenderVertices[j].x;
      m_pVertices[uVertex].y=pRenderMesh->m_pElements[i].m_pRenderVertices[j].y;
      m_pVertices[uVertex].z=pRenderMesh->m_pElements[i].m_pRenderVertices[j].z;
      m_pVertices[uVertex].diffuse=pRenderMesh->m_pElements[i].m_pRenderVertices[j].diffuse;
      m_pVertices[uVertex].u=pRenderMesh->m_pElements[i].m_pRenderVertices[j].u;
      m_pVertices[uVertex].v=-pRenderMesh->m_pElements[i].m_pRenderVertices[j].v;
      m_pVertices[uVertex].nx=pRenderMesh->m_pElements[i].m_pRenderVertices[j].nx;
      m_pVertices[uVertex].ny=pRenderMesh->m_pElements[i].m_pRenderVertices[j].ny;
      m_pVertices[uVertex].nz=pRenderMesh->m_pElements[i].m_pRenderVertices[j].nz;
      

      uVertex++;
    }     
    #ifdef USESTATICBUFFERS      
    if (bUseVBIB)
    {
      assert( memcmp(m_pMeshElements[i].m_pVertices, pVertices, sizeof(FVF_PosNormalDiffuseTex1)*pRenderMesh->m_pElements[i].m_uVertices)==0);
    }
    #endif
  }
  assert(uVertex==uVertices);

  #ifdef USESTATICBUFFERS 
  if (bUseVBIB)
  {
    pVertexBuffer->Unlock();
  }
  #endif  



  #ifdef USESTATICBUFFERS  
  if (bUseVBIB)
  {  
  pIndexBuffer=ResourceManager::GetIndexBufferFromID(m_iIndexBuffer);
  pIndexBuffer->Lock(0, sizeof(unsigned short)*uIndices, (BYTE**) &pIndices, 0);
  }
  #endif

  m_pIndices=new unsigned short[uIndices];
  if (!m_pIndices)
  {
    return -1;
  }



  uIndex=0;
  for (i=0 ; i<pRenderMesh->m_uElements ; i++)
  {
    m_pMeshElements[i].m_uStartIndex=uIndex;
    m_pMeshElements[i].m_uPrimitives=pRenderMesh->m_pElements[i].m_uIndices/3;
    m_pMeshElements[i].m_pIndices   =m_pIndices+m_pMeshElements[i].m_uStartIndex;
    

    #if OPTIMIZEIB
    OptimizeIndexList(m_pIndices+uIndex, pRenderMesh->m_pElements[i].m_pusIndices, pRenderMesh->m_pElements[i].m_uIndices);
    if (bUseVBIB)
    {
      memcpy(pIndices+uIndex, m_pIndices+uIndex, sizeof(short)*pRenderMesh->m_pElements[i].m_uIndices);
    }
    uIndex+=pRenderMesh->m_pElements[i].m_uIndices;    
    #else            
    for (j=0 ; j<pRenderMesh->m_pElements[i].m_uIndices ; j++)
    {
      #ifdef USESTATICBUFFERS  
      if (bUseVBIB)
      {
        pIndices[uIndex]=pRenderMesh->m_pElements[i].m_pusIndices[j];
      }
      #endif

      m_pIndices[uIndex]=pRenderMesh->m_pElements[i].m_pusIndices[j];
      uIndex++;
    }
    #endif
    ///

    #ifdef USESTATICBUFFERS    
    if (bUseVBIB)
    {
      assert( memcmp(m_pMeshElements[i].m_pIndices, pIndices, sizeof(unsigned short)*pRenderMesh->m_pElements[i].m_uIndices)==0);
    }
    #endif
  }  

  assert(uIndex==uIndices);

  #ifdef USESTATICBUFFERS        
  if (bUseVBIB)
  {
    pIndexBuffer->Unlock();
  }
  #endif

  // Radius
  m_fRadius=0;
  for (i=0 ; i<pRenderMesh->m_uElements ; i++)
  {
    for (j=0 ; j<pRenderMesh->m_pElements[i].m_uVertices ; j++)
    {
      Vector3D v=Vector3D(pRenderMesh->m_pElements[i].m_pRenderVertices[j].x,
                          pRenderMesh->m_pElements[i].m_pRenderVertices[j].y,
                          pRenderMesh->m_pElements[i].m_pRenderVertices[j].z);

      m_fRadius=max(v.Length(), m_fRadius);
      
      uVertex++;
    } 
  }

  return (0);

HASERROR:
  return (-1);

  
}

int D3DGeometry::Shutdown()
{
  if (m_pcName)            { delete[] m_pcName; m_pcName=0; }
  if (m_iVertexBuffer!=-1) { ResourceManager::ReleaseVertexBuffer(m_iVertexBuffer); m_iVertexBuffer=-1; }
  if (m_iIndexBuffer !=-1) { ResourceManager::ReleaseIndexBuffer(m_iIndexBuffer ); m_iIndexBuffer =-1; }

  if (m_pVertices)     delete[] m_pVertices; m_pVertices=0;
  if (m_pIndices)      delete[] m_pIndices; m_pIndices=0;
  if (m_pMeshElements) delete[] m_pMeshElements; m_pMeshElements=0;

  return (0);
}

void D3DGeometry::PreTransform  (Vector3D* pv3d, Quaternion* pq)
{
  int i,j;

  Matrix4X4 m;
  ToTransform(&m, pv3d, pq);            

  for (j=0 ; j<m_uMeshElements ; j++)
  {
    for (i=0 ; i<m_pMeshElements[j].m_uVertices ; i++)
    {
      Vector3D v(m_pMeshElements[j].m_pVertices[i].x,
                 m_pMeshElements[j].m_pVertices[i].y,
                 m_pMeshElements[j].m_pVertices[i].z);

      Vector3D vt;

      m.Transform(&vt, &v, 1);

      m_pMeshElements[j].m_pVertices[i].x=vt.x;
      m_pMeshElements[j].m_pVertices[i].y=vt.y;
      m_pMeshElements[j].m_pVertices[i].z=vt.z;
    }
    
  }
}


void D3DGeometry::AABB(AABox* pAABB)
{
  int i,j;
  pAABB->m_v3dMax=Vector3D(FLT_MIN, FLT_MIN, FLT_MIN);
  pAABB->m_v3dMin=Vector3D(FLT_MAX, FLT_MAX, FLT_MAX);

  for (j=0 ; j<m_uMeshElements ; j++)
  {
    for (i=0 ; i<m_pMeshElements[j].m_uVertices ; i++)
    {
      Vector3D v(m_pMeshElements[j].m_pVertices[i].x,
                 m_pMeshElements[j].m_pVertices[i].y,
                 m_pMeshElements[j].m_pVertices[i].z);

      *pAABB|=v;
    }
    
  }
}