#include "SM_Engine3DPch.h"
#include "SM_Coordinates.h"

namespace Coordinates
{
  float m_fWidth, m_fHeight;

  void  UpdatePhysicViewport(float x, float y, float w, float h)
  {
    D3DVIEWPORT8 Viewport; 
  
    Viewport.X      =Coordinates::GetPhysicX(x);
    Viewport.Y      =Coordinates::GetPhysicY(y);
    Viewport.Width  =Coordinates::GetPhysicX(w);
    Viewport.Height =Coordinates::GetPhysicY(h);
    Viewport.MinZ   =0.0f;
    Viewport.MaxZ   =1.0f;


    SM_D3d::Device()->SetViewport(&Viewport);    
  }

  void  UpdatePhysicalSize()
  {
    IDirect3DSurface8* pSurface=0; 
    SM_D3d::Device()->GetRenderTarget(&pSurface);

    D3DSURFACE_DESC dd;
    pSurface->GetDesc(&dd);

    m_fWidth  =dd.Width;
    m_fHeight =dd.Height;

    pSurface->Release();
  }
  
  float PhysicalWidth()
  {
    return m_fWidth;
  }

  float PhysicalHeight()
  {
    return m_fHeight;
  }


  float GetPhysicX     (float x)
  {
    return (m_fWidth*x/640.0f);
  }

  float GetPhysicY     (float y)
  {
    return (m_fHeight*y/480.0f);
  }
}