#ifndef __SM_DEMOSCRIPT

#define __SM_DEMOSCRIPT

#include "SM_DemoEffect.h"
#include "SM_DemoTune.h"
#include "SM_Main.h"


/*
  FORMATO SCRIPT

  // Comentario
  [  Abre comentario
  ]  Cierra comentario 


Sincronizacion:

Comandos de efectos:

  FXSTART     nombrefx
  FXSTOP      nombrefx
  FXLOAD      nombrefx
  FXSHUT      nombrefx
  FXCOMMAND   nombrefx parametros hasta final de linea

Sistema:
  VIDEOSTART	xres yres bpp fullscreen	(fullscreen=1 si pantalla completa)
  VIDEOEND 	chapa video
  
  CLEARON                      ...en cada frame borra la pantalla
  CLEAROFF                     ...no borra la pantalla (por defecto apagado)
  

  SYNC 	    	pos row                  	...Espera a que musica este en pos row

  LOADMUSIC 	nombremusica       
  PLAYMUSIC 
  STOPMUSIC 
  FREEMUSIC 

  LOADMP3     nombreMP3
  PLAYMP3     
  STOPMP3     
  FREEMP3
  SKIPTOTIME  time
  SYNCTIME    time
*/


namespace SM_DemoScript
{
  int   Init            (char* pcScript, bool bLooped);
  int   Shutdown        ();

  int   RunPreStartFrame(int iStartLayer, int iEndLayer);
  int   RunPreRender    (int iStartLayer, int iEndLayer);
  int   Run             (int iStartLayer, int iEndLayer);  // 1: OK ; 0: He acabado ; -1: ERROR  
  int   RunPostRender   (int iStartLayer, int iEndLayer);
  int   RunPostEndFrame (int iStartLayer, int iEndLayer);

  int   RunCommands     ();

  void  UpdateTime      ();
  float GetTime         ();

  void InsertActiveFXList(SM_DemoEffect*     pEffect);


  SM_DemoEffect*       GetFirstEffect();
  SM_DemoEffect*       GetNextEffect();
  SM_DemoEffect*       GetFirstActiveEffect();
  SM_DemoEffect*       GetNextActiveEffect();

  extern bool          g_bDrawFPS;
};

#endif