unit vector;

INTERFACE

type
	PVector=^TVector;
	TVector=record
		x,y,z:single;
	end;

procedure CopyVector(var a,b:TVector);
procedure MakeVector(x,y,z:single;var v:TVector);
procedure ResetVector(var v:TVector);
function VectorEqual(var a,b:TVector):boolean;
function VectorLength(var v:TVector):single;
function VectorDistance(var a,b:TVector):single;
procedure CrossProduct(var U,V,Normal:TVector);
procedure GetNormal(var P1,P2,P3,Normal:TVector);
function DotProduct(var U,V:TVector):single;
function DotUnit(var u,v:TVector):single;
procedure VectorAdd(var d,v1,v2:TVector);
procedure VectorSub(var d,v1,v2:TVector);
procedure VectorDivide(var d,v:TVector;s:single);
procedure VectorMultiply(var v:TVector;s:single);
procedure VectorNeg(var v:TVector);
procedure VectorNormalize(var v:TVector;var d:TVector);

IMPLEMENTATION

procedure CopyVector(var a,b:TVector);
begin
	b.x:=a.x;
	b.y:=a.y;
	b.z:=a.z;
end;

procedure MakeVector(x,y,z:single;var v:TVector);
begin
	v.x:=x;
	v.y:=y;
	v.z:=z;
end;

procedure ResetVector(var v:TVector);
begin
	v.x:=0;
	v.y:=0;
	v.z:=0;
end;

function VectorEqual(var a,b:TVector):boolean;
begin
	VectorEqual:=(a.x=b.x) and (a.y=b.y) and (a.z=b.z);
end;

function VectorDistance(var a,b:TVector):single;
var
	t:TVector;

begin
	VectorSub(t,a,b);
	VectorDistance:=VectorLength(t);
end;

function VectorLength(var v:TVector):single;
var
	m:single;

begin
	m:=sqrt(sqr(v.x)+sqr(v.y)+sqr(v.z));
	if m=0 then m:=1;
	VectorLength:=m;
end;

procedure VectorNormalize(var v:TVector;var d:TVector);
var
	l:single;

begin
	l:=VectorLength(v);
	d.x:=v.x/l;
	d.y:=v.y/l;
	d.z:=v.z/l;
end;

procedure CrossProduct(var u,v,normal:TVector);
begin
	normal.x:=(u.y*v.z)-(u.z*v.y);
	normal.y:=(u.z*v.x)-(u.x*v.z);
	normal.z:=(u.x*v.y)-(u.y*v.x);
end;

procedure GetNormal(var p1,p2,p3,normal:TVector);
var
	u,v:TVector;

begin
	VectorSub(u,p2,p1);
	VectorSub(v,p3,p1);
	CrossProduct(u,v,normal);
end;

function DotProduct(var u,v:TVector):single;
var
	m:single;

begin
	m:=1/(VectorLength(u)*VectorLength(v));
	DotProduct:=(u.x*v.x)+(u.y*v.y)+(u.z*u.z)*m;
end;

function DotUnit(var u,v:TVector):single;
var
	m:single;

begin
	DotUnit:=(u.x*v.x)+(u.y*v.y)+(u.z*v.z);
end;

procedure VectorAdd(var d,v1,v2:TVector);
begin
	d.x:=v1.x+v2.x;
	d.y:=v1.y+v2.y;
	d.z:=v1.z+v2.z;
end;

procedure VectorSub(var d,v1,v2:TVector);
begin
	d.x:=v1.x-v2.x;
	d.y:=v1.y-v2.y;
	d.z:=v1.z-v2.z;
end;

procedure VectorDivide(var d,v:TVector;s:single);
begin
	d.x:=v.x/s;
	d.y:=v.y/s;
	d.z:=v.z/s;
end;

procedure VectorMultiply(var v:TVector;s:single);
begin
	v.x:=v.x*s;
	v.y:=v.y*s;
	v.z:=v.z*s;
end;

procedure VectorNeg(var v:TVector);
begin
	v.x:=-v.x;
	v.y:=-v.y;
	v.z:=-v.z;
end;

end.