unit UltraMID;
{
  Just an UltraMID <--> Turbo Pascal interface.
  This code is freeware as long as you give me the proper credits.

  Programmed by Luis Crespo, 5/94.
  If you want to contact me for any reason, my Addresses are:

    E-Mail     : FidoNet 2:343/108.21, Internet d8089110@est.fib.upc.es
    Snail Mail : P.O. Box 93142, 08080 Barcelona, Spain.
}

interface


var
  UMVector:byte;    {Interrupt vector where UltraMID is hooked}
  UMEntry:pointer;  {UltraMID entry point}


  function UMDetect:boolean;
  {Detects the presence of UltraMID TSR. Must be called to detect the
   tsr entry point, before calling any other function.}

  { UltraMID MIDI-output functions.
    To learn how to use each of those functions, read the file
    ULTRAMID.DOC  that comes with the SDK. }
  procedure LoadMidiPatches(var TrackHdr; Len:LongInt);
  procedure LoadXmidiPatches(var EvntBuf);
  procedure LoadPatch(Pat:byte);
  procedure UnLoadPatch(Pat:byte);
  procedure StartSequence;
  procedure UnloadAllPatches;
  procedure MidiOut(b:byte);
  procedure MidiOutStr(var MidiStr; Len:word);
  procedure AllNotesOff;
  procedure AppStart;
  procedure AppEnd;



implementation

const
  TSR_LOAD_MIDI_PATCHES  = 10;
  TSR_LOAD_XMIDI_PATCHES = 11;
  TSR_LOAD_PATCH         = 12;
  TSR_UNLOAD_PATCH       = 13;
  TSR_START_SEQUENCE     = 14;
  TSR_UNLOAD_ALL_PATCHES = 15;
  TSR_MIDI_OUT           = 16;
  TSR_MIDI_OUT_STR       = 17;
  TSR_ALL_NOTES_OFF      = 18;

  TSR_APP_START          = 26;
  TSR_APP_END            = 27;



  procedure ToSillyProgrammers; far;
  {Just in case you forgot to call the detection routine, or you did it but
   your program doesn't abort when it doesn't detect UltraMID}
  begin
    asm mov ax,3; int 10h end;
    WriteLn('HEY!!! ULTRAMID not detected!!!');
    Halt;
  end;

  function UMDetect:boolean;
  var
    p:pointer;
    s:array[1..Length('ULTRAMID')] of char;
    ct,UMSeg:word;
    Det:boolean;
  begin
    ct:=$78*4;
    Det:=false;
    while (not Det) and (ct<=$7F*4) do
    begin
      UMSeg:=MemW[0:ct+2];
      move(Mem[UMSeg:$103],s,Length('ULTRAMID'));
      if s='ULTRAMID' then
			begin
        Det:=true;
        UMEntry:=ptr(UMSeg,MemW[0:ct]);
        UMVector:=ct div 4;
      end;
      Inc(ct,4);
    end;
    UMDetect:=Det;
  end;

  procedure UMCall(Num:word); assembler;
  asm
    mov  ax,Num
    call dword ptr [UMEntry]
  end;


  {-------------------- UltraMID functions --------------------}

	procedure LoadMidiPatches(var TrackHdr; Len:LongInt);
  begin
    asm
      les di,TrackHdr
      mov dx,word ptr Len
      mov bx,word ptr Len+2
    end;
    UMCall(TSR_LOAD_MIDI_PATCHES);
  end;

  procedure LoadXmidiPatches(var EvntBuf);
  begin
    asm les di,EvntBuf end;
    UMCall(TSR_LOAD_XMIDI_PATCHES);
  end;

  procedure LoadPatch(Pat:byte);
  begin
    asm
      mov cl,Pat
      xor ch,ch
    end;
		UMCall(TSR_LOAD_PATCH);
  end;

  procedure UnLoadPatch(Pat:byte);
  begin
    asm
      mov cl,Pat
      xor ch,ch
    end;
    UMCall(TSR_UNLOAD_PATCH);
  end;

  procedure StartSequence;
  begin
    UMCall(TSR_START_SEQUENCE);
  end;

  procedure UnloadAllPatches;
  begin
		UMCall(TSR_UNLOAD_ALL_PATCHES);
	end;

	procedure MidiOut(b:byte);
	begin
		asm
			mov cl,b
			xor ch,ch
		end;
		UMCall(TSR_MIDI_OUT);
	end;

	procedure MidiOutStr(var MidiStr; Len:word);
	begin
		asm
			les di,MidiStr
			mov cx,Len
		end;
		UMCall(TSR_MIDI_OUT_STR);
	end;

	procedure AllNotesOff;
	begin
		UMCall(TSR_ALL_NOTES_OFF);
	end;

	procedure AppStart;
	begin
		UMCall(TSR_APP_START);
	end;

	procedure AppEnd;
	begin
		UMCall(TSR_APP_END);
	end;


begin
	UMEntry:=@ToSillyProgrammers;
end.
