unit triangles;

INTERFACE

uses Engine3D;

function triangle(x1,y1,x2,y2,x3,y3,c:integer):boolean;
{Pinta un tringulo}

function FlatTransparentTriangle(x1,y1,x2,y2,x3,y3,c:integer;trans,light:word):boolean;
{Pinta un tringulo flat transparente}

function GouraudTransparentTriangle(x1,y1,c1,x2,y2,c2,x3,y3,c3:integer;trans,light:word):boolean;
{Pinta un tringulo transparente}

function TriangleGouraud(x1,y1,color1,x2,y2,color2,x3,y3,color3:integer):boolean;
{Pinta un tringulo con sombreado gouraud}

function TextureTriangle(y1,x1,ty1,tx1,y2,x2,ty2,tx2,y3,x3,ty3,tx3:integer;texture:word):boolean;
{Pinta un Triangle texturado}

function TextureTransparentTriangle(y1,x1,ty1,tx1,y2,x2,ty2,tx2,y3,x3,ty3,tx3:integer;texture,trans:word):boolean;
{Pinta un Triangle texturado}

function TextureTriangleFlat(	x1,y1,tx1,ty1,
															x2,y2,tx2,ty2,
															x3,y3,tx3,ty3,c:integer;
															texture,light:word):boolean;

function TextureTriangleGouraud(x1,y1,tx1,ty1,c1,
																x2,y2,tx2,ty2,c2,
																x3,y3,tx3,ty3,c3:integer;
																texture,light:word):boolean;

function TextureTriangleEnvMap(	x1,y1,tx1,ty1,u1,v1,
																x2,y2,tx2,ty2,u2,v2,
																x3,y3,tx3,ty3,u3,v3:integer;
																texture,EnvMap,light:word):boolean;

function TexturePerspectiveTriangle(var t:TTriangle):boolean;
function TexturePerspectiveTransparentTriangle(var t:TTriangle):boolean;

procedure SetTexturePrecision(n:byte);

IMPLEMENTATION

uses Op386,Mode13,math;

const
	TOPE=system.round(YMAX*2.25);

	COLOR_PRECISION=23;{}
	TEXTURE_PRECISION=23;

var
	xxi,sxi,syi,ci,ui,vi,
	xxd,sxd,syd,cd,ud,vd:array[-TOPE..TOPE] of integer;
	mdx,msx,msy:LongInt;
	my,mxy:integer;

	dizdx,duizdx,dvizdx,dizdy,duizdy,dvizdy,
	dizdxn,duizdxn,dvizdxn,
	xa,xb,iza,uiza,viza,
	dxdya,dxdyb,dizdya,duizdya,dvizdya:double;
	texture:PTexture;

	SUBDIVSHIFT,SUBDIVSIZE:integer;

procedure SwapFloat(var x,y:double);
var
	t:double;

begin
	t:=x;
	x:=y;
	y:=t;
end;

procedure DrawSection(y1,y2:integer);
var
	scr:^byte;
	x1,x2,
	x,xcount:integer;
	z,dx,
	iz,uiz,viz:double;
	u1,v1,
	u2,v2,
	u,v,du,dv:LongInt;

begin
	while y1<y2 do
		begin
			x1:=round(xa);
			if x1<region.xul then x1:=region.xul;
			x2:=round(xb);
			if x2>region.xlr then x2:=region.xlr;

			dx:=1-(xa-x1);
			iz:=iza+dx*dizdx;
			uiz:=uiza+dx*duizdx;
			viz:=viza+dx*dvizdx;

			scr:=ptr(vRAM,MultByWidth[y1]+x1);

			z:=65536/iz;
			u2:=round(uiz*z);
			v2:=round(viz*z);

			xcount:=x2-x1;
			while xcount>=SUBDIVSIZE do
				begin
					iz:=iz+dizdxn;
					uiz:=uiz+duizdxn;
					viz:=viz+dvizdxn;

					u1:=u2;
					v1:=v2;

					z:=65536/iz;
					u2:=round(uiz*z);
					v2:=round(viz*z);

					u:=u1;
					v:=v1;

					du:=(u2-u1) shr SUBDIVSHIFT;
					dv:=(v2-v1) shr SUBDIVSHIFT;

					x:=SUBDIVSIZE;
					ASM
						PUSH	BP
						PUSH	DS

						DB		_386;MOV		AX,WORD(u)
						DB		_386;MOV		DX,WORD(v)
						DB		_386;MOV		SI,WORD(du)
						DB		_386;MOV		CX,WORD(dv)

						{$IFDEF __BPPROT__}
						MOV		BX,CS
						ADD		BX,SelectorInc
						MOV		ES,BX
						DB		_386;MOV		WORD(ES:@AUTO+3),CX
						{$ELSE}
						DB		_386;MOV		WORD(CS:@AUTO+3),CX
						{$ENDIF}
						LES		DI,scr
						MOV		DS,WORD(texture+2)
						MOV		BP,x

@BUCLE:
						DB		$66,$0F,$A4,$C3,$10				{SHLD	EBX,EAX,16}
						DB		$66,$0F,$A4,$D1,$10				{SHLD ECX,EDX,16}
						MOV		BH,CL

						MOV		BL,[BX]
						MOV		ES:[DI],BL
						INC		DI

						DB		_386;ADD		AX,SI
@AUTO:
						DB		$66,$81,$C2,0,0,0,0			{ADD EDX,dv;}

						DEC		BP
						JNZ		@BUCLE

						POP		DS
						POP		BP
						MOV		WORD(scr),DI
					END;

{					while x>0 do
						begin
							scr^:=texture^[(v and $ff0000) shr 8,(u and $ff0000) shr 16];
							inc(scr);
							inc(u,du);
							inc(v,dv);
							dec(x);
						end;}
					dec(xcount,SUBDIVSIZE);
				end;

			if xcount>0 then
				begin
					iz:=iz+dizdx*xcount;
					uiz:=uiz+duizdx*xcount;
					viz:=viz+dvizdx*xcount;

					u1:=u2;
					v1:=v2;

					z:=65536/iz;
					u2:=round(uiz*z);
					v2:=round(viz*z);

					u:=u1;
					v:=v1;

					du:=(u2-u1) div xcount;
					dv:=(v2-v1) div xcount;

					ASM
						PUSH	BP
						PUSH	DS

						DB		_386;MOV		AX,WORD(u)
						DB		_386;MOV		DX,WORD(v)
						DB		_386;MOV		SI,WORD(du)
						DB		_386;MOV		CX,WORD(dv)

						{$IFDEF __BPPROT__}
						MOV		BX,CS
						ADD		BX,SelectorInc
						MOV		ES,BX
						DB		_386;MOV		WORD(ES:@AUTO+3),CX
						{$ELSE}
						DB		_386;MOV		WORD(CS:@AUTO+3),CX
						{$ENDIF}
						LES		DI,scr
						MOV  	DS,WORD(texture+2)
						MOV		BP,xcount

@BUCLE:
						DB		$66,$0F,$A4,$C3,$10				{SHLD	EBX,EAX,16}
						DB		$66,$0F,$A4,$D1,$10				{SHLD ECX,EDX,16}
						MOV		BH,CL

						MOV		BL,[BX]
						MOV		ES:[DI],BL
						INC		DI

						DB		_386;ADD		AX,SI
@AUTO:
						DB		$66,$81,$C2,0,0,0,0			{ADD EDX,dv;}

						DEC		BP
						JNZ		@BUCLE

						POP		DS
						POP		BP
					END;
{					while xcount>0 do
						begin
							scr^:=texture^[(v and $ff0000) shr 8,(u and $ff0000) shr 16];
							inc(scr);
							inc(u,du);
							inc(v,dv);
							dec(xcount);
						end;}
				end;

			xa:=xa+dxdya;
			xb:=xb+dxdyb;
			iza:=iza+dizdya;
			uiza:=uiza+duizdya;
			viza:=viza+dvizdya;
			inc(y1);
		end;
end;

function TexturePerspectiveTriangle(var t:TTriangle):boolean;
var
	x1,y1,x2,y2,x3,y3,
	iz1,uiz1,viz1,iz2,uiz2,viz2,iz3,uiz3,viz3,
	dxdy1,dxdy2,dxdy3,
	tempf,
	denom,
	dy:double;
	y1i,y2i,y3i:integer;
	side:boolean;

begin
	TexturePerspectiveTriangle:=FALSE;

	x1:=t.x1+0.5;
	y1:=t.y1+0.5;
	x2:=t.x2+0.5;
	y2:=t.y2+0.5;
	x3:=t.x3+0.5;
	y3:=t.y3+0.5;

	iz1:=1/t.z1;
	iz2:=1/t.z2;
	iz3:=1/t.z3;
	uiz1:=t.u1*iz1;
	viz1:=t.v1*iz1;
	uiz2:=t.u2*iz2;
	viz2:=t.v2*iz2;
	uiz3:=t.u3*iz3;
	viz3:=t.v3*iz3;

	texture:=t.texture;

	if y1>y2 then
		begin
			SwapFloat(x1,x2);
			SwapFloat(y1,y2);
			SwapFloat(iz1,iz2);
			SwapFloat(uiz1,uiz2);
			SwapFloat(viz1,viz2);
		end;
	if y1>y3 then
		begin
			SwapFloat(x1,x3);
			SwapFloat(y1,y3);
			SwapFloat(iz1,iz3);
			SwapFloat(uiz1,uiz3);
			SwapFloat(viz1,viz3);
		end;
	if y2>y3 then
		begin
			SwapFloat(x2,x3);
			SwapFloat(y2,y3);
			SwapFloat(iz2,iz3);
			SwapFloat(uiz2,uiz3);
			SwapFloat(viz2,viz3);
		end;

	y1i:=trunc(y1);
	y2i:=trunc(y2);
	y3i:=trunc(y3);

	if ((y1i=y2i) and (y2i=y3i)) or ((x1=x2) and (x2=x3)) then exit;

	if y1i<region.yul then y1i:=region.yul;
	if y2i<region.yul then y2i:=region.yul;
	if y3i<region.yul then exit;

	if y3i>region.ylr then y3i:=region.ylr;
	if y2i>region.ylr then y2i:=region.ylr;
	if y1i>region.ylr then exit;

	denom:=((x3-x1)*(y2-y1)-(x2-x1)*(y3-y1));
	if denom=0 then exit;
	denom:=1/denom;
	dizdx:=((iz3-iz1)*(y2-y1)-(iz2-iz1)*(y3-y1))*denom;
	duizdx:=((uiz3-uiz1)*(y2-y1)-(uiz2-uiz1)*(y3-y1))*denom;
	dvizdx:=((viz3-viz1)*(y2-y1)-(viz2-viz1)*(y3-y1))*denom;
	dizdy:=((iz2-iz1)*(x3-x1)-(iz3-iz1)*(x2-x1))*denom;
	duizdy:=((uiz2-uiz1)*(x3-x1)-(uiz3-uiz1)*(x2-x1))*denom;
	dvizdy:=((viz2-viz1)*(x3-x1)-(viz3-viz1)*(x2-x1))*denom;

	dizdxn:=dizdx*SUBDIVSIZE;
	duizdxn:=duizdx*SUBDIVSIZE;
	dvizdxn:=dvizdx*SUBDIVSIZE;

	if y2>y1 then	dxdy1:=(x2-x1)/(y2-y1);
	if y3>y1 then dxdy2:=(x3-x1)/(y3-y1);
	if y3>y2 then	dxdy3:=(x3-x2)/(y3-y2);

	side:=dxdy2>dxdy1;
	if y1=y2 then	side:=x1>x2;
	if y2=y3 then	side:=x3>x2;

	if not side then
		begin
			dxdya:=dxdy2;
			dizdya:=dxdy2*dizdx+dizdy;
			duizdya:=dxdy2*duizdx+duizdy;
			dvizdya:=dxdy2*dvizdx+dvizdy;

			dy:=1-(y1-y1i);
			xa:=x1+dy*dxdya;
			iza:=iz1+dy*dizdya;
			uiza:=uiz1+dy*duizdya;
			viza:=viz1+dy*dvizdya;

			if y1i<y2i then
				begin
					xb:=x1+dy*dxdy1;
					dxdyb:=dxdy1;
					DrawSection(y1i,y2i);
				end;
			if y2i<y3i then
				begin
					xb:=x2+(1-(y2-y2i))*dxdy3;
					dxdyb:=dxdy3;
					DrawSection(y2i,y3i);
				end;
		end
	else
		begin
			dxdyb:=dxdy2;
			dy:=1-(y1-y1i);
			xb:=x1+dy*dxdyb;

			if y1i<y2i then
				begin
					dxdya:=dxdy1;
					dizdya:=dxdy1*dizdx+dizdy;
					duizdya:=dxdy1*duizdx+duizdy;
					dvizdya:=dxdy1*dvizdx+dvizdy;
					xa:=x1+dy*dxdya;
					iza:=iz1+dy*dizdya;
					uiza:=uiz1+dy*duizdya;
					viza:=viz1+dy*dvizdya;
					DrawSection(y1i,y2i);
				end;
			if y2i<y3i then
				begin
					dxdya:=dxdy3;
					dizdya:=dxdy3*dizdx+dizdy;
					duizdya:=dxdy3*duizdx+duizdy;
					dvizdya:=dxdy3*dvizdx+dvizdy;
					dy:=1-(y2-y2i);
					xa:=x2+dy*dxdya;
					iza:=iz2+dy*dizdya;
					uiza:=uiz2+dy*duizdya;
					viza:=viz2+dy*dvizdya;
					DrawSection(y2i,y3i);
				end;
		end;
	TexturePerspectiveTriangle:=TRUE;
end;

procedure DrawTransparentSection(y1,y2:integer;trans:word);
var
	scr:^byte;
	x1,x2,
	x,xcount:integer;
	z,dx,
	iz,uiz,viz:double;
	u1,v1,
	u2,v2,
	u,v,du,dv:LongInt;

begin
	while y1<y2 do
		begin
			x1:=round(xa);
			if x1<region.xul then x1:=region.xul;
			x2:=round(xb);
			if x2>region.xlr then x2:=region.xlr;

			dx:=1-(xa-x1);
			iz:=iza+dx*dizdx;
			uiz:=uiza+dx*duizdx;
			viz:=viza+dx*dvizdx;

			scr:=ptr(vRAM,MultByWidth[y1]+x1);

			z:=65536/iz;
			u2:=round(uiz*z);
			v2:=round(viz*z);

			xcount:=x2-x1;
			while xcount>=SUBDIVSIZE do
				begin
					iz:=iz+dizdxn;
					uiz:=uiz+duizdxn;
					viz:=viz+dvizdxn;

					u1:=u2;
					v1:=v2;

					z:=65536/iz;
					u2:=round(uiz*z);
					v2:=round(viz*z);

					u:=u1;
					v:=v1;

					du:=(u2-u1) shr SUBDIVSHIFT;
					dv:=(v2-v1) shr SUBDIVSHIFT;

					x:=SUBDIVSIZE;
					ASM
						PUSH	BP
						PUSH	DS

						MOV		AX,trans
						DW		MOV_GS_AX

						DB		_386;MOV		AX,WORD(u)
						DB		_386;MOV		DX,WORD(v)
						DB		_386;MOV		SI,WORD(du)
						DB		_386;MOV		CX,WORD(dv)

						{$IFDEF __BPPROT__}
						MOV		BX,CS
						ADD		BX,SelectorInc
						MOV		ES,BX
						DB		_386;MOV		WORD(ES:@AUTO+3),CX
						{$ELSE}
						DB		_386;MOV		WORD(CS:@AUTO+3),CX
						{$ENDIF}
						LES		DI,scr
						MOV		DS,WORD(texture+2)
						MOV		BP,x

@BUCLE:
						DB		$66,$0F,$A4,$C3,$10				{SHLD	EBX,EAX,16}
						DB		$66,$0F,$A4,$D1,$10				{SHLD ECX,EDX,16}
						MOV		BH,CL

						MOV		BL,[BX]
						MOV		BH,ES:[DI]
						DB		GS;MOV		BL,[BX]
						MOV		ES:[DI],BL
						INC		DI

						DB		_386;ADD		AX,SI
@AUTO:
						DB		$66,$81,$C2,0,0,0,0			{ADD EDX,dv;}

						DEC		BP
						JNZ		@BUCLE

						POP		DS
						POP		BP
						MOV		WORD(scr),DI
					END;

{					while x>0 do
						begin
							scr^:=texture^[(v and $ff0000) shr 8,(u and $ff0000) shr 16];
							inc(scr);
							inc(u,du);
							inc(v,dv);
							dec(x);
						end;}
					dec(xcount,SUBDIVSIZE);
				end;

			if xcount>0 then
				begin
					iz:=iz+dizdx*xcount;
					uiz:=uiz+duizdx*xcount;
					viz:=viz+dvizdx*xcount;

					u1:=u2;
					v1:=v2;

					z:=65536/iz;
					u2:=round(uiz*z);
					v2:=round(viz*z);

					u:=u1;
					v:=v1;

					du:=(u2-u1) div xcount;
					dv:=(v2-v1) div xcount;

					ASM
						PUSH	BP
						PUSH	DS

						MOV		AX,trans
						DW		MOV_GS_AX

						DB		_386;MOV		AX,WORD(u)
						DB		_386;MOV		DX,WORD(v)
						DB		_386;MOV		SI,WORD(du)
						DB		_386;MOV		CX,WORD(dv)

						{$IFDEF __BPPROT__}
						MOV		BX,CS
						ADD		BX,SelectorInc
						MOV		ES,BX
						DB		_386;MOV		WORD(ES:@AUTO+3),CX
						{$ELSE}
						DB		_386;MOV		WORD(CS:@AUTO+3),CX
						{$ENDIF}
						LES		DI,scr
						MOV  	DS,WORD(texture+2)
						MOV		BP,xcount

@BUCLE:
						DB		$66,$0F,$A4,$C3,$10				{SHLD	EBX,EAX,16}
						DB		$66,$0F,$A4,$D1,$10				{SHLD ECX,EDX,16}
						MOV		BH,CL

						MOV		BL,[BX]
						MOV		BH,ES:[DI]
						DB		GS;MOV		BL,[BX]
						MOV		ES:[DI],BL
						INC		DI

						DB		_386;ADD		AX,SI
@AUTO:
						DB		$66,$81,$C2,0,0,0,0			{ADD EDX,dv;}

						DEC		BP
						JNZ		@BUCLE

						POP		DS
						POP		BP
					END;
{					while xcount>0 do
						begin
							scr^:=texture^[(v and $ff0000) shr 8,(u and $ff0000) shr 16];
							inc(scr);
							inc(u,du);
							inc(v,dv);
							dec(xcount);
						end;}
				end;

			xa:=xa+dxdya;
			xb:=xb+dxdyb;
			iza:=iza+dizdya;
			uiza:=uiza+duizdya;
			viza:=viza+dvizdya;
			inc(y1);
		end;
end;

function TexturePerspectiveTransparentTriangle(var t:TTriangle):boolean;
var
	x1,y1,x2,y2,x3,y3,
	iz1,uiz1,viz1,iz2,uiz2,viz2,iz3,uiz3,viz3,
	dxdy1,dxdy2,dxdy3,
	tempf,
	denom,
	dy:double;
	y1i,y2i,y3i:integer;
	side:boolean;

begin
	TexturePerspectiveTransparentTriangle:=FALSE;

	x1:=t.x1+0.5;
	y1:=t.y1+0.5;
	x2:=t.x2+0.5;
	y2:=t.y2+0.5;
	x3:=t.x3+0.5;
	y3:=t.y3+0.5;

	iz1:=1/t.z1;
	iz2:=1/t.z2;
	iz3:=1/t.z3;
	uiz1:=t.u1*iz1;
	viz1:=t.v1*iz1;
	uiz2:=t.u2*iz2;
	viz2:=t.v2*iz2;
	uiz3:=t.u3*iz3;
	viz3:=t.v3*iz3;

	texture:=t.texture;

	if y1>y2 then
		begin
			SwapFloat(x1,x2);
			SwapFloat(y1,y2);
			SwapFloat(iz1,iz2);
			SwapFloat(uiz1,uiz2);
			SwapFloat(viz1,viz2);
		end;
	if y1>y3 then
		begin
			SwapFloat(x1,x3);
			SwapFloat(y1,y3);
			SwapFloat(iz1,iz3);
			SwapFloat(uiz1,uiz3);
			SwapFloat(viz1,viz3);
		end;
	if y2>y3 then
		begin
			SwapFloat(x2,x3);
			SwapFloat(y2,y3);
			SwapFloat(iz2,iz3);
			SwapFloat(uiz2,uiz3);
			SwapFloat(viz2,viz3);
		end;

	y1i:=trunc(y1);
	y2i:=trunc(y2);
	y3i:=trunc(y3);

	if ((y1i=y2i) and (y2i=y3i)) or ((x1=x2) and (x2=x3)) then exit;

	if y1i<region.yul then y1i:=region.yul;
	if y2i<region.yul then y2i:=region.yul;
	if y3i<region.yul then exit;

	if y3i>region.ylr then y3i:=region.ylr;
	if y2i>region.ylr then y2i:=region.ylr;
	if y1i>region.ylr then exit;

	denom:=((x3-x1)*(y2-y1)-(x2-x1)*(y3-y1));
	if denom=0 then exit;
	denom:=1/denom;
	dizdx:=((iz3-iz1)*(y2-y1)-(iz2-iz1)*(y3-y1))*denom;
	duizdx:=((uiz3-uiz1)*(y2-y1)-(uiz2-uiz1)*(y3-y1))*denom;
	dvizdx:=((viz3-viz1)*(y2-y1)-(viz2-viz1)*(y3-y1))*denom;
	dizdy:=((iz2-iz1)*(x3-x1)-(iz3-iz1)*(x2-x1))*denom;
	duizdy:=((uiz2-uiz1)*(x3-x1)-(uiz3-uiz1)*(x2-x1))*denom;
	dvizdy:=((viz2-viz1)*(x3-x1)-(viz3-viz1)*(x2-x1))*denom;

	dizdxn:=dizdx*SUBDIVSIZE;
	duizdxn:=duizdx*SUBDIVSIZE;
	dvizdxn:=dvizdx*SUBDIVSIZE;

	if y2>y1 then	dxdy1:=(x2-x1)/(y2-y1);
	if y3>y1 then dxdy2:=(x3-x1)/(y3-y1);
	if y3>y2 then	dxdy3:=(x3-x2)/(y3-y2);

	side:=dxdy2>dxdy1;
	if y1=y2 then	side:=x1>x2;
	if y2=y3 then	side:=x3>x2;

	if not side then
		begin
			dxdya:=dxdy2;
			dizdya:=dxdy2*dizdx+dizdy;
			duizdya:=dxdy2*duizdx+duizdy;
			dvizdya:=dxdy2*dvizdx+dvizdy;

			dy:=1-(y1-y1i);
			xa:=x1+dy*dxdya;
			iza:=iz1+dy*dizdya;
			uiza:=uiz1+dy*duizdya;
			viza:=viz1+dy*dvizdya;

			if y1i<y2i then
				begin
					xb:=x1+dy*dxdy1;
					dxdyb:=dxdy1;
					DrawSection(y1i,y2i);
				end;
			if y2i<y3i then
				begin
					xb:=x2+(1-(y2-y2i))*dxdy3;
					dxdyb:=dxdy3;
					DrawTransparentSection(y2i,y3i,seg(t.transparency^));
				end;
		end
	else
		begin
			dxdyb:=dxdy2;
			dy:=1-(y1-y1i);
			xb:=x1+dy*dxdyb;

			if y1i<y2i then
				begin
					dxdya:=dxdy1;
					dizdya:=dxdy1*dizdx+dizdy;
					duizdya:=dxdy1*duizdx+duizdy;
					dvizdya:=dxdy1*dvizdx+dvizdy;
					xa:=x1+dy*dxdya;
					iza:=iz1+dy*dizdya;
					uiza:=uiz1+dy*duizdya;
					viza:=viz1+dy*dvizdya;
					DrawTransparentSection(y1i,y2i,seg(t.transparency^));
				end;
			if y2i<y3i then
				begin
					dxdya:=dxdy3;
					dizdya:=dxdy3*dizdx+dizdy;
					duizdya:=dxdy3*duizdx+duizdy;
					dvizdya:=dxdy3*dvizdx+dvizdy;
					dy:=1-(y2-y2i);
					xa:=x2+dy*dxdya;
					iza:=iz2+dy*dizdya;
					uiza:=uiz2+dy*duizdya;
					viza:=viz2+dy*dvizdya;
					DrawTransparentSection(y2i,y3i,seg(t.transparency^));
				end;
		end;
	TexturePerspectiveTransparentTriangle:=TRUE;
end;

procedure ScanFlatEdge(x1,y1,x2,y2:integer);ASSEMBLER;
ASM
	DB			$66,$BE;DD $80000000	{MOV ESI,$80000000}

	MOV			SI,x1
	MOV			BX,y1
	MOV			AX,x2
	MOV			CX,y2

	LEA			DI,xxi+(TOPE*2) 			{DS:DI=@xi[0]}

	CMP			BX,CX               	{if y1>y2 then...}
	JLE			@Y_MENOR

	XCHG		CX,BX               	{swap(y1,y2);}
	XCHG		AX,SI               	{swap(x1,x2);}

	LEA			DI,xxd+(TOPE*2)  			{DS:DI=@xd[0]}

@Y_MENOR:
	CMP			BX,-TOPE    	{Cutre recorte... :( }
	JG			@SIGUE1
	MOV			BX,-TOPE+1

@SIGUE1:
	CMP			CX,TOPE
	JL			@SIGUE2
	MOV			CX,TOPE-1

@SIGUE2:
	SUB			CX,BX									{a:=(y2-y1)+1;}
	JL			@FIN									{if a=0 then goto fin}
	INC			CX

	ADD			BX,BX
	ADD			DI,BX                 {DS:DI=@x[y1]}

	SUB			AX,SI
	DB			_386;SHL		AX,16    	{incr:=(x2-x1)+1 shl 16;}
	DW			CDQ
	DB			_386;IDIV		CX      	{incr:=incr div a;}
	DB			_386;ROL		AX,16     {Intercambia EAX}

	DB			_386;XCHG		AX,SI     {EAX=$8000:x1 | ESI=incr:signo}

																{ALIGN 16}
@BUCLE:          								{for n:=1 to p+1 do}
	MOV			[DI],AX
	ADD			DI,2

	DB			_386;ADD		AX,SI			{inc(acum,incr);}
	ADC			AX,0

	DEC			CX
	JNZ			@BUCLE

@FIN:
END;

var
	c32:LongInt;
	j:integer;
	code:boolean;

function triangle(x1,y1,x2,y2,x3,y3,c:integer):boolean;ASSEMBLER;
ASM
	CLD
	PUSH		BP

	MOV			code,FALSE

	MOV			AX,c
	MOV			AH,AL
	MOV			BX,AX
	DB			_386;SHL		AX,16
	MOV			AX,BX
	DB			_386;MOV		WORD(c32),AX

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y2<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y2>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JGE			@FINAL				{if my>region.ylr then goto final}
	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	DB			_386;XOR		CX,CX

	PUSH		x1
	PUSH		y1
	PUSH		x2
	PUSH		y2
	CALL		ScanFlatEdge

	PUSH		x2
	PUSH		y2
	PUSH		x3
	PUSH		y3
	CALL		ScanFlatEdge

	PUSH		x3
	PUSH		y3
	PUSH		x1
	PUSH		y1
	CALL		ScanFlatEdge


	MOV			ES,vRAM

	MOV			AX,my
	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX                   {DS:SI=@Xi[my]}

	MOV			BP,mxy
	SUB			BP,AX
	JL			@FINAL
	INC			BP                      {for n:=(mxy-my)+1 DownTo 0 do}
	MOV			j,BP

	DB			_386;MOV	AX,WORD(c32)

@BUCLE_P:                         {ALIGN 16}
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			BP,WORD(xxi[SI])
	CMP			BP,BX     {if x1>region.xlr then goto salir}
	JGE			@SALIR
	MOV			CX,WORD(xxd[SI])
	CMP			CX,DX     {if x2<region.xul then goto salir}
	JL			@SALIR

	CMP			BP,DX     {if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			BP,DX

@SIGUE10:
	CMP			CX,BX   	{if x2>region.xlr then x2:=region.xlr}
	JL			@SIGUE20
	MOV			CX,BX

@SIGUE20:
	SUB			CX,BP			{x2:=(x2-x1)+1;}
	JL			@SALIR    {if x2<=0 then goto salir}
	INC			CX

	PUSH		DI
	ADD			DI,BP			{inc(DirPant,x1);}

	MOV			DL,CL
	AND			DL,3
	SHR			CX,2
	REP;		DB _386;STOSW   {REP STOSD}
	MOV			CL,DL
	REP			STOSB

	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320    {Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	MOV			code,TRUE

@FINAL:
	POP			BP

	MOV			AL,code
END;

procedure ScanGouraudEdge(x1,y1,c1,x2,y2,c2:integer);ASSEMBLER;
var
	tmp:LongInt;

ASM
	LEA			DI,xxi+(TOPE*2) 				{DS:SI=@Xi[0]}

	MOV			BX,y1                 {if y1>y2 then...}
	MOV			CX,y2

	CMP			BX,CX
	JL			@Y_MENOR

	XCHG		BX,CX                 {...swap(y1,y2)}

	MOV			AX,x1                 {swap(x1,x2)}
	XCHG		AX,x2
	MOV			x1,AX

	MOV			AX,c1                 {swap(c1,c2)}
	XCHG		AX,c2
	MOV			c1,AX

	LEA			DI,xxd+(TOPE*2) 			{DS:DI=@Xd[0]}

@Y_MENOR:
	CMP			BX,-TOPE    	{Cutre recorte... :( }
	JG			@SIGUE1
	MOV			BX,-TOPE+1

@SIGUE1:
	CMP			CX,TOPE
	JL			@SIGUE2
	MOV			CX,TOPE-1

@SIGUE2:
	SUB			CX,BX									{a:=(y2-y1)+1;}
	JL			@FIN              		{if a=0 then goto fin;}
	INC			CX

	ADD			BX,BX
	ADD			DI,BX

	DB			$66,$BE;DD $80000000	{MOV ESI,$80000000}
	MOV			SI,x1
	MOV			AX,x2
	SUB			AX,SI
	DB			_386;SHL		AX,16    	{incr:=(x2-x1)+1 shl 16;}
	DW			CDQ
	DB			_386;IDIV		CX      	{incr:=incr div a;}
	DB			_386;ROL		AX,16     {Intercambia EAX}
	DB			_386;MOV    WORD(tmp),AX

	MOV			BX,c1
	MOV			AX,c2
	SUB			AX,BX
	DB			_386;ROR		AX,32-COLOR_PRECISION 		{incr:=(c2-c1) shl 16;}
	DW			CDQ
	DB			_386;IDIV		CX      	{incr:=incr div p;}
	DB			_386;SAR		AX,COLOR_PRECISION-8
	MOV			BH,BL
	MOV			BL,$80                {BX=color1:$80 ; AX=incr}

	DB			_386;MOV    DX,WORD(tmp)
																{ALIGN 16}
@BUCLE:          								{for n:=1 to p+1 do}
	MOV			[DI],SI
	MOV			[DI+(TOPE*12)+6],BH
	ADD			DI,2

	DB			_386;ADD		SI,DX   	{inc(acum,incr);}
	ADC			SI,0

	ADD			BX,AX   							{inc(acumc,incrc);}

	DEC			CX
	JNZ			@BUCLE

@FIN:
END;

function TriangleGouraud(x1,y1,color1,x2,y2,color2,x3,y3,color3:integer):boolean;ASSEMBLER;
var
	c1:word;
	i:LongInt;

ASM
	MOV			code,FALSE

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y1<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y1>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:                    {AX=my / BX=mxy}
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JG			@FINAL				{if my>region.ylr then goto final}

	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	DB			_386;XOR		CX,CX
	DB			_386;MOV		WORD(i),CX	{HI(i)=0}

	PUSH		x1
	PUSH		y1
	PUSH		color1
	PUSH		x2
	PUSH		y2
	PUSH		color2
	CALL		ScanGouraudEdge

	PUSH		x2
	PUSH		y2
	PUSH		color2
	PUSH		x3
	PUSH		y3
	PUSH		color3
	CALL		ScanGouraudEdge

	PUSH		x3
	PUSH		y3
	PUSH		color3
	PUSH		x1
	PUSH		y1
	PUSH		color1
	CALL		ScanGouraudEdge

	MOV			AX,my
	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX                   {DS:SI=@Xi[my]}

	MOV			BX,mxy
	SUB			BX,AX
	JL			@FINAL
	INC			BX                      {for n:=(mxy-my)+1 DownTo 0 do}
	MOV		 	j,BX

@BUCLE_P:
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			AX,WORD(xxi[SI])
	CMP			AX,BX     							{if x1>region.xlr then goto salir}
	JG			@SALIR
	MOV			CX,WORD(xxd[SI])
	CMP			CX,DX     							{if x2<region.xul then goto salir}
	JL			@SALIR                  	{if i<=0 then goto salir}

	MOV			WORD(i),CX
	SUB			WORD(i),AX
	JL			@SALIR
	INC 		WORD(i)

	MOV			c1,0
	CMP			AX,DX     							{if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			c1,DX
	SUB			c1,AX
	MOV			AX,DX

@SIGUE10:
	CMP			CX,BX   								{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE20
	MOV			CX,BX

@SIGUE20:
	SUB			CX,AX										{a:=(x2-x1)+1}
	JL			@SALIR
	INC			CX

	PUSH		DI
	ADD			DI,AX										{inc(DirPant,x1);}

	MOV			BX,WORD(ci[SI])
	MOV			AX,WORD(cd[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-COLOR_PRECISION    		{incr:=(c2-c1) shl 16;}
	DW			CDQ
	DB			_386;IDIV		WORD(i)  		{incr:=incr div a;}
	DB			_386;SAR    AX,COLOR_PRECISION-8
	CMP			c1,0
	JZ			@NO_CLIP
	PUSH		AX
	IMUL		c1
	ADD			BL,AH
	INC			BL
	POP			AX

@NO_CLIP:
	MOV			BH,BL
	MOV			BL,$80                  {swap(BX)}

	PUSH		DS
	MOV			DS,vRAM

@BUCLE_G:     {ALIGN 16}					{for n:=1 to a+1 do}
	MOV			[DI],BH
	INC			DI
	ADD			BX,AX   								{inc(acum,incr);}

	DEC			CX
	JNZ			@BUCLE_G

	POP			DS
	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320      						{Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	MOV			code,TRUE

@FINAL:
	MOV			AL,code
END;

procedure ScanTextureEdge(x1,y1,x2,y2,tx1,ty1,tx2,ty2:integer);ASSEMBLER;
ASM
	PUSH		BP

	DB			_386;XOR		CX,CX

	LEA			DI,xxi+(TOPE*2) 			{DS:SI=@Xi[0]}

	MOV			BX,y1                 {if y1>y2 then...}
	MOV			CX,y2
	CMP			BX,CX
	JL			@Y_MENOR

	XCHG		BX,CX                 {...swap(y1,y2)}

	MOV			AX,x1                 {swap(x1,x2)}
	XCHG		AX,x2
	MOV			x1,AX

	MOV			AX,tx1                {swap(tx1,tx2)}
	XCHG		AX,tx2
	MOV			tx1,AX

	MOV			AX,ty1                {swap(tx1,tx2)}
	XCHG		AX,ty2
	MOV			ty1,AX

	LEA			DI,xxd+(TOPE*2) 			{DS:DI=@Xd[0]}

@Y_MENOR:
	CMP			BX,-TOPE    	{Cutre recorte... :( }
	JG			@SIGUE1
	MOV			BX,-TOPE+1

@SIGUE1:
	CMP			CX,TOPE
	JL			@SIGUE2
	MOV			CX,TOPE-1

@SIGUE2:
	SUB			CX,BX											{a:=(y2-y1)+1;}
	JL			@FIN              				{if a<=0 then goto fin;}
	INC			CX

	ADD			BX,BX
	ADD			DI,BX

	MOV			AX,x2
	SUB			AX,x1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16     		{Intercambia EAX}
	DB			_386;MOV    WORD(mdx),AX	{mdx:=(x2-x1) shl 16 div a;}

	MOV			AX,tx2
	SUB			AX,tx1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16     		{Intercambia EAX}
	DB			_386;MOV    WORD(msx),AX  {msx:=(tx2-tx1) shl 16 div a;}

	MOV			AX,ty2
	SUB			AX,ty1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16    		{Intercambia EAX}
	DB			_386;MOV    WORD(msy),AX  {msy:=(ty2-ty1) shl 16 div a;}

	DB			$66,$BE;DD $80000000			{MOV ESI,$80000000}
	DB			_386;MOV		DX,SI
	DB			_386;MOV		BX,SI
	MOV			SI,x1
	MOV			DX,tx1
	MOV			BX,ty1

	MOV			j,CX

	DB			_386;MOV		CX,WORD(mdx)
	DB			_386;MOV		AX,WORD(msy)
	DB			_386;MOV		BP,WORD(msx)

@BUCLE:          								{for y:=my to mxy+1 do}
	MOV			[DI],SI               {xxi[y]:=x1;}
	MOV			[DI+(TOPE*4+2)],DL    {sxi[y]:=tx1;}
	MOV			[DI+(TOPE*8+4)],BL    {syi[y]:=ty1;}
	ADD			DI,2

	DB			_386;ADD		SI,CX    	{add(x1,mdx);		16:16}
	ADC			SI,0

	DB			_386;ADD		DX,BP     {add(tx1,msx);	16:16}
	ADC			DL,0
	DB			_386;ADD		BX,AX    	{add(ty1,msy);	16:16}
	ADC			BL,0

	DEC			j
	JNZ			@BUCLE

@FIN:
	POP			BP
END;

var
	k:LongInt;
	c1:integer;
	t:word;

function TextureTriangle(y1,x1,ty1,tx1,y2,x2,ty2,tx2,y3,x3,ty3,tx3:integer;texture:word):boolean;ASSEMBLER;
ASM
	MOV			code,FALSE

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y1<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y1>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:                    {AX=my / BX=mxy}
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JGE			@FINAL				{if my>region.ylr then goto final}
	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	PUSH		x1
	PUSH		y1
	PUSH		x2
	PUSH		y2
	PUSH		tx1
	PUSH		ty1
	PUSH		tx2
	PUSH		ty2
	CALL		ScanTextureEdge

	PUSH		x2
	PUSH		y2
	PUSH		x3
	PUSH		y3
	PUSH		tx2
	PUSH		ty2
	PUSH		tx3
	PUSH		ty3
	CALL		ScanTextureEdge

	PUSH		x3
	PUSH		y3
	PUSH		x1
	PUSH		y1
	PUSH		tx3
	PUSH		ty3
	PUSH		tx1
	PUSH		ty1
	CALL		ScanTextureEdge

	MOV			AX,my

	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX

	MOV			BX,mxy
	SUB			BX,AX
	JL			@FINAL
	INC			BX
	MOV		 	j,BX                    {for j:=(mxy-my)+1 DownTo 0 do}

	MOV			ES,vRAM
	MOV			AX,texture
	MOV			t,AX

	PUSH		BP
	DB			_386;XOR		BP,BP
	DB			_386;MOV		WORD(k),BP{}

@BUCLE_P:
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			BP,WORD(xxd[SI])
	CMP			BP,DX     							{if x2<region.xul then goto salir}
	JL			@SALIR
	MOV			AX,WORD(xxi[SI])
	CMP			AX,BX     							{if x1>region.xlr then goto salir}
	JG			@SALIR

	MOV			WORD(k),BP
	SUB			WORD(k),AX
	JL			@SALIR
	INC			WORD(k)

	CMP			BP,BX   								{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE10
	MOV			BP,BX

@SIGUE10:
	MOV			c1,0
	CMP			AX,DX     							{if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE20
	MOV			c1,DX
	SUB			c1,AX
	MOV			AX,DX

@SIGUE20:
	SUB			BP,AX										{a:=(x2-x1)+1;}
	JL			@SALIR    							{if x2<=0 then goto salir;}
	INC			BP

	PUSH		DI
	ADD			DI,AX										{inc(DirPant,x1);}

	MOV			AX,WORD(sxd[SI])
	MOV			BX,WORD(sxi[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8
	MOV			WORD(msx),AX					{msx=(sxd[n]-sxi[n] shl 16) div a}
	CMP			c1,0
	JZ			@NO_CLIP1
	IMUL		c1
	ADD			BL,AH
	INC			BL

@NO_CLIP1:
	MOV			AX,WORD(syd[SI])
	MOV			CX,WORD(syi[SI]) 		{sy=syi[n]}
	SUB			AX,CX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)  {msy=(syd[n]-syi[n] shl 16) div a shr 8}
	DB			_386;SAR		AX,TEXTURE_PRECISION-8
	CMP			c1,0
	JZ			@NO_CLIP2
	PUSH		AX
	IMUL		c1
	ADD			CL,AH
	INC			CL
	POP			AX

@NO_CLIP2:
	MOV			CH,CL
	MOV			CL,$80
	DB			_386;ROL		CX,16
	MOV			CH,BL
	MOV			CL,$80

	DB			_386;ROL		AX,16
	MOV			AX,WORD(msx)

	PUSH		DS
	MOV			DS,t                    {DS=texture, ES=vRAM}

@BUCLE_G:             						{for n:=1 to (x2-x1)+1 do}
	DB 			$66,$0F,$A4,$CB,$10			{SHLD EBX,ECX,16}
	MOV			BL,CH
	DB			_386;ADD		CX,AX     	{add(sy|sx,msy|msx);}

	MOV			BL,[BX]
	MOV			ES:[DI],BL     					{plot(sxi[j]+n,syi[j],test(sx,sy);}
	INC			DI

	DEC			BP
	JNZ			@BUCLE_G

	POP			DS
	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320      						{Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	POP			BP

	MOV			code,TRUE

@FINAL:
	MOV			AL,code
END;

function TextureTransparentTriangle(y1,x1,ty1,tx1,y2,x2,ty2,tx2,y3,x3,ty3,tx3:integer;texture,trans:word):boolean;ASSEMBLER;
ASM
	MOV			code,FALSE

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y1<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y1>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:                    {AX=my / BX=mxy}
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JGE			@FINAL				{if my>region.ylr then goto final}
	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	PUSH		x1
	PUSH		y1
	PUSH		x2
	PUSH		y2
	PUSH		tx1
	PUSH		ty1
	PUSH		tx2
	PUSH		ty2
	CALL		ScanTextureEdge

	PUSH		x2
	PUSH		y2
	PUSH		x3
	PUSH		y3
	PUSH		tx2
	PUSH		ty2
	PUSH		tx3
	PUSH		ty3
	CALL		ScanTextureEdge

	PUSH		x3
	PUSH		y3
	PUSH		x1
	PUSH		y1
	PUSH		tx3
	PUSH		ty3
	PUSH		tx1
	PUSH		ty1
	CALL		ScanTextureEdge

	MOV			AX,my

	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX

	MOV			BX,mxy
	SUB			BX,AX
	JL			@FINAL
	INC			BX
	MOV		 	j,BX                    {for j:=(mxy-my)+1 DownTo 0 do}

	MOV			ES,vRAM
	MOV			AX,texture
	MOV			t,AX
	MOV			AX,trans
	DW			MOV_GS_AX

	PUSH		BP
	DB			_386;XOR		BP,BP
	DB			_386;MOV		WORD(k),BP{}

@BUCLE_P:
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			BP,WORD(xxd[SI])
	CMP			BP,DX     							{if x2<region.xul then goto salir}
	JL			@SALIR
	MOV			AX,WORD(xxi[SI])
	CMP			AX,BX     							{if x1>region.xlr then goto salir}
	JG			@SALIR

	MOV			WORD(k),BP
	SUB			WORD(k),AX
	JL			@SALIR
	INC			WORD(k)

	CMP			BP,BX   								{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE10
	MOV			BP,BX

@SIGUE10:
	MOV			c1,0
	CMP			AX,DX     							{if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE20
	MOV			c1,DX
	SUB			c1,AX
	MOV			AX,DX

@SIGUE20:
	SUB			BP,AX										{a:=(x2-x1)+1;}
	JL			@SALIR    							{if x2<=0 then goto salir;}
	INC			BP

	PUSH		DI
	ADD			DI,AX										{inc(DirPant,x1);}

	MOV			AX,WORD(sxd[SI])
	MOV			BX,WORD(sxi[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8
	MOV			WORD(msx),AX					{msx=(sxd[n]-sxi[n] shl 16) div a}
	CMP			c1,0
	JZ			@NO_CLIP1
	IMUL		c1
	ADD			BL,AH
	INC			BL

@NO_CLIP1:
	MOV			AX,WORD(syd[SI])
	MOV			CX,WORD(syi[SI]) 		{sy=syi[n]}
	SUB			AX,CX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)  {msy=(syd[n]-syi[n] shl 16) div a shr 8}
	DB			_386;SAR		AX,TEXTURE_PRECISION-8
	CMP			c1,0
	JZ			@NO_CLIP2
	PUSH		AX
	IMUL		c1
	ADD			CL,AH
	INC			CL
	POP			AX

@NO_CLIP2:
	MOV			CH,CL
	MOV			CL,$80
	DB			_386;ROL		CX,16
	MOV			CH,BL
	MOV			CL,$80

	DB			_386;ROL		AX,16
	MOV			AX,WORD(msx)

	PUSH		DS
	MOV			DS,t                    {DS=texture, ES=vRAM, GS=trans}

@BUCLE_G:             						{for n:=1 to (x2-x1)+1 do}
	DB 			$66,$0F,$A4,$CB,$10			{SHLD EBX,ECX,16}
	MOV			BL,CH
	DB			_386;ADD		CX,AX     	{add(sy|sx,msy|msx);}

	MOV			BL,[BX]
	MOV			BH,ES:[DI]
	DB			GS;MOV		BL,[BX]
	MOV			ES:[DI],BL     					{plot(sxi[j]+n,syi[j],test(sx,sy);}
	INC			DI

	DEC			BP
	JNZ			@BUCLE_G

	POP			DS
	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320      						{Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	POP			BP

	MOV			code,TRUE

@FINAL:
	MOV			AL,code
END;

var
	i,l:integer;

function TextureTriangleFlat(x1,y1,tx1,ty1,
															x2,y2,tx2,ty2,
															x3,y3,tx3,ty3,c:integer;
															texture,light:word):boolean;ASSEMBLER;
ASM
	MOV			code,FALSE

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y1<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y1>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:                    {AX=my / BX=mxy}
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JG			@FINAL				{if my>region.ylr then goto final}

	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	PUSH		x1
	PUSH		y1
	PUSH		x2
	PUSH		y2
	PUSH		tx1
	PUSH		ty1
	PUSH		tx2
	PUSH		ty2
	CALL		ScanTextureEdge

	PUSH		x2
	PUSH		y2
	PUSH		x3
	PUSH		y3
	PUSH		tx2
	PUSH		ty2
	PUSH		tx3
	PUSH		ty3
	CALL		ScanTextureEdge

	PUSH		x3
	PUSH		y3
	PUSH		x1
	PUSH		y1
	PUSH		tx3
	PUSH		ty3
	PUSH		tx1
	PUSH		ty1
	CALL		ScanTextureEdge

	MOV			AX,my

	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX

	MOV			BX,mxy
	SUB			BX,AX
	JL			@FINAL
	INC			BX
	MOV		 	j,BX                    {for j:=(mxy-my)+1 DownTo 0 do}

	MOV			ES,vRAM
	MOV			AX,light
	DW			MOV_FS_AX
	MOV			AX,c
	MOV			i,AX
	MOV			AX,texture
	MOV			t,AX

	PUSH		BP
	DB			_386;XOR		BP,BP				{hi(BP)=0}
	DB			_386;MOV		WORD(k),BP{}

@BUCLE_P:
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			AX,WORD(xxi[SI])
	CMP			AX,BX     							{if x1>region.xlr then goto salir}
	JG			@SALIR
	MOV			BP,WORD(xxd[SI])
	CMP			BP,DX     							{if x2<region.xul then goto salir}
	JL			@SALIR

	MOV			WORD(k),BP
	SUB			WORD(k),AX
	JL			@SALIR
	INC			WORD(k)

	MOV			c1,0
	CMP			AX,DX     							{if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			c1,DX
	SUB			c1,AX
	MOV			AX,DX

@SIGUE10:
	CMP			BP,BX   								{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE20
	MOV			BP,BX

@SIGUE20:
	SUB			BP,AX										{a:=(x2-x1)+1}
	JL			@SALIR    							{if x2<=0 then goto salir}
	INC			BP

	PUSH		DI
	ADD			DI,AX										{inc(DirPant,x1);}

	MOV			AX,WORD(syd[SI])
	MOV			BX,WORD(syi[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8  	{msx=(sxd[n]-sxi[n] shl 16) div a}
	MOV			WORD(msy),AX
	CMP			c1,0
	JZ			@NO_CLIP1
	IMUL		c1
	ADD			BL,AH
	INC			BL

@NO_CLIP1:
	MOV			CH,BL
	MOV			CL,$80
	DB			_386;ROL		CX,16

	MOV			AX,WORD(sxd[SI])
	MOV			BX,WORD(sxi[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8  	{msx=(sxd[n]-sxi[n] shl 16) div a}
	CMP			c1,0
	JZ			@NO_CLIP2
	PUSH		AX
	IMUL		c1
	ADD			BL,AH
	INC			BL
	POP			AX

@NO_CLIP2:
	MOV			CH,BL  									{sx=sxi[n]}
	MOV			CL,$80

	DB			_386;ROL		AX,16
	MOV			AX,WORD(msy)
	DB			_386;ROL		AX,16{}

	MOV			DL,BYTE(i)

	PUSH		DS                      {DS=texture, ES=vRAM, FS=light}
	MOV			DS,t

@BUCLE:             							{for n:=1 to (x2-x1)+1 do}
	DB 			$66,$0F,$A4,$CB,$10			{SHLD EBX,ECX,16}
	MOV			BL,CH

	DB			_386;ADD		CX,AX     	{add(sy|sx,msy|msx);}

	MOV			BH,[BX]                 {color de la textura}
	MOV			BL,DL										{color de la luz}
	DB			FS;MOV			BL,[BX]     {color destino}

	MOV			ES:[DI],BL     					{plot(sxi[j]+n,syi[j],test(sx,sy);}
	INC			DI

	DEC			BP
	JNZ			@BUCLE

	POP			DS
	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320      						{Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	POP			BP

	MOV			code,TRUE

@FINAL:
	MOV			AL,code
END;

var
	IncCol,AcumCol:word;

procedure ScanTextureGouraudEdge(x1,y1,x2,y2,tx1,ty1,tx2,ty2,c1,c2:integer);ASSEMBLER;
ASM
	PUSH		BP

	DB			_386;XOR		CX,CX

	LEA			DI,xxi+(TOPE*2) 			{DS:SI=@Xi[0]}

	MOV			BX,y1                 {if y1>y2 then...}
	MOV			CX,y2
	CMP			BX,CX
	JL			@Y_MENOR

	XCHG		BX,CX                 {...swap(y1,y2)}

	MOV			AX,x1                 {swap(x1,x2)}
	XCHG		AX,x2
	MOV			x1,AX

	MOV			AX,c1                 {swap(c1,c2)}
	XCHG		AX,c2
	MOV			c1,AX

	MOV			AX,tx1                {swap(tx1,tx2)}
	XCHG		AX,tx2
	MOV			tx1,AX

	MOV			AX,ty1                {swap(tx1,tx2)}
	XCHG		AX,ty2
	MOV			ty1,AX

	LEA			DI,xxd+(TOPE*2) 			{DS:DI=@Xd[0]}

@Y_MENOR:
	CMP			BX,-TOPE    	{Cutre recorte... :( }
	JG			@SIGUE1
	MOV			BX,-TOPE+1

@SIGUE1:
	CMP			CX,TOPE
	JL			@SIGUE2
	MOV			CX,TOPE-1

@SIGUE2:
	SUB			CX,BX											{a:=(y2-y1)+1;}
	JL			@FIN              				{if a<0 then goto fin;}
	INC			CX
	MOV			j,CX

	ADD			BX,BX
	ADD			DI,BX

	FILD    ty2
	FISUB		ty1
	FIDIV		j         								{ST(1)=msy:=(ty2-ty1)/l}
	FILD		ty1        								{ST(0)=ty}

	MOV			AX,c2
	MOV			BX,c1
	SUB			AX,BX
	DB			_386;ROR		AX,32-COLOR_PRECISION
	DW			CDQ
	DB			_386;IDIV		CX            {incr:=(c2-c1) shl 16 div a shr 8;}
	DB			_386;SAR		AX,COLOR_PRECISION-8
	MOV			BH,BL
	MOV			BL,$80                		{BX=color1:$80 ; AX=incr}
	MOV     AcumCol,BX
	MOV     IncCol,AX

	MOV			AX,tx2
	SUB			AX,tx1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16     		{Intercambia EAX}
	DB			_386;MOV    WORD(msx),AX  {msx:=(tx2-tx1) shl 16 div a;}

	DB			$66,$BE;DD $80000000			{MOV ESI,$80000000}
	MOV			AX,x2
	MOV			SI,x1
	SUB			AX,SI
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16         {mdx:=(x2-x1) shl 16 div a;}
	DB			_386;MOV    WORD(mdx),AX

	{$IFDEF __BPPROT__}
	PUSH		DS
	MOV			CX,IncCol
	MOV			DX,CS
	ADD			DX,SelectorInc
	MOV			DS,DX
	MOV			WORD(DS:@IC+2),CX
	POP			DS
	{$ELSE}
	MOV			CX,IncCol
	MOV			WORD(@IC+2),CX
	{$ENDIF}

	DB			_386;MOV		DX,SI
	MOV			DL,BYTE(tx1)
	DB			_386;MOV		BP,WORD(msx)
	MOV			CX,AcumCol            {ESI=$8000:x1 | EAX=incr:signe}

@BUCLE:          								{for y:=my to mxy+1 do}
	MOV			[DI],SI               {xxi[y]:=x1;}
	MOV			[DI+(TOPE*4+2)],DL    {sxi[y]:=tx1;}
	FIST		WORD([DI+(TOPE*8+4)])	{syi[y]:=ty1;}
	MOV			[DI+(TOPE*12)+6],CH		{ci[y]:=AcumCol;}
	ADD			DI,2

@IC:
	ADD			CX,$FFFF

	DB			_386;ADD		SI,AX    	{add(x1,mdx);		16:16}
	ADC			SI,0

	DB			_386;ADD		DX,BP     {add(tx1,msx);	16:16}
	ADC			DL,0

	FADD		ST(0),ST(1)           {add(ty1,msy);}

	DEC			j
	JNZ			@BUCLE

	FISTP		j
	FISTP		j{}

@FIN:
	POP			BP
END;

var
	cc:integer;

function TextureTriangleGouraud(x1,y1,tx1,ty1,c1,
																x2,y2,tx2,ty2,c2,
																x3,y3,tx3,ty3,c3:integer;
																texture,light:word):boolean;ASSEMBLER;
ASM
	MOV			code,FALSE

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y1<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y1>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:                    {AX=my / BX=mxy}
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JG			@FINAL				{if my>region.ylr then goto final}

	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	PUSH		x1
	PUSH		y1
	PUSH		x2
	PUSH		y2
	PUSH		tx1
	PUSH		ty1
	PUSH		tx2
	PUSH		ty2
	PUSH		c1
	PUSH		c2
	CALL		ScanTextureGouraudEdge

	PUSH		x2
	PUSH		y2
	PUSH		x3
	PUSH		y3
	PUSH		tx2
	PUSH		ty2
	PUSH		tx3
	PUSH		ty3
	PUSH		c2
	PUSH		c3
	CALL		ScanTextureGouraudEdge

	PUSH		x3
	PUSH		y3
	PUSH		x1
	PUSH		y1
	PUSH		tx3
	PUSH		ty3
	PUSH		tx1
	PUSH		ty1
	PUSH		c3
	PUSH		c1
	CALL		ScanTextureGouraudEdge

	MOV			AX,my

	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX

	MOV			BX,mxy
	SUB			BX,AX
	JL			@FINAL
	INC			BX
	MOV		 	j,BX                    {for j:=(mxy-my)+1 DownTo 0 do}

	MOV			ES,vRAM
	MOV			AX,light
	DW			MOV_FS_AX
	MOV			AX,texture
	MOV			t,AX

	PUSH		BP
	DB			_386;XOR		BP,BP				{hi(BP)=0}
	DB			_386;MOV		WORD(k),BP{}

@BUCLE_P:
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			AX,WORD(xxi[SI])
	CMP			AX,BX     							{if x1>region.xlr then goto salir}
	JG			@SALIR
	MOV			BP,WORD(xxd[SI])
	CMP			BP,DX     							{if x2<region.xul then goto salir}
	JL			@SALIR

	MOV			WORD(k),BP
	SUB			WORD(k),AX
	JL			@SALIR
	INC			WORD(k)

	MOV			cc,0
	CMP			AX,DX     							{if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			cc,DX
	SUB			cc,AX                   {cc:=region.xul-x1}
	MOV			AX,DX

@SIGUE10:
	CMP			BP,BX   								{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE20
	MOV			BP,BX

@SIGUE20:
	SUB			BP,AX										{a:=(x2-x1)+1}
	JL			@SALIR    							{if x2<=0 then goto salir}
	INC			BP

	PUSH		DI
	ADD			DI,AX										{inc(DirPant,x1);}

	MOV			AX,WORD(cd[SI])
	MOV			BX,WORD(ci[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-COLOR_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)    	{incr:=(c2-c1) shl 16 div a shr 8;}
	DB			_386;SAR		AX,COLOR_PRECISION-8
	MOV			IncCol,AX
	CMP			cc,0
	JZ			@NO_CLIP0
	IMUL		cc
	ADD			BL,AH
	INC			BL

@NO_CLIP0:
	MOV			CH,BL
	MOV			CL,$80                  {CX=swap(BX)}
	MOV			AcumCol,CX

	MOV			AX,WORD(syd[SI])
	MOV			BX,WORD(syi[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8  	{msy=(syd[n]-syi[n] shl 16) div a}
	MOV			WORD(msy),AX
	CMP			cc,0
	JZ			@NO_CLIP1
	IMUL		cc
	ADD			BL,AH
	INC			BL

@NO_CLIP1:
	MOV			CH,BL
	MOV			CL,$80
	DB			_386;ROL		CX,16

	MOV			AX,WORD(sxd[SI])
	MOV			BX,WORD(sxi[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8  	{msx=(sxd[n]-sxi[n] shl 16) div a}
	CMP			cc,0
	JZ			@NO_CLIP2
	PUSH		AX
	IMUL		cc
	ADD			BL,AH
	INC			BL
	POP			AX

@NO_CLIP2:
	MOV			CH,BL  									{sx=sxi[n]}
	MOV			CL,$80

	DB			_386;ROL		AX,16
	MOV			AX,WORD(msy)
	DB			_386;ROL		AX,16{}

	MOV			DX,AcumCol
	PUSH		SI
	MOV			SI,IncCol

	PUSH		DS                      {DS=texture, ES=vRAM, FS=light}
	MOV			DS,t

@BUCLE:             							{for n:=1 to (x2-x1)+1 do}
	DB 			$66,$0F,$A4,$CB,$10			{SHLD EBX,ECX,16}
	MOV			BL,CH

	DB			_386;ADD		CX,AX     	{add(sy|sx,msy|msx);}

	MOV			BH,[BX]                 {color de la textura}
	MOV			BL,DH										{color de la luz}
	DB			FS;MOV			BL,[BX]     {color destino}

	ADD			DX,SI

	MOV			ES:[DI],BL     {plot(sxi[j]+n,syi[j],test(sx,sy);}
	INC			DI

	DEC			BP
	JNZ			@BUCLE

	POP			DS
	POP			SI
	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320      						{Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	POP			BP

	MOV			code,TRUE

@FINAL:
	MOV			AL,code
END;

var
	mu,mv:Longint;

procedure ScanTextureEnvMapEdge(x1,y1,x2,y2,tx1,ty1,tx2,ty2,u1,v1,u2,v2:integer);ASSEMBLER;
ASM
	PUSH		BP
	DB			_386;XOR		CX,CX

	LEA			DI,xxi+(TOPE*2) 			{DS:SI=@Xi[0]}

	MOV			BX,y1                 {if y1>y2 then...}
	MOV			CX,y2
	CMP			BX,CX
	JL			@Y_MENOR

	XCHG		BX,CX                 {...swap(y1,y2)}

	MOV			AX,x1                 {swap(x1,x2)}
	XCHG		AX,x2
	MOV			x1,AX

	MOV			AX,tx1                {swap(tx1,tx2)}
	XCHG		AX,tx2
	MOV			tx1,AX

	MOV			AX,ty1                {swap(ty1,ty2)}
	XCHG		AX,ty2
	MOV			ty1,AX

	MOV			AX,u1                	{swap(u1,u2)}
	XCHG		AX,u2
	MOV			u1,AX

	MOV			AX,v1                	{swap(v1,v2)}
	XCHG		AX,v2
	MOV			v1,AX

	LEA			DI,xxd+(TOPE*2) 			{DS:DI=@Xd[0]}

@Y_MENOR:
	CMP			BX,-TOPE    	{Cutre recorte... :( }
	JG			@SIGUE1
	MOV			BX,-TOPE+1

@SIGUE1:
	CMP			CX,TOPE
	JL			@SIGUE2
	MOV			CX,TOPE-1

@SIGUE2:
	SUB			CX,BX											{a:=(y2-y1)+1;}
	JL			@FIN              				{if a<=0 then goto fin;}
	INC			CX
	MOV			j,CX

	ADD			BX,BX
	ADD			DI,BX

	MOV			AX,u2
	SUB			AX,u1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16     		{Intercambia EAX}
	DB			_386;MOV    WORD(mu),AX		{mu:=(u2-u1) shl 16 div a;}

	MOV			AX,v2
	SUB			AX,v1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16     		{Intercambia EAX}
	DB			_386;MOV    WORD(mv),AX		{mu:=(u2-u1) shl 16 div a;}

	MOV			AX,x2
	SUB			AX,x1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16     		{Intercambia EAX}
	DB			_386;MOV    WORD(mdx),AX	{mdx:=(x2-x1) shl 16 div a;}

	MOV			AX,tx2
	SUB			AX,tx1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16     		{Intercambia EAX}
	DB			_386;MOV    WORD(msx),AX  {msx:=(tx2-tx1) shl 16 div a;}

	MOV			AX,ty2
	SUB			AX,ty1
	DB			_386;SHL		AX,16
	DW			CDQ
	DB			_386;IDIV		CX
	DB			_386;ROL		AX,16    		{Intercambia EAX}
	DB			_386;MOV    WORD(msy),AX  {msy:=(ty2-ty1) shl 16 div a;}

	DB			$66,$BE;DD $80000000			{MOV ESI,$80000000}
	DB			_386;MOV		DX,SI
	DB			_386;MOV		BX,SI
	DB			_386;MOV		AX,SI
	DB			_386;MOV		CX,SI
	MOV			SI,x1
	MOV			DX,tx1
	MOV			BX,ty1
	MOV			AX,u1
	MOV			CX,v1

	MOV			BP,j

@BUCLE:          								{for y:=my to mxy+1 do}
	MOV			[DI],SI               {xxi[y]:=x1;}
	MOV			[DI+(TOPE*4+2)],DL    {sxi[y]:=tx1;}
	MOV			[DI+(TOPE*8+4)],BL    {syi[y]:=ty1;}
	MOV			[DI+(TOPE*16+8)],AL   {ui[y]:=u1;}
	MOV			[DI+(TOPE*20+10)],CL  {vi[y]:=v1;}
	ADD			DI,2

	DB			_386;ADD		SI,WORD(mdx)  {add(x1,mdx);		16:16}
	ADC			SI,0

	DB			_386;ADD		DX,WORD(msx)  {add(tx1,msx);	16:16}
	ADC			DL,0
	DB			_386;ADD		BX,WORD(msy)  {add(ty1,msy);	16:16}
	ADC			BL,0

	DB			_386;ADD		AX,WORD(mu)
	ADC			AL,0

	DB			_386;ADD		CX,WORD(mv)
	ADC			CL,0

	DEC			BP
	JNZ			@BUCLE

@FIN:
	POP			BP
END;

function TextureTriangleEnvMap(	x1,y1,tx1,ty1,u1,v1,
																x2,y2,tx2,ty2,u2,v2,
																x3,y3,tx3,ty3,u3,v3:integer;
																texture,EnvMap,light:word):boolean;ASSEMBLER;
ASM
	MOV			code,FALSE

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y1<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y1>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:                    {AX=my / BX=mxy}
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JGE			@FINAL				{if my>region.ylr then goto final}
	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	PUSH		x1
	PUSH		y1
	PUSH		x2
	PUSH		y2
	PUSH		tx1
	PUSH		ty1
	PUSH		tx2
	PUSH		ty2
	PUSH		u1
	PUSH		v1
	PUSH		u2
	PUSH		v2
	CALL		ScanTextureEnvMapEdge

	PUSH		x2
	PUSH		y2
	PUSH		x3
	PUSH		y3
	PUSH		tx2
	PUSH		ty2
	PUSH		tx3
	PUSH		ty3
	PUSH		u2
	PUSH		v2
	PUSH		u3
	PUSH		v3
	CALL		ScanTextureEnvMapEdge

	PUSH		x3
	PUSH		y3
	PUSH		x1
	PUSH		y1
	PUSH		tx3
	PUSH		ty3
	PUSH		tx1
	PUSH		ty1
	PUSH		u3
	PUSH		v3
	PUSH		u1
	PUSH		v1
	CALL		ScanTextureEnvMapEdge

	MOV			AX,my

	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX

	MOV			BX,mxy
	SUB			BX,AX
	JL			@FINAL
	INC			BX
	MOV		 	j,BX                    {for j:=(mxy-my)+1 DownTo 0 do}

	MOV			ES,vRAM
	MOV			AX,texture
	MOV			t,AX
	MOV			AX,EnvMap
	DW			MOV_FS_AX
	MOV			AX,light
	DW			MOV_GS_AX

	PUSH		BP
	DB			_386;XOR		BP,BP
	DB			_386;MOV		WORD(k),BP{}

@BUCLE_P:
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			BP,WORD(xxd[SI])
	CMP			BP,DX     							{if x2<region.xul then goto salir}
	JL			@SALIR
	MOV			AX,WORD(xxi[SI])
	CMP			AX,BX     							{if x1>region.xlr then goto salir}
	JG			@SALIR

	MOV			WORD(k),BP
	SUB			WORD(k),AX
	JL			@SALIR
	INC			WORD(k)

	CMP			BP,BX   								{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE10
	MOV			BP,BX

@SIGUE10:
	MOV			c1,0
	CMP			AX,DX     							{if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE20
	MOV			c1,DX
	SUB			c1,AX
	MOV			AX,DX

@SIGUE20:
	SUB			BP,AX										{a:=(x2-x1)+1;}
	JL			@SALIR    							{if x2<=0 then goto salir;}
	INC			BP

	PUSH		DI
	ADD			DI,AX										{inc(DirPant,x1);}

	MOV			AX,WORD(ud[SI])
	SUB			AX,WORD(ui[SI])
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8
	MOV			WORD(mu),AX					{msx=(sxd[n]-sxi[n] shl 16) div a}
	CMP			c1,0
	JZ			@NO_CLIP00
	IMUL		c1
	INC			AH
	ADD			BYTE(ui[SI]),AH

@NO_CLIP00:
	MOV			AX,WORD(vd[SI])
	SUB			AX,WORD(vi[SI])
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8
	MOV			WORD(mv),AX					{msx=(sxd[n]-sxi[n] shl 16) div a}
	CMP			c1,0
	JZ			@NO_CLIP01
	IMUL		c1
	INC			AH
	ADD			BYTE(vi[SI]),AH

@NO_CLIP01:
	MOV			AX,WORD(sxd[SI])
	MOV			BX,WORD(sxi[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)
	DB			_386;SAR		AX,TEXTURE_PRECISION-8
	MOV			WORD(msx),AX					{msx=(sxd[n]-sxi[n] shl 16) div a}
	CMP			c1,0
	JZ			@NO_CLIP1
	IMUL		c1
	ADD			BL,AH
	INC			BL

@NO_CLIP1:
	MOV			AX,WORD(syd[SI])
	MOV			CX,WORD(syi[SI]) 		{sy=syi[n]}
	SUB			AX,CX
	DB			_386;ROR		AX,32-TEXTURE_PRECISION
	DW			CDQ
	DB			_386;IDIV		WORD(k)  {msy=(syd[n]-syi[n] shl 16) div a shr 8}
	DB			_386;SAR		AX,TEXTURE_PRECISION-8
	CMP			c1,0
	JZ			@NO_CLIP2
	PUSH		AX
	IMUL		c1
	ADD			CL,AH
	INC			CL
	POP			AX

@NO_CLIP2:
	MOV			CH,CL
	MOV			CL,$80
	DB			_386;ROL		CX,16
	MOV			CH,BL
	MOV			CL,$80

	DB			_386;ROL		AX,16
	MOV			AX,WORD(msx)

	MOV			DH,BYTE(ui[SI])
	MOV			DL,$80
	DB			_386;ROL		DX,16
	MOV			DH,BYTE(vi[SI])
	MOV			DL,$80

	PUSH		SI
	MOV			SI,WORD(mu)
	DB			_386;ROL		SI,16
	MOV			SI,WORD(mv)

	PUSH		DS
	PUSH		t
	{$IFDEF __BPPROT__}
	MOV			BX,CS
	ADD			BX,SelectorInc
	MOV			DS,BX
	DB			_386;MOV		WORD(DS:@AUTO_AX+3),AX
	{$ELSE}
	DB			_386;MOV		WORD(CS:@AUTO_AX+3),AX
	{$ENDIF}
	POP			DS

@BUCLE_G:   						{DS=texture, FS=envmap, GS=light, ES=screen}
	DB 			$66,$0F,$A4,$D3,$10			{SHLD EBX,EDX,16}
	MOV			BL,DH
	DB			_386;ADD		DX,SI
	DB			FS;MOV			AL,[BX]

	DB 			$66,$0F,$A4,$CB,$10			{SHLD EBX,ECX,16}
	MOV			BL,CH
@AUTO_AX:
	DB			$66,$81,$C1,0,0,0,0			{ADD ECX,n=add(sy|sx,msy|msx);}
	MOV			BH,[BX]

	MOV			BL,AL
	DB			GS;MOV			BL,[BX]
	MOV			ES:[DI],BL     					{plot(sxi[j]+n,syi[j],test(sx,sy);}
	INC			DI

	DEC			BP
	JNZ			@BUCLE_G

@ENDED:
	POP			DS
	POP			SI
	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320      						{Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	POP			BP

	MOV			code,TRUE

@FINAL:
	MOV			AL,code
END;

function FlatTransparentTriangle(x1,y1,x2,y2,x3,y3,c:integer;trans,light:word):boolean;ASSEMBLER;
ASM
	CLD
	PUSH		BP

	MOV			code,FALSE

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y2<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y2>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JGE			@FINAL				{if my>region.ylr then goto final}
	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	DB			_386;XOR		CX,CX

	PUSH		x1
	PUSH		y1
	PUSH		x2
	PUSH		y2
	CALL		ScanFlatEdge

	PUSH		x2
	PUSH		y2
	PUSH		x3
	PUSH		y3
	CALL		ScanFlatEdge

	PUSH		x3
	PUSH		y3
	PUSH		x1
	PUSH		y1
	CALL		ScanFlatEdge

	MOV			AX,c
	MOV			i,AX
	MOV			ES,vRAM
	MOV			AX,trans
	DW			MOV_GS_AX
	MOV			AX,light
	DW			MOV_FS_AX

	MOV			AX,my
	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX                   {DS:SI=@Xi[my]}

	MOV			BP,mxy
	SUB			BP,AX
	JL			@FINAL
	INC			BP                      {for n:=(mxy-my)+1 DownTo 0 do}
	MOV			j,BP

@BUCLE_P:                         {ALIGN 16}
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			BP,WORD(xxi[SI])
	CMP			BP,BX     {if x1>region.xlr then goto salir}
	JGE			@SALIR
	MOV			CX,WORD(xxd[SI])
	CMP			CX,DX     {if x2<region.xul then goto salir}
	JL			@SALIR

	CMP			BP,DX     {if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			BP,DX

@SIGUE10:
	CMP			CX,BX   	{if x2>region.xlr then x2:=region.xlr}
	JL			@SIGUE20
	MOV			CX,BX

@SIGUE20:
	SUB			CX,BP			{x2:=(x2-x1)+1;}
	JL			@SALIR    {if x2<=0 then goto salir}
	INC			CX

	MOV			DL,BYTE(i)

	PUSH		DI
	ADD			DI,BP			{inc(DirPant,x1);}

@BUCLE:							{GS=trans, FS=light}
	MOV			BH,ES:[DI]
	MOV			BL,DL
	DB			GS;MOV		BH,[BX]
	MOV			BL,DL
	DB			FS;MOV		BL,[BX]
	MOV			ES:[DI],BL
	INC			DI
	DEC			CX
	JNZ			@BUCLE

	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320    {Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	MOV			code,TRUE

@FINAL:
	POP			BP

	MOV			AL,code
END;

function GouraudTransparentTriangle(x1,y1,c1,x2,y2,c2,x3,y3,c3:integer;trans,light:word):boolean;ASSEMBLER;
ASM
	CLD
	PUSH		BP

	MOV			code,FALSE

	MOV			CX,y1
	MOV			SI,y2
	MOV			DI,y3

	MOV			AX,CX         {if y1<y2 then my:=y2;}
	CMP			AX,SI
	JLE			@M1
	MOV			AX,SI

@M1:
	CMP			AX,DI         {if y2<y3 then my:=y3;}
	JLE			@M2
	MOV			AX,DI

@M2:
	MOV			BX,CX         {if y1>y2 then mxy:=y2;}
	CMP			BX,SI
	JGE			@M3
	MOV			BX,SI

@M3:
	CMP			BX,DI         {if y2>y3 then mxy:=y3;}
	JGE			@M4
	MOV			BX,DI

@M4:
	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JGE			@FINAL				{if my>region.ylr then goto final}
	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JG			@FINAL        {if my>mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

	MOV			AX,x1
	MOV			BX,x2
	MOV			CX,x3

	CMP			AX,BX
	JLE			@MX1
	XCHG		AX,BX

@MX1:
	CMP			BX,CX
	JLE			@MX2
	XCHG		BX,CX

@MX2:
	CMP			AX,BX
	JLE			@MX3
	XCHG		AX,BX

@MX3:
	CMP			AX,region.xlr
	JG			@FINAL
	CMP			CX,region.xul
	JL			@FINAL

	DB			_386;XOR		CX,CX

	PUSH		x1
	PUSH		y1
	PUSH		c1
	PUSH		x2
	PUSH		y2
	PUSH		c2
	CALL		ScanGouraudEdge

	PUSH		x2
	PUSH		y2
	PUSH		c2
	PUSH		x3
	PUSH		y3
	PUSH		c3
	CALL		ScanGouraudEdge

	PUSH		x3
	PUSH		y3
	PUSH		c3
	PUSH		x1
	PUSH		y1
	PUSH		c1
	CALL		ScanGouraudEdge

	MOV			ES,vRAM
	MOV			AX,trans
	DW			MOV_GS_AX
	MOV			AX,light
	DW			MOV_FS_AX

	MOV			AX,my
	MOV			BX,AX
	ADD			BX,BX
	MOV			DI,WORD(MultByWidth[BX])  {DirPant:=my*320}

	MOV			SI,TOPE*2
	ADD			SI,BX                   {DS:SI=@Xi[my]}

	MOV			BP,mxy
	SUB			BP,AX
	JL			@FINAL
	INC			BP                      {for n:=(mxy-my)+1 DownTo 0 do}
	MOV			j,BP

@BUCLE_P:                         {ALIGN 16}
	MOV			DX,region.xul
	MOV			BX,region.xlr

	MOV			BP,WORD(xxi[SI])
	CMP			BP,BX     {if x1>region.xlr then goto salir}
	JGE			@SALIR
	MOV			CX,WORD(xxd[SI])
	CMP			CX,DX     {if x2<region.xul then goto salir}
	JL			@SALIR

	MOV			WORD(i),CX
	SUB			WORD(i),BP
	JL			@SALIR
	INC 		WORD(i)

	MOV			WORD(k),0
	CMP			BP,DX     							{if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			WORD(k),DX
	SUB			WORD(k),BP
	MOV			BP,DX

@SIGUE10:
	CMP			CX,BX   	{if x2>region.xlr then x2:=region.xlr}
	JL			@SIGUE20
	MOV			CX,BX

@SIGUE20:
	SUB			CX,BP			{x2:=(x2-x1)+1;}
	JL			@SALIR    {if x2<=0 then goto salir}
	INC			CX

	MOV			BX,WORD(ci[SI])
	MOV			AX,WORD(cd[SI])
	SUB			AX,BX
	DB			_386;ROR		AX,32-COLOR_PRECISION    		{incr:=(c2-c1) shl 16;}
	DW			CDQ
	DB			_386;IDIV		WORD(i)  		{incr:=incr div a;}
	DB			_386;SAR    AX,COLOR_PRECISION-8
	CMP			WORD(k),0
	JZ			@NO_CLIP
	PUSH		AX
	IMUL		WORD(k)
	ADD			BL,AH
	INC			BL
	POP			AX

@NO_CLIP:
	MOV			DH,BL
	MOV			DL,$80                  {swap(BX)}

	PUSH		DI
	ADD			DI,BP			{inc(DirPant,x1);}

@BUCLE:							{GS=trans, FS=light}
	MOV			BH,ES:[DI]
	MOV			BL,DH
	DB			GS;MOV		BH,[BX]
	MOV			BL,DH
	DB			FS;MOV		BL,[BX]
	MOV			ES:[DI],BL
	INC			DI

	ADD			DX,AX
	DEC			CX
	JNZ			@BUCLE

	POP			DI

@SALIR:
	ADD			SI,2
	ADD			DI,320    {Y salto a la siguiente lnea}

	DEC			j
	JNZ			@BUCLE_P

	MOV			code,TRUE

@FINAL:
	POP			BP

	MOV			AL,code
END;

procedure SetTexturePrecision(n:byte);
begin
	SUBDIVSHIFT:=n;
	SUBDIVSIZE:=1 shl SUBDIVSHIFT;
end;

begin
	FillChar(xxi,SizeOf(xxi),0);
	FillChar(xxd,SizeOf(xxd),0);
	FillChar(sxi,SizeOf(sxi),0);
	FillChar(sxd,SizeOf(sxd),0);
	FillChar(syi,SizeOf(syi),0);
	FillChar(syd,SizeOf(syd),0);
	FillChar(ci,SizeOf(ci),0);
	FillChar(cd,SizeOf(cd),0);

	SetTexturePrecision(6);
end.