unit spline;

INTERFACE

uses key,quatern,clax,vector;

procedure CompElementDeriv(pp,p,pn:double;var ds,dd:double;ksm,ksp,kdm,kdp:double);
procedure CompDerivFirst(key,keyn,keynn:PKey);
procedure CompDerivLast(keypp,keyp,key:PKey);
procedure CompDerivLoopFirst(keyp,key,keyn:PKey;lf:double);
procedure CompDerivLoopLast(keyp,key,keyn:PKey;lf:double);
procedure CompDerivTwo(key:PKey);
procedure CompAB(prev,cur,next:PKey);
function SplineEase(t,a,b:double):double;
function SplineInit(var track:TTrack):LongInt;
function SplineInitRot(var track:TTrack):LongInt;
function SplineGetKeyDouble(var track:TTrack;frame:double;var out:double):LongInt;
function SplineGetKeyVect(var track:TTrack;frame:double;var out:TVector):LongInt;
function SplineGetKeyQuat(var track:TTrack;frame:double;var out:TQuat):LongInt;

IMPLEMENTATION

procedure CompElementDeriv(pp,p,pn:double;var ds,dd:double;ksm,ksp,kdm,kdp:double);
var
	delm,delp:double;

begin
	delm:=-pp;
	delp:=pn-p;
	ds:=ksm*delm+ksp*delp;
	dd:=kdm*delm+kdp*delp;
end;

procedure CompDeriv(keyp,key,keyn:PKey);
var
	tm,cm,cp,bm,bp,tmcm,tmcp,
	ksm,ksp,kdm,kdp,
	dt,fp,fn,c:double;

begin
	dt:=0.5*(keyn^.frame-keyp^.frame);
	fp:=(key^.frame-keyp^.frame)/dt;
	fn:=(keyn^.frame-key^.frame)/dt;
	c:=abs(key^.cont);
	fp:=fp+c-c*fp;
	fn:=fn+c-c*fn;
	cm:=-key^.cont;
	tm:=0.5*(1-key^.tens);
	cp:=-cm;
	bm:=-key^.bias;
	bp:=-bm;
	tmcm:=tm*cm;
	tmcp:=tm*cp;
	ksm:=tmcm*bp*fp; ksp:=tmcp*bm*fp;
	kdm:=tmcp*bp*fn; kdp:=tmcm*bm*fn;
	CompElementDeriv(keyp^.val._quat.w,key^.val._quat.w,keyn^.val._quat.w,
										key^.dsa,key^.dda,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.x,key^.val._quat.x,keyn^.val._quat.x,
										key^.dsb,key^.ddb,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.y,key^.val._quat.y,keyn^.val._quat.y,
										key^.dsc,key^.ddc,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.z,key^.val._quat.z,keyn^.val._quat.z,
										key^.dsd,key^.ddd,ksm,ksp,kdm,kdp);
end;

procedure CompDerivFirst(key,keyn,keynn:PKey);
var
	f20,f10,v20,v10:double;

begin
	f20:=keynn^.frame-key^.frame;
	f10:=keyn^.frame-key^.frame;
	v20:=keynn^.val._quat.w-key^.val._quat.w;
	v10:=keyn^.val._quat.w-key^.val._quat.w;
	key^.dda:=(1-key^.tens)*(v20*(0.25-f10/(2*f20))+(v10-v20/2)*3/2+v20/2);
	v20:=keynn^.val._quat.x-key^.val._quat.x;
	v10:=keyn^.val._quat.x-key^.val._quat.x;
	key^.ddb:=(1-key^.tens)*(v20*(0.25-f10/(2*f20))+(v10-v20/2)*3/2+v20/2);
	v20:=keynn^.val._quat.y-key^.val._quat.y;
	v10:=keyn^.val._quat.y-key^.val._quat.y;
	key^.ddc:=(1-key^.tens)*(v20*(0.25-f10/(2*f20))+(v10-v20/2)*3/2+v20/2);
	v20:=keynn^.val._quat.z-key^.val._quat.z;
	v10:=keyn^.val._quat.z-key^.val._quat.z;
	key^.ddd:=(1-key^.tens)*(v20*(0.25-f10/(2*f20))+(v10-v20/2)*3/2+v20/2);
end;

procedure CompDerivLast(keypp,keyp,key:PKey);
var
	f20,f10,v20,v10:double;

begin
	f20:=key^.frame-keypp^.frame;
	f10:=key^.frame-keyp^.frame;
	v20:=key^.val._quat.w-keypp^.val._quat.w;
	v10:=key^.val._quat.w-keyp^.val._quat.w;
	key^.dsa:=(1-key^.tens)*(v20*(0.25-f10/(2*f20))+(v10-v20/2)*3/2+v20/2);
	v20:=key^.val._quat.x-keypp^.val._quat.x;
	v10:=key^.val._quat.x-keyp^.val._quat.x;
	key^.dsb:=(1-key^.tens)*(v20*(0.25-f10/(2*f20))+(v10-v20/2)*3/2+v20/2);
	v20:=key^.val._quat.y-keypp^.val._quat.y;
	v10:=key^.val._quat.y-keyp^.val._quat.y;
	key^.dsc:=(1-key^.tens)*(v20*(0.25-f10/(2*f20))+(v10-v20/2)*3/2+v20/2);
	v20:=key^.val._quat.z-keypp^.val._quat.z;
	v10:=key^.val._quat.z-keyp^.val._quat.z;
	key^.dsd:=(1-key^.tens)*(v20*(0.25-f10/(2*f20))+(v10-v20/2)*3/2+v20/2);
end;

procedure CompDerivLoopFirst(keyp,key,keyn:PKey;lf:double);
var
	tm,cm,cp,bm,bp,tmcm,tmcp,
	ksm,ksp,kdm,kdp,
	dt,fp,fn,c:double;

begin
	dt:=0.5*(keyn^.frame-keyp^.frame+lf);
	fp:=(key^.frame-keyp^.frame+lf)/dt;
	fn:=(keyn^.frame-key^.frame)/dt;
	c:=abs(key^.cont);
	fp:=fp+c-c*fp;
	fn:=fn+c-c*fn;
	cm:=1-key^.cont;
	tm:=0.5*(1-key^.tens);
	cp:=2-cm;
	bm:=1-key^.bias;
	bp:=2-bm;
	tmcm:=tm*cm;
	tmcp:=tm*cp;
	ksm:=tmcm*bp*fp; ksp:=tmcp*bm*fp;
	kdm:=tmcp*bp*fn; kdp:=tmcm*bm*fn;
	CompElementDeriv(keyp^.val._quat.w,key^.val._quat.w,keyn^.val._quat.w,
										key^.dsa,key^.dda,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.x,key^.val._quat.x,keyn^.val._quat.x,
										key^.dsb,key^.ddb,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.y,key^.val._quat.y,keyn^.val._quat.y,
										key^.dsc,key^.ddc,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.z,key^.val._quat.z,keyn^.val._quat.z,
										key^.dsd,key^.ddd,ksm,ksp,kdm,kdp);
end;

procedure CompDerivLoopLast(keyp,key,keyn:PKey;lf:double);
var
	tm,cm,cp,bm,bp,tmcm,tmcp,
	ksm,ksp,kdm,kdp,
	dt,fp,fn,c:double;

begin
	dt:=0.5*(keyn^.frame-keyp^.frame+lf);
	fp:=(key^.frame-keyp^.frame)/dt;
	fn:=(keyn^.frame-key^.frame+lf)/dt;
	c:=abs(key^.cont);
	fp:=fp+c-c*fp;
	fn:=fn+c-c*fn;
	cm:=1-key^.cont;
	tm:=0.5*(1-key^.tens);
	cp:=2-cm;
	bm:=1-key^.bias;
	bp:=2-bm;
	tmcm:=tm*cm;
	tmcp:=tm*cp;
	ksm:=tmcm*bp*fp; ksp:=tmcp*bm*fp;
	kdm:=tmcp*bp*fn; kdp:=tmcm*bm*fn;
	CompElementDeriv(keyp^.val._quat.w,key^.val._quat.w,keyn^.val._quat.w,
										key^.dsa,key^.dda,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.x,key^.val._quat.x,keyn^.val._quat.x,
										key^.dsb,key^.ddb,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.y,key^.val._quat.y,keyn^.val._quat.y,
										key^.dsc,key^.ddc,ksm,ksp,kdm,kdp);
	CompElementDeriv(keyp^.val._quat.z,key^.val._quat.z,keyn^.val._quat.z,
										key^.dsd,key^.ddd,ksm,ksp,kdm,kdp);
end;

procedure CompDerivTwo(key:PKey);
var
	keyn:PKey;

begin
	keyn:=key^.next;

	key^.dsa:=0;
	key^.dsb:=0;
	key^.dsc:=0;
	key^.dsd:=0;
	key^.dda:=(keyn^.val._quat.w-key^.val._quat.w)*(1-key^.tens);
	key^.ddb:=(keyn^.val._quat.x-key^.val._quat.x)*(1-key^.tens);
	key^.ddc:=(keyn^.val._quat.y-key^.val._quat.y)*(1-key^.tens);
	key^.ddd:=(keyn^.val._quat.z-key^.val._quat.z)*(1-key^.tens);
	keyn^.dda:=0;
	keyn^.ddb:=0;
	keyn^.ddc:=0;
	keyn^.ddd:=0;
	keyn^.dsa:=(keyn^.val._quat.w-key^.val._quat.w)*(1-keyn^.tens);
	keyn^.dsb:=(keyn^.val._quat.x-key^.val._quat.x)*(1-keyn^.tens);
	keyn^.dsc:=(keyn^.val._quat.y-key^.val._quat.y)*(1-keyn^.tens);
	keyn^.dsd:=(keyn^.val._quat.z-key^.val._quat.z)*(1-keyn^.tens);
end;

procedure CompAB(prev,cur,next:PKey);
var
	qprev,qnext,q,
	qp,qm,qa,qb,qae,qbe,
	_QA,_QB,_QC,
	QAA,QAB,QAC:TQuat;
	tm,cm,cp,bm,bp,tmcm,tmcp,ksm,ksp,kdm,kdp,
	dt,fp,fn,c:double;
	i:LongInt;

begin
	QTCopy(cur^.val._quat,QAB);
	QTCopy(cur^.qa,_QB);
	if prev<>NIL then
		begin
			QTCopy(prev^.val._quat,QAA);
			QTCopy(prev^.qa,_QA);
		end;
	if next<>NIL then
		begin
			QTCopy(next^.val._quat,QAC);
			QTCopy(next^.qa,_QC);
		end;
	if prev<>NIL then
		if abs(QAB.w-QAA.w)>2*PI-EPSILON then
			begin
				QTCopy(QAB,q);
				q.w:=0;
				QTlog(q,qm);
			end
		else
			begin
				QTCopy(_QA,qprev);
				if QTDotunit(qprev,_QB)<0 then QTNegate(qprev,qprev);
				QTLnDif(qprev,_QB,qm);
			end;
	if next<>NIL then
		if abs(QAC.w-QAB.w)>2*PI-EPSILON then
			begin
				QTCopy(QAC,q);
				q.w:=0;
				QTLog(q,qp);
			end
		else
			begin
				QTCopy(_QC,qnext);
				if QTDotUnit(qnext,_QB)<0 then QTNegate(qnext,qnext);
				QTLnDif(_QB,qnext,qp);
			end;
	if prev=NIL then QTCopy(qp,qm);
	if next=NIL then QTCopy(qm,qp);
	fn:=1;
	fp:=1;
	cm:=1-cur^.cont;
	if (prev<>NIL) and(next<>NIL) then
		begin
			dt:=0.5*(next^.frame-prev^.frame);
			fp:=(cur^.frame-prev^.frame)/dt;
			fn:=(next^.frame-cur^.frame)/dt;
			c:=abs(cur^.cont);
			fp:=fp+c-c*fp;
			fn:=fn+c-c*fn;
		end;
	tm:=0.5*(1-cur^.tens);
	cp:=2-cm;
	bm:=1-cur^.bias;
	bp:=2-bm;
	tmcm:=tm*cm;
	tmcp:=tm*cp;
	ksm:=1-tmcm*bp*fp;
	ksp:=tmcp*bm*fp;
	kdm:=tmcp*bp*fn;
	kdp:=tmcm*bm*fn-1;
	qa.x:=0.5*(kdm*qm.x+kdp*qp.x);
	qb.x:=0.5*(ksm*qm.x+ksp*qp.x);
	qa.y:=0.5*(kdm*qm.y+kdp*qp.y);
	qb.y:=0.5*(ksm*qm.y+ksp*qp.y);
	qa.z:=0.5*(kdm*qm.z+kdp*qp.z);
	qb.z:=0.5*(ksm*qm.z+ksp*qp.z);
	qa.w:=0.5*(kdm*qm.w+kdp*qp.w);
	qb.w:=0.5*(ksm*qm.w+ksp*qp.w);
	QTExp(qa,qae);
	QTExp(qb,qbe);
	QTMul(QB,qae,cur^.ds);
	QTMul(QB,qbe,cur^.dd);
end;

function SplineEase(t,a,b:double):double;
var
	k,s:double;

begin
	s:=a+b;

	if s=0 then
		begin
			SplineEase:=t;
			exit;
		end;
	if s>1 then
		begin
			a:=a/s;
			b:=b/s;
		end;
	k:=1/(2-a-b);
	if t<a then
		begin
			SplineEase:=(k/a)*sqr(t);
			exit;
		end
	else
		if t<1-b then
			begin
				SplineEase:=k*(2*t-a);
				exit;
			end
		else
			begin
				t:=1-t;
				SplineEase:=1-(k/b)*sqr(t);
			end;
end;

function SplineInit(var track:TTrack):LongInt;
var
	curr,keys,last:PKey;

begin
	keys:=track.keys;
	last:=track.last;

	if keys<>NIL then
		begin
			SplineInit:=ClaxErrNullPtr;
			exit;
		end;
	if keys^.next<>NIL then
		begin
			SplineInit:=ClaxErrSpline;
			exit;
		end;

	if keys^.next^.next<>NIL then
		begin
			curr:=keys^.next;
			while curr^.next<>NIL do
				begin
{			for (curr = keys->next; curr->next; curr = curr->next)}
					CompDeriv(curr^.prev,curr,curr^.next);
					curr:=curr^.next;
				end;
			if (track.flags>0) and (ClaxTrackLoop>0) then
				begin
					CompDerivLoopFirst(last^.prev,keys,keys^.next,track.frames);
					CompDerivLoopLast(last^.prev,last,keys^.next,track.frames);
				end
			else
				begin
					CompDerivFirst(keys,keys^.next,keys^.next^.next);
					CompDerivLast(curr^.prev^.prev,curr^.prev,curr);
				end;
		end
	else
		CompDerivTwo(keys);

	SplineInit:=ClaxErrOk;
end;

function SplineInitRot(var track:TTrack):LongInt;
var
	curr,keys,last:PKey;

begin
	keys:=track.keys;
	last:=track.last;

	if keys=NIL then
		begin
			SplineInitRot:=ClaxErrNullPtr;
			exit;
		end;
	if keys^.next=NIL then
		begin
			SplineInitRot:=ClaxErrSpline;
			exit;
		end;

	if keys^.next^.next<>NIL then
		begin
			curr:=keys^.next;
			while curr^.next<>NIL do
				begin
					CompAB(curr^.prev,curr,curr^.next);
					curr:=curr^.next;
				end;
{	/*    if track^.flags & clax_track_loop) begin
				CompAB(last^.prev,keys,keys^.next);
				CompAB(keys^.prev,last,keys^.next);
			end; else begin */}
			CompAB(NIL,keys,keys^.next);
			CompAB(keys,last,NIL);
		end
	else
		begin
			CompAB(NIL,keys,keys^.next);
			CompAB(keys,last,NIL);
		end;
	SplineInitRot:=ClaxErrOk;
end;

function SplineGetKeyDouble(var track:TTrack;frame:double;var out:double):LongInt;
var
	keys:PKey;
	t,t2,t3:double;
	h:array[0..3] of double;

begin
	if frame<0 then
		begin
			SplineGetKeyDouble:=ClaxErrBadFrame;
			exit;
		end;
	if {(track=NIL) or }(track.keys=NIL) then
		begin
			SplineGetKeyDouble:=ClaxErrNullPtr;
			exit;
		end;

	if frame<track.last^.frame then
		keys:=track.keys
	else
		keys:=track.last;
	while (keys^.next<>NIL) and (frame>keys^.next^.frame) do keys:=keys^.next;
	track.last:=keys;
	if (keys^.next=NIL) or (frame<keys^.frame) then
		begin
			out:=keys^.val._double;
			SplineGetKeyDouble:=ClaxErrOk;
			exit;
		end;
	t:=(frame-keys^.frame)/(keys^.next^.frame-keys^.frame);
	t:=SplineEase(t,keys^.EaseFrom,keys^.next^.EaseTo);
	t2:=sqr(t);
	t3:=t2*t;
	h[0]:=2*t3-3*t2+1;
	h[1]:=-2*t3+3*t2;
	h[2]:=t3-2*t2+t;
	h[3]:=t3-t2;
	out:=(h[0]*keys^.val._double)+(h[1]*keys^.next^.val._double)+(h[2]*keys^.dda)+(h[3]*keys^.next^.dsa);
	SplineGetKeyDouble:=ClaxErrOk;
end;

function SplineGetKeyVect(var track:TTrack;frame:double;var out:TVector):LongInt;
var
	keys:PKey;
	t,t2,t3:double;
	h:array[0..3] of double;

begin
	if frame<0 then
		begin
			SplineGetKeyVect:=ClaxErrBadFrame;
			exit;
		end;
	if {(track=NIL) or }(track.keys=NIL) then
		begin
			SplineGetKeyVect:=ClaxErrNullPtr;
			exit;
		end;

	if frame<track.last^.frame then
		keys:=track.keys
	else
		keys:=track.last;
	while (keys^.next<>NIL) and (frame>keys^.next^.frame) do keys:=keys^.next;
	track.last:=keys;
	if (keys^.next=NIL) or (frame<keys^.frame) then
		begin
			CopyVector(keys^.val._vect,out);
			SplineGetKeyVect:=ClaxErrok;;
			exit;
		end;
	t:=(frame-keys^.frame)/(keys^.next^.frame-keys^.frame);
	t:=SplineEase(t,keys^.easefrom,keys^.next^.easeto);
	t2:=sqr(t);
	t3:=t2*t;
	h[0]:=2*t3-3*t2+1;
	h[1]:=-2*t3+3*t2;
	h[2]:=t3-2*t2+t;
	h[3]:=t3-t2;
	out.x:=(h[0]*keys^.val._vect.x)+(h[1]*keys^.next^.val._vect.x)+(h[2]*keys^.dda)+       (h[3]*keys^.next^.dsa);
	out.y:=(h[0]*keys^.val._vect.y)+(h[1]*keys^.next^.val._vect.y)+(h[2]*keys^.ddb)+       (h[3]*keys^.next^.dsb);
	out.z:=(h[0]*keys^.val._vect.z)+(h[1]*keys^.next^.val._vect.z)+(h[2]*keys^.ddc)+       (h[3]*keys^.next^.dsc);
	SplineGetKeyVect:=ClaxErrok;
end;

function SplineGetKeyQuat(var track:TTrack;frame:double;var out:TQuat):LongInt;
var
	keys:PKey;
	a,b,p,q,q1:TQuat;
	t,angle,spin:double;

begin
	if frame<0 then
		begin
			SplineGetKeyQuat:=ClaxErrBadFrame;
			exit;
		end;
	if {(track=NIL) or }(track.keys=NIL) then
		begin
			SplineGetKeyQuat:=ClaxErrNullPtr;
			exit;
		end;

	if (frame<track.last^.frame) then
		keys:=track.keys
	else
		keys:=track.last;
	while (keys^.next<>NIL) and (frame>keys^.next^.frame) do keys:=keys^.next;
	track.last:=keys;
	if (keys^.next=NIL) or (frame<keys^.frame) then
		begin
			QTCopy(keys^.qa,out);
			SplineGetKeyQuat:=ClaxErrok;
			exit;
		end;
	t:=(frame-keys^.frame)/(keys^.next^.frame-keys^.frame);
	t:=SplineEase(t,keys^.EaseFrom,keys^.next^.EaseTo);
	QTCopy(keys^.qa,a);
	QTCopy(keys^.next^.qa,b);

	angle:=keys^.next^.val._quat.w-keys^.val._quat.w;
	if angle>0 then
		spin:=trunc(angle/(2*PI))	{floor(){}
	else
		spin:=round(angle/(2*PI));
{//	!!! FIX !!!
//	angle =angle-(2*PI)*spin;
//	if abs(angle)>PI) begin}
	QTSlerpl(a,b,spin,t,p);
	QTslerpl(keys^.dd,keys^.next^.ds,spin,t,q);
	t:=((1-t)*2)*t;
	QTSlerpl(p,q,0,t,q1);
{//  end; else begin
//    QTslerp(&a,&b,spin,t,&p);
//    QTslerp(&keys^.dd,&keys^.next^.ds,spin,t,&q);
//    t =(((1-t)*2)*t);
//    QTslerp(&p,&q,0,t,&q1);
//  end;}
	QTCopy(q1,out);
	SplineGetKeyQuat:=ClaxErrok;
end;

end.