unit song;

INTERFACE

const
	LEFT=0;
	MIDDLE=8;
	RIGHT=15;

var
	sonido:(GRAVIS,BLASTER,PC);

function init:byte;
{Inicializa la base de samples y devuelve
1=Error en ficheros, 2=error de XMS}

procedure done;
{Libera la memoria de los samples por el dispositivo GUS, SB, SPEAKER}

procedure PlaySmp(n:integer;b:integer);
{Toca el sample N con el panning B}

IMPLEMENTATION

uses
	DSP,speaker,GUS,XMS,
	{$IFDEF _LZ_}
	LzFiles;
	{$ELSE}
	files;
	{$ENDIF}

const
	TOTAL_SAMPLES=50;

type
	Tsample=record
		RAM,LoopBegin,LoopEnd:LongInt;
		handle,longitud,frecuencia:word;
		nada:array[1..14] of byte;
	end;

var
	sample:array[0..TOTAL_SAMPLES] of Tsample;

	leidos:word;

function init;
var
	f:Tfile;
	total:LongInt;

	function HayXMS:boolean;
begin
	HayXMS:=(xms.init) and (xms.version>=$200) and
					(XMS.MemAvail>=total div 1024) and (XMSError=0);
end;

	procedure RAM2XMS(b:integer;l:word);
var
	n,p:word;
	buffer,g:^byte;

begin
	GetMem(buffer,l);
	read(f,buffer^,l,n);

	g:=buffer;
	for n:=1 to l do		{AMIGA-PC}
		begin
			g^:=g^ xor $80;
			inc(g);
		end;

	p:=l;
	if odd(p) then inc(p);

	with sample[b] do
		begin
			handle:=XMS.Malloc((p div 1024)+1);
			longitud:=p;

			MoveXMS.bytes:=p;
			MoveXMS.HandleOrigen:=0;
			MoveXMS.DirOrigen:=buffer;
			MoveXMS.HandleDestino:=handle;
			MoveXMS.DirDestino:=ptr(0,0);
			XMS.move;
		end;

	FreeMem(buffer,l);
end;

	function LeeCabecera:boolean;
var
	n,l:word;

begin
	LeeCabecera:=FALSE;

	if open(f,'SAMPLES.BIN',RO)>0 then exit;

	read(f,leidos,2,l);
	for n:=1 to leidos do read(f,sample[n].frecuencia,2,l);

	total:=0;
	for n:=1 to leidos do with sample[n] do
		begin
			read(f,longitud,2,l);
			inc(total,longitud);
		end;

	LeeCabecera:=TRUE;
end;

	function InitGUS:byte;
var
	PunteroRAM:LongInt;
	l,n,d:word;
	p:^byte;

begin
	InitGUS:=1;
	if not LeeCabecera then exit;

	InitGUS:=3;
	if GUSMemory<total div 1024 then exit;

	PunteroRAM:=0;
	for n:=1 to leidos do with sample[n] do
		begin
			l:=longitud;

			GetMem(p,l);
			read(f,p^,l,d);
			GUSWrite(PunteroRAM,p^,l);
			FreeMem(p,l);

			RAM:=PunteroRAM;
			LoopBegin:=PunteroRAM;
			LoopEnd:=PunteroRAM+l;

			VoiceVolume(n,$bff);
			VoiceMode(n,BIT8+LOOPOFF+UNIDIR+FORW);
			VoiceFreq(n,frecuencia);

			inc(PunteroRAM,l);
		end;

	close(f);

	InitGUS:=0;
end;

	function InitSBandPC:byte;
var
	n:integer;

begin
	InitSbandPC:=0;

	if not LeeCabecera then
		begin
			InitSbandPC:=1;
			exit;
		end;

	if not HayXMS then
		begin
			InitSbandPC:=2;
			exit;
		end;

	for n:=1 to leidos do RAM2XMS(n,sample[n].longitud);

	close(f);
end;

begin
	if gus.init(14) then
		sonido:=GRAVIS
	else
		if GetSB then
			sonido:=BLASTER
		else
			begin
				sonido:=PC;
				speaker.init;
			end;

	case sonido of
		GRAVIS:init:=InitGUS;
		BLASTER,PC:init:=InitSBandPC;
	end;
end;

procedure done;

	procedure LiberaXMS;
var
	n:integer;

begin
	for n:=1 to leidos do XMS.dalloc(sample[n].handle);
end;

var
	n:integer;

begin
	case sonido of
		GRAVIS:for n:=0 to 14 do VoiceStop(n);
		BLASTER,PC:
			begin
				LiberaXMS;

				if sonido=BLASTER then
					begin
						resetDSP;
						speakerOFF;
					end
				else
					speaker.done;
			end;
	end;
end;

procedure PlaySmp(n:integer;b:integer);
var
	v:^Tsample;
	voz:^byte;
	l:word;

	procedure XMS2RAM(num:integer;h:word);
begin
	MoveXMS.bytes:=l;
	MoveXMS.HandleOrigen:=h;
	MoveXMS.DirOrigen:=ptr(0,0);
	MoveXMS.HandleDestino:=0;
	MoveXMS.DirDestino:=voz;
	XMS.move;
end;

var
	s:^Tsample;

begin
	case sonido of
		GRAVIS:
			begin
				VoiceBalance(n,b);

				s:=@sample[n];
				with s^ do GUS.PlaySmp(n,RAM,LoopBegin,LoopEnd);
				VoiceStart(n);
			end;

		BLASTER,PC:
			begin
				v:=@sample[n];

				with v^ do
					begin
						l:=longitud;
						GetMem(voz,l);

						XMS2RAM(n,handle);
						if sonido=BLASTER then
							DSP.PlaySmp(voz^,l,frecuencia)
						else
							speaker.PlaySmp(voz,l,frecuencia);

						FreeMem(voz,l);
					end;
			end;
	end;
end;

end.