unit RLEFiles;

INTERFACE

type
	Tfile=record
		name:string[12];
		ZeroPos,LastPos,FilePos,
		BytesToSkip,RealSize,EncodeSize:LongInt;
		MyBuffer:^byte;
		compress,open:boolean;
	end;

	ModoLectura=(RO,WO,RW);

function init(n:string):boolean;
procedure done;
function open(var f:Tfile;nombre:string;ml:ModoLectura):integer;
function ReWrite(var f:Tfile;nombre:string):integer;
function close(var f:Tfile):integer;
function read(var f:Tfile;var buffer;bytes:word;var leidos:word):integer;
function write(var f:Tfile;var buffer;bytes:word;var escritos:word):integer;
function seek(var f:Tfile;desplazamiento:LongInt):integer;
function FilePos(var f:Tfile):LongInt;
function erase(var f:Tfile):integer;
function rename(var f:Tfile;nuevo:string):integer;
function FileSize(var f:Tfile):LongInt;
function EOF(var f:Tfile):boolean;

IMPLEMENTATION

uses RLE,cadenas,mem,speed;

const
	MAX_BUFFER=64000;

var
	big:file;

function FindFile(var f:TFile;n:string):boolean;
var
	next:LongInt;
	m:integer;

begin
	FindFile:=FALSE;
	system.seek(big,3);
	repeat
		BlockRead(big,f.name[0],13);
		for m:=1 to length(f.name) do dec(f.name[m]);
		BlockRead(big,f.RealSize,4);
		BlockRead(big,f.EncodeSize,4);
		BlockRead(big,next,4);
		BlockRead(big,f.compress,1);
		if upper(f.name)=upper(n) then
			begin
				FindFile:=TRUE;
				break;
			end;
		system.seek(big,next+1);
	until system.EOF(big);
end;

function init(n:string):boolean;
var
	magic:array[0..2] of char;

begin
	init:=FALSE;
	assign(big,n);
	{$I-}reset(big,1);{$I+}
	if IOResult<>0 then exit;
	BlockRead(big,magic,SizeOf(magic));
	if magic<>'BIG' then
		begin
			system.close(big);
			exit;
		end;
	init:=TRUE;
end;

procedure done;
begin
	system.close(big);
end;

function open(var f:Tfile;nombre:string;ml:ModoLectura):integer;
begin
	open:=-1;
	f.open:=FindFile(f,nombre);
	if not f.open then exit;
	if not GetMem(f.MyBuffer,MAX_BUFFER) then exit;
	f.LastPos:=system.FilePos(big);
	f.ZeroPos:=f.LastPos;
	f.FilePos:=0;
	f.BytesToSkip:=MaxLongInt;
	open:=0;
end;

function ReWrite(var f:Tfile;nombre:string):integer;
begin
	ReWrite:=-1;
end;

function close(var f:Tfile):integer;
begin
	FreeMem(f.MyBuffer,MAX_BUFFER);
	close:=ord(not f.open);
	f.open:=FALSE;
end;

function read(var f:Tfile;var buffer;bytes:word;var leidos:word):integer;
var
	c,reales:word;
	b,tmp:^byte;

begin
	if f.compress then
		begin
			reales:=f.EncodeSize;
			if reales>MAX_BUFFER then reales:=MAX_BUFFER;
			c:=f.RealSize;
			if c>MAX_BUFFER then c:=MAX_BUFFER;

			if f.BytesToSkip>f.RealSize then
				begin
					system.seek(big,f.LastPos);
					GetMem(b,reales);
					BlockRead(big,b^,reales);
					decode(b^,f.Mybuffer^,c);
					FreeMem(b,reales);
					f.LastPos:=system.FilePos(big);
					f.BytesToSkip:=0;
				end;
			if f.BytesToSkip<f.RealSize then
				begin
					tmp:=pointer(f.MyBuffer);
					inc(tmp,f.BytesToSkip);
					move(tmp^,buffer,bytes);
					inc(f.BytesToSkip,bytes);
					leidos:=bytes;
					inc(f.FilePos,leidos);
				end;
		end
	else
		begin
			system.seek(big,f.LastPos);
			BlockRead(big,buffer,bytes);
			f.LastPos:=system.FilePos(big);
		end;
end;

function write(var f:Tfile;var buffer;bytes:word;var escritos:word):integer;
begin
	write:=-1;
end;

function seek(var f:Tfile;desplazamiento:LongInt):integer;
var
	d,step,reales:word;
	tmp:^byte;
	n:LongInt;

begin
	if f.compress then
		begin
{			if desplazamiento>MAX_BUFFER then
				d:=MAX_BUFFER
			else
				d:=desplazamiento;
			GetMem(tmp,MAX_BUFFER);
			system.seek(big,f.ZeroPos);
			f.BytesToEmpty:=0;
			f.BytesToSkip:=0;

			n:=0;
			while n<desplazamiento do
				begin
					if f.BytesToEmpty<=0 then
						begin
							BlockRead(big,f.MyBuffer^,MAX_BUFFER,reales);
							f.BytesToEmpty:=MAX_BUFFER;
						end;
					step:=RLE.decode(f.MyBuffer^,tmp^,d);
					inc(f.BytesToSkip,step);
					f.BytesToEmpty:=MAX_BUFFER-step;
					inc(n,d);
				end;

			f.LastPos:=system.FilePos(big);
			f.FilePos:=desplazamiento;
			FreeMem(tmp,MAX_BUFFER);}
		end
	else
		system.seek(big,f.ZeroPos+desplazamiento);
end;

function FilePos(var f:Tfile):LongInt;
begin
	if f.compress then
		FilePos:=f.FilePos
	else
		FilePos:=f.LastPos;
end;

function erase(var f:Tfile):integer;
begin
	erase:=-1;
end;

function rename(var f:Tfile;nuevo:string):integer;
begin
	rename:=-1;
end;

function FileSize(var f:Tfile):LongInt;
begin
	if f.compress then
		FileSize:=f.EncodeSize
	else
		FileSize:=f.RealSize;
end;

function EOF(var f:Tfile):boolean;
begin
	if f.compress then
		EOF:=f.FilePos>=f.RealSize
	else
		EOF:=f.LastPos>=f.RealSize;
end;

end.