unit RLE;

INTERFACE

function decode(var from,where;total:word):word;
procedure encode(var from,where;var n:word);

IMPLEMENTATION

uses OP386;

function decode(var from,where;total:word):word;{ASSEMBLER;
ASM
	PUSH		DS

	MOV			BX,64000
	MOV			CX,0
	LES			DI,where
	LDS			SI,from

@BUCLE:
	MOV			AL,[SI]
	INC			SI
	TEST		AL,10000000b
	JZ			@NO_RUN

	MOV			CL,AL
	AND			CL,$3F
	MOV			AL,[SI]
	INC			SI

	SUB			BX,CX
	REP			STOSB
	JNZ			@BUCLE
	JMP			@FIN

@NO_RUN:
	MOV			ES:[DI],AL
	INC			DI
	DEC			BX
	JNZ			@BUCLE
	DEC			SI

@FIN:
	MOV			AX,SI
	SUB			AX,WORD(from)

	POP			DS
END;}

var
	f,w:^byte;
	b:byte;
	a,n,m:word;

begin
	f:=@from;
	w:=@where;
	n:=0;
	repeat
		b:=f^;
		inc(f);
		if b>192 then
			begin
				b:=b and 63;
				m:=f^;
				if m=6 then m:=0;{}
				inc(f);
				for a:=1 to b do
					begin
						w^:=m;
						inc(w);
					end;
				inc(n,b);
			end
		else
			begin
				w^:=b;
				inc(w);
				inc(n);
			end;
	until n>64000;
	decode:=ofs(f^)-ofs(from);
end;

procedure encode(var from,where;var n:word);
var
	this,runCount,last:byte;
	total,srcIndex,i:word;
	f,w:^byte;

begin
	total:=0;
	runCount:=1;
	f:=@from;
	w:=@where;
	last:=f^;

	for srcIndex:=1 to n do
		begin
			inc(f);
			this:=f^;
			if this=last then
				begin
					inc(runCount);
					if runCount=63 then
						begin
							w^:=63 or 192;
							inc(w);
							w^:=last;
							inc(w);
							inc(total,2);
							runCount:=0;
						end
				end
			else
				begin
					if (runCount>1) or (last>=192) then
						begin
							w^:=runCount or 192;
							inc(w);
							w^:=last;
							inc(w);
							inc(total,2);
						end
					else
						if runCount=1 then
							begin
								w^:=last;
								inc(w);
								inc(total);
							end;
					last:=this;
					runCount:=1;
				end;
		end;
	n:=total;
end;

end.