unit PCX;

INTERFACE

uses colors;

function LoadPCX(name:string;var palette256:Tpal):boolean;
function SavePCX(n:string;p:pointer;var c:Tpal):boolean;

IMPLEMENTATION

uses VESA
{$IFDEF _LZ_}
	,LZFiles
{$ELSE}
	{$IFDEF _RLE_}
	,RLEFiles
	{$ELSE}
	,files
{$ENDIF}
{$ENDIF}
	;

const
 MAX_WIDTH = 4000;
 COMPRESION_NUM = $C0;
 MAX_BLOCK = 4096;

 RED = 0;
 GREEN = 1;
 BLUE = 2;

type
	BlockArray = array [0..MAX_BLOCK] of byte;
	LineArray = array [0..MAX_WIDTH] of byte;

	tPCX = record
		Manufacturer: byte;

		Version: byte;

		Encoding: byte;

		Bits_per_pixel: byte;

		Xmin: integer;
		Ymin: integer;
		Xmax: integer;
		Ymax: integer;

		Hdpi: integer;
		Vdpi: integer;

		ColorMap: array [0..15, RED..BLUE] of byte;

		Reserved: byte;

		Nplanes: byte;

		Bytes_per_line_per_plane: integer;

		PaletteInfo: integer;

		HscreenSize: integer;
		VscreenSize: integer;

		Filler: array [74..127] of byte;
	end;

var
	Name:string;
	f:Tfile;
	BlockData:BlockArray;

	Cabeza:tPCX;
	PCXline:LineArray;

	Ymax,NextByte,Index:integer;
	Data:byte;

procedure Read256palette(var p:Tpal);
var
	i:integer;
	b:byte;
	l:word;

begin
	seek(f,FileSize(f)-769);
	Read(f,b,1,l);
	Read(f,P,3*256,l);
	seek(f,128);

	for i:=0 to 255 do
		begin
			p[i].red:=p[i].red div 4;
			p[i].green:=p[i].green div 4;
			p[i].blue:=p[i].blue div 4;
		end;
end;

procedure ReadHeader(var p:Tpal);
var
	l:word;

begin
	Read(f,Cabeza,128,l);
	Ymax:=479;
	Read256palette(p);

	Index := 0;
	NextByte := MAX_BLOCK;
end;

procedure ReadByte;
var
	NumBlocksRead:word;

begin
	if NextByte=MAX_BLOCK then
		begin
			Read(f,BlockData,MAX_BLOCK,NumBlocksRead);
			NextByte:=0;
	 end;

	data := BlockData [NextByte];
	inc (NextByte);
end;  { ReadByte }

procedure ReadPCXLine;
var
	 count: integer;
	 bytes_per_line: integer;

begin
	bytes_per_line:=Cabeza.Bytes_per_line_per_plane*Cabeza.Nplanes;

	if Index<>0 then FillChar(PCXline[0],Index,data);

	while (Index < bytes_per_line) do
		begin
			ReadByte;

			if (data and $C0)=COMPRESION_NUM then
				begin
					count:= data and $3F;
					ReadByte;
					FillChar(PCXline[Index],count,data);
					inc(Index,count);
				end
			else
				begin
					PCXline[Index]:=data;
					inc(Index);
				end;
		end;

	dec(Index,bytes_per_line);
end;

function LoadPCX(name:string;var palette256:Tpal):boolean;
var
	k,kmax:integer;

begin
	LoadPCX:=FALSE;
	if open(f,name,RO)>0 then exit;

	ReadHeader(palette256);

	kmax:=Cabeza.Ymin+Ymax;
	if Cabeza.Ymax<kmax then kmax:=Cabeza.ymax;

	for k:=Cabeza.Ymin to kmax do
		begin
			ReadPCXLine;
{			DrawBitMap(0,k,Cabeza.XMax-Cabeza.Xmin,1,@PCXline);}
			move(pcxline,ptr($a000,K*320)^,320);
		end;

	close(f);
	LoadPCX:=TRUE;
end;

function SavePCX(n:string;p:pointer;var c:Tpal):boolean;
Var
	F : TFile;
	Ln : Byte;
	s:word;

Procedure WriteHeader;

Const
	OldPal : Array [1..48] of Byte = (0,0,0,216,152,56,120,116,4,112,108,4,236,
				172,76,248,196,128,64,36,36,36,40,20,248,
				188,104,212,144,156,60,36,36,116,112,8,
				120,116,8,124,120,8,52,48,4,240,196,136);

Var
	B,L : Byte;
	I : Integer;
	le:word;

Begin
	B := 10;                              (*  Manufacturer                *)
	write (F,B,1,le);
	B := 5;                               (*  Version                     *)
	write (F,B,1,le);
	B := 1;                               (*  Encoding                    *)
	write (F,B,1,le);
	B := 8;                               (*  Bytes Per Pixel             *)
	write (F,B,1,le);
	I := 0;                               (*  Min X                       *)
	write (F,I,2,le);
	I := 0;                               (*  Min Y                       *)
	write (F,I,2,le);
	I := 319;                             (*  Max X                       *)
	write (F,I,2,le);
	I := 199;                             (*  Max Y                       *)
	write (F,I,2,le);
	I := 320;                             (*  Horizontal Resolution       *)
	write (F,I,2,le);
	I := 200;                             (*  Vertical Resolution         *)
	write (F,I,2,le);                   (*  Default Palette             *)
	write (F,Mem [Seg (OldPal):Ofs (OldPal)],48,le);
	B := 0;                               (*  Reserved                    *)
	write (F,B,1,le);
	B := 1;                               (*  Color Planes                *)
	write (F,B,1,le);
	I := 320;                             (*  Bytes Per Line              *)
	write (F,I,2,le);
	I := 0;                               (*  Palette Type                *)
	write (F,I,2,le);
	B := 0;
	For L:= 1 to 58 Do write(F,B,1,le);
End;

Procedure EncodeLine (Ln : Byte);
Var
	B : Array [1..64] of Byte;
	I,J,T : Word;
	A : Byte;
	P : Array [0..319] of Byte;
	le:word;

Begin
	I := 0;
	J := 0;
	T := 0;
	Move (Mem [S:Ln * 320],P,320);
	While T < 320 Do
	Begin
		I := 0;
		While ((P [T + I] = P [T + I + 1]) And ((T + I) < 320) And (I < 63)) Do
			Inc (I);
		If I > 0 Then
		Begin
			A := I Or 192;
			write (F,A,1,le);
			write (F,P [T],1,le);
			Inc (T,I);
			Inc (J,2);
		End
		Else Begin
			If (((P [T]) And 192) = 192) Then
			Begin
				 A := 193;
				 write (F,A,1,le);
				 Inc (J);
			End;
			write (F,P [T],1,le);
			Inc (T);
			Inc (J);
		End;
	End;
End;

Procedure WritePalette;
var
	l,le:word;

Begin
	L := 12;
	write (F,L,1,le);
	For L := 0 to 255 Do with c[l] do
	Begin
		write (F,red,1,le);
		write (F,Green,1,le);
		write (F,Blue,1,le);
	End;
End;

Begin
	SavePCX:=FALSE;

	if ReWrite(f,n)>0 then close(f);

	s:=seg(p);
	WriteHeader;
	For Ln:=0 to 199 Do EncodeLine(Ln);
	WritePalette;
	Close(F);

	SavePCX:=TRUE;
End;

end.