unit Old3D;

INTERFACE

uses vector,colors;

const
	DEG=360;
	RAD=3.1415926536/(DEG/2);
	COSINE=DEG div 4;

	SHIFT=10;            	{No overflow in fixed point}
	ESCALE=1 shl SHIFT;

	MARK_VERTEX_TOO_CLOSE=-32767;

	MAX_VERTEX=2500;
	MAX_FACES=4000;
	MAX_OBJ_IN_ANIM=128;
	MAX_LIGHTS=3;

	DistanceFromEye:LongInt=512;
	AmbientLight:word=128;

type
	Trender=(_POINT_,_WIRE_,_FLAT_,_GOURAUD_,_ENVMAP_,_TEXTURE_,_TEXTURE_FLAT_,_TEXTURE_GOURAUD_,_TEXTURE_ENVMAP_);

	Tangle=record
		balanza,caida,deriva:double;
	end;

	Tvertex=record
		x,y,z,
		nx,ny,nz:LongInt;
		u,v:byte;
	end;
	TaVertex=array[0..MAX_VERTEX] of Tvertex;
	PaVertex=^TaVertex;

	Tfaces=record
		texture:pointer;
		v1,v2,v3:word;
		color:byte;

		nada:array[1..5] of byte;
	end;
	TaFaces=array[0..MAX_FACES] of Tfaces;
	PaFaces=^TaFaces;

	Tscreen=record
		u,v,
		light:byte;
		sx,sy,
		tx,ty:integer;
		z:LongInt;

		nada:byte;
	end;
	TaScreen=array[0..MAX_FACES] of Tscreen;
	PaScreen=^TaScreen;

	Tsegment=array[0..254,0..256] of byte;{}
	Ptexture=^Tsegment;Plight=^Tsegment;PTransparency=^Tsegment;

	Pobject=^Tobject;
	Frender=function(o:Pobject;ordena:boolean):integer;

	Tobject=record
		vertex,faces:word;

		sx,sy:integer;    		{Coordenadas 2D projectadas}
		x,y,z,            		{Coordenadas 3D del objeto antes y Z despus de la rotacin}
		nx,ny,nz,         		{Normales del objeto antes y despus de la rotacin}
		wx,wy,wz:LongInt; 		{Coordenadas del objeto en el mundo 3d}

		deriva,balanza,caida:0..DEG;
		ZclipMin,ZclipMax,
		ZobjectMin,ZobjectMax:LongInt;

		UnColor:byte;
		FaceVisible:boolean;
		EnvMap:pointer;

		shade:array[0..255] of byte;

		Pvertex:PaVertex;     {Array de vrtices}
		Pfaces:PaFaces;       {Array de caras}
		Pscreen:PaScreen;     {Array resultante}

		light:Plight;         {Mapa de luces}

		Put3DObject:Frender;	{Pinta un objeto 3d segn el tipo de render}
		RenderType:Trender;   {Tipo de render actual}
	end;

	Tani=record
		obj:array[0..MAX_OBJ_IN_ANIM] of Pobject;
		RenderType:Trender;
		TotalFrames:word;

		deriva,balanza,caida:0..DEG;
		wx,wy,wz:LongInt;

		light:Plight;
	end;
	Pani=^Tani;

	Tcalcs=(_12MULS_,_MATRIX_);

var
	sine:array[0..DEG+COSINE] of LongInt;
	Rsin:array[0..DEG+COSINE] of double;{}

procedure SetCalculs(m:Tcalcs);
{Inicializa el tipo de matriz}

procedure SetCamera(var a:Tangle);
{Vara los ngulos de la camara}
procedure SetOriginCamera(var f:TVector);
{Vara las coordenadas de la camara}

procedure Precalc12Mult(o:Pobject);
{Precalcula los valores de seno, coseno y caida del objeto o}
procedure RotateVertex12Mult(o:Pobject);
{Devuelve en SX y SY las coordenadas rotadas del objeto o, devuelve FALSE si Z<=0}
procedure RotateNormals12Mult(o:Pobject);
{Rota las normales del objeto o}

procedure PrecalcMatrix(o:Pobject);
{Precalcula los valores de seno, coseno y caida del objeto o}
procedure RotateMatrix(o:Pobject);
{Devuelve en SX y SY las coordenadas rotadas del objeto o, devuelve FALSE si Z<=0}
procedure RotateNormalsMatrix(o:Pobject);
{Rota las normales del objeto o}

procedure SetRenderType(o:Pobject;r:Trender);
{Cambia el mtodo de render para Put3DObject}
function GetRenderType(o:Pobject):Trender;
{Devuelve el mtodo de render de Put3DObject}

function LoadObject(var o:Pobject;nombre:string):boolean;
{Lee el fichero nombre y lo mete en el objeto o, si FALSE, error de fichero}
procedure FreeObject(var o:Pobject);
{Libera la memoria ocupada por el objeto}
procedure ResetObject(o:Pobject);
{Pone por defecto las coordenadas y los ngulos del objeto}
procedure SetTextureObject(o:Pobject;h:integer);
{Le asigna a TODO un objeto la texture h}
procedure SetEnvMapObject(o:Pobject;h:pointer);
{Asigna el envmap h, para _TEXTURE_ENVMAP_}
function MakeCloneObject(f:Pobject;var d:Pobject):boolean;
{Hace que los datos de f estn en la misma zona de memoria de d}
procedure FreeCloneObject(var o:Pobject);
{Libera el clone o}
procedure MakeCloneLight(f:Pobject;var d:Pobject);
{hace un clone del mapa de luces}
procedure SetPointWireObjectColor(o:Pobject;c:byte);
{Fuerza el color c en wire y point}
procedure SetFaceVisible(o:Pobject;v:boolean);
{Fuerza las caras ocultas a ser visibles en point y wire? si TRUE}

function LoadTexture(n:string;var p:Tpal):integer;
{Carga una textura y devuelve un handle a ella}
function SaveTexture(n:string;t:Ptexture;var p:Tpal):boolean;
{Salva una texture}
function FreeTexture(h:integer):boolean;
{Libera el handle}
function GetTexture(h:integer):Ptexture;
{Devuelve el puntero del handle}

function LoadLight(var l:Plight;n:string):boolean;
{Carga e inicializa un mapa de luces para textureflat y texturegouraud}
procedure Freelight(var l:Plight);
{Libera el mapa de luz}

function LoadLightObject(o:Pobject;n:string):boolean;
{Carga en el objeto o el fichero n de luz}
procedure FreeLightObject(o:Pobject);
{Libera la memoria ocupada por la luz en o}
procedure RemapColors(o:Pobject;inicial,cuantos:integer);
{Remapea los colores resultantes del objeto}

function NewFocus:integer;
{Inicializa un nuevo foco}
procedure SetFocus(h:integer;var ft:TVector);
{Pone un foco de luz para polgonos gouraud y texture gouraud}
procedure FreeFocus(h:integer);
{libera el foco h}
procedure SetOriginFocus(var ff:TVector);

function LoadAni(var ani:Pani;n:string):integer;
{Carga la  animacin n}
procedure FreeAni(var ani:Pani);
{Libera ka animacin}
function PlayAni(ani:Pani;f:integer;o:boolean):integer;
{Muestra el frame f}
function MakeCloneAni(f:Pani;var d:Pani):boolean;
{Hace una copia de una animacin a otra, pero ocupando la misma zona de memoria}
procedure FreeCloneAni(var f:Pani);
procedure SetAniRenderType(ani:Pani;r:Trender);
{Cambia el mtodo de render para PlayAni}
function GetAniRenderType(ani:Pani):Trender;
{Devuelve el mtodo de render de PlayAni}
procedure SetPointWireAniColor(ani:Pani;c:integer);
procedure SetEnvMapAni(ani:Pani;h:pointer);

function LoadAniLight(ani:Pani;n:string):boolean;
{Carga una luz para la animacin}
procedure FreeAniLight(ani:Pani);
{Libera la luz de la animacin}

IMPLEMENTATION

uses math,Mode13,triangles,OP386,mem,matrix,
{$IFDEF _LZ_}
	LZFiles;
{$ELSE}
	files;
{$ENDIF}

type
	TR3d=record
		magic:array[0..1] of char; {3D}
		vertex,faces:word;
	end;

	TRAni=record
		magic:array[0..2] of char; {ANI}
		frames:word;
	end;

	Pnext=^TLtexture;
	TLtexture=record
		texture:Ptexture;
		previous,next:Pnext;
		n:integer;
	end;

const
	LastTexture:Pnext=NIL;ActualTexture:Pnext=NIL;FirstTexture:Pnext=NIL;

	FocusFrom:TVector=(x:-50;y:50;z:-100);

	CameraFrom:TVector=(x:0;y:0;z:0);
	CameraTo:Tangle=(balanza:0;caida:0;deriva:0);

type
	Fcall=procedure(o:Pobject);

var
	PrecalcsVertexNormals,RotateVertexs,RotateNormals:Fcall;

	call:array[Trender] of Frender;

type
	Tlight=record
		light:TVector;
		active:boolean;
		nada:array[1..3] of byte;
	end;

var
	Alight:array[0..MAX_LIGHTS] of Tlight;

procedure SetCamera(var a:Tangle);
begin
	CameraTo:=a;
end;

procedure SetOriginCamera(var f:TVector);
begin
	CameraFrom:=f;
end;

var
	SenoDeriva,CosenoDeriva,
	SenoBalanza,CosenoBalanza,
	SenoCaida,CosenoCaida,
	xa,ya,za:LongInt;

procedure Precalc12Mult(o:Pobject);ASSEMBLER;
ASM
	LES		DI,o

	MOV		BX,ES:Tobject[DI].deriva
	SHL		BX,2

	MOV		SI,ES:Tobject[DI].balanza
	SHL		SI,2

	MOV		DI,ES:Tobject[DI].caida
	SHL		DI,2

	DB		_386;MOV		AX,WORD(sine[BX])	{o.SenoDeriva:=sine[o.deriva];}
	DB		_386;MOV		WORD(SenoDeriva),AX

	DB		_386;MOV		AX,WORD(sine[BX+COSINE*4])	{o.CosenoDeriva:=sine[COSENO+o.deriva];}
	DB		_386;MOV		WORD(CosenoDeriva),AX



	DB		_386;MOV		AX,WORD(sine[SI])	{o.SenoBalanza:=sine[o.balanza];}
	DB		_386;MOV		WORD(SenoBalanza),AX

	DB		_386;MOV		AX,WORD(sine[SI+COSINE*4])	{o.CosenoBalanza:=sine[COSENO+o.balanza];}
	DB		_386;MOV		WORD(CosenoBalanza),AX



	DB		_386;MOV		AX,WORD(sine[DI])	{o.SenoCaida:=sine[o.caida];}
	DB		_386;MOV		WORD(SenoCaida),AX

	DB		_386;MOV		AX,WORD(sine[DI+COSINE*4])	{o.CosenoCaida:=sine[COSENO+o.caida];}
	DB		_386;MOV		WORD(CosenoCaida),AX
END;

procedure RotateVertex12Mult(o:Pobject);ASSEMBLER;
ASM
	PUSH		BP

	LES     BX,o
	MOV			ES:Tobject[BX].sx,MARK_VERTEX_TOO_CLOSE

	DB			_386;MOV			DI,WORD(CosenoDeriva)
	DB			_386;MOV			SI,WORD(SenoDeriva)
	DB			_386;MOV			CX,WORD(ES:Tobject[BX].x)

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			DI
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(ES:Tobject[BX].z)
	DB			_386;IMUL			SI
	DB			_386;SUB			BP,AX
	DB			_386;SAR			BP,SHIFT
	DB			_386;MOV			WORD(xa),BP	{xa:=(CosenoDeriva*x-SenoDeriva*z) div ESCALA;}

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(ES:Tobject[BX].z)
	DB			_386;IMUL			DI
	DB			_386;ADD			AX,BP
	DB			_386;SAR			AX,SHIFT
	DB			_386;MOV			WORD(za),AX	{za:=(SenoDeriva*x+CosenoDeriva*z) div ESCALA;}

	DB			_386;MOV			DI,WORD(CosenoBalanza)
	DB			_386;MOV			SI,WORD(SenoBalanza)
	DB			_386;MOV			CX,WORD(ES:Tobject[BX].y)

	DB			_386;MOV      AX,WORD(xa)
	DB			_386;IMUL			DI
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI
	DB			_386;ADD			AX,BP
	DB			_386;SAR			AX,SHIFT
	DB			_386;ADD			AX,WORD(ES:Tobject[BX].wx)
	DB			_386;MOV			WORD(ES:Tobject[BX].x),AX	{x:=(CosenoBalanza*xa+SenoBalanza*y) div ESCALA;}

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			DI
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(xa)
	DB			_386;IMUL			SI
	DB			_386;SUB			BP,AX
	DB			_386;SAR			BP,SHIFT
	DB			_386;MOV			WORD(ya),BP	{ya:=(CosenoBalanza*y-SenoBalanza*xa) div ESCALA;}

	DB			_386;MOV			DI,WORD(CosenoCaida)
	DB			_386;MOV			SI,WORD(SenoCaida)
	DB			_386;MOV			CX,WORD(za)

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			DI
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(ya)
	DB			_386;IMUL			SI
	DB			_386;SUB			BP,AX
	DB			_386;SAR			BP,SHIFT
	DB			_386;ADD			BP,WORD(ES:Tobject[BX].wz)
	DB			_386;MOV			WORD(ES:Tobject[BX].z),BP	{z:=(CosenoCaida*za-SenoCaida*ya) div ESCALA;}
	DB			_386;CMP			BP,WORD(ES:Tobject[BX].ZclipMin)
	JLE			@SALIR
	DB			_386;
	DB			_386;CMP			BP,WORD(ES:Tobject[BX].ZclipMax)
	JGE			@SALIR

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(ya)
	DB			_386;IMUL			DI
	DB			_386;ADD			AX,BP
	DB			_386;SAR			AX,SHIFT
	DB			_386;ADD			AX,WORD(ES:Tobject[BX].wy)			{AX=inc(y,my);}
	DB			_386;MOV			WORD(ES:Tobject[BX].y),AX	{y:=(SenoCaida*za+CosenoCaida*ya) div ESCALA;}

	DB			_386;MOV			DI,WORD(ES:Tobject[BX].z)
	DB			_386;MOV			SI,WORD(ES:Tobject[BX].x)

	DB			_386;IMUL			WORD(DistanceFromEye)
	DB			_386;IDIV			DI
	ADD			AX,CENTERY
	MOV			ES:Tobject[BX].sy,AX	{sy:=100+(y*DistanceFromEye) div z;}

	DB			_386;MOV			AX,SI
	DB			_386;IMUL			WORD(DistanceFromEye)
	DB			_386;IDIV			DI
	ADD			AX,CENTERX
	MOV			ES:Tobject[BX].sx,AX  {sx:=160+(x*DistanceFromEye) div z;}

@SALIR:
	POP			BP
END;

procedure RotateNormals12Mult(o:Pobject);ASSEMBLER;
ASM
	PUSH		BP
	LES			BX,o

	DB			_386;MOV			DI,WORD(CosenoDeriva)
	DB			_386;MOV			SI,WORD(SenoDeriva)
	DB			_386;MOV			CX,WORD(ES:Tobject[BX].nx)

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			DI   	{nx*CosenoDeriva}
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(ES:Tobject[BX].nz)
	DB			_386;IMUL			SI   	{nz*SenoDeriva}
	DB			_386;SUB			BP,AX
	DB			_386;SAR			BP,SHIFT
	DB			_386;MOV			WORD(xa),BP{xa:=(CosenoDeriva*nx-SenoDeriva*nz) div ESCALA;}

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI    {nx*SenoDeriva}
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(ES:Tobject[BX].nz)
	DB			_386;IMUL			DI    {nz*CosenoDeriva}
	DB			_386;ADD			AX,BP
	DB			_386;SAR			AX,SHIFT
	DB			_386;MOV			WORD(za),AX	{za:=(SenoDeriva*nx+CosenoDeriva*nz) div ESCALA;}

	DB			_386;MOV			DI,WORD(CosenoBalanza)
	DB			_386;MOV			SI,WORD(SenoBalanza)
	DB			_386;MOV			CX,WORD(ES:Tobject[BX].ny)

	DB			_386;MOV      AX,WORD(xa)
	DB			_386;IMUL			DI         {xa*CosenoBalanza}
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI         {ny*SenoBalanza}
	DB			_386;ADD			AX,BP
	DB			_386;SAR			AX,SHIFT
	DB			_386;MOV			WORD(ES:Tobject[BX].nx),AX	{nx:=(CosenoBalanza*xa+SenoBalanza*ny) div ESCALA;}

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			DI         {ny*CosenoBalanza}
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(xa)
	DB			_386;IMUL			SI         {xa*SenoBalanza}
	DB			_386;SUB			BP,AX
	DB			_386;SAR			BP,SHIFT
	DB			_386;MOV			WORD(ya),BP	{ya:=(CosenoBalanza*ny-SenoBalanza*xa) div ESCALA;}

	DB			_386;MOV			DI,WORD(CosenoCaida)
	DB			_386;MOV			SI,WORD(SenoCaida)
	DB			_386;MOV			CX,WORD(za)

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			DI         {za*CosenoCaida}
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(ya)
	DB			_386;IMUL			SI         {ya*SenoCaida)}
	DB			_386;SUB			BP,AX
	DB			_386;SAR			BP,SHIFT
	DB			_386;MOV			WORD(ES:Tobject[BX].nz),BP	{nz:=(CosenoCaida*za-SenoCaida*ya) div ESCALA;}

	DB			_386;MOV			AX,CX
	DB			_386;IMUL			SI         {za*SenoCaida}
	DB			_386;MOV			BP,AX
	DB			_386;MOV			AX,WORD(ya)
	DB			_386;IMUL			DI         {ya*CosenoCaida}
	DB			_386;ADD			AX,BP
	DB			_386;SAR			AX,SHIFT
	DB			_386;MOV			WORD(ES:Tobject[BX].ny),AX

	POP			BP
END;

var
	camera,mat:TMatrix;

procedure PrecalcMatrix(o:Pobject);
var
	ax,ay,az,
	Xsin,Xcos,
	Ysin,Ycos,
	Zsin,Zcos,
	sxsz,sxcz,szcx,cxcz:double;

begin
	ax:=-CameraTo.caida;
	ay:=-CameraTo.deriva;
	az:=-CameraTo.balanza;

{	if ax<0 then ax:=ax+DEG;
	Xsin:=Rsin[ax];Xcos:=Rsin[COSINE+ax];
	if ay<0 then ay:=ay+DEG;
	Ysin:=Rsin[ay];Ycos:=Rsin[COSINE+ay];
	if az<0 then az:=az+DEG;
	Zsin:=Rsin[az];Zcos:=Rsin[COSINE+az];}

	Xsin:=sin(ax*RAD);Xcos:=cos(ax*RAD);{}
	Ysin:=sin(ay*RAD);Ycos:=cos(ay*RAD);
	Zsin:=sin(az*RAD);Zcos:=cos(az*RAD);

	sxsz:=Xsin*Zsin;
	sxcz:=Xsin*Zcos;
	szcx:=Zsin*Xcos;
	cxcz:=Xcos*Zcos;

	camera[0,0]:=Ycos*Zcos;
	camera[1,0]:=Ycos*Zsin;
	camera[2,0]:=-Ysin;
	camera[0,1]:=Ysin*sxcz-szcx;
	camera[1,1]:=Ysin*sxsz+cxcz;
	camera[2,1]:=Xsin*Ycos;
	camera[0,2]:=Ysin*cxcz+sxsz;
	camera[1,2]:=Ysin*szcx-sxcz;
	camera[2,2]:=Xcos*Ycos;

	with o^ do
		begin
			Xsin:=Rsin[caida];Xcos:=Rsin[COSINE+caida];
			Ysin:=Rsin[deriva];Ycos:=Rsin[COSINE+deriva];
			Zsin:=Rsin[balanza];Zcos:=Rsin[COSINE+balanza];
		end;

	sxsz:=Xsin*Zsin;
	sxcz:=Xsin*Zcos;
	szcx:=Zsin*Xcos;
	cxcz:=Xcos*Zcos;

	mat[0,0]:=Ycos*Zcos;
	mat[1,0]:=Ycos*Zsin;
	mat[2,0]:=-Ysin;
	mat[0,1]:=Ysin*sxcz-szcx;
	mat[1,1]:=Ysin*sxsz+cxcz;
	mat[2,1]:=Xsin*Ycos;
	mat[0,2]:=Ysin*cxcz+sxsz;
	mat[1,2]:=Ysin*szcx-sxcz;
	mat[2,2]:=Xcos*Ycos;
end;

procedure RotateMatrix(o:Pobject);
var
	xx,yy,zz,
	tx,ty,tz:double;

begin
	with o^ do
		begin
			tx:=(x*mat[0,0])+(y*mat[0,1])+(z*mat[0,2])+wx-CameraFrom.x;
			ty:=(x*mat[1,0])+(y*mat[1,1])+(z*mat[1,2])+wy-CameraFrom.y;
			tz:=(x*mat[2,0])+(y*mat[2,1])+(z*mat[2,2])+wz-CameraFrom.z;

			zz:=(tx*camera[2,0])+(ty*camera[2,1])+(tz*camera[2,2]);
			if (zz>ZclipMin) and (zz<ZclipMax) then
				begin
					xx:=(tx*camera[0,0])+(ty*camera[0,1])+(tz*camera[0,2]);
					yy:=(tx*camera[1,0])+(ty*camera[1,1])+(tz*camera[1,2]);

					sx:=CENTERX+round(xx*DistanceFromEye/zz);
					sy:=CENTERY+round(yy*DistanceFromEye/zz);
					z:=round(zz);
				end
			else
				sx:=MARK_VERTEX_TOO_CLOSE;
		end;
end;

procedure RotateNormalsMatrix(o:Pobject);
var
	rx,ry,rz,
	tx,ty,tz:double;

begin
	with o^ do
		begin
			rx:=nx/65536;{}
			ry:=ny/65536;
			rz:=nz/65536;

			tx:=(rx*mat[0,0])+(ry*mat[0,1])+(rz*mat[0,2]);
			ty:=(rx*mat[1,0])+(ry*mat[1,1])+(rz*mat[1,2]);
			tz:=(rx*mat[2,0])+(ry*mat[2,1])+(rz*mat[2,2]);

			nx:=round(tx*65536);
			ny:=round(ty*65536);
			nz:=round(tz*65536);

{			nx:=round((tx*camera[0,0])+(ty*camera[0,1])+(tz*camera[0,2]));
			ny:=round((tx*camera[1,0])+(ty*camera[1,1])+(tz*camera[1,2]));
			nz:=round((tx*camera[2,0])+(ty*camera[2,1])+(tz*camera[2,2]));}
		end;
end;

function CalculateNormalLight(o:Pobject;h:integer):word;
var
	l:double;

begin
	CalculateNormalLight:=0;
	with Alight[h] do
		begin
			if not active then exit;
			l:=(light.x*o^.nx)+(light.y*o^.ny)+(light.z*o^.nz)+AmbientLight;
			if l<0 then
				l:=0
			else
				if l>255 then l:=255;
		end;
	CalculateNormalLight:=round(l);
end;

var
	x1,y1,
	x2,y2,
	x3,y3:integer;

function IsFaceVisibleOld(FaceVisible:boolean):boolean;ASSEMBLER;
ASM
	MOV			AL,TRUE
	CMP			FaceVisible,TRUE
	JZ			@FIN

	MOV			AX,x2             {ESI=(x2-x1)*}
	SUB			AX,x1
	DW			CWDE
														{(y3-y1)-}
	MOV			DX,y3
	SUB			DX,y1
	DD			MOVSX_EDX_DX

	DB			_386;IMUL		DX
	DB			_386;MOV		DI,AX


	MOV			AX,y2             {EAX=(y2-y1)*}
	SUB			AX,y1
	DW			CWDE

	MOV			DX,x3             {(x3-x1)}
	SUB			DX,x1
	DD			MOVSX_EDX_DX

	DB			_386;IMUL		DX
	DB			_386;SUB		DI,AX	{IsFaceVisible:=ESI-EAX<0;}

	DB			$0F,$9C,$C0				{SETL AL}

@FIN:
END;

function IsFaceVisible:boolean;ASSEMBLER;
ASM
	MOV			AX,x2             {ESI=(x2-x1)*}
	SUB			AX,x1
	DW			CWDE
														{(y3-y1)-}
	MOV			DX,y3
	SUB			DX,y1
	DD			MOVSX_EDX_DX

	DB			_386;IMUL		DX
	DB			_386;MOV		DI,AX


	MOV			AX,y2             {EAX=(y2-y1)*}
	SUB			AX,y1
	DW			CWDE

	MOV			DX,x3             {(x3-x1)}
	SUB			DX,x1
	DD			MOVSX_EDX_DX

	DB			_386;IMUL		DX
	DB			_386;SUB		DI,AX	{IsFaceVisible:=ESI-EAX<0;}

	DB			$0F,$9C,$C0				{SETL AL}

@FIN:
END;

(*procedure Qsort(o:Pobject;max:word);

	procedure sort(l,r:integer);
var
	i,j,xx:integer;
	xchg:Tfaces;
	zi,zj:LongInt;

begin
	with o^ do
		begin
			i:=l;j:=r;
			xx:=Pscreen^[Pfaces^[(i+j) div 2].v1].z+
					Pscreen^[Pfaces^[(i+j) div 2].v2].z+
					Pscreen^[Pfaces^[(i+j) div 2].v3].z;

			repeat
				zi:=Pscreen^[Pfaces^[i].v1].z+
						Pscreen^[Pfaces^[i].v2].z+
						Pscreen^[Pfaces^[i].v3].z;
				while zi>xx do
					begin
						inc(i);
						zi:=Pscreen^[Pfaces^[i].v1].z+
								Pscreen^[Pfaces^[i].v2].z+
								Pscreen^[Pfaces^[i].v3].z;
					end;

				zj:=Pscreen^[Pfaces^[j].v1].z+
						Pscreen^[Pfaces^[j].v2].z+
						Pscreen^[Pfaces^[j].v3].z;
				while xx>zj do
					begin
						dec(j);
						zj:=Pscreen^[Pfaces^[j].v1].z+
								Pscreen^[Pfaces^[j].v2].z+
								Pscreen^[Pfaces^[j].v3].z;
					end;

				if i<=j then
					begin
						if zi<>zj then
							begin
								xchg:=Pfaces^[i];
								Pfaces^[i]:=Pfaces^[j];
								Pfaces^[j]:=xchg;
							end;

						inc(i);
						dec(j);
					end;
			until i>j;
		end;

	if l<j then sort(l,j);
	if i<r then sort(i,r);
end;

begin
	sort(0,max);
end;*)

var
	Po:Pobject;

procedure sort(l,r:integer);ASSEMBLER;
var
	i,j:integer;
	x,zi,zj:LongInt;
	y:Tfaces;

{	x:=o.Pscreen^[o.Pfaces^[(i+j) div 2].Vertex1].z+
		 o.Pscreen^[o.Pfaces^[(i+j) div 2].Vertex2].z+
		 o.Pscreen^[o.Pfaces^[(i+j) div 2].Vertex3].z;}

ASM
	MOV		AX,l
	MOV		i,AX
	MOV		AX,r
	MOV		j,AX

	MOV		AX,WORD(Po+2)
	DW		MOV_FS_AX
	MOV		DI,WORD(Po) {FS:DI=@o}

	DB		FS;MOV		AX,WORD(Tobject[DI].Pfaces+2)
	DW		MOV_GS_AX
	DB		FS;MOV		SI,WORD(Tobject[DI].Pfaces)	{GS:SI=@o.Pfaces}
	DB		FS;LES		BX,Tobject[DI].Pscreen			{ES:BX=@o.Pscreen}

	MOV		AX,i
	ADD		AX,j
	SHR		AX,1
	SHL		AX,4      {*16=SizeOf(Tfaces)}
	ADD		SI,AX     {GS:SI=@o.Pfaces[(i+j) div 2]}

	DB		GS;MOV		DI,Tfaces[SI].v1
	SHL		DI,4			{*16=SizeOf(Tscreen)}
	DB		_386;MOV	CX,WORD(ES:Tscreen[DI+BX].z)	{ES:DI=@o.Pscreen[o.Pfaces^[(i+j) div 2]]}

	DB		GS;MOV		DI,Tfaces[SI].v2
	SHL		DI,4
	DB		_386;ADD	CX,WORD(ES:Tscreen[DI+BX].z)

	DB		GS;MOV		DI,Tfaces[SI].v3
	SHL		DI,4
	DB		_386;ADD	CX,WORD(ES:Tscreen[DI+BX].z)

	DB		_386;MOV	WORD(x),CX

{-----------------------------------------------------------------------------
repeat
	while o.Pscreen^[o.Pfaces^[i].Vertex1].z+
				o.Pscreen^[o.Pfaces^[i].Vertex2].z+
				o.Pscreen^[o.Pfaces^[i].Vertex3].z>x do inc(i);}

@COMIENZO:
	PUSH	BP
	MOV		DI,WORD(Po)

	DB		_386;MOV	CX,WORD(x)
	MOV		AX,i
	MOV		DX,AX
	SHL		DX,4      {*16=SizeOf(Tfaces)}

	DB		FS;LES		BX,Tobject[DI].Pscreen			{ES:BX=@o.Pscreen}
	DB		FS;MOV		BP,WORD(Tobject[DI].Pfaces)
	ADD		BP,DX     {GS:BP=@o.Pfaces[i]}

@BUCLE_I:
	DB		GS;MOV		DI,Tfaces[BP].v1
	SHL		DI,4      {*16=SizeOf(Tscreen)}

	DB		GS;MOV		SI,Tfaces[BP].v2
	SHL		SI,4

	DB		_386;MOV	DX,WORD(ES:Tscreen[DI+BX].z)	{ES:DI=@o.Pscreen^[o.Pfaces^[i].v1];}

	DB		GS;MOV		DI,Tfaces[BP].v3
	SHL		DI,4

	DB		_386;ADD	DX,WORD(ES:Tscreen[SI+BX].z)

	INC		AX        {inc(i)}
	ADD		BP,TYPE(Tfaces)

	DB		_386;ADD	DX,WORD(ES:Tscreen[DI+BX].z)

	DB		_386;CMP	DX,CX
	JG		@BUCLE_I

	POP		BP

	DEC		AX
	MOV		i,AX

	DB		_386;MOV	WORD(zi),DX

{-----------------------------------------------------------------------------
	while x>o.Pscreen^[o.Pfaces^[j].v1].z+
					o.Pscreen^[o.Pfaces^[j].v2].z+
					o.Pscreen^[o.Pfaces^[j].v3].z do dec(j);}

	PUSH	BP
	MOV		DI,WORD(Po)

	MOV		AX,j
	MOV		DX,AX
	SHL		DX,4      {*16=SizeOf(Tfaces)}

	DB		FS;LES		BX,Tobject[DI].Pscreen					{ES:BX=@o.Pscreen}
	DB		FS;MOV		BP,WORD(Tobject[DI].Pfaces)
	ADD		BP,DX     {GS:BP=@o.Pfaces[j]}


@BUCLE_J:
	DB		GS;MOV		DI,Tfaces[BP].v1
	SHL		DI,4      {*16=SizeOf(Tscreen)}

	DB		GS;MOV		SI,Tfaces[BP].v2
	SHL		SI,4

	DB		_386;MOV	DX,WORD(ES:Tscreen[DI+BX].z)	{ES:DI=@o.Pscreen^[o.Pfaces^[i].v1];}

	DB		GS;MOV		DI,Tfaces[BP].v3
	SHL		DI,4

	DB		_386;ADD	DX,WORD(ES:Tscreen[SI+BX].z)

	DEC		AX        {dec(j)}
	SUB		BP,TYPE(Tfaces)

	DB		_386;ADD	DX,WORD(ES:Tscreen[DI+BX].z)

	DB		_386;CMP		CX,DX
	JG		@BUCLE_J

	POP		BP

	INC		AX
	MOV		j,AX

{		DB		_386;MOV	WORD(zj),DX}

{-----------------------------------------------------------------------------
	if i<=j then
	begin
		y:=o.Pfaces^[i];
		o.Pfaces^[i]:=o.Pfaces^[j];
		o.Pfaces^[j]:=y;

		inc(i);
		dec(j);
	end;}

{	MOV		AX,i}
	MOV		BX,i
	CMP		BX,AX
	JG		@FIN

	DB		_386;MOV	CX,WORD(zi)
	DB		_386;CMP	CX,DX
	JZ		@Z_IGUALES                  {if zi<>zj then continue;}

	MOV		DI,WORD(Po)
	DB		FS;MOV		SI,WORD(Tobject[DI].Pfaces)
	MOV		DI,SI
	DW		MOV_DX_GS
	MOV		ES,DX                       {GS:SI;ES:DI=o.Pfaces}

	SHL		BX,4												{*SizeOf(Tfaces)}
	ADD		DI,BX
	SHL		AX,4												{*SizeOf(Tfaces)}
	ADD		SI,AX

	DB		_386;MOV		AX,WORD(ES:Tfaces[DI].texture)
	DB		_386;MOV		CX,ES:Tfaces[DI].v1
	DW		GS_386;MOV	BX,WORD(Tfaces[SI].texture)
	DW		GS_386;MOV	DX,Tfaces[SI].v1

	DB		_386;XCHG		AX,BX
	DB		_386;XCHG		CX,DX

	DB		_386;MOV		WORD(ES:Tfaces[DI].texture),AX
	DB		_386;MOV		ES:Tfaces[DI].v1,CX
	DW		GS_386;MOV	WORD(Tfaces[SI].texture),BX
	DW		GS_386;MOV	Tfaces[SI].v1,DX

	DB		_386;MOV		CX,ES:Tfaces[DI].v3
	DW		GS_386;MOV	DX,Tfaces[SI].v3

	DB		_386;XCHG		CX,DX

	DB		_386;MOV		ES:Tfaces[DI].v3,CX
	DW		GS_386;MOV	Tfaces[SI].v3,DX

@Z_IGUALES:
	INC		i
	DEC		j

	MOV		AX,i
	CMP		AX,j
	JLE		@COMIENZO		{until i>j;}

@FIN:
{	if l<j then sort(l,j);
	if i<r then sort(i,r);}

	MOV		AX,l
	MOV		BX,j
	CMP		AX,BX
	JGE		@1
	PUSH	AX
	PUSH	BX
	CALL	sort

@1:
	MOV		AX,i
	MOV		BX,r
	CMP		AX,BX
	JGE		@2
	PUSH	AX
	PUSH	BX
	CALL	sort

@2:
END;

procedure Qsort(o:Pobject;max:word);
begin
	Po:=o;
	sort(0,max);
end;

var
	_SP:word;

function PutTextureTriangle(f:PaFaces;s:PaScreen;Nfaces:word):integer;ASSEMBLER;
var
	i,j:integer;

ASM
	MOV			AX,Nfaces
	MOV			j,AX																{for j:=Nfaces DownTo 0 do}

	MOV			i,0

@BUCLE:
	MOV			_SP,SP

	LES			SI,f																{ES:SI=o.Pfaces^[j]}
	MOV			AX,WORD(s+2)
	DW			MOV_GS_AX
	MOV			DX,WORD(s)

	MOV			DI,MARK_VERTEX_TOO_CLOSE

	MOV			BX,WORD(ES:Tfaces[SI].v1)   				{[BX]=o.Pfaces^[j].v1}
	SHL			BX,4                                {*16=SizeOf(Tscreen)}
	ADD			BX,DX
	DW			GS_386;MOV	CX,Tscreen[BX].sx				{x1,y1:=o.Pscreen^[o.Pfaces^[j].v1].sx,sy;}
	CMP			CX,DI                               {if x1=MARK_VERTEX_TOO_CLOSE then continue}
	JZ			@POP
	DB			_386;MOV		x1,CX
	DB			_386;PUSH		CX
	DW			GS_386;PUSH	WORD(Tscreen[BX].tx)		{tx1,ty1:=o.Pscreen^[o.Pfaces^[j].v1].tx,ty;}

	MOV			BX,WORD(ES:Tfaces[SI].v2)
	SHL			BX,4
	ADD			BX,DX
	DW			GS_386;MOV	CX,Tscreen[BX].sx
	CMP			CX,DI
	JZ			@POP
	DB			_386;MOV		x2,CX
	DB			_386;PUSH		CX
	DW			GS_386;PUSH	WORD(Tscreen[BX].tx)

	MOV			BX,WORD(ES:Tfaces[SI].v3)
	SHL			BX,4
	ADD			BX,DX
	DW			GS_386;MOV	CX,Tscreen[BX].sx
	CMP			CX,DI
	JZ			@POP
	DB			_386;MOV		x3,CX
	DB			_386;PUSH		CX
	DW			GS_386;PUSH	WORD(Tscreen[BX].tx)

	CALL		IsFaceVisible
{	TEST		AL,AL{}
	JGE			@POP

	PUSH		WORD(ES:Tfaces[SI].texture+2)
	CALL		TextureTriangle {inc(i,ord(TriTex(x1,y1,x2,y2,x3,y3,tx1,ty1,tx2,ty2,tx3,ty3,ts)));}
	CMP			AL,TRUE
	JNZ			@POP
	INC			i

@POP:
	ADD			WORD(f),TYPE(Tfaces)
	MOV			SP,_SP{}
	DEC			j
	JGE			@BUCLE

	MOV			AX,i
END;

function PutPointObject(o:Pobject;ordena:boolean):integer;FAR;
var
	u,
	i,j,
	Nfaces:integer;
	fv:boolean;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz-CameraFrom.z<=ZobjectMin) or (wz-CameraFrom.z>ZobjectMax) then exit;}

			u:=UnColor;
			Nfaces:=faces-1;
			fv:=FaceVisible;

			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2) 	{FS:SI=@o.Pvertex^[j]}
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2) 	{GS:DI=@o.Pscreen^[j]}
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	DI,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),DI
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o{}
		DB			_386;MOV		DX,ES:Tobject[BX].sx
		DB			_386;MOV		CX,WORD(ES:Tobject[BX].z)

		MOV			SI,WORD(s)          {GS:SI=@o.Pscreen^[j]}
		DW			GS_386;MOV	Tscreen[SI].sx,DX			{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[SI].z),CX{o.Pscreen^[j].z:=o.z;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	ASM
		MOV			AX,WORD(g+2)
		DW			MOV_GS_AX
	END;
	i:=0;
	for j:=Nfaces DownTo 0 do
		begin
			ASM
				LES			SI,f								{ES:SI=o.Pfaces^[j]}
				MOV			DX,WORD(g)  				{GS:DX=o.Pscreen^[j]}

				MOV			BX,ES:Tfaces[SI].v1   	{AX=o.Pfaces^[j].v1}
				SHL			BX,4								{*16 = SizeOf(Tscreen)}
				ADD			BX,DX       				{BX=offset(o.Pscreen[0])}
				DW			GS_386;MOV	CX,Tscreen[BX].sx
				DB			_386;MOV		x1,CX				{x1,y1:=o.Pscreen^[o.Pfaces^[j].v1].sx,sy;}

				MOV			BX,ES:Tfaces[SI].v2 	{AX=o.Pfaces^[j].v2}
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	CX,Tscreen[BX].sx
				DB			_386;MOV		x2,CX

				MOV			BX,ES:Tfaces[SI].v3 {AX=o.Pfaces^[j].v3}
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	CX,Tscreen[BX].sx
				DB			_386;MOV		x3,CX

				ADD			WORD(f),TYPE(Tfaces)
			END;

			if (x1<>MARK_VERTEX_TOO_CLOSE) and
				 (x2<>MARK_VERTEX_TOO_CLOSE) and
				 (x3<>MARK_VERTEX_TOO_CLOSE) and (IsFaceVisibleOld(fv)) then
				begin
					plot(x1,y1,u);
					plot(x2,y2,u);
					plot(x3,y3,u);

					inc(i);
				end;
		end;

	PutPointObject:=i;
end;

function PutWireObject(o:Pobject;ordena:boolean):integer;FAR;
var
	u,
	i,j,
	Nfaces:integer;
	fv:boolean;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz-CameraFrom.z<=ZobjectMin) or (wz-CameraFrom.z>ZobjectMax) then exit;}

			u:=UnColor;
			Nfaces:=faces-1;
			fv:=FaceVisible;

			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2) 	{FS:SI=@o.Pvertex^[j]}
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2) 	{GS:DI=@o.Pscreen^[j]}
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	DI,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),DI
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o{}
		DB			_386;MOV		DX,ES:Tobject[BX].sx
		DB			_386;MOV		CX,WORD(ES:Tobject[BX].z)

		MOV			SI,WORD(s)          {GS:SI=@o.Pscreen^[j]}
		DW			GS_386;MOV	Tscreen[SI].sx,DX			{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[SI].z),CX{o.Pscreen^[j].z:=o.z;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	ASM
		MOV			AX,WORD(g+2)
		DW			MOV_GS_AX
	END;
	i:=0;
	for j:=Nfaces DownTo 0 do
		begin
			ASM
				LES			SI,f								{ES:SI=o.Pfaces^[j]}
				MOV			DX,WORD(g)  				{GS:DX=o.Pscreen^[j]}

				MOV			BX,ES:Tfaces[SI].v1   	{AX=o.Pfaces^[j].v1}
				SHL			BX,4								{*16 = SizeOf(Tscreen)}
				ADD			BX,DX       				{BX=offset(o.Pscreen[0])}
				DW			GS_386;MOV	CX,Tscreen[BX].sx
				DB			_386;MOV		x1,CX				{x1,y1:=o.Pscreen^[o.Pfaces^[j].v1].sx,sy;}

				MOV			BX,ES:Tfaces[SI].v2
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	CX,Tscreen[BX].sx
				DB			_386;MOV		x2,CX

				MOV			BX,ES:Tfaces[SI].v3
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	CX,Tscreen[BX].sx
				DB			_386;MOV		x3,CX

				ADD			WORD(f),TYPE(Tfaces)
			END;

			if (x1<>MARK_VERTEX_TOO_CLOSE) and
				 (x2<>MARK_VERTEX_TOO_CLOSE) and
				 (x3<>MARK_VERTEX_TOO_CLOSE) and (IsFaceVisibleOld(fv)) then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,u);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,u);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,u);

					inc(i);
				end;
		end;

	PutWireObject:=i;
end;

function PutFlatObject(o:Pobject;ordena:boolean):integer;FAR;
var
	color:byte;
	i,j,l,
	Nfaces:integer;
	foco:word;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz-CameraFrom.z<=ZobjectMin) or (wz-CameraFrom.z>ZobjectMax) then exit;}

			Nfaces:=faces-1;

			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2) 	{FS:SI=@o.Pvertex^[j]}
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2) 	{GS:DI=@o.Pscreen^[j]}
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	DI,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),DI
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		DW			FS_386;MOV	DI,WORD(Tvertex[SI].nx)	{o.x:=o.Pvertex^[j].nx;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].ny)	{o.y:=o.Pvertex^[j].ny;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].nz)	{o.z:=o.Pvertex^[j].nz;}

		DB			_386;MOV		WORD(ES:Tobject[BX].nx),DI
		DB			_386;MOV		WORD(ES:Tobject[BX].ny),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].nz),DX

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o{}
		PUSH		ES
		PUSH		BX
		CALL		RotateNormals

		MOV			foco,0{}
		MOV			l,MAX_LIGHTS
		LES			BX,o{}

@LL:
		PUSH		ES
		PUSH		BX
		PUSH		l
		CALL		CalculateNormalLight
		ADD			foco,AX
		DEC			l
		JGE			@LL

@NO_LIGHT:
		MOV			AX,foco
		CMP			AX,255
		JBE			@OK
		MOV			AX,255

@OK:
		LES			BX,o{}
		DB			_386;MOV		DX,ES:Tobject[BX].sx
		DB			_386;MOV		CX,WORD(ES:Tobject[BX].z)

		MOV			SI,WORD(s)          {GS:SI=@o.Pscreen^[j]}
		DW			GS_386;MOV	Tscreen[SI].sx,DX			{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[SI].z),CX{o.Pscreen^[j].z:=o.z;}
		DB			GS;MOV			Tscreen[SI].light,AL  {o.Pscreen^[j].light:=color;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	if ordena then Qsort(o,Nfaces);

	ASM
		MOV			AX,WORD(g+2)
		DW			MOV_GS_AX
	END;
	i:=0;
	for j:=Nfaces DownTo 0 do
		begin
			ASM
				LES			SI,f								{ES:SI=o.Pfaces^[j]}
				MOV			DX,WORD(g)  				{GS:DX=o.Pscreen^[j]}
				MOV			CH,0

				MOV			BX,ES:Tfaces[SI].v1   	{AX=o.Pfaces^[j].v1}
				SHL			BX,4								{*16 = SizeOf(Tscreen)}
				ADD			BX,DX       				{BX=offset(o.Pscreen[0])}
				DB			GS;MOV	CL,Tscreen[BX].light
				ADD			CL,ES:Tfaces[SI].color{}
				MOV			AX,CX
				DW			GS_386;MOV	BX,Tscreen[BX].sx
				DB			_386;MOV		x1,BX		{x1,y1:=o.Pscreen^[o.Pfaces^[j].v1].sx,sy;}

				MOV			BX,ES:Tfaces[SI].v2
				SHL			BX,4
				ADD			BX,DX
				DB			GS;MOV	CL,Tscreen[BX].light
				ADD			CL,ES:Tfaces[SI].color
				ADD			AX,CX
				DW			GS_386;MOV	BX,Tscreen[BX].sx
				DB			_386;MOV		x2,BX

				MOV			BX,ES:Tfaces[SI].v3
				SHL			BX,4
				ADD			BX,DX
				DB			GS;MOV	CL,Tscreen[BX].light
				ADD			CL,ES:Tfaces[SI].color
				ADD			AX,CX
				DW			GS_386;MOV	BX,Tscreen[BX].sx
				DB			_386;MOV		x3,BX

				MOV			CX,3
				CWD
				IDIV		CX
				MOV			BX,AX
				LES			DI,o
				MOV 		AL,BYTE(ES:Tobject[DI].shade[BX])
				MOV			color,AL        						{color medio del polgono}

				ADD			WORD(f),TYPE(Tfaces)
			END;

			if (x1<>MARK_VERTEX_TOO_CLOSE) and
				 (x2<>MARK_VERTEX_TOO_CLOSE) and
				 (x3<>MARK_VERTEX_TOO_CLOSE) and (IsFaceVisible) then
				inc(i,ord(triangle(	x1,y1,
														x2,y2,
														x3,y3,color)));
		end;

	PutFlatObject:=i;
end;

function PutGouraudObject(o:Pobject;ordena:boolean):integer;FAR;
var
	color1,color2,color3:byte;
	i,j,l,
	Nfaces:integer;
	foco:word;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz-CameraFrom.z<=ZobjectMin) or (wz-CameraFrom.z>ZobjectMax) then exit;}

			Nfaces:=faces-1;

			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2) 	{FS:SI=@o.Pvertex^[j]}
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2)
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	AX,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),AX
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		DW			FS_386;MOV	AX,WORD(Tvertex[SI].nx)	{o.nx:=o.Pvertex^[j].nx;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].ny)	{o.ny:=o.Pvertex^[j].ny;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].nz)	{o.nz:=o.Pvertex^[j].nz;}

		DB			_386;MOV		WORD(ES:Tobject[BX].nx),AX
		DB			_386;MOV		WORD(ES:Tobject[BX].ny),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].nz),DX

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o{}
		PUSH		ES
		PUSH		BX
		CALL		RotateNormals

		MOV			foco,0
		MOV			l,MAX_LIGHTS
		LES			BX,o{}

@LL:
		PUSH		ES
		PUSH		BX
		PUSH		l
		CALL		CalculateNormalLight {AX=color}
		ADD			foco,AX
		DEC			l
		JGE			@LL

@NO_LIGHT:
		MOV			AX,foco
		CMP			AX,255
		JBE			@OK
		MOV			AX,255

@OK:
		LES			BX,o{}
		DB			_386;MOV		SI,WORD(ES:Tobject[BX].sx)
		DB			_386;MOV		DX,WORD(ES:Tobject[BX].z)

		MOV			DI,WORD(s)
		DW			GS_386;MOV	Tscreen[DI].sx,SI				{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[DI].z),DX	{o.Pscreen^[j].z:=o.z;}
		DB			GS;MOV			Tscreen[DI].light,AL    {o.Pscreen^[j].light:=color;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	if ordena then Qsort(o,Nfaces);

	ASM
		MOV			AX,WORD(g+2)
		DW			MOV_GS_AX

		MOV			AX,WORD(o+2)
		DW			MOV_FS_AX
	END;
	i:=0;
	for j:=Nfaces DownTo 0 do
		begin
			ASM
				LES			SI,f								{ES:SI=o.Pfaces^[j]}
				MOV			DX,WORD(g)  				{GS:DX=o.Pscreen^[j]}
				MOV			DI,WORD(o)

				MOV			BX,ES:Tfaces[SI].v1   	{[BX]=o.Pfaces^[j].v1}
				SHL			BX,4                        {*16=SizeOf(Tscreen)}
				ADD			BX,DX
				DW			GS_386;MOV	AX,Tscreen[BX].sx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color{}
				MOV			BH,0
				DB			FS;MOV 			CL,BYTE(Tobject[DI].shade[BX])
				DB			_386;MOV		x1,AX						{x1,y1:=o.Pscreen^[o.Pfaces^[j].v1].sx,sy;}
				MOV 		color1,CL		{color1:=o.shade[o.Pscreen^[o.Pfaces^[j].v1[o.Pfaces^[j].color].luz];}

				MOV			BX,ES:Tfaces[SI].v2
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	AX,Tscreen[BX].sx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color
				MOV			BH,0
				DB			FS;MOV 			CL,BYTE(Tobject[DI].shade[BX])
				DB			_386;MOV		x2,AX
				MOV 		color2,CL

				MOV			BX,ES:Tfaces[SI].v3
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	AX,Tscreen[BX].sx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color
				MOV			BH,0
				DB			FS;MOV 			CL,BYTE(Tobject[DI].shade[BX])
				DB			_386;MOV		x3,AX
				MOV 		color3,CL

				ADD			WORD(f),TYPE(Tfaces)
			END;

			if (x1<>MARK_VERTEX_TOO_CLOSE) and
				 (x2<>MARK_VERTEX_TOO_CLOSE) and
				 (x3<>MARK_VERTEX_TOO_CLOSE) and (IsFaceVisible) then
				inc(i,ord(TriangleGouraud(x1,y1,color1,
																	x2,y2,color2,
																	x3,y3,color3)));
		end;

	PutGouraudObject:=i;
end;

var
	TcenterX,TcenterY:integer;

function PutEnvMapObject(o:Pobject;ordena:boolean):integer;FAR;
var
	tny,tnx:integer;
	Nfaces,
	j:integer;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz<=ZobjectMin) or (wz>=ZobjectMax) then exit;}

			Nfaces:=faces-1;
			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2) 	{FS:SI=@o.Pvertex^[j]}
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2)
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	AX,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),AX
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		DW			FS_386;MOV	AX,WORD(Tvertex[SI].nx)	{o.nx:=o.Pvertex^[j].nx;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].ny)	{o.ny:=o.Pvertex^[j].ny;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].nz)	{o.nz:=o.Pvertex^[j].nz;}

		DB			_386;MOV		WORD(ES:Tobject[BX].nx),AX
		DB			_386;MOV		WORD(ES:Tobject[BX].ny),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].nz),DX

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o{}
		PUSH		ES
		PUSH		BX
		CALL		RotateNormals

		DB			_386;MOV		AX,WORD(ES:Tobject[BX].nx)
		DB			_386;SAR		AX,16-7
		ADD			AX,TcenterX
		MOV			tnx,AX                {tnx:=128+(o.nx*128) shr 16;}

		DB			_386;MOV		AX,WORD(ES:Tobject[BX].ny)
		DB			_386;SAR		AX,16-7
		ADD			AX,TcenterY
		MOV			tny,AX                {tny:=128+(o.ny*128) shr 16;}

		LES			BX,o{}
		DB			_386;MOV		SI,WORD(ES:Tobject[BX].sx)
		DB			_386;MOV		DX,WORD(ES:Tobject[BX].z)

		MOV			DI,WORD(s)
		DB			_386;MOV		AX,tnx
		DW			GS_386;MOV	Tscreen[DI].sx,SI				{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[DI].z),DX	{o.Pscreen^[j].z:=o.z;}
		DW			GS_386;MOV	WORD(Tscreen[DI].tx),AX	{o.Pscreen^[j].tx,ty:=o.nx,o.ny;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	if ordena then Qsort(o,Nfaces);
	PutEnvMapObject:=PutTextureTriangle(f,g,Nfaces);
end;

function PutTextureObject(o:Pobject;ordena:boolean):integer;FAR;
var
	tny,tnx,
	Nfaces,
	j:integer;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz-CameraFrom.z<=ZobjectMin) or (wz-CameraFrom.z>ZobjectMax) then exit;}

			Nfaces:=faces-1;

			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2) 	{FS:SI=@o.Pvertex^[j]}
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2)
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	DI,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		MOV			AH,0
		DB			FS;MOV	AL,Tvertex[SI].u
		MOV			tnx,AX                {tnx:=o.Pvertex^[j].u;}
		DB			FS;MOV	AL,Tvertex[SI].v
		MOV			tny,AX                {tny:=o.Pvertex^[j].v;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),DI
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o
		DB			_386;MOV		SI,WORD(ES:Tobject[BX].sx)
		DB			_386;MOV		DX,WORD(ES:Tobject[BX].z)

		MOV			DI,WORD(s)
		DB			_386;MOV		AX,tnx
		DW			GS_386;MOV	Tscreen[DI].sx,SI				{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[DI].z),DX	{o.Pscreen^[j].z:=o.z;}
		DW			GS_386;MOV	WORD(Tscreen[DI].tx),AX	{o.Pscreen^[j].tx,ty:=o.nx,o.ny;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	if ordena then Qsort(o,Nfaces);
	PutTextureObject:=PutTextureTriangle(f,g,Nfaces);
end;

function PutTextureFlatObject(o:Pobject;ordena:boolean):integer;FAR;
var
	ts,ls,
	foco:word;
	ty1,tx1,
	ty2,tx2,
	ty3,tx3,
	color,
	i,j,l,
	Nfaces,
	tny,tnx:integer;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz-CameraFrom.z<=ZobjectMin) or (wz-CameraFrom.z>ZobjectMax) then exit;}

			Nfaces:=faces-1;

			ls:=seg(light^);

			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2)
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2)
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	AX,WORD(Tvertex[SI].nx)	{o.nx:=o.Pvertex^[j].nx;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].ny)	{o.ny:=o.Pvertex^[j].ny;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].nz)	{o.nz:=o.Pvertex^[j].nz;}

		DB			_386;MOV		WORD(ES:Tobject[BX].nx),AX
		DB			_386;MOV		WORD(ES:Tobject[BX].ny),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].nz),DX

		DW			FS_386;MOV	DI,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),DI
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		MOV			AH,0
		DB			FS;MOV	AL,Tvertex[SI].u
		MOV			tnx,AX                							{tnx:=o.Pvertex^[j].u;}
		DB			FS;MOV	AL,Tvertex[SI].v
		MOV			tny,AX                							{tny:=o.Pvertex^[j].v;}

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o{}
		PUSH		ES
		PUSH		BX
		CALL		RotateNormals

		MOV			foco,0
		MOV			l,MAX_LIGHTS
		LES			BX,o{}

@LL:
		PUSH		ES
		PUSH		BX
		PUSH		l
		CALL		CalculateNormalLight {AX=color}
		ADD			foco,AX
		DEC			l
		JGE			@LL

@NO_LIGHT:
		MOV			AX,foco
		CMP			AX,255
		JBE			@OK
		MOV			AX,255

@OK:
		LES			BX,o{}
		DB			_386;MOV		SI,WORD(ES:Tobject[BX].sx)
		DB			_386;MOV		DX,WORD(ES:Tobject[BX].z)

		MOV			DI,WORD(s)
		DB			_386;MOV		CX,tnx
		DW			GS_386;MOV	Tscreen[DI].sx,SI				{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[DI].z),DX	{o.Pscreen^[j].z:=o.z;}
		DB			GS;MOV			Tscreen[DI].light,AL    {o.Pscreen^[j].light:=color;}
		DW			GS_386;MOV	WORD(Tscreen[DI].tx),CX	{o.Pscreen^[j].tx,ty:=o.nx,o.ny;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	if ordena then Qsort(o,Nfaces);

	i:=0;
	for j:=Nfaces DownTo 0 do
		begin
			ASM
				LES			SI,f								{ES:SI=o.Pfaces^[j]}

				MOV			AX,WORD(g+2)
				DW			MOV_GS_AX
				MOV			DX,WORD(g)  				{GS:DX=o.Pscreen^[j]}

				MOV			BX,ES:Tfaces[SI].v1   	{[BX]=o.Pfaces^[j].Vertex1}
				SHL			BX,4                        {*16=SizeOf(Tscreen)}
				ADD			BX,DX
				DW			GS_386;MOV	AX,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color{}
				MOV			BH,0
				MOV			DI,BX
				DB			_386;MOV		x1,AX						{x1,y1:=o.Pscreen^[o.Pfaces^[j].v1].sx,sy;}
				DB			_386;MOV		tx1,CX

				MOV			BX,ES:Tfaces[SI].v2
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	AX,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color
				MOV			BH,0
				ADD			DI,BX
				DB			_386;MOV		x2,AX
				DB			_386;MOV		tx2,CX

				MOV			BX,ES:Tfaces[SI].v3
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	AX,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color
				MOV			BH,0
				ADD			DI,BX
				DB			_386;MOV		x3,AX
				DB			_386;MOV		tx3,CX

				MOV     AX,WORD(ES:Tfaces[SI].texture+2)
				MOV     ts,AX

				MOV			AX,DI
				MOV			CX,3
				CWD
				IDIV		CX
				MOV			BX,AX
				LES			DI,o
				MOV			BL,BYTE(ES:Tobject[DI].shade[BX])
				MOV			color,BX

				ADD			WORD(f),TYPE(Tfaces)
			END;

			if (x1<>MARK_VERTEX_TOO_CLOSE) and
				 (x2<>MARK_VERTEX_TOO_CLOSE) and
				 (x3<>MARK_VERTEX_TOO_CLOSE) and (IsFaceVisible) then
				inc(i,ord(TextureTriangleFlat(x1,y1,tx1,ty1,
																			x2,y2,tx2,ty2,
																			x3,y3,tx3,ty3,
																			color,ts,ls)));
		end;

	PutTextureFlatObject:=i;
end;

function PutTextureGouraudObject(o:Pobject;ordena:boolean):integer;FAR;
var
	color1,color2,color3:byte;

	ls,ts,
	foco:word;

	ty1,tx1,
	ty2,tx2,
	ty3,tx3,
	i,j,l,
	Nfaces,
	tny,tnx:integer;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz-CameraFrom.z<=ZobjectMin) or (wz-CameraFrom.z>ZobjectMax) then exit;}

			Nfaces:=faces-1;

			ls:=seg(light^);

			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2)
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2)
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	AX,WORD(Tvertex[SI].nx)	{o.nx:=o.Pvertex^[j].nx;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].ny)	{o.ny:=o.Pvertex^[j].ny;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].nz)	{o.nz:=o.Pvertex^[j].nz;}

		DB			_386;MOV		WORD(ES:Tobject[BX].nx),AX
		DB			_386;MOV		WORD(ES:Tobject[BX].ny),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].nz),DX

		DW			FS_386;MOV	DI,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),DI
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		MOV			AH,0
		DB			FS;MOV	AL,Tvertex[SI].u
		MOV			tnx,AX                {tnx:=o.Pvertex^[j].u;}
		DB			FS;MOV	AL,Tvertex[SI].v
		MOV			tny,AX                {tny:=o.Pvertex^[j].v;}

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o{}
		PUSH		ES
		PUSH		BX
		CALL		RotateNormals

		MOV			foco,0
		MOV			l,MAX_LIGHTS
		LES			BX,o{}

@LL:
		PUSH		ES
		PUSH		BX
		PUSH		l
		CALL		CalculateNormalLight {AX=color}
		ADD			foco,AX
		DEC			l
		JGE			@LL

@NO_LIGHT:
		MOV			AX,foco
		CMP			AX,255
		JBE			@OK
		MOV			AX,255

@OK:
		LES			BX,o
		DB			_386;MOV		SI,WORD(ES:Tobject[BX].sx)
		DB			_386;MOV		DX,WORD(ES:Tobject[BX].z)

		MOV			DI,WORD(s)
		DB			_386;MOV		CX,tnx
		DW			GS_386;MOV	Tscreen[DI].sx,SI				{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[DI].z),DX	{o.Pscreen^[j].z:=o.z;}
		DB			GS;MOV			Tscreen[DI].light,AL    {o.Pscreen^[j].light:=color;}
		DW			GS_386;MOV	WORD(Tscreen[DI].tx),CX	{o.Pscreen^[j].tx,ty:=o.nx,o.ny;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	if ordena then Qsort(o,Nfaces);

	i:=0;
	for j:=Nfaces DownTo 0 do
		begin
			ASM
				LES			SI,f								{ES:SI=o.Pfaces^[j]}

				MOV			AX,WORD(g+2)
				DW			MOV_GS_AX
				MOV			DX,WORD(g)  				{GS:DX=o.Pscreen^[j]}
				MOV			AX,WORD(o+2)
				DW			MOV_FS_AX

				MOV			BX,ES:Tfaces[SI].v1   	{[BX]=o.Pfaces^[j].v1}
				SHL			BX,4                        {*16=SizeOf(Tscreen)}
				ADD			BX,DX
				DW			GS_386;MOV	DI,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color{}
				MOV			BH,0
				DB			_386;MOV		x1,DI						{x1,y1:=o.Pscreen^[o.Pfaces^[j].v1].sx,sy;}
				MOV			DI,WORD(o)
				DB			FS;MOV			BL,BYTE(Tobject[DI].shade[BX])
				DB			_386;MOV		tx1,CX
				MOV 		color1,BL

				MOV			BX,ES:Tfaces[SI].v2
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	DI,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color
				MOV			BH,0
				DB			_386;MOV		x2,DI
				MOV			DI,WORD(o)
				DB			FS;MOV			BL,BYTE(Tobject[DI].shade[BX])
				DB			_386;MOV		tx2,CX
				MOV 		color2,BL

				MOV			BX,ES:Tfaces[SI].v3
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	DI,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BL,Tscreen[BX].light
				ADD			BL,ES:Tfaces[SI].color
				MOV			BH,0
				DB			_386;MOV		x3,DI
				MOV			DI,WORD(o)
				DB			FS;MOV			BL,BYTE(Tobject[DI].shade[BX])
				DB			_386;MOV		tx3,CX
				MOV 		color3,BL

				MOV     AX,WORD(ES:Tfaces[SI].texture+2)
				MOV     ts,AX

				ADD			WORD(f),TYPE(Tfaces)
			END;

			if (x1<>MARK_VERTEX_TOO_CLOSE) and
				 (x2<>MARK_VERTEX_TOO_CLOSE) and
				 (x3<>MARK_VERTEX_TOO_CLOSE) and (IsFaceVisible) then
				inc(i,ord(TextureTriangleGouraud(	x1,y1,tx1,ty1,color1,
																					x2,y2,tx2,ty2,color2,
																					x3,y3,tx3,ty3,color3,
																					ts,ls)));
		end;

	PutTextureGouraudObject:=i;
end;

function PutTextureEnvMapObject(o:Pobject;ordena:boolean):integer;FAR;
var
	v1,u1,
	v2,u2,
	v3,u3,
	vn,un:byte;
	ty1,tx1,
	ty2,tx2,
	ty3,tx3,
	tny,tnx,
	Nfaces,
	i,j:integer;

	ls,ts,tsem:word;

	v:PaVertex;
	g,s:PaScreen;
	f:PaFaces;

begin
	with o^ do
		begin
{			if (wz-CameraFrom.z<=ZobjectMin) or (wz-CameraFrom.z>ZobjectMax) then exit;}

			Nfaces:=faces-1;

			v:=Pvertex;
			f:=Pfaces;
			s:=Pscreen;
			g:=s;

			tsem:=seg(EnvMap^);
			ls:=seg(light^);
		end;

	PrecalcsVertexNormals(o);

	ASM
		MOV			AX,WORD(v+2) 	{FS:SI=@o.Pvertex^[j]}
		DW			MOV_FS_AX
		MOV			AX,WORD(s+2)
		DW			MOV_GS_AX
		LES			BX,o

		MOV			AX,ES:Tobject[BX].vertex
		MOV			j,AX					{for j:=Nvertex DownTo 0 do}

@BUCLE:
		MOV			SI,WORD(v)

		DW			FS_386;MOV	DI,WORD(Tvertex[SI].x)	{o.x:=o.Pvertex^[j].x;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].y)	{o.y:=o.Pvertex^[j].y;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].z)	{o.z:=o.Pvertex^[j].z;}

		DB			_386;MOV		WORD(ES:Tobject[BX].x),DI
		DB			_386;MOV		WORD(ES:Tobject[BX].y),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].z),DX

		DW			FS_386;MOV	AX,WORD(Tvertex[SI].nx)	{o.nx:=o.Pvertex^[j].nx;}
		DW			FS_386;MOV	CX,WORD(Tvertex[SI].ny)	{o.ny:=o.Pvertex^[j].ny;}
		DW			FS_386;MOV	DX,WORD(Tvertex[SI].nz)	{o.nz:=o.Pvertex^[j].nz;}

		DB			_386;MOV		WORD(ES:Tobject[BX].nx),AX
		DB			_386;MOV		WORD(ES:Tobject[BX].ny),CX
		DB			_386;MOV		WORD(ES:Tobject[BX].nz),DX

		MOV			AH,0
		DB			FS;MOV	AL,Tvertex[SI].u
		MOV			tnx,AX                							{tnx:=o.Pvertex^[j].u;}
		DB			FS;MOV	AL,Tvertex[SI].v
		MOV			tny,AX                							{tny:=o.Pvertex^[j].v;}

		ADD			WORD(v),TYPE(Tvertex)

		PUSH		ES
		PUSH		BX
		CALL		RotateVertexs

		LES			BX,o{}
		PUSH		ES
		PUSH		BX
		CALL		RotateNormals

		DB			_386;MOV		AX,WORD(ES:Tobject[BX].nx)
		DB			_386;SAR		AX,16-7
		ADD			AX,TcenterX
		MOV			un,AL                {tnx:=128+(o.nx*128) shr 16;}

		DB			_386;MOV		AX,WORD(ES:Tobject[BX].ny)
		DB			_386;SAR		AX,16-7
		ADD			AX,TcenterY
		MOV			vn,AL                {tny:=128+(o.ny*128) shr 16;}

		LES			BX,o{}
		DB			_386;MOV		SI,WORD(ES:Tobject[BX].sx)
		DB			_386;MOV		DX,WORD(ES:Tobject[BX].z)

		MOV			DI,WORD(s)
		DB			_386;MOV		AX,tnx
		MOV			CX,WORD(un)
		DW			GS_386;MOV	Tscreen[DI].sx,SI				{o.Pscreen^[j].sx:=o.sx;o.Pscreen^[j].sy:=o.sy;}
		DW			GS_386;MOV	WORD(Tscreen[DI].z),DX	{o.Pscreen^[j].z:=o.z;}
		DW			GS_386;MOV	WORD(Tscreen[DI].tx),AX	{o.Pscreen^[j].tx,ty:=tnx,tny;}
		DB			GS;MOV			WORD(Tscreen[DI].u),CX	{o.Pscreen^[j].u,v:=un,vn;}
		ADD			WORD(s),TYPE(Tscreen)

		DEC			j
		JNZ			@BUCLE
	END;

	if ordena then Qsort(o,Nfaces);

	i:=0;
	for j:=Nfaces DownTo 0 do
		begin
			ASM
				LES			SI,f								{ES:SI=o.Pfaces^[j]}

				MOV			AX,WORD(g+2)
				DW			MOV_GS_AX
				MOV			DX,WORD(g)  				{GS:DX=o.Pscreen^[j]}

				MOV			BX,ES:Tfaces[SI].v1   	{[BX]=o.Pfaces^[j].v1}
				SHL			BX,4                        {*16=SizeOf(Tscreen)}
				ADD			BX,DX
				DW			GS_386;MOV	DI,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BX,WORD(Tscreen[BX].u)
				DB			_386;MOV		x1,DI						{x1,y1:=o.Pscreen^[o.Pfaces^[j].v1].sx,sy;}
				DB			_386;MOV		tx1,CX
				MOV 		WORD(u1),BX

				MOV			BX,ES:Tfaces[SI].v2
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	DI,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BX,WORD(Tscreen[BX].u)
				DB			_386;MOV		x2,DI
				DB			_386;MOV		tx2,CX
				MOV 		WORD(u2),BX

				MOV			BX,ES:Tfaces[SI].v3
				SHL			BX,4
				ADD			BX,DX
				DW			GS_386;MOV	DI,Tscreen[BX].sx
				DW			GS_386;MOV	CX,Tscreen[BX].tx
				DB			GS;MOV			BX,WORD(Tscreen[BX].u)
				DB			_386;MOV		x3,DI
				DB			_386;MOV		tx3,CX
				MOV 		WORD(u3),BX

				MOV     AX,WORD(ES:Tfaces[SI].texture+2)
				MOV     ts,AX

				ADD			WORD(f),TYPE(Tfaces)
			END;

			if (x1<>MARK_VERTEX_TOO_CLOSE) and
				 (x2<>MARK_VERTEX_TOO_CLOSE) and
				 (x3<>MARK_VERTEX_TOO_CLOSE) and (IsFaceVisible) then
				inc(i,ord(TextureTriangleEnvMap(x1,y1,tx1,ty1,u1,v1,
																				x2,y2,tx2,ty2,u2,v2,
																				x3,y3,tx3,ty3,u3,v3,
																				ts,tsem,ls)));
		end;

	PutTextureEnvMapObject:=i;
end;

procedure SetRenderType(o:Pobject;r:Trender);
begin
	with o^ do
		begin
			Put3DObject:=call[r];
			RenderType:=r;
		end;
end;

function GetRenderType(o:Pobject):Trender;
begin
	GetRenderType:=o^.RenderType;
end;

function LoadObject(var o:Pobject;nombre:string):boolean;
var
	f:Tfile;
	l,n:word;
	c3d:TR3d;

begin
	LoadObject:=FALSE;

	if pos('.',nombre)=0 then nombre:=nombre+'.3D';
	if open(f,nombre,RO)>0 then exit;

	read(f,c3d,SizeOf(c3d),l);
	if (c3d.magic<>'3D') or (not GetMem(o,SizeOf(Tobject))) then
		begin
			close(f);
			exit;
		end;

	with o^ do
		begin
			vertex:=c3d.vertex;
			faces:=c3d.faces;

			if (not GetMem(Pscreen,SizeOf(Tscreen)*faces)) or
				 (not GetMem(Pvertex,SizeOf(Tvertex)*vertex)) or
				 (not GetMem(Pfaces,SizeOf(Tfaces)*faces)) then
				begin
					close(f);
					exit;
				end;

			read(f,Pvertex^,SizeOf(Tvertex)*vertex,l);
			read(f,Pfaces^,SizeOf(Tfaces)*faces,l);

			close(f);
		end;

	ResetObject(o);
	RemapColors(o,0,255);

	LoadObject:=TRUE;
end;

procedure FreeObject(var o:Pobject);
begin
	with o^ do
		begin
			FreeMem(Pscreen,SizeOf(Tscreen)*faces);
			FreeMem(Pfaces,SizeOf(Tfaces)*faces);
			FreeMem(Pvertex,SizeOf(Tvertex)*vertex);
		end;

	FreeMem(o,SizeOf(Tobject));
end;

procedure ResetObject(o:Pobject);
begin
	with o^ do
		begin
			wx:=0;wy:=0;wz:=3000;
			caida:=0;balanza:=0;deriva:=0;
			ZobjectMin:=1;ZobjectMax:=100000;
			ZclipMin:=50;ZclipMax:=ZobjectMax;

			EnvMap:=NIL;{}
			UnColor:=15;
			FaceVisible:=FALSE;

			RenderType:=_FLAT_;
			Put3DObject:=PutFlatObject;
		end;
end;

procedure SetTextureObject(o:Pobject;h:integer);
var
	t:Ptexture;

begin
	t:=GetTexture(h);
	ASM
		PUSH		DS
		DB			_386;MOV		AX,WORD(t)

		LES			DI,o
		MOV			CX,ES:Tobject[DI].faces
		LDS			DI,ES:Tobject[DI].Pfaces

	@BUCLE:
		DB			_386;MOV		WORD(Tfaces[DI].texture),AX
		ADD			DI,TYPE(Tfaces)
		DEC			CX
		JNZ			@BUCLE

		POP			DS
	END;
end;
{var
	n:integer;
begin
	with o^ do for n:=0 to faces-1 do Pfaces^[n].texture:=h
end;}

function MakeCloneObject(f:Pobject;var d:Pobject):boolean;
var
	ca,ba,de,
	xx,yy,zz:LongInt;

begin
	MakeCloneObject:=FALSE;
	if not GetMem(d,SizeOf(Tobject)) then exit;

	ResetObject(d);
	d^:=f^;

	MakeCloneObject:=TRUE;
end;

procedure FreeCloneObject(var o:Pobject);
begin
	FreeMem(o,SizeOf(Tobject));
end;

procedure MakeCloneLight(f:Pobject;var d:Pobject);
begin
	d^.light:=f^.light;
end;

procedure SetPointWireObjectColor(o:Pobject;c:byte);
begin
	o^.UnColor:=c;{}
end;

procedure SetFaceVisible(o:Pobject;v:boolean);
begin
	o^.FaceVisible:=v;{}
end;

procedure SetEnvMapObject(o:Pobject;h:pointer);
begin
	o^.EnvMap:=h;{}
end;


function NewFocus:integer;
var
	n:integer;

begin
	NewFocus:=-1;
	for n:=0 to MAX_LIGHTS do
		if not Alight[n].active then
			begin
				Alight[n].active:=TRUE;
				NewFocus:=n;
				exit;
			end;
end;

procedure SetFocus(h:integer;var ft:TVector);
var
	length:double;
	r:TVector;

begin
	with Alight[h] do
		begin
			if not active then exit;
			VectorSub(r,ft,FocusFrom);
			VectorNormalize(r,light);
		end;
end;

procedure FreeFocus(h:integer);
begin
	Alight[h].active:=FALSE;
end;

procedure SetOriginFocus(var ff:TVector);
begin
	FocusFrom:=ff;
end;


procedure PutTextureLight(x,y:integer);{}
begin
	TcenterX:=x;TcenterY:=y;
end;

procedure RemapColors(o:Pobject;inicial,cuantos:integer);
var
	n:integer;
	a,m:double;

begin
	m:=cuantos/256;
	a:=inicial;

	for n:=0 to 255 do with o^ do
		begin
			shade[n]:=round(a);
			a:=a+m;
		end;
end;

function LoadLightObject(o:Pobject;n:string):boolean;
begin
	LoadLightObject:=Loadlight(o^.light,n);
end;

procedure FreeLightObject(o:Pobject);
begin
	FreeLight(o^.light);
end;

procedure SetCalculs(m:Tcalcs);
begin
	case m of
		_12MULS_:
			begin
				PrecalcsVertexNormals:=Precalc12Mult;
				RotateVertexs:=RotateVertex12Mult;
				RotateNormals:=RotateNormals12Mult;
				AmbientLight:=128;
			end;

		_MATRIX_:
			begin
				PrecalcsVertexNormals:=PrecalcMatrix;
				RotateVertexs:=RotateMatrix;
				RotateNormals:=RotateNormalsMatrix;
				AmbientLight:=128;
			end;
	end;
end;

function LoadAni(var ani:Pani;n:string):integer;
var
	vertex,faces,
	a:integer;
	cani:TRAni;
	c3d:TR3d;
	f:Tfile;
	l:word;

begin
	LoadAni:=0;

	if not GetMem(ani,SizeOf(Tani)) then exit;

	if pos('.',n)=0 then n:=n+'.ANI';
	if open(f,n,RO)>0 then exit;
	read(f,cani,SizeOf(cani),l);
	if (cani.magic<>'ANI') or (cani.frames-1>MAX_OBJ_IN_ANIM) then
		begin
			close(f);
			exit;
		end;

	for a:=0 to cani.frames-1 do with ani^ do
		begin
			LoadAni:=-(a+1);

			read(f,c3d,SizeOf(c3d),l);
			if (c3d.magic<>'3D') or (not GetMem(obj[a],SizeOf(Tobject))) then
				begin
					close(f);
					exit;
				end;

			with obj[a]^ do
				begin
					vertex:=c3d.vertex;
					faces:=c3d.faces;

					if (not GetMem(Pscreen,SizeOf(Tscreen)*faces)) or
						 (not GetMem(Pvertex,SizeOf(Tvertex)*vertex)) or
						 (not GetMem(Pfaces,SizeOf(Tfaces)*faces)) then
						begin
							close(f);
							exit;
						end;

					read(f,Pvertex^,SizeOf(Tvertex)*vertex,l);
					read(f,Pfaces^,SizeOf(Tfaces)*faces,l);
				end;

			ResetObject(obj[a]);
			RemapColors(obj[a],0,255);
		end;

	with ani^ do
		begin
			RenderType:=_FLAT_;
			TotalFrames:=cani.frames-1;

			wx:=0;wy:=0;wz:=1500;
			caida:=0;balanza:=0;deriva:=0;
		end;

	LoadAni:=ani^.TotalFrames;
end;

procedure FreeAni(var ani:Pani);
var
	a:integer;

begin
	for a:=0 to ani^.TotalFrames do FreeObject(ani^.obj[a]);
	dispose(ani);
end;

function PlayAni(ani:Pani;f:integer;o:boolean):integer;
var
	ob:Pobject;

begin
	with ani^ do
		begin
			ob:=obj[f];
			ob^.wx:=wx;ob^.wy:=wy;ob^.wz:=wz;
			ob^.caida:=caida;ob^.balanza:=balanza;ob^.deriva:=deriva;
			ob^.light:=light;

			PlayAni:=call[RenderType](ob,o);
		end;
end;

function LoadAniLight(ani:Pani;n:string):boolean;
begin
	LoadAniLight:=LoadLight(ani^.light,n);
end;

procedure FreeAniLight(ani:Pani);
begin
	FreeLight(ani^.light);
end;

function MakeCloneAni(f:Pani;var d:Pani):boolean;
begin
	MakeCloneAni:=FALSE;
	if not GetMem(d,SizeOf(Tani)) then exit;
	d^:=f^;
	MakeCloneAni:=TRUE;
end;

procedure FreeCloneAni(var f:Pani);
begin
	FreeMem(f,SizeOf(Tani));
end;

procedure SetAniRenderType(ani:Pani;r:Trender);
begin
	ani^.RenderType:=r;
end;

function GetAniRenderType(ani:Pani):Trender;
begin
	GetAniRenderType:=ani^.RenderType;
end;

procedure SetPointWireAniColor(ani:Pani;c:integer);
var
	f:integer;

begin
	with ani^ do for f:=0 to TotalFrames do obj[f]^.UnColor:=c;
end;

procedure SetEnvMapAni(ani:Pani;h:pointer);
var
	f:integer;

begin
	with ani^ do for f:=0 to TotalFrames do obj[f]^.EnvMap:=h;
end;

function LoadTexture(n:string;var p:Tpal):integer;
var
	f:Tfile;
	ll:word;
	magic:array[0..2] of char;

begin
	LoadTexture:=-1;

	if pos('.',n)=0 then n:=n+'.TEX';
	if open(f,n,RO)>0 then exit;

	read(f,magic,SizeOf(magic),ll);
	if magic<>'TEX' then
		begin
			close(f);
			exit;
		end;

	new(ActualTexture);
	if not GetMem(ActualTexture^.texture,SizeOf(Tsegment)) then
		begin
			dispose(ActualTexture);
			close(f);
			exit;
		end;

	if LastTexture=NIL then
		begin
			FirstTexture:=ActualTexture;
			ActualTexture^.n:=1;
			ActualTexture^.previous:=NIL;
		end
	else
		begin
			LastTexture^.next:=ActualTexture;
			ActualTexture^.previous:=LastTexture;
			ActualTexture^.n:=LastTexture^.n+1;
		end;
	ActualTexture^.next:=NIL;
	LastTexture:=ActualTexture;

	read(f,ActualTexture^.texture^,SizeOf(Tsegment),ll);
	seek(f,65536+SizeOf(magic));{}
	read(f,p,SizeOf(p),ll);
	close(f);

	LoadTexture:=ActualTexture^.n;
end;

function SaveTexture(n:string;t:Ptexture;var p:Tpal):boolean;
const
	magic:array[0..2] of char='TEX';

var
	f:Tfile;
	l:word;

begin
	SaveTexture:=FALSE;

	if pos('.',n)=0 then n:=n+'.TEX';
	if ReWrite(f,n)>0 then exit;
	write(f,magic,SizeOf(magic),l);
	write(f,t^,SizeOf(Tsegment),l);
	write(f,l,1,l);{}
	write(f,p,SizeOf(Tpal),l);
	close(f);

	SaveTexture:=TRUE;
end;

function FreeTexture(h:integer):boolean;
var
	PreviousTexture,NextTexture,ActualTexture:Pnext;

begin
	FreeTexture:=FALSE;

	ActualTexture:=FirstTexture;
	while (ActualTexture^.n<>h) and (ActualTexture<>NIL) do ActualTexture:=ActualTexture^.next;
	if ActualTexture=NIL then exit;
	FreeMem(ActualTexture^.texture,SizeOf(Tsegment));

	PreviousTexture:=ActualTexture^.previous;
	NextTexture:=ActualTexture^.next;
	if PreviousTexture<>NIL then
		if ActualTexture^.next=NIL then
			if PreviousTexture<>NIL then PreviousTexture^.next:=NIL
		else
			begin
				PreviousTexture^.next:=ActualTexture^.next;
				NextTexture^.previous:=PreviousTexture;
			end;
	if ActualTexture=FirstTexture then
		begin
			FirstTexture:=NextTexture;
			PreviousTexture:=NIL;
		end;
	if ActualTexture=LastTexture then
		begin
			LastTexture:=PreviousTexture;
			NextTexture:=NIL;
		end;

	dispose(ActualTexture);
	ActualTexture:=NIL;

	FreeTexture:=TRUE;
end;

function GetTexture(h:integer):Ptexture;
var
	ActualTexture:Pnext;

begin
	ActualTexture:=FirstTexture;
	while (ActualTexture^.n<>h) and (ActualTexture<>NIL) do ActualTexture:=ActualTexture^.next;
	if ActualTexture=NIL then
		GetTexture:=NIL
	else
		GetTexture:=ActualTexture^.texture;
end;

function LoadLight(var l:Plight;n:string):boolean;
var
	f:Tfile;
	ll:word;
	magic:array[0..4] of char;

begin
	LoadLight:=FALSE;

	if not GetMem(l,SizeOf(Tsegment)) then exit;

	if pos('.',n)=0 then n:=n+'.LGT';
	if open(f,n,RO)>0 then exit;

	read(f,magic,SizeOf(magic),ll);
	if magic<>'LIGHT' then
		begin
			close(f);
			exit;
		end;

	read(f,l^,SizeOf(Tsegment),ll);
	close(f);

	LoadLight:=TRUE;
end;

procedure FreeLight(var l:Plight);
begin
	FreeMem(l,SizeOf(Tsegment));
end;

var
	a:integer;

begin
	FillChar(Alight,SizeOf(Alight),0);

	call[_POINT_]:=PutPointObject;
	call[_WIRE_]:=PutWireObject;
	call[_FLAT_]:=PutFlatObject;
	call[_GOURAUD_]:=PutGouraudObject;
	call[_ENVMAP_]:=PutEnvMapObject;
	call[_TEXTURE_]:=PutTextureObject;
	call[_TEXTURE_FLAT_]:=PutTextureFlatObject;
	call[_TEXTURE_GOURAUD_]:=PutTextureGouraudObject;
	call[_TEXTURE_ENVMAP_]:=PutTextureEnvMapObject;

	PutTextureLight(128,128);

	SetCalculs(_12MULS_);
	for a:=0 to high(sine) do	sine[a]:=round(sin(a*RAD)*ESCALE);
	for a:=0 to high(Rsin) do Rsin[a]:=sin(a*RAD);
end.