unit MyMikMod;

INTERFACE

function init:boolean;
function load(n:Pchar;loop:boolean):boolean;
procedure stop;
procedure done;

IMPLEMENTATION

uses MikMod,Vtimer;

var
	wow:PuniMOD;
	mtmr:integer;

procedure MyTimer;FAR;
{
	 this is the player interrupt which calls the mikmod routines to
	 update the sound.. do NOT FORGET: this should be a FAR function.
}
begin
	MP_HandleTick;              { update module }
	VT_SetBPM(mtmr,mp_bpm);     { set new timer speed }
	MD_Update;                  { update the device }
end;

function init:boolean;
begin
		 { Register the device drivers you want to use }
	MD_RegisterDriver(pnosnddriver);
	MD_RegisterDriver(pgusdriver);

		 { Register the loaders you want to use }
	ML_RegisterLoader(puniload);

		 { Initialize the virtual timer handler & allocate a new timer handle,
			 which will be used to update the music }
	VT_Init;
	mtmr:=VT_Alloc;
	VT_SetHandler(mtmr,@MyTimer);

		 { reset the error variable }
	myerr:=NIL;

		 { initialize the device driver }
	init:=MD_Init;
end;

function load(n:Pchar;loop:boolean):boolean;
begin
	load:=FALSE;
					{ device is ok, load the module }
	wow:=ML_LoadFN(n);
	if wow=NIL then exit;

	{ initialize playing routines to play *this* module }
	MP_Init(wow);
	mp_loop:=loop;             { loop the song }

	{ set number of hardware soundchannels to use for this module }
	md_numchn:=mp_numchn;

	{ start mixing & outputting sound }
	MD_PlayStart;

	{ set the interrupt speed start it }
	VT_SetBPM(mtmr,mp_bpm);
	VT_Start(mtmr);

	load:=TRUE;
end;

procedure stop;
begin
	VT_Stop(mtmr);   { stop the timer interrupt }
	MD_PlayStop;     { stop outputting sound }

	ML_Free(wow);    { free the module }
	MD_Exit;      	 { de-init device }
end;

procedure done;
begin
	VT_Exit;      	 { de-init virtual timer.. don't forget this!! }
end;

end.