unit MyEMS;

INTERFACE

const
	EMSError:byte=0;

function init:boolean;
{Devuelve TRUE si hay EMS e inicializa la EMS}

procedure SegmentoPagina(var segmento:word);
{Devuelve el segmento de pgina para la EMS}

function MemAvail:word;
{Devuelve en LIBRES el nmero de pginas libres (16K)}

function malloc(numero:word):word;
{Localiza NUMERO pginas y devuelve su handle}

procedure ActivarPagina(fisica:byte;logica,handle:word);
{Activa el handle de la pgina lgica y fsica (normalmente 0 y 0) }

procedure ActivaPaginas(num,handle:word;dir:pointer);
{Activa el handle de las pginas lgica y fsica (normalmente 0 y 0)
del buffer DIR que tiene unas entradas de 1 palabra para la pgina lgica
y la segunda la pgina fsica}

procedure dalloc(handle:word);
{Libera el handle HANDLE}

function version:byte;
{Devuelve la versin de EMS}

								{TODAS ESTAS RUTINAS DE EMS CAMBIAN EMSError SI OCURRE
								ALGUN ERROR, SI NO A 0}

IMPLEMENTATION

function init:boolean;

procedure estado;ASSEMBLER;
ASM
	MOV			AH,$40
	INT			$67
	MOV			EMSError,AH
END;

function existe:boolean;
const
	nombre:string[8]='EMMXXXX0';

var
	puntero:^byte;
	i:integer;

begin
	existe:=TRUE;
	ASM
		MOV			AX,$3567
		INT			$21
		MOV			WORD(puntero),$A
		MOV			WORD(puntero+2),ES
	END;
	for i:=1 to 8 do
		if ord(nombre[i])=puntero^ then
			inc(puntero)
		else
			begin
				existe:=FALSE;
				exit;
			end;
end;

begin
	init:=FALSE;
	if existe then
		begin
			init:=TRUE;
			estado;
		end;
end;

procedure SegmentoPagina(var segmento:word);ASSEMBLER;
ASM
	MOV			AH,$41
	INT			$67
	LES			DI,segmento
	XCHG		AX,BX
	STOSW
	MOV			EMSError,BH
END;

function MemAvail:word;ASSEMBLER;
ASM
	MOV			AH,$59
  MOV			AL,1
	INT			$67
	XCHG		AX,BX
	MOV			EMSError,BH
end;

function malloc(numero:word):word;ASSEMBLER;
ASM
	MOV			AX,$5A00
	MOV			BX,numero
	INT			$67
	XCHG		AX,DX
	STOSW
	MOV			EMSError,DH
END;

procedure ActivarPagina(fisica:byte;logica,handle:word);ASSEMBLER;
ASM
	MOV			AH,$44
	MOV			AL,fisica
	MOV			BX,logica
	MOV			DX,handle
	INT			$67
	MOV			EMSError,AH
END;

procedure ActivaPaginas(num,handle:word;dir:pointer);ASSEMBLER;
ASM
	PUSH		DS
	MOV			AX,$5000
	MOV			CX,num
	MOV			DX,handle
	LDS			SI,dir
	INT			$67
	MOV			EMSError,AH
END;

procedure dalloc(handle:word);ASSEMBLER;
ASM
	MOV			AH,$45
	MOV			DX,handle
	INT			$67
	MOV			EMSError,AH
END;

function version:byte;ASSEMBLER;
ASM
	MOV			AH,$46
	INT			$67
	MOV			EMSError,AH
	OR			AH,AH
	JZ			@FIN
	XOR			AL,AL

@FIN:
END;

end.
