unit MyDOS;

INTERFACE

const
	ErrorPrinter:byte=0;

	DIRECTORIO_EXISTE=5;
	DIRECTORIO_NO_EXISTE=3;

	FICHERO_NO_EXISTE=2;
	PATH_NO_ENCONTRADO=3;
	DEMASIADOS_FICHEROS_ABIERTOS=4;
	ACCESO_DENEGADO=5;
	HANDLE_INVALIDO=6;
	MEMORIA_INSUFICIENTE=8;
	DISCO_PROTEGIDO=9;

type
	Tunidad=(_A,_B,_C,_D,_E,_F,_G,_H,_I,_J,_K,_L,_M,_N,_O,_P,
						_Q,_R,_S,_T,_U,_V,_W,_X,_Y,_Z);
	lpt=(LPT1,LPT2,LPT3);
	Tletra=(MINI,PROPORCIONAL,ESTRECHA,ALTA_CALIDAD,SUB_INDICES,SUPER_INDICES,
					DOBLE_IMPRESION,CURSIVA,NEGRITA,SUBRAYADO,DOBLE_ANCHURA,NORMAL);

const
	Seg0000:word=0;
	SegC000:word=$c000;

procedure dir(opciones:string);
{igual que en el DOS}

procedure del(opciones:string);
{igual que en el DOS}

procedure copia(opciones:string);
{igual que el COPY del DOS}

function sgn(valor:integer):integer;
{devuelve -1 si VALOR<0, 0 si VALOR=0 y 1 si VALOR>0}

function TestBit(var conta;num:integer):boolean;
{devuelve TRUE si el bit NUM de conta est a 1, CONTA puede ser cualquier tipo ENTERO}

procedure SetBit(var conta;num:integer);
{pone a 1 el bit NUM de CONTA, CONTA puede ser cualquier tipo ENTERO}

procedure ClearBit(var conta;num:integer);
{pone a 0 el bit NUM de CONTA,
CONTA puede ser cualquier tipo ENTERO}

procedure ToggleBit(var conta;num:integer);
{pone a 0 el bit NUM de CONTA si est a 1 y si no a 0, CONTA puede ser cualquier tipo ENTERO}

function aleatorio(inferior,superior:integer):integer;
{devuelve un nmero aleatorio entre SUPERIOR e INFERIOR y con signo}

procedure drive(disco:Tunidad);
{cambia la unidad de disco activa}

function GetDrive:byte;
{devuelve la unidad de disco activa}

function ImpresoraOn(cual:lpt):boolean;
{devuelve TRUE si la impresora esta ON, cual=LPT1, LPT2 o LPT3}

procedure TipoLetra(tipo:Tletra);
{cambia el tipo de letra para la impresora}

procedure ImprimeTexto(texto:string);
{imprime una cadena}

procedure ImprimeNumero(numero:LongInt);
{imprime una cifra}

procedure reboot;
{resetea el ordenador}

procedure AlarmaON(h,m:byte;dir:pointer);
{activa la alarma, a las H:M,s ir a las rutina DIR}

procedure AlarmaOFF;
{desactiva la alarma}

procedure EveryInit(mil:word;dir:pointer);
{rutina de interrupcin de cada MIL milisegundos ir a DIR, el
procedimiento a de ser FAR}

procedure EveryDone;
{Deshabilita el procedimiento Every}

procedure after(mil:word;dir:pointer);
{rutina de interrupcin dedpus DE MIL milisegundos ir a DIR, el
procedimiento a de ser FAR}

procedure NumLockON;
{Enciende la luz del NUM LOCK}

procedure NumLockOFF;
{Apagala luz del NUM LOCK}

procedure CapsOn;
procedure CapsOff;
procedure LockOn;
procedure LockOff;


function PorCiento(num:LongInt;tanto:integer):integer;
{Calcula el tanto TANTO por ciento de NUM}

procedure EnableIrq(i:byte);
{Habilita la int I}

procedure DisableIrq(i:byte);
{Deshabilita la int I}

procedure EOI;
INLINE(
	$B0/$20/	{MOV AL,$20}
	$E6/$20   {OUT $20,AL}
	);
{Hace un End Of Interrupt hard}

procedure CLI;
INLINE($FA);	{CLI}

procedure STI;
INLINE($FB);	{STI}

procedure PUSHF;
INLINE($9C);	{PUSHF}

procedure IncPtr(p:pointer;num:LongInt);
{incrementa el puntero p en NUM unidades,
pero al salir de segmento va al siguiente}
INLINE(
	$58/											{POP		AX}
	$5B/											{POP		BX}
	$5E/											{POP		SI}
	$07/											{POP		ES}

	$26/$01/$04/							{ADD		ES:[SI],AX}
	$73/$06/									{JNC		@SIGUE}
	$26/$81/$44/$02/$00/$10/	{ADD		ES:WORD([SI+2]),$1000}
{@SIGUE:}
	$C1/$E3/$0C/							{SHL		BX,12   *$1000}
	$26/$01/$5C/$02						{ADD		ES:[SI+2],BX}
	);

procedure DecPtr(p:pointer;num:LongInt);
{decrementa el puntero p en NUM unidades,
pero al salir de segmento va al anterior}
INLINE(
	$58/											{POP		AX}
	$5B/											{POP		BX}
	$5E/											{POP		SI}
	$07/											{POP		ES}

	$26/$29/$04/							{SUB		ES:[SI],AX}
	$73/$06/									{JNC		@SIGUE}
	$26/$81/$6C/$02/$00/$10/	{SUB		ES:WORD([SI+2]),$1000}
{@SIGUE:}
	$C1/$E3/$0C/							{SHL		BX,12   *$1000}
	$26/$29/$5C/$02						{SUB		ES:[SI+2],BX}
	);

procedure WritePtr(p:pointer;o:word;dato:byte);
{Escribe en el puntero P, +offset O, el dato DATO, como en C *(p+xx)=a}
INLINE(
	$58/				{POP		AX}
	$4B/				{POP		BX}
	$5E/				{POP		SI}
	$07/				{POP		ES}
	$26/$88/$00	{MOV		ES:[SI+BX],AL}
	);

function ReadPtr(p:pointer;o:word):byte;
{Lee el dato del puntero P, +offset O, como en C a=*(p+xx)}
INLINE(
	$58/				{POP		AX}
	$4B/				{POP		BX}
	$5E/				{POP		SI}
	$07/				{POP		ES}
	$26/$8A/$00	{MOV		AL,ES:[SI+BX]}
	);

function GetCDROM(var unidad:char):boolean;
{Devuelve TRUE si hay CD y UNIDAD es la letra del CD}

function md(var dir:string):byte;
{Crea mltiples subdirectorios y devuelve >0 si error}

procedure SetTimer(n:word);
{Reprograma el timer, para que genere N interrupciones por segundo}

procedure TimerTicks(n:word);

procedure NormalTimer;
{Pone el timer a la velocidad normal}

function GetTimer:word;
{Devuelve la velocidad del timer}

function PtrToLinear(p:pointer):LongInt;
{Devuelve la direccin linear del puntero P}

procedure delay(decimas:word);
{Espera decimas de segundos}

function rnd(n:word):word;
{Devuelve un nmero aleatorio entre 0 y n-1}

function InProtectedMode:boolean;
{TRUE si estamos bajo un gestor de EMM}

function SegmentCodeToWrite:word;
{Devuelve un segmento que apunta a CS, para poder escribir en l}

function FindShl(n:integer):integer;

IMPLEMENTATION

uses
	{printer,}DOS,OP386
{$IFDEF __BPPROT__}
	,PM
{$ENDIF}
	;

const
	MiliSegundos:real=0.0182;
	PuedoAfter:boolean=TRUE;

	INT_TIEMPO=8;

var
	TiempoEvery,TiempoAfter:real;
	GuardaAlarma:pointer;
	AnteriorEvery,AnteriorAfter,RutinaEvery,RutinaAfter:procedure;
	n1,n2:word;
	random:word;

procedure RutinaIntEvery;INTERRUPT;
begin
	PUSHF;
	AnteriorEvery;

	inc(n1);
	if n1>TiempoEvery then
		begin
			RutinaEvery;
			n1:=0;
		end;

	STI;
end;

procedure RutinaIntAfter;INTERRUPT;
begin
	PUSHF;
	AnteriorAfter;

	inc(n2);
	if n2>TiempoAfter then
		begin
			RutinaAfter;
			SetIntVec(INT_TIEMPO,@AnteriorAfter);
			PuedoAfter:=TRUE;
		end;

	STI;
end;

procedure dir(opciones:string);
begin
	SwapVectors;
	exec(GetEnv('COMSPEC'),'/c dir '+opciones);
	SwapVectors;
end;

procedure del(opciones:string);
begin
	SwapVectors;
	exec(GetEnv('COMSPEC'),'/c del '+opciones);
	SwapVectors;
end;

procedure copia(opciones:string);
begin
	SwapVectors;
	exec(GetEnv('COMSPEC'),'/c copy '+opciones);
	SwapVectors;
end;

function sgn(valor:integer):integer;
begin
	if valor<0 then
		sgn:=-1
	else
		if valor=0 then
			sgn:=0
		else
			sgn:=1;
end;

function TestBit(var conta;num:integer):boolean;ASSEMBLER;
ASM
	LES			DI,conta
	MOV			AX,num
	DD			BT_ES_DI_AX
	DB			$0F,$92,$C0	{SETC		AL}
END;

procedure SetBit(var conta;num:integer);ASSEMBLER;
ASM
	LES			DI,conta
	MOV			AX,num
	DD			BTS_ES_DI_AX
END;

procedure ClearBit(var conta;num:integer);ASSEMBLER;
ASM
	LES			DI,conta
	MOV			AX,num
	DD			BTR_ES_DI_AX
END;

procedure ToggleBit(var conta;num:integer);ASSEMBLER;
ASM
	LES			DI,conta
	MOV			AX,num
	DD			BTC_ES_DI_AX
END;

function aleatorio(inferior,superior:integer):integer;
begin
	aleatorio:={system.random}rnd(superior-inferior)+inferior;
end;

procedure drive(disco:Tunidad);ASSEMBLER;
ASM
	MOV			AH,$E
	MOV			DL,disco
	INT			$21
END;

function GetDrive:byte;ASSEMBLER;
ASM
	MOV			AH,$19
	INT			$21
END;

function ImpresoraOn(cual:lpt):boolean;
var
	r:byte;

begin
	ErrorPrinter:=0;
	ImpresoraOn:=FALSE;

	ASM
		MOV			AH,2
		XOR			DH,DH
		MOV			DL,cual
		INT			$17
		MOV			r,AH
	END;

	case r of
		2,$4a:ErrorPrinter:=1;
		0,$10,8,$18,$58:ErrorPrinter:=2;
		$28,$38:ErrorPrinter:=3;
		$88,$c8:ErrorPrinter:=4;
		$90:ImpresoraOn:=TRUE;
		else ErrorPrinter:=5;
	end;
end;

procedure TipoLetra(tipo:Tletra);
const
	COD=#27;

begin
	case tipo of
		MINI:ImprimeTexto(COD+'P');
		PROPORCIONAL:ImprimeTexto(COD+'p'+#1);
		ESTRECHA:ImprimeTexto(#15);
		ALTA_CALIDAD:ImprimeTexto(COD+'x'+#1);
		SUB_INDICES:ImprimeTexto(COD+'S'+#1);
		SUPER_INDICES:ImprimeTexto(COD+'S'+#0);
		DOBLE_IMPRESION:ImprimeTexto(COD+'G');
		CURSIVA:ImprimeTexto(COD+'4');
		NEGRITA:ImprimeTexto(COD+'E');
		SUBRAYADO:ImprimeTexto(COD+'-'+#1);
		DOBLE_ANCHURA:ImprimeTexto(#14);
		NORMAL:ImprimeTexto(COD+'@');
	end;
end;

procedure ImprimeTexto(texto:string);
begin
{	write(lst,texto);}
end;

procedure ImprimeNumero(numero:LongInt);
begin
{	write(lst,numero);}
end;

procedure reboot;ASSEMBLER;	{}
ASM
	MOV		AL,$FE
	OUT		$64,AL
END;

procedure AlarmaON(h,m:byte;dir:pointer);
begin
	GetIntVec($4a,GuardaAlarma);
	SetIntVec($4a,dir);

	h:=(h div 10)*16+h mod 10;
	m:=(m div 10)*16+m mod 10;

	ASM
		MOV			AH,6
		MOV			CH,h
		MOV			CL,m
		XOR			DH,DH
		INT			$1A
	END;
end;

procedure AlarmaOFF;
begin
	SetIntVec($4a,GuardaAlarma);

	ASM
		MOV			AH,7
		INT			$1A
	END;
end;

procedure EveryInit(mil:word;dir:pointer);
begin
	TiempoEvery:=mil*MiliSegundos;
	@RutinaEvery:=dir;

	GetIntVec(INT_TIEMPO,@AnteriorEvery);
	SetIntVec(INT_TIEMPO,@RutinaIntEvery);
end;

procedure EveryDone;
begin
	SetIntVec(INT_TIEMPO,@AnteriorEvery);
end;

procedure after(mil:word;dir:pointer);
begin
	if not PuedoAfter then exit;

	PuedoAfter:=FALSE;
	TiempoAfter:=mil*milisegundos;
	@RutinaAfter:=dir;

	GetIntVec(INT_TIEMPO,@AnteriorAfter);
	SetIntVec(INT_TIEMPO,@RutinaIntAfter);
end;

procedure NumLockON;ASSEMBLER;
ASM
	MOV			ES,SEG0040
	OR			BYTE(ES:[$17]),$20
END;

procedure NumLockOFF;ASSEMBLER;
ASM
	MOV			ES,SEG0040
	AND			BYTE(ES:[$17]),$DF
END;

procedure CapsOn;ASSEMBLER;
ASM
	MOV		ES,Seg0040
	OR		BYTE(ES:[$17]),$40
END;

procedure CapsOff;ASSEMBLER;
ASM
	MOV		ES,Seg0040
	AND		BYTE(ES:[$17]),$BF
END;

procedure LockOn;ASSEMBLER;
ASM
	MOV		ES,Seg0040
	OR		BYTE(ES:[$17]),$10
END;

procedure LockOff;ASSEMBLER;
ASM
	MOV		ES,Seg0040
	AND		BYTE(ES:[$17]),$EF
END;

function PorCiento(num:LongInt;tanto:integer):integer;
begin
	PorCiento:=(tanto*num) div 100;
end;

procedure EnableIRQ(i:byte);
begin
	if i<8 then
		port[$21]:=port[$21] and (not (1 shl i))
	else
		begin
			port[$a1]:=port[$a1] and (not (1 shl (i-8)));
			port[$21]:=port[$21] and (not (1 shl 2));
		end;
end;

procedure DisableIRQ(i:byte);
begin
	if i<8 then
		port[$21]:=port[$21] or (1 shl i)
	else
		port[$a1]:=port[$a1] or (1 shl (i-8));
end;

(*procedure IncPtr(p:pointer;num:LongInt);ASSEMBLER;
ASM
	PUSH		DS
	LDS			SI,p

	MOV			AX,WORD(num)
	ADD			[SI],AX
	JNC			@SIGUE
	ADD			WORD([SI+2]),$1000

@SIGUE:
	MOV			AX,WORD(num+2)
	SHL			AX,12   {*$1000}
	ADD			[SI+2],AX

	POP			DS
END;

procedure DecPtr(p:pointer;num:LongInt);ASSEMBLER;
ASM
	PUSH		DS

	LDS			SI,p
	MOV			AX,WORD(num)
	SUB			[SI],AX
	JNC			@SIGUE
	SUB			WORD([SI+2]),$1000

@SIGUE:
	MOV			AX,WORD(num+2)
	SHL			AX,12  {*$1000}
	SUB			[SI+2],AX

	POP			DS
END;

procedure WritePtr(p:pointer;o:word;dato:byte);ASSEMBLER;
ASM
	LES			DI,p
	MOV			AL,dato
	MOV			BX,o
	MOV			ES:[DI+BX],AL
END;

function ReadPtr(p:pointer;o:word):byte;ASSEMBLER;
ASM
	LES			DI,p
	MOV			BX,o
	MOV			AL,ES:[DI+BX]
END;*)

function GetCDROM(var unidad:char):boolean;ASSEMBLER;
var
	err:boolean;

ASM
	MOV			err,FALSE

	MOV			AX,$1500
	MOV			BX,0
	MOV 		CX,0
	INT			$2F
	CMP			BX,0
	JZ			@ERROR

	MOV			err,TRUE

	MOV			AX,$150D
	INT			$2F

	MOV			AL,'A'
	ADD			AL,CL
	LES			BX,unidad
	MOV			ES:[BX],AL

@ERROR:
	MOV			AL,err
END;

function md(var dir:string):byte;
var
	a,b,n,m:integer;

begin
	md:=0;
	m:=0;
	if dir[length(dir)]='\' then dec(dir[0]);

	for n:=1 to length(dir) do
		if dir[n]='\' then
			begin
				inc(m);
				if m=2 then a:=n;
			end;

	if m>=2 then
		begin
			repeat
				MkDir(copy(dir,1,a-1));
				b:=IOResult;
				md:=b;
				if (b>0) and (b<>DIRECTORIO_EXISTE) then exit;

				repeat
					inc(a);
				until (dir[a]='\') or (a>length(dir));

			until a>length(dir);

			if dir[a-1]='\' then dec(dir[0]);

			Mkdir(copy(dir,1,a-1));
			b:=IOResult;
			md:=b;
			if (b>0) and (b<>DIRECTORIO_EXISTE) then
				exit
			else
				md:=0;

		end
	else
		begin
			MkDir(dir);
			b:=IOResult;
			md:=b;
			if (b>0) and (b<>DIRECTORIO_EXISTE) then
				exit
			else
				md:=0;
		end;
end;

procedure SetTimer(n:word);ASSEMBLER;
ASM
	CLI
	MOV		BX,n

	MOV		AL,00110100b
	OUT		$43,AL
	JMP		@1

@1:
	MOV		AL,BL
	OUT		$40,AL
	JMP		@2

@2:
	MOV		AL,BH
	OUT		$40,AL
	JMP		@3

@3:
	STI
END;

procedure TimerTicks(n:word);
var
	divisor:word;

begin
	divisor:=LongInt(1193181 div n);
	SetTimer(divisor);
end;

procedure NormalTimer;ASSEMBLER;
ASM
	MOV			AL,$34
	OUT			$43,AL

	MOV			AL,0
	OUT			$40,AL
	OUT			$40,AL
END;

function GetTimer:word;ASSEMBLER;
ASM
	MOV			AL,0
	OUT			$43,AL

	IN			AL,$40
	MOV			AH,AL
	IN			AL,$40
	XCHG		AH,AL
	NEG			AX
END;

function PtrToLinear(p:pointer):LongInt;
begin
	 PtrToLinear:=LongInt(seg(p^)) shl 4+ofs(p^);
end;

procedure delay(decimas:word);ASSEMBLER;
ASM
	MOV		CX,decimas
	ADD		CX,CX

@BUCLE:
	HLT
	LOOP	@BUCLE
END;

function rnd(n:word):word;ASSEMBLER;
ASM
	MOV			AX,random
	XOR			AX,$AA55
	ADD			AX,AX
	ADC			AX,$118
	MOV			random,AX

	CMP			AX,n
	JB			@SIGUE
	AND			AX,n

@SIGUE:
END;

function InProtectedMode:boolean;ASSEMBLER;
ASM
	SMSW    AX
	AND     AX,1
END;

function SegmentCodeToWrite:word;ASSEMBLER;
ASM
	MOV		AX,CS
	ADD		AX,SelectorInc
END;

function FindShl(n:integer):integer;
var
	a:integer;

begin
	FindShl:=-1;
	for a:=1 to 16 do
		if 1 shl a=n then
			begin
				FindShl:=a;
				exit;
			end;
end;

begin
	randomize;
	random:=system.random(65535);

{$IFDEF __BPPROT__}
	Seg0000:=seg(ConvertPtr(ptr(Seg0000,0))^);
	SegC000:=seg(ConvertPtr(ptr(SegC000,0))^);
{$ENDIF}
end.