unit ModeX;

INTERFACE

uses colors
{$IFDEF _SYNCRO_}
	,MyMidas
{$ENDIF}
;

const
	MAXX=320;MAXY=512;

	XMAX:word=319;YMAX:word=199;
	CENTERX:word=160;CENTERY:word=100;

	INPUT_1=$3DA;

	SC_INDEX=$3C4;
	GC_INDEX=$3CE;
	CC_INDEX=$3D4;

	GC_READ_MAP=2;
	SC_READ_MAP=4;

	LATCHES_ON=8;
	LATCHES_OFF=$FF08;

	ALL_PLANES_ON=$F02;
	ALL_PLANES_OFF=$F;

	PLANO_UNO=1;
	PLANO_DOS=2;
	PLANO_TRES=4;
	PLANO_CUATRO=8;
	ALL_PLANES=$F;

	START_DISP_HI=$C;
	START_DISP_LO=$D;

	BACK_PAGE=2;

	MAX_VERTICES=50;

type
	ClipRegion=record
		xul,yul,xlr,ylr:integer;
	end;

	Twrite=(_COPY_,_AND_,_OR_,_XOR_);

	Tres=(X320x50,X320x60,X320x100,X320x120,X320x128,
				X320x200,X320x240,X320x256,X320x400,X320x480,X320x512);

	Tmode=(	NOP,
					COPY_CLEAR,
					COPY_BACK);

	Txy=record
		x,y:integer;
	end;
	Tpoligono=array[0..MAX_VERTICES] of Txy;

const
	region:ClipRegion=(xul:0;yul:0;xlr:319;ylr:199);

	plano:array[0..7] of byte=
		(GC_READ_MAP,PLANO_UNO,
		 GC_READ_MAP,PLANO_DOS,
		 GC_READ_MAP,PLANO_TRES,
		 GC_READ_MAP,PLANO_CUATRO);

var
	MultBy80:array[0..MAXY] of word;
	desplazamiento:array[0..16] of word;
	PageSize:word;
	ModoActual:Tmode;
	PaginaActiva,PaginaVisible:integer;

	vRAM:^byte;

function init(modo:Tmode;r:Tres):boolean;
{Inicializa el ModoX como:
COPIA=Todo se mueve sobre el fondo de la pgina BACK_PAGE
BORRA=Todo se mueve sobre fondo negro, ms rpido
NADA=Ni borra ni copia, para rutinas que llenan compltamente la pantalla}

procedure done;
{Acaba el ModoX}

procedure ClearPage(color:byte;pagina:integer);
{Borra la pantalla activa con el color en PA pgina}

procedure plot(x,y:integer;color:byte);
{Pinta un punto en XY con color}

function 	test(x,y:integer):byte;
{Devuelve el color del punto que hay en XY}

procedure DrawH(x1,y1,x2:integer;color:byte);
{Dibuja una lnea horizontal de x1 a x2 en la fila y1 con color}

procedure DrawV(x1,y1,y2:integer;color:byte);
{Dibuja una lnea vertical de y1 a y2 en la columna x1 con color}

procedure rectangle(Xpos1,Ypos1,Xpos2,Ypos2,color:integer);
{Dibuja un rectngulo relleno de color, desde X1Y1 a X2Y2}

procedure draw(x1,y1,x2,y2:integer;color:byte);
{Dibuja una lnea de x1y1 a x2y2 con color}

procedure SetActivePage(n:integer);
{Indica cual ser la pgina activa}

function GetActivePage:integer;
{Devuelve la pgina activa}

procedure SetDisplayPage(n:integer);
{Indica cual ser la pgina a visualizar}

function GetDisplayPage:integer;
{Devuelve cual es la pgina a visualizar}

procedure scroll(x,y:integer);
{Hace un desplazamiento de XY}

procedure poligono(vertices:integer;var poligono:Tpoligono;color:byte);
{Pinta un polgono de VERTICES caras con el tipo Tpoligono y color}

procedure triangulo(x1,y1,x2,y2,x3,y3:integer;color:byte);

procedure CopyPage(SourcePage,DestPage:integer);
{Copia la pgina fuente a la destino}

procedure anima;
{Intercambia las pginas activa y visible, a este procedimiento hay que
llamarlo contnuamente despus de pintar todo}

function clip(var x1,y1,x2,y2:integer):boolean;
{Hace un clipping de x1,y1 y x2,y2}

procedure SetPlanes(n:byte);
{Activa los planos que se quieren}

procedure box(x1,y1,x2,y2:integer;color:byte);
{Pinta una caja de X1Y1 a X2Y2 con COLOR}

procedure SetWriteMode(n:Twrite);
{Establece el modo de escritura copy/and/or/xor}

procedure OutTextXY(x:integer;y:integer;color,fondo:byte;cadena:string);
{Escribe la cadena en XY con color y fondo}

procedure OutNumXY(x,y:integer;color,fondo:byte;num:LongInt);
{Escribe el nmero en XY con color y fondo}

procedure print(x,y:integer;color,fondo:byte;cadena:string;num:LongInt);

procedure BigOutTextXY(x,y:integer;color,fondo:byte;cadena:string);
{Escribe la cadena CADENA en las coordenadas XY
con el color COLOR fondo FONDO, pero con puntos ms gordos}

procedure SplitScreen(ad:word);

procedure FillEllipse(x,y,rx,ry,color:integer);
{hace una elipse en x MAX 128 y MAX 50 con radios rx,xy y color}

procedure SetAddress(ad:word);
{Le indica a la VGA, donde a de empezar la visualizacin de la memoria}

function LoadPCX(n:string;pagina:integer;var c:Tpal):boolean;
{Carga un PCX como fondo, si FALSE, error de fichero y devuelve en p
los colores del PCX}

procedure SetLineCompare(l:word);
procedure PresetRowScan(s:byte);

function VGAExist:boolean;

procedure frame;
INLINE(

{$IFDEF _SYNCRO_}

	$66/$A1/frames/     {			MOV	EAX,frames}
	$66/$3B/$06/frames/ {@1:	CMP	frames,EAX}
	$74/$F9);						{			JZ	@1}

{$ELSE}

	$BA/$DA/$03/	{			MOV 	DX,$3DA}
	$EC/   				{@1:	IN 		AL,DX}
	$A8/$08/			{			TEST 	AL,8}
	$75/$FB/			{			JZ		@1}

	$EC/   				{@2:	IN 		AL,DX}
	$A8/$08/			{			TEST 	AL,8}
	$74/$FB);			{			JZ		@2}

{$ENDIF}

{Espera un barrido de pantalla}

procedure WaitVR;
procedure WaitDE;

IMPLEMENTATION

uses
	OP386,
	{$IFDEF _LZ_}
	LzFiles;
	{$ELSE}
	files;
	{$ENDIF}

var
	pv:integer;

procedure derecha;ASSEMBLER;
ASM
	DB	1,3,7,15
END;

procedure izquierda;ASSEMBLER;
ASM
	DB	15,14,12,8
END;

function init(modo:Tmode;r:Tres):boolean;

	procedure SetVGAModeX;
begin
	ASM
		MOV			AX,$13
		INT			$10

		MOV     DX,SC_INDEX
		MOV     AX,$604
		OUT     DX,AX

		MOV     DX,CC_INDEX
		MOV     AX,$E317
		OUT     DX,AX

		MOV     AX,$14
		OUT     DX,AX

		MOV			ES,WORD(vRAM+2)
		MOV			CX,64000/2
		XOR			DI,DI
		MOV			AX,DI
		REP			STOSW
	END;

	PaginaActiva:=0;
	PaginaVisible:=1;
end;

	procedure Enable240Lines;FORWARD;
	procedure Enable256Lines;FORWARD;

	procedure Enable50Lines;
var
	n:integer;

begin
	YMAX:=49;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 15 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;

	ASM
		MOV 		DX,CC_INDEX
		MOV 		AL,9
		MOV 		AH,11000011b
		OUT 		DX,AX
	END;
end;

	procedure Enable60Lines;
var
	n:integer;

begin
	Enable240Lines;

	YMAX:=59;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 12 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;

	ASM
		MOV 		DX,CC_INDEX
		MOV 		AL,9
		MOV 		AH,11000011b
		OUT 		DX,AX
	END;
end;

	procedure Enable100Lines;
var
	n:integer;

begin
	YMAX:=99;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 7 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;

	ASM
		MOV 		DX,CC_INDEX
		MOV 		AL,9
		MOV 		AH,11000001b
		OUT			DX,AX
	END;
end;

	procedure Enable120Lines;
var
	n:integer;

begin
	Enable240Lines;

	YMAX:=119;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 5 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;

	ASM
		MOV 		DX,CC_INDEX
		MOV 		AL,9
		MOV 		AH,11000001b
		OUT 		DX,AX
	END;
end;

	procedure Enable128Lines;
var
	n:integer;

begin
	Enable256Lines;

	YMAX:=127;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 5 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;

	ASM
		MOV 		DX,CC_INDEX
		MOV 		AL,9
		MOV 		AH,11000001b
		OUT 		DX,AX
	END;
end;

	procedure Enable200Lines;
var
	n:integer;

begin
	YMAX:=199;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 3 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;
end;

	procedure Enable240Lines;
var
	n:integer;

begin
	ASM
		MOV			DX,$3C2
		MOV			AL,$E3

		MOV			DX,CC_INDEX
		MOV			AX,$2C11
		OUT			DX,AX

		MOV			AX,$D06
		OUT			DX,AX

		MOV			AX,$3E07
		OUT			DX,AX

		MOV			AX,$EA10
		OUT			DX,AX

		MOV			AX,$AC11
		OUT			DX,AX

		MOV			AX,$DF12
		OUT			DX,AX

		MOV			AX,$E715
		OUT			DX,AX

		MOV			AX,$616
		OUT			DX,AX
	END;

	YMAX:=239;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 2 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;
end;

	procedure Enable256Lines;
const
	RegSet:array[0..20] of byte=($e3,4,6,$11,0,6,$20,7,$3e,$10,$ff,$12,$fe,$15,
															 $ff,$16,$10,$14,0,$17,$e3);

var
	n:integer;

begin
	ASM
		LEA			SI,RegSet
		MOV			DX,$3C2
		OUTSB
		INC			DL
		INC			DL
		OUTSW

		MOV			CX,9
		MOV			DL,$D4
		REP			OUTSW
	END;

	YMAX:=255;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 2 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;
end;

	procedure Enable400Lines;
var
	n:integer;

begin
	YMAX:=399;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	for n:=0 to 1 do desplazamiento[n]:=PageSize*n;

	PaginaActiva:=0;
	PaginaVisible:=1;

	ASM
		MOV 		DX,CC_INDEX
		MOV 		AL,9
		MOV 		AH,01000000b
		OUT 		DX,AX
	END;
end;

	procedure Enable480Lines;
begin
	Enable240Lines;

	YMAX:=479;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	desplazamiento[0]:=0;
	desplazamiento[1]:=0;

	PaginaActiva:=0;
	PaginaVisible:=0;

	ASM
		MOV 		DX,CC_INDEX
		MOV 		AL,9
		MOV 		AH,01000000b
		OUT 		DX,AX
	END;
end;

	procedure Enable512Lines;
begin
	Enable256Lines;

	YMAX:=511;
	CENTERY:=(YMAX+1) div 2;
	region.ylr:=YMAX;

	PageSize:=(YMAX+1)*80;
	desplazamiento[0]:=0;
	desplazamiento[1]:=0;

	PaginaActiva:=0;
	PaginaVisible:=0;

	ASM
		MOV 		DX,CC_INDEX
		MOV 		AL,9
		MOV 		AH,01000000b
		OUT 		DX,AX
	END;
end;

begin
	init:=FALSE;
	if not VGAExist then exit;

	{$IFDEF _SYNCRO_}
	StopScreenSyncro;
	{$ENDIF}

	SetVGAModeX;

	case r of
		X320x50:Enable50Lines;
		X320x60:Enable60Lines;
		X320x100:Enable100Lines;
		X320x120:Enable120Lines;
		X320x128:Enable128Lines;
		X320x200:Enable200Lines;
		X320x240:Enable240Lines;
		X320x256:Enable256Lines;
		X320x400:Enable400Lines;
		X320x480:Enable480Lines;
		X320x512:Enable512Lines;
	end;

	{$IFDEF _SYNCRO_}
	SetScreenSyncro(GetScreenSyncro);
	{$ENDIF}

	SetActivePage(PaginaActiva);
	SetDisplayPage(PaginaVisible);

	ModoActual:=modo;
	init:=TRUE;
end;

procedure done;ASSEMBLER;
ASM
	MOV		AX,3
	INT		$10
END;

procedure anima;
var
	temp:LongInt;

begin
	PaginaVisible:=PaginaVisible xor 1;

	{$IFNDEF _SYNCRO_}
	PaginaActiva:=PaginaActiva xor 1;

	WaitDE;
	SetDisplayPage(PaginaVisible);

	WaitVR;
	SetActivePage(PaginaActiva);

	{$ELSE}

	temp:=frames;
	while frames=temp do;

	PaginaActiva:=PaginaActiva xor 1;
	SetActivePage(PaginaActiva);
	{$ENDIF}

	case ModoActual of
		COPY_BACK:CopyPage(BACK_PAGE,PaginaActiva);
		COPY_CLEAR:ClearPage(0,PaginaActiva);
	end;
end;

function test(x,y:integer):byte;ASSEMBLER;
ASM
	LES			DI,vRAM

	MOV			BX,y
	ADD			BX,BX  {Y*2}
	ADD			DI,WORD(MultBy80[BX])

	MOV			BX,x
	MOV			CX,BX
	SHR			CX,2   {X/4}
	ADD			DI,CX

	MOV			DX,GC_INDEX
	AND			BX,3
	ADD			BX,BX
	MOV			AH,BYTE(plano[BX])
	MOV			AL,SC_READ_MAP
	OUT			DX,AX

	MOV			AL,ES:[DI]
END;

procedure plot(x,y:integer;color:byte);ASSEMBLER;
ASM
	LES			DI,vRAM

	MOV			BX,y
	CMP			BX,YMAX
	JA			@SALIR

	ADD			BX,BX  {Y*2}
	ADD			DI,WORD(MultBy80[BX])

	MOV			BX,x
	CMP			BX,XMAX
	JA			@SALIR

	MOV			CX,BX
	SHR			CX,2   {X/4}
	ADD			DI,CX

	MOV			DX,SC_INDEX
	AND			BX,3
	ADD			BX,BX
	MOV			AX,WORD(plano[BX])
	OUT			DX,AX

	MOV			AL,color
	MOV			ES:[DI],AL

@SALIR:
END;

procedure SetActivePage(n:integer);ASSEMBLER;
ASM
	MOV			BX,n
	ADD			BX,BX
	MOV     AX,WORD(desplazamiento[BX])
	MOV			WORD(vRAM),AX
END;

function GetActivePage:integer;
begin
	GetActivePage:=ofs(vRAM^) div PageSize;
end;

procedure SetDisplayPage(n:integer);ASSEMBLER;
ASM
	MOV			BX,n
	MOV			pv,BX

	ADD			BX,BX
	MOV			CX,WORD(desplazamiento[BX])

	MOV     DX,CC_INDEX
	MOV     AL,START_DISP_LO
	MOV     AH,CL
	OUT     DX,AX

	MOV			AL,START_DISP_HI
	MOV     AH,CH
	OUT     DX,AX

END;

function GetDisplayPage:integer;
begin
	GetDisplayPage:=pv;
end;

procedure CopyPage(SourcePage,DestPage:integer);ASSEMBLER;
ASM
	CLD
	PUSH		DS

	MOV			SI,SourcePage
	ADD			SI,SI
	MOV			SI,WORD(desplazamiento[SI])

	MOV			DI,DestPage
	ADD			DI,DI
	MOV			DI,WORD(desplazamiento[DI])

	MOV			CX,PageSize

	MOV			AX,WORD(vRAM+2)	{}
	MOV			ES,AX
	MOV			DS,AX

	MOV			DX,GC_INDEX
	MOV			AX,LATCHES_ON
	OUT			DX,AX

	MOV			DX,SC_INDEX
	MOV			AX,ALL_PLANES_ON
	OUT			DX,AX

	REP     MOVSB

	MOV			DX,GC_INDEX
	MOV			AX,LATCHES_OFF
	OUT			DX,AX

	POP			DS
END;

procedure ClearPage(color:byte;pagina:integer);ASSEMBLER;
ASM
	CLD
	MOV			ES,WORD(vRAM+2)

	MOV			DI,pagina
	ADD			DI,DI
	MOV			DI,WORD(desplazamiento[DI])

	MOV			CX,PageSize
	{$IFNDEF CUTRE_VGA}
	SHR			CX,2
	{$ELSE}
	SHR			CX,1
	{$ENDIF}

	MOV			DX,SC_INDEX
	MOV			AX,ALL_PLANES_ON
	OUT			DX,AX

	MOV			AL,color
	MOV			AH,AL
	{$IFNDEF CUTRE_VGA}
	MOV			BX,AX
	DB			_386;SHL	AX,16
	ADD			AX,BX

	REP;		DB _386;STOSW	{REP STOSD}
	{$ELSE}
	REP			STOSW
	{$ENDIF}
END;

procedure scroll(x,y:integer);ASSEMBLER;
ASM
	MOV			AX,x
	MOV			BX,y

	MOV			CX,8	{}
	DIV			CL

	MOV			CL,AH
	XOR			AH,AH
	XCHG		AX,BX

	MOV			SI,AX
	ADD			SI,SI
	MOV			AX,WORD(MultBy80[SI])

	ADD			BX,AX

	SUB			DL,6
	MOV			AH,BH
	MOV			AL,$C
	OUT			DX,AX

	MOV			AH,BL
	INC			AL
	OUT			DX,AX

	ADD			DL,6

@3:
	IN			AL,DX
	TEST		AL,8
	JZ			@3

	SUB			DL,6
	MOV			AH,CH
	MOV			AL,8
	OUT			DX,AX

	MOV			DL,$C0
	MOV			AL,$13 OR $20
	OUT			DX,AL

	MOV			AL,CL
	OUT			DX,AL
END;

procedure DrawH(x1,y1,x2:integer;color:byte);ASSEMBLER;
ASM
	CLD
	LES			DI,vRAM

	MOV			BX,y1					{if y1>region.ylr then goto salir}
	CMP			BX,region.ylr
	JG			@SALIR

	CMP			BX,region.yul
	JL			@SALIR				{if y1<region.yul then goto salir}

	ADD			BX,BX
	ADD			DI,WORD(MultBy80[BX])	{*80}

	MOV			DX,x1
	MOV			CX,x2

	CMP			DX,CX
	JL			@MENOR
	XCHG		DX,CX			{if x1>x2 swap(x1,x2)}

@MENOR:
	MOV			AX,region.xul
	MOV			BX,region.xlr

	CMP			DX,BX     {if x1>region.xlr then goto salir}
	JG			@SALIR

	CMP			DX,AX     {if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE1
	MOV			DX,AX

@SIGUE1:
	CMP			CX,AX     {if x2<region.xul then goto salir}
	JL			@SALIR

	CMP			CX,BX   	{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE2
	MOV			CX,BX

@SIGUE2:
	MOV			BX,DX
	AND			BX,3
	MOV			AH,BYTE(CS:izquierda[BX])

	MOV			BX,CX
	AND			BX,3
	MOV			AL,BYTE(CS:derecha[BX])

	SHR			DX,2			{x1:=x1 div 4}
	ADD			DI,DX			{inc(DirPant,x1)}

	SHR			CX,2			{x2:=x2 div 4}
	SUB			CX,DX			{dec(x2,x1)}
	JG			@MAYOR
	AND			AH,AL

@MAYOR:
	MOV			BH,AL

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	OUT			DX,AX
	INC			DX

	MOV			AH,color	{AH=color}
	MOV			AL,AH

	STOSB             {Pinta extremo izquierdo}
	JCXZ		@SALIR		{if longitud=0 salir}

	DEC			CX
	JCXZ		@DERECHA	{Slo parte derecha}
	MOV			AL,ALL_PLANES
	OUT			DX,AL

	MOV			AL,AH
	{$IFNDEF CUTRE_VGA}
	MOV			SI,AX
	DB			_386;SHL AX,16
	ADD			AX,SI

	MOV			SI,CX
	AND			SI,3
	SHR			CX,2
	REP;		DB _386;	STOSW     {{Pinta parte del centro [REP STOSD]}
	MOV			CX,SI
	{$ENDIF}
	SHR			CX,1
	REP			STOSW
	ADC			CX,CX
	REP			STOSB

@DERECHA:
	MOV			AL,BH
	OUT			DX,AL

	MOV			ES:[DI],AH {Pinta extremo izquierdo}

@SALIR:
END;

procedure DrawV(x1,y1,y2:integer;color:byte);ASSEMBLER;
ASM
	CLD
	MOV			DI,WORD(vRAM)

	MOV			BX,y1
	MOV			CX,y2
	CMP			BX,CX     {if y1>y2 then swap(y1,y2)}
	JL			@SIGUE
	XCHG		BX,CX

@SIGUE:
	MOV			AX,region.yul
	MOV			DX,region.ylr

	CMP			BX,DX   	{if y1>region.ylr then goto salir}
	JG			@SALIR

	CMP			BX,AX			{if y1<region.yul then y1:=region.yul}
	JGE			@SIGUE1
	MOV			BX,AX

@SIGUE1:
	CMP			CX,DX   	{if y2>region.ylr then y2:=region.ylr}
	JLE			@SIGUE2
	MOV			CX,DX

@SIGUE2:
	CMP			CX,AX
	JL			@SALIR		{if y2<region.yul then goto salir}

	ADD			BX,BX
	ADD			DI,WORD(MultBy80[BX])	{y:=y*80}

	MOV			AX,x1

	CMP			AX,region.xlr
	JG			@SALIR		{if x1>region.xlr then goto salir}

	CMP			AX,region.xul
	JL			@SALIR		{if x1<region.xul the goto salir}

	MOV			SI,AX
	SHR			AX,2
	ADD			DI,AX      {dir:=(y*80)+(x/4)}
	SHR			BX,1
	SUB			CX,BX      {CX=y1-y2}

	MOV			DX,SC_INDEX
	AND			SI,3
	ADD			SI,SI
	MOV			AX,WORD(plano[SI])
	OUT			DX,AX

	PUSH		DS
	MOV			DS,WORD(vRAM+2)
	MOV			AL,color
	MOV			BX,80

@BUCLE:
	MOV			[DI],AL
	ADD			DI,BX
	DEC			CX
	JNZ			@BUCLE

	POP			DS

@SALIR:
END;

procedure rectangle(Xpos1,Ypos1,Xpos2,Ypos2,color:integer);
var
	n:integer;

begin
	for n:=Ypos1 to Ypos2 do DrawH(Xpos1,n,Xpos2,color);
end;

const
	TOPE=MAXY;

var
	my,mxy:integer;
	Xi,Xd:array[-TOPE..TOPE] of word;

procedure poligono(vertices:integer;var poligono:Tpoligono;color:byte);ASSEMBLER;
ASM
	CLD
	PUSH		BP

	MOV			AL,color
	MOV			BYTE(@COLORIN+1),AL

	MOV			SI,WORD(poligono)
	MOV			AX,WORD(poligono+2)       {GS:SI=@poligono[0]}
	DW			MOV_GS_AX

	DB			GS;MOV			DX,[SI+4]  		{DX=poligono[1].x}
	DB			GS;MOV			DI,[SI+6]  		{DI=poligono[1].y}
	ADD			SI,8                      {GS:SI=@poligono[2]}

	MOV			AX,DI                     {AX=my}
	MOV			BX,DI                     {BX=mxy=my}

	MOV			CX,vertices
	MOV			WORD(@VERT+1),CX
	DEC			CX                        {for i:=2 to vertices do}

@BUCLE00:
	DB			GS;MOV			BP,Tpoligono[SI].Txy.y

	CMP			BP,AX		{if poligono[i].y<my my:=poligono[i].y}
	JGE			@SIGUE_Y
	MOV			AX,BP

@SIGUE_Y:
	CMP			BP,BX 	{if poligono[i].y>mxy mxy:=poligono[i].y}
	JLE			@SIGUE_X
	MOV			BX,BP

@SIGUE_X:
	ADD			SI,4
	DEC			CX
	JNZ			@BUCLE00

	DB			GS;MOV			Tpoligono[SI].Txy.x,DX	{poligono[vertices+1].x:=poligono[1].x;}
	DB			GS;MOV			Tpoligono[SI].Txy.y,DI	{poligono[vertices+1].y:=poligono[1].y;}

	MOV			CX,region.yul
	MOV			DX,region.ylr

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JG			@FINAL				{if my>region.ylr then goto final}

	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JE			@FINAL        {if mx=mxy then goto final}

	MOV     my,AX
	MOV			mxy,BX

{---------------------------------------------------------------------------}
@VERT:
	MOV			CX,0    			{for i:=vertices DownTo 1 do}
	SUB			SI,4					{GS:SI=@poligono[i];}

	MOV			AX,DS
	MOV			ES,AX

@COM:
		PUSH		CX

		DB			GS;MOV			DI,Tpoligono[SI].Txy.y		{y2=poligono[i].y}
		CMP			DI,TOPE
		JG			@MAYOR11

		CMP			DI,-TOPE
		JG			@SIGUE11
		MOV			DI,-TOPE+1
		JMP			@SIGUE11

@MAYOR11:
		MOV			DI,TOPE-1

@SIGUE11:
		MOV			DX,DI       {Guardo y1}

		DB			GS;MOV			BX,Tpoligono[SI+4].Txy.y	{y1=poligono[i+1].y}
		CMP			BX,TOPE
		JG			@MAYOR22

		CMP			BX,-TOPE
		JG			@SIGUE22
		MOV			BX,-TOPE+1
		JMP			@SIGUE22

@MAYOR22:
		MOV			BX,TOPE-1   {BX=m2}

@SIGUE22:
		DB			GS;MOV			AX,Tpoligono[SI].Txy.x		{x1:=poligono[i].x;}
		DB			GS;MOV			BP,Tpoligono[SI+4].Txy.x 	{x2:=poligono[i+1].x;}

		SUB			DI,BX							{a:=y2-y1;}
		DD			MOVSX_ECX_DI

		JZ			@FIN_BUCLE				{if a=0 then continue}
		JL			@A_MENOR          {if a<0 then goto a_menor}

		LEA			DI,Xi+(TOPE*2) 		{ES:DI=@xi[0]}
		ADD			BX,BX
		ADD			DI,BX
		JMP			@A_SIGUE

@A_MENOR:
		SUB			BX,DX             {a:=y1-y2}
		DD			MOVSX_ECX_BX

		LEA			DI,Xd+(TOPE*2)  	{ES:DI=@xd[0]}
		ADD			DX,DX             {Recupero y1}
		ADD			DI,DX

		XCHG		AX,BP             {swap(x1,x2)}

@A_SIGUE:
			INC			CX

			DB			$66,$81,$C5,$0,0,0,$80{ADD EBP,$80000000}
			SUB			AX,BP
			INC			AX
			DB			_386;SHL		AX,16    	{incr:=(c2-c1)+1 shl 16;}
			DW			CDQ
			DB			_386;IDIV		CX      	{incr:=incr div p;}

			DB			_386;ROL		AX,16     {Intercambia EAX}
			DB			_386;XCHG		AX,BP

			{$IFNDEF precision}
			CLC
			{$ENDIF}
@BUCLE:            									{for n:=1 to p+1 do}
			STOSW
			{$IFNDEF precision}
			DB			_386;ADC		AX,BP   	{inc(acum,incr);}
			{$ELSE}
			DB			_386;ADD		AX,BP
			ADC			AX,0
			{$ENDIF}
			DEC			CX
			JNZ			@BUCLE

@FIN_BUCLE:
		POP			CX

		SUB			SI,4
		DEC			CX
		JNZ			@COM

{---------------------------------------------------------------------------}
	MOV			AX,region.xul
	MOV			WORD(@R1+1),AX

	MOV			AX,region.xlr
	MOV			WORD(@R2+1),AX

	MOV			BX,my

	LES			DI,vRAM
	MOV			BP,BX                  {BP=my}
	ADD			BP,BP
	ADD			DI,WORD(DS:MultBy80[BP]) {DirPant:=my*80}

	LEA			SI,Xi+(TOPE*2)
	ADD			SI,BP                	{GS:SI=@Xid[my]}

	MOV			BP,DI									{BP=DirPant}

	MOV			AX,mxy
	SUB			AX,BX                 {for n:=(mxy-my)+1 DownTo 0 do}
	MOV			BX,AX
	INC			BX

@BUCLE_P:
	LODSW          								{DX=xi[n]}
	MOV			CX,[SI+(TOPE*4)]    	{CX=xd[n]}

	CMP			AX,CX
	JLE			@SIGUE
	XCHG		AX,CX                 {if x1>x2 swap(x1,x2)}

@SIGUE:
	PUSH		BX   {Guardo y1}

{----------------------------------------------------------------------------}
@R1:
	MOV			DX,0

@R2:
	MOV			BX,0

	CMP			AX,BX     {if x1>region.xlr then goto salir}
	JG			@SALIR

	CMP			CX,DX     {if x2<region.xul then goto salir}
	JL			@SALIR

	CMP			AX,DX     {if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			AX,DX

@SIGUE10:
	CMP			CX,BX   	{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE20
	MOV			CX,BX

@SIGUE20:
	MOV			BX,AX
	SHR			AX,2			{x1:=x1 div 4;}
	AND			BX,3
	MOV			DL,BYTE(CS:izquierda[BX])

	MOV			BX,CX
	SHR			CX,2			{x2:=x2 div 4;}
	AND			BX,3
	MOV			BH,BYTE(CS:derecha[BX])
	MOV			BYTE(@DERECHA+1),BH

	MOV			DI,BP
	ADD			DI,AX			{inc(DirPant,x1);}

	SUB			CX,AX			{dec(x2,x1)}
	JNZ			@NO_COMBINA
	AND			DL,BH     {Combina mscaras izquierda y derecha}

@NO_COMBINA:
	MOV			AH,DL

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	OUT			DX,AX
	INC			DL

@COLORIN:
	MOV			AL,0
	STOSB             {Pinta extremo izquierdo}
	JCXZ		@SALIR		{if longitud=0 then goto salir}

	MOV			AH,AL
	DEC			CX
	JCXZ		@DERECHA	{Slo parte derecha}

	MOV			AL,ALL_PLANES
	OUT			DX,AL

	MOV			AL,AH
	{$IFNDEF CUTRE_VGA}
	MOV			BX,AX
	DB			_386;SHL AX,16
	ADD			AX,BX

	MOV			BX,CX
	AND			BX,3
	SHR			CX,2
	REP;		DB _386;STOSW     {Pinta parte del centro [REP STOSD]}
	MOV			CX,BX
	{$ENDIF}
	SHR			CX,1
	REP			STOSW
	ADC			CX,CX
	REP			STOSB

@DERECHA:
	MOV			AL,0
	OUT			DX,AL

	MOV			ES:[DI],AH 	{Pinta extremo derecho}

@SALIR:
{----------------------------------------------------------------------------}
	ADD			BP,80       {Y salto a la siguiente lnea}

	POP			BX
	DEC			BX
	JNZ			@BUCLE_P

@FINAL:
	POP			BP
END;

var
	colorin:byte;
	r1,r2:word;

procedure triangulo(x1,y1,x2,y2,x3,y3:integer;color:byte);ASSEMBLER;
ASM
	CLD
	PUSH		BP

	MOV			AL,color
	MOV			colorin,AL

{----------------------------------------------------------------------------}
	MOV			AX,y1
	CMP			AX,y2
	JLE			@SIGUE1

	MOV			BX,AX
	XCHG		BX,y2
	MOV			y1,BX

	MOV			BX,x1
	XCHG		BX,x2
	MOV			x1,BX

@SIGUE1:
	MOV			AX,y2
	CMP			AX,y3
	JLE			@SIGUE2

	MOV			BX,AX
	XCHG		BX,y3
	MOV   	y2,BX

	MOV			BX,x2
	XCHG		BX,x3
	MOV			x2,BX

@SIGUE2:
	MOV			AX,y1       {Repite}
	CMP			AX,y2
	JLE			@SIGUE3

	MOV			BX,AX
	XCHG		BX,y2
	MOV			y1,BX

	MOV			BX,x1
	XCHG		BX,x2
	MOV			x1,BX

@SIGUE3:

{----------------------------------------------------------------------------}

	MOV			CX,region.yul
	MOV			DX,region.ylr

	MOV			AX,y1
	MOV			BX,y3

	CMP			AX,CX        	{if my<region.yul then my:=region.yul;}
	JGE			@MAYOR_0
	MOV			AX,CX

@MAYOR_0:
	CMP			BX,DX					{if mxy>region.ylr then mxy:=region.ylr;}
	JLE			@MENOR_YMAX
	MOV			BX,DX

@MENOR_YMAX:
	CMP			AX,DX
	JG			@FINAL				{if my>region.ylr then goto final}

	CMP			BX,CX
	JL			@FINAL				{if mxy<region.yul then goto final}

	CMP			AX,BX
	JE			@FINAL        {if mx=mxy then goto final}

	MOV			my,AX
	MOV			mxy,BX

{---------------------------------------------------------------------------}
	PUSH		DS
	POP			ES              {ES=DS}

		MOV			DI,y3
		CMP			DI,TOPE
		JG			@MAYOR11

		CMP			DI,-TOPE    	{Cutre cdigo...}
		JG			@SIGUE11
		MOV			DI,-TOPE+1
		JMP			@SIGUE11

@MAYOR11:
		MOV			DI,TOPE-1

@SIGUE11:
		MOV			DX,DI       	{Guardo y3}

		MOV			BX,y1
		CMP			BX,TOPE
		JG			@MAYOR22

		CMP			BX,-TOPE
		JG			@SIGUE22
		MOV			BX,-TOPE+1
		JMP			@SIGUE22

@MAYOR22:
		MOV			BX,TOPE-1   	{BX=m2}

@SIGUE22:
		DB			$66,$BE;DD $80000000{MOV ESI,$80000000}
		MOV			AX,x3
		MOV			SI,x1

		SUB			DI,BX							{a:=y1-y3;}
		DD			MOVSX_ECX_DI

		JZ			@FIN_BUCLE				{if a=0 then continue}
		JL			@A_MENOR          {if a<0 then goto a_menor}

		LEA			DI,Xi+(TOPE*2) 		{ES:DI=@xi[0]}
		ADD			BX,BX
		ADD			DI,BX
		JMP			@A_SIGUE

@A_MENOR:
		NEG			DI                {a:=-a}
		DD			MOVSX_ECX_DI

		LEA			DI,Xd+(TOPE*2)  	{ES:DI=@xd[0]}
		ADD			DX,DX             {Recupero y1}
		ADD			DI,DX

		XCHG		AX,SI             {swap(x1,x3)}

@A_SIGUE:
			INC			CX

			SUB			AX,SI
			INC			AX
			DB			_386;SHL		AX,16    	{incr:=(c2-c1)+1 shl 16;}
			DW			CDQ
			DB			_386;IDIV		CX      	{incr:=incr div p;}

			DB			_386;ROL		AX,16     {Intercambia EAX}
			DB			_386;XCHG		AX,SI

			{$IFNDEF precision}
			CLC
			{$ENDIF}

@BUCLE:            									{for n:=1 to p+1 do}
			STOSW
			{$IFNDEF precision}
			DB			_386;ADC		AX,SI   	{inc(acum,incr);}
			{$ELSE}
			DB			_386;ADD		AX,SI   	{inc(acum,incr);}
			ADC			AX,0
			{$ENDIF}
			DEC			CX
			JNZ			@BUCLE

@FIN_BUCLE:
{---------------------------------------------------------------------------}

		MOV			DI,y2
		CMP			DI,TOPE
		JG			@MAYOR33

		CMP			DI,-TOPE    	{Cutre cdigo...}
		JG			@SIGUE33
		MOV			DI,-TOPE+1
		JMP			@SIGUE33

@MAYOR33:
		MOV			DI,TOPE-1

@SIGUE33:
		MOV			DX,DI       	{Guardo y2}

		MOV			BX,y3
		CMP			BX,TOPE
		JG			@MAYOR44

		CMP			BX,-TOPE
		JG			@SIGUE44
		MOV			BX,-TOPE+1
		JMP			@SIGUE44

@MAYOR44:
		MOV			BX,TOPE-1   	{BX=m2}

@SIGUE44:
		DB			$66,$BE;DD $80000000	{MOV ESI,$80000000}
		MOV			AX,x2
		MOV			SI,x3

		SUB			DI,BX							{a:=y2-y3;}
		DD			MOVSX_ECX_DI

		JZ			@FIN_BUCLE1				{if a=0 then continue}
		JL			@A_MENOR1         {if a<0 then goto a_menor}

		LEA			DI,Xi+(TOPE*2) 		{ES:DI=@xi[0]}
		ADD			BX,BX
		ADD			DI,BX
		JMP			@A_SIGUE1

@A_MENOR1:
		NEG			DI                {a:=-a}
		DD			MOVSX_ECX_DI

		LEA			DI,Xd+(TOPE*2)  	{ES:DI=@xd[0]}
		ADD			DX,DX             {Recupero y1}
		ADD			DI,DX

		XCHG		AX,SI             {swap(x2,x3)}

@A_SIGUE1:
			INC			CX

			SUB			AX,SI
			INC			AX
			DB			_386;SHL		AX,16    	{incr:=(c2-c1)+1 shl 16;}
			DW			CDQ
			DB			_386;IDIV		CX      	{incr:=incr div p;}

			DB			_386;ROL		AX,16     {Intercambia EAX}
			DB			_386;XCHG		AX,SI

			{$IFNDEF precision}
			CLC
			{$ENDIF}

@BUCLE1:            								{for n:=1 to p+1 do}
			STOSW
			{$IFNDEF precision}
			DB			_386;ADC		AX,SI   	{inc(acum,incr);}
			{$ELSE}
			DB			_386;ADD		AX,SI   	{inc(acum,incr);}
			ADC			AX,0
			{$ENDIF}
			DEC			CX
			JNZ			@BUCLE1

@FIN_BUCLE1:
{---------------------------------------------------------------------------}
		MOV			DI,y1
		CMP			DI,TOPE
		JG			@MAYOR55

		CMP			DI,-TOPE    	{Cutre cdigo...}
		JG			@SIGUE55
		MOV			DI,-TOPE+1
		JMP			@SIGUE55

@MAYOR55:
		MOV			DI,TOPE-1

@SIGUE55:
		MOV			DX,DI       	{Guardo y1}

		MOV			BX,y2
		CMP			BX,TOPE
		JG			@MAYOR66

		CMP			BX,-TOPE
		JG			@SIGUE66
		MOV			BX,-TOPE+1
		JMP			@SIGUE66

@MAYOR66:
		MOV			BX,TOPE-1   	{BX=m2}

@SIGUE66:
		DB			$66,$BE;DD $80000000	{MOV ESI,$80000000}
		MOV			AX,x1
		MOV			SI,x2

		SUB			DI,BX							{a:=y1-y2;}
		DD			MOVSX_ECX_DI

		JZ			@FIN_BUCLE2				{if a=0 then continue}
		JL			@A_MENOR2         {if a<0 then goto a_menor}

		LEA			DI,Xi+(TOPE*2) 		{ES:DI=@xi[0]}
		ADD			BX,BX
		ADD			DI,BX
		JMP			@A_SIGUE2

@A_MENOR2:
		NEG			DI                {a:=-a}
		DD			MOVSX_ECX_DI

		LEA			DI,Xd+(TOPE*2)  	{ES:DI=@xd[0]}
		ADD			DX,DX             {Recupero y1}
		ADD			DI,DX

		XCHG		AX,SI             {swap(x1,x2)}

@A_SIGUE2:
			INC			CX

			SUB			AX,SI
			INC			AX
			DB			_386;SHL		AX,16    	{incr:=(c2-c1)+1 shl 16;}
			DW			CDQ
			DB			_386;IDIV		CX      	{incr:=incr div p;}

			DB			_386;ROL		AX,16     {Intercambia EAX}
			DB			_386;XCHG		AX,SI

			{$IFNDEF precision}
			CLC
			{$ENDIF}

@BUCLE2:            								{for n:=1 to p+1 do}
			STOSW
			{$IFNDEF precision}
			DB			_386;ADC		AX,SI  		{inc(acum,incr);}
			{$ELSE}
			DB			_386;ADD		AX,SI   	{inc(acum,incr);}
			ADC			AX,0
			{$ENDIF}
			DEC			CX
			JNZ			@BUCLE2

@FIN_BUCLE2:
{---------------------------------------------------------------------------}

	MOV			AX,region.xul
	MOV     r1,AX

	MOV			AX,region.xlr
	MOV			r2,ax

	LES			DI,vRAM
	MOV			BX,my

	MOV			BP,BX
	ADD			BP,BP
	ADD			DI,WORD(DS:MultBy80[BP])   {DirPant:=my*80}

	LEA			SI,Xi+(TOPE*2)
	ADD			SI,BP                   {GS:SI=@Xid[my]}

	MOV			BP,mxy
	SUB			BP,BX
	INC			BP                      {for n:=(mxy-my)+1 DownTo 0 do}

@BUCLE_P:
	LODSW                           {AX=xi[n]}
	MOV			CX,[SI+(TOPE*4)]    		{CX=xd[n]}

	CMP			AX,CX
	JLE			@SIGUE
	XCHG		AX,CX                   {if x1>x2 swap(x1,x2)}

@SIGUE:
	PUSH		DI   {Guardo DirPant}

{----------------------------------------------------------------------------}
	MOV			DX,r1
	MOV			BX,r2

	CMP			AX,BX     {if x1>region.xlr then goto salir}
	JG			@SALIR

	CMP			CX,DX     {if x2<region.xul then goto salir}
	JL			@SALIR

	CMP			AX,DX     {if x1<region.xul then x1:=region.xul}
	JGE			@SIGUE10
	MOV			AX,DX

@SIGUE10:
	CMP			CX,BX   	{if x2>region.xlr then x2:=region.xlr}
	JLE			@SIGUE20
	MOV			CX,BX

@SIGUE20:
	MOV			BX,AX
	SHR			AX,2			{x1:=x1 div 4;}
	AND			BX,3
	MOV			DL,BYTE(CS:izquierda[BX])

	MOV			BX,CX
	SHR			CX,2			{x2:=x2 div 4;}
	AND			BX,3
	MOV			BH,BYTE(CS:derecha[BX])
	MOV			BYTE(@DERECHA+1),BH

	ADD			DI,AX			{inc(DirPant,x1);}

	SUB			CX,AX			{dec(x2,x1)}
	JNZ			@NO_COMBINA
	AND			DL,BH     {Combina mscaras izquierda y derecha}

@NO_COMBINA:
	MOV			AH,DL

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	OUT			DX,AX
	INC			DL

	MOV			AL,colorin
	STOSB             {Pinta extremo izquierdo}
	JCXZ		@SALIR		{if longitud=0 then goto salir}

	MOV			AH,AL
	DEC			CX
	JCXZ		@DERECHA	{Slo parte derecha}

	MOV			AL,ALL_PLANES
	OUT			DX,AL

	MOV			AL,AH
	{$IFNDEF CUTRE_VGA}
	MOV			BX,AX
	DB			_386;SHL AX,16
	ADD			AX,BX

	MOV			BX,CX
	AND			BX,3
	SHR			CX,2
	REP;		DB _386;STOSW     {Pinta parte del centro [REP STOSD]}
	MOV			CX,BX
	{$ENDIF}
	SHR			CX,1
	REP			STOSW
	ADC			CX,CX
	REP			STOSB

@DERECHA:
	MOV			AL,0
	OUT			DX,AL

	MOV			ES:[DI],AH 	{Pinta extremo derecho}

@SALIR:
{----------------------------------------------------------------------------}
	POP			DI
	ADD			DI,80       {Y salto a la siguiente lnea}

	DEC			BP
	JNZ			@BUCLE_P

@FINAL:
	POP			BP
END;

function clip(var x1,y1,x2,y2:integer):boolean;ASSEMBLER;
ASM
	push	bp

	les		di,x1
	mov		bx,es:[di]

	les		di,y1
	mov		cx,es:[di]

	les		di,x2
	mov		si,es:[di]

	les		di,y2
	mov		di,es:[di]

@@doclip:
	cmp	bx,si			{is the line vertical?}
	je	@@vert

	cmp	cx,di
	je	@@horz		{or horizontal?}

{------------------------------}
	xor	al,al

	test	cx,cx
	jns	@no1
	or	al,0001b
	jmp	@dox

@no1:
	cmp	cx,200
	jl	@dox
	or	al,0010b

@dox:
	test	bx,bx
	jns	@no2
	or	al,0100b
	jmp	@no3

@no2:
	cmp	bx,320
	jl	@no3
	or	al,1000b

@no3:

{----------------------------}

	xor	ah,ah

	test di,di
	jns	@no1_
	or	ah,0001b
	jmp	@dox_

@no1_:
	cmp	di,199
	jl	@dox_
	or	ah,0010b

@dox_:
	test	si,si
	jns	@no2_
	or	ah,0100b
	jmp	@no3_

@no2_:
	cmp	si,320
	jl	@no3_
	or	ah,1000b

@no3_:
{----------------------------}

	mov	dl,al			{don't draw if the line is fully}
	and	dl,ah			{outside the screen (outcodes}
	jnz	@@outside		{have at least 1 same bit set}

	mov	dl,al
	or	dl,ah			{if both outcodes are zero, the line}
	jz	@@done			 {is completely on screen}

	test	al,al
	jnz	@@cp1
	mov	al,ah			{ swap points if point 1 doesn't need}
	xchg	bx,si		{	 clipping}
	xchg	cx,di

@@cp1:
	mov	bp,ax			{ bp = outcode for point 1}

	test	al,0001b
	jz	@@no11

	mov	ax,si			{ outcode AND 1 != 0 --> point is}
	sub	ax,bx			{ above the window}
	neg	cx
	imul	cx
	add	cx,di			{ x1 = x1 + (x2-x1) * (0-y1) / (y2-y1)}
	idiv	cx
	add	bx,ax

	xor	cx,cx			{ y1 = 0}

	jmp	@@no12


@@no11:
	test	bp,0010b
	jz	@@no12

	mov	ax,si			{ outcode AND 2 != 0 --> point is}
	sub	ax,bx			{below the window}
	mov	dx,199
	sub	dx,cx
	imul	dx
	neg	cx
	add	cx,di			{ x1 = x1 + (x2-x1) * (yMax-y1)}
	idiv	cx			{	/ (y2-y1)}
	add	bx,ax

	mov	cx,199		{ y1 = yMax}


@@no12:
	cmp	bx,si
	je	@@horz

	test	bp,0100b
	jz	@@no13

	mov	ax,di			{ outcode AND 4 != 0 --> point is}
	sub	ax,cx			{ to left of the window}
	neg	bx
	imul	bx
	add	bx,si
	idiv	bx			{y1 = y1 + (y2-y1) * (0-x1) / (x2-x1)}
	add	cx,ax

	xor	bx,bx			{x1 = 0}

	jmp	@@doclip


@@no13:
	test	bp,1000b
	jz	@@doclip

	mov	ax,di			{ outcode AND 8 != 0 --> point is}
	sub	ax,cx			{ to right of the window}
	mov	dx,319
	sub	dx,bx
	imul	dx
	neg	bx
	add	bx,si
	idiv	bx			{ y1 = y1 + (y2-y1) * (xMax-x1)}
	add	cx,ax			{	/ (x2-x1)}

	mov	bx,319		{x1 = xMax}

	jmp	@@doclip

@@outside:
	mov	ax,FALSE
	pop bp
	jmp	@@exit

@@vert:
	{ vertical line}
	cmp	cx,di
	jle	@@v1			{swap endpoints if y2<y1}
	xchg	cx,di
	xchg	bx,si

@@v1:
	test	di,di
	js	@@outside		{is the line completely outside the}
	cmp	cx,200		{ screen?}
	jge	@@outside
	cmp	bx,320		{ in X direction?}
	jae	@@outside

	cmp	di,200
	jl	@@v2
	mov	di,199

@@v2:
	test	cx,cx
	jns	@@done
	xor	cx,cx
	jmp	@@done


@@horz:
	{ horizontal line}
	cmp	bx,si
	jle	@@h1			{swap endpoints if x2<x1}

	xchg	bx,si
	xchg	cx,di

@@h1:
	test	si,si
	js	@@outside		{is the line completely outside the}
	cmp	bx,320			{ screen?}
	jge	@@outside
	cmp	cx,200		{in Y direction?}
	jae	@@outside

	cmp	si,320
	jl	@@h2
	mov	si,319

@@h2:
	test	bx,bx
	jns	@@done
	xor	bx,bx


@@done:
	pop		bp

	mov		ax,di

	les		di,x1
	mov		es:[di],bx

	les		di,y1
	mov		es:[di],cx

	les		di,x2
	mov		es:[di],si

	les		di,y2
	mov		es:[di],ax

	mov al,TRUE

@@exit:
END;

procedure SetPlanes(n:byte);ASSEMBLER;
ASM
	MOV			DX,SC_INDEX
	MOV			AH,n
	MOV			AL,2
	OUT			DX,AX
END;

procedure box(x1,y1,x2,y2:integer;color:byte);
begin
	DrawH(x1,y1,x2,color);
	DrawV(x2,y1,y2,color);
	DrawH(x2,y2,x1,color);
	DrawV(x1,y2,y1,color);
end;

procedure SetWriteMode(n:Twrite);ASSEMBLER;
ASM
	MOV			DX,GC_INDEX
	MOV			AH,n
	SHL			AH,3
	MOV			AL,3
	OUT			DX,AX
END;

procedure draw(x1,y1,x2,y2:integer;color:byte);

	function sgn(valor:integer):integer;
begin
	if valor<0 then sgn:=-1 else if valor=0 then sgn:=0 else sgn:=1;
end;

var
	t,distancia,Xerr,Yerr,DeltaX,DeltaY,IncX,IncY:integer;

begin
	Xerr:=0;Yerr:=0;

	DeltaX:=x2-x1;
	DeltaY:=y2-y1;

	IncX:=sgn(DeltaX);
	IncY:=sgn(DeltaY);

	DeltaX:=abs(DeltaX);
	DeltaY:=abs(DeltaY);

	if DeltaX>DeltaY then distancia:=DeltaX else distancia:=DeltaY;

	for t:=1 to distancia+1 do
		begin
			plot(x1,y1,color);

			inc(Xerr,DeltaX);
			inc(Yerr,DeltaY);

			if Xerr>distancia then
				begin
					dec(Xerr,distancia);
					inc(x1,IncX);
				end;

			if Yerr>distancia then
				begin
					dec(Yerr,distancia);
					inc(y1,IncY);
				end;
		end;
end;

procedure OutTextXY(x:integer;y:integer;color,fondo:byte;cadena:string);

	procedure text(x,y:integer;caracter:char;color,fondo:byte);ASSEMBLER;
ASM
	LES				DI,vRAM

	PUSH			DS

	MOV				BX,y
	ADD				BX,BX
	ADD				DI,x
	ADD				DI,WORD(MultBy80[BX])

	MOV				AX,$40
	MOV				DS,AX
	MOV				CX,[$85]

	XOR				AX,AX
	MOV				DS,AX
	MOV				AL,caracter
	MOV				BX,$43*4
	LDS				SI,[BX]
	MUL				CL
	ADD				SI,AX
	MOV				BL,color
	MOV       BH,fondo

	MOV				DX,SC_INDEX
	MOV				AL,GC_READ_MAP
	OUT				DX,AL
	INC				DX
	MOV				CH,$11

@BUCLE:
	PUSH			CX
	MOV				CL,8
	LODSB
	MOV				AH,AL

@CONT1:
	MOV				AL,BL
	ADD				AH,AH
	JC				@CONT2
	MOV				AL,BH

@CONT2:
	PUSH			AX
	MOV				AL,CH
	OUT				DX,AL
	POP				AX

	MOV				ES:[DI],AL

	ROL				CH,1
	ADC				DI,0
	DEC				CL
	JNZ				@CONT1

@SIGUE:
	ADD				DI,80-2
	POP				CX
	DEC				CL
	JNZ				@BUCLE

	POP				DS
END;

var
	m:byte;
	cx:integer;

begin
	cx:=x;
	for m:=1 to length(cadena) do
		begin
			text(cx,y,cadena[m],color,fondo);
			inc(cx,2);
		end;
end;

procedure OutNumXY(x,y:integer;color,fondo:byte;num:LongInt);
var
	s:string;

begin
	str(num,s);
	OutTextXY(x,y,color,fondo,s);
end;

procedure print(x,y:integer;color,fondo:byte;cadena:string;num:LongInt);
var
	s:string;

begin
	OutTextXY(x,y,color,fondo,cadena);
  inc(x,length(cadena)*2+1);
{	inc(x,8);}

	str(num,s);
	OutTextXY(x,y,color,fondo,s);
end;

procedure BigOutTextXY(x,y:integer;color,fondo:byte;cadena:string);

	procedure text(x,y:integer;caracter:char;color,fondo:byte);ASSEMBLER;
var
	yy:integer;

ASM
	PUSH			DS
	LES				DI,vRAM
	MOV				AX,DI
	ADD				AX,PageSize
	SUB				AX,80*4
	MOV				WORD(@CONT1+2),AX

	MOV				BX,y
	MOV				yy,BX

	CMP				BX,region.ylr
	JG				@FIN

	ADD				BX,BX
	ADD				DI,x
	TEST			y,NOT 0
	JL				@MENOR0
	ADD				DI,WORD(MultBy80[BX])

@MENOR0:
	MOV				AX,$40
	MOV				DS,AX
	MOV				CX,[$85]

	XOR				AX,AX
	MOV				DS,AX
	MOV				AL,caracter
	MOV				BX,$43*4
	LDS				SI,[BX]
	MUL				CL
	ADD				SI,AX
	MOV				BL,color
	MOV       BH,fondo

@BUCLE:
	PUSH			CX
	MOV				CL,8
	LODSB
	MOV				AH,AL

	TEST			yy,NOT 0
	JL				@SIGUE1

@CONT1:
	CMP				DI,16000
	JL				@CONT0
	POP				CX
	JMP				@FIN

@CONT0:
	MOV				AL,BL
	ADD				AH,AH
	JNC				@OTRA

@CONT2:
	MOV				ES:[DI],AL
	MOV				ES:[DI+80],AL
	MOV				ES:[DI+160],AL

@OTRA:
	INC				DI
	DEC				CL
	JNZ				@CONT1

@SIGUE:
	ADD				DI,(80*3)-8

@SIGUE1:
	INC				yy
	POP				CX
	DEC				CL
	JNZ				@BUCLE

@FIN:
	POP				DS
END;

var
	m:byte;
	cx:integer;

begin
	SetPlanes(ALL_PLANES);
	cx:=x;

	for m:=1 to length(cadena) do
		begin
			text(cx,y,cadena[m],color,fondo);
			inc(cx,8);
		end;
end;

procedure SplitScreen(ad:word);ASSEMBLER;
ASM
	MOV			DX,CC_INDEX
	MOV			AX,ad

	MOV			BH,AH
	MOV			BL,BH
	AND			BX,$201
	SHL			BX,4
	ADD			BH,BH

	MOV			AH,AL
	MOV     AL,$18
	OUT			DX,AX

	MOV			AL,7
	OUT			DX,AX
	INC			DX

	IN			AL,DX
	DEC			DX

	MOV			AH,AL
	AND     AH,11101111b
	OR			AH,BL
	MOV			AL,7
	OUT			DX,AX

	MOV			AL,9
	OUT			DX,AL
	INC			DX

	IN			AL,DX
	DEC			DX

	MOV			AH,AL
	AND			AH,10111111b
	OR			AH,BH
	MOV			AL,9
	OUT			DX,AX
END;

var
	senos:array[0..360+90] of integer;

procedure FillEllipse(x,y,rx,ry,color:integer);ASSEMBLER;
ASM
	PUSH		BP

	MOV			DI,ry
	CMP			DI,50
	JA			@FIN
	MOV			SI,rx

	MOV			AX,x
	MOV			WORD(@CAMBIA_X1+1),AX
	MOV			WORD(@CAMBIA_X2+1),AX

	MOV			AX,y
	MOV			WORD(@CAMBIA_Y1+1),AX
	MOV			WORD(@CAMBIA_Y2+1),AX

	MOV			AX,color
	MOV			WORD(@CAMBIA_COLOR1+1),AX
	MOV			WORD(@CAMBIA_COLOR2+1),AX

	MOV			CX,360		{for n:=360 DownTo 180 do}

@BUCLE:
	MOV			BX,CX
	ADD			BX,BX
	MOV			AX,WORD(senos[BX])
	IMUL		SI
	SAR			AX,8      {x:=(rx*seno[n]) div ESCALA;}
	MOV			BP,AX

	MOV			BX,CX
	ADD			BX,BX
	MOV			AX,WORD(senos[BX+180])
	IMUL		DI
	SAR			AX,8			{y:=(ry*seno[n+90]) div ESCALA;}

@CAMBIA_Y1:
	MOV			BX,0
	SUB			BX,AX     {arriba:=CENTERY-y;}
	MOV			WORD(@CAMBIA_Y3+1),BX

@CAMBIA_Y2:
	ADD			AX,0			{abajo:=CENTERY+y;}

@CAMBIA_X1:
	MOV			DX,0
	ADD			DX,BP			{izquierda=CENTERX+x;}

@CAMBIA_X2:
	MOV			BX,0
	SUB			BX,BP     {derecha=CENTERX-x;}

	CMP			BX,DX     {if izquierda=derecha then continue;}
	JE			@SIGUE

	PUSH		CX
	PUSH		DI

	PUSH		DX
	PUSH		BX

@CAMBIA_COLOR1:
	MOV			CX,0

	PUSH		DX
	PUSH		AX
	PUSH		BX
	PUSH		CX
	CALL		DrawH    	{DrawH(izquierda,abajo,derecha,color);}

@CAMBIA_COLOR2:
	MOV			CX,0

	POP			BX
	POP			DX

@CAMBIA_Y3:
	MOV 		AX,0

	PUSH		DX
	PUSH		AX
	PUSH		BX
	PUSH		CX
	CALL		DrawH     {DrawH(izquierda,arriba,derecha,color);}

	POP			DI
	POP			CX

@SIGUE:
	DEC			CX
	CMP			CX,90*3
	JNE			@BUCLE

@FIN:
	POP			BP
END;

procedure SetAddress(ad:word);ASSEMBLER;
ASM
	MOV			DX,$3D4
	MOV			AL,$C
	MOV			AH,BYTE(ad+1)
	OUT			DX,AX

	INC			AL
	MOV			AH,BYTE(ad)
	OUT			DX,AX
END;

function LoadPCX(n:string;pagina:integer;var c:Tpal):boolean;
type
	PCX=record
		manufacturer,version,encoding,BitsPerPixel:byte;
		XMin,YMin,XMax,YMax,HRes,VRes:word;
		palette:array[0..47] of byte;
		reserved:byte;
		ColorPlanes:byte;
		BytesPerLine:word;
		PalleteType:word;
		filler:array[0..57] of byte;
	end;

var
	f:Tfile;
	header:PCX;
	p:^byte;

procedure SetPal;
var
	n:integer;
	l:word;

begin
	seek(f,FileSize(f)-SizeOf(c));
	read(f,c,SizeOf(c),l);

	for n:=0 to 255 do with c[n] do
		begin
			red:=red div 4;
			green:=green div 4;
			blue:=blue div 4;
		end;
end;

function DescomprimePCX(var p;dir:word;l:word;var plano:byte):word;ASSEMBLER;
ASM
	LES			DI,plano
	MOV			CH,ES:[DI]

	PUSH		DS
	PUSH		BP

	MOV			ES,WORD(vRAM+2)
	MOV			DI,dir
	LDS			SI,p

	MOV			BP,l

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	OUT			DX,AL
	INC			DX

@BUCLE:
	MOV			CL,1
	LODSB
	CMP			AL,192
	JB			@SIGUE
	MOV			CL,AL
	AND			CL,63
	LODSB
	DEC			BP
	JZ			@FIN

@SIGUE:
	MOV			BL,AL

@BUC:
	MOV			AL,CH
	OUT			DX,AL

	MOV			ES:[DI],BL
	ROL			CH,1
	ADC			DI,0

	DEC			CL
	JNZ			@BUC

	DEC			BP
	JNZ			@BUCLE

@FIN:
	POP			BP
	POP			DS

	MOV			AX,DI

	LES			DI,plano
	MOV			ES:[DI],CH
END;

function ReadPCX:word;
var
	l:word;

begin
	read(f,p^,64000,l);
	if (l<64000) and (l>0) then dec(l,768);

	ReadPCX:=l;
end;

function ValidPCX:boolean;
var
	l:word;

begin
	seek(f,0);
	read(f,header,SizeOf(header),l);

	with header do
		ValidPCX:=(manufacturer=10) and (version=5) and
							(BitsPerPixel=8) and (ColorPlanes=1);
end;

function ValidPal:boolean;
var
	v:byte;
	l:word;

begin
	seek(f,FileSize(f)-769);
	read(f,v,1,l);

	ValidPal:=v=$c;
end;

var
	dir,longitud:word;
	plano:byte;

begin
	LoadPCX:=FALSE;

	if (open(f,n,RO)>0) or (not ValidPCX) or (not ValidPal) then
		begin
			close(f);
			exit;
		end;

	GetMem(p,64000);
	SetPal;
	seek(f,128);
	longitud:=ReadPCX;
	dir:=desplazamiento[pagina];
	plano:=$11;

	while longitud>0 do
		begin
			dir:=descomprimePCX(p^,dir,longitud,plano);
			longitud:=ReadPCX;
		end;

	FreeMem(p,64000);
	LoadPCX:=TRUE;

	close(f);
end;

procedure SetLineCompare(l: WORD);
	BEGIN
		 Port[$3d4] := $18; Port[$3d5] := BYTE(l);
		 Port[$3d4] := $7;  Port[$3d5] := (Port[$3d5] AND $EF)
																			OR BYTE((l AND $100) DIV 2);
		 Port[$3d4] := $9;  Port[$3d5] := (Port[$3d5] AND $BF)
																			OR BYTE((l AND $200) DIV 8)
	END;

PROCEDURE PresetRowScan(s : BYTE);
	BEGIN
		 Port[$3d4] := 8; Port[$3d5] := (Port[$3d5] AND $E0) OR (s AND $0F)
	END;

function VGAExist:boolean;ASSEMBLER;
ASM
	MOV			AX,$1A00
	INT			$10

	CMP			AL,$1A
	JNZ			@NO
	MOV			AL,TRUE
	JMP			@FIN

@NO:
	MOV			AL,FALSE

@FIN:
END;

procedure WaitVR;ASSEMBLER;
ASM
	MOV			DX,INPUT_1

@RASTER_HI:
	IN			AL,DX
	TEST		AL,8
	JZ			@RASTER_HI
END;

procedure WaitDE;ASSEMBLER;
ASM
	MOV			DX,INPUT_1

@RASTER:
	IN			AL,DX
	TEST		AL,8
	JNZ			@RASTER
END;

var
	n:word;

begin
	for n:=0 to MAXY do MultBy80[n]:=n*80;
	for n:=0 to high(senos) do senos[n]:=round(256*sin(n/180*pi));

	FillChar(Xi,SizeOf(Xi),0);FillChar(Xd,SizeOf(Xd),0);

	vRAM:=ptr(SegA000,0);
end.