unit math;

INTERFACE

const
	DEG=360;
	COSINE=DEG div 4;
	RAD=3.1415926536/(DEG/2);

function n(x:double):double;
function log(x,base:double):double;
function hipotenusa(lado1,lado2:double):double;
function tangente(a:double):double;
function cotangente(x:double):double;
function secante(x:double):double;
function cosecante(x:double):double;
function pow(mantisa,exponente:double):double;  {Eleva la mantisa al exponente}
function cubica(num:double):double;          {Calcula la raiz cbica de NUM}
function asin(x:double):double;
function acos(x:double):double;
function arcocotangente(x:double):double;
function arcocosecante(x:double):double;
function arcosecante(x:double):double;
function radianes(grados:double):double;
{convierte los grados a radianes}

function grados(radianes:double):double;
{convierte los radianes en grados}

function FindSqrt(numero:longint):word;
{Devuelve la raz cbica de NUMERO}

function Int2Fixed(n:LongInt):LongInt;
function Fixed2Int(n:LongInt):integer;
function Float2Fixed(n:double):LongInt;
function Fixed2Float(n:LongInt):double;
function FixedMul(n1,n2:LongInt):LongInt;
function FixedDiv(n1,n2:LongInt):LongInt;

function Atan2(y,x:double):double;
procedure ModifyCopro;

function sgn(valor:integer):integer;
function round(n:double):LongInt;
function LensToFov(lens:double):double;

IMPLEMENTATION

uses OP386;

function n(x:double):double;
var
	x2,t,y1,y2,y3,y4,y5,z,r:double;

begin
	y1:=1/(1+(0.2316419*abs(x)));
	y2:=sqr(y1);
	y3:=y2*y1;
	y4:=y3*y1;
	y5:=y4*y1;
	x2:=sqr(x);
	z:=0.3989423*exp(-x2/2);
	r:=(1.330274*y5)-(1.821256*y4)+(1.781478*y3)-(0.356538*y2)+(0.3193815*y1);
	t:=1-(z*r);
	if x>0 then
		n:=t
	else
		n:=1-t;
end;

function log(x,base:double):double;
begin
	if x=0 then
		log:=0
	else
		if (base=0) and (x=1) then
			log:=1
		else
			log:=ln(x)/ln(base)
end;

function hipotenusa(lado1,lado2:double):double;
begin
	hipotenusa:=sqrt(sqr(lado1)+sqr(lado2));
end;

function tangente(a:double):double;

	function AdjustAngle(a:double):double;
begin
	repeat
		if a<=-pi then a:=a+2*pi;
		if a>pi then a:=a-2*pi
	until (a>-pi) and (a<=pi);
	AdjustAngle:=a
end;

begin
	a:=AdjustAngle(a);
	if abs(a-pi/2)<1e-10 then
		tangente:=9.99e+37
	else
		if abs(a-3*pi/2)<1e-10 then
			tangente:=-9.99e+37
		else
			tangente:=sin(a)/cos(a)
end;

function cotangente(x:double):double;
begin
	cotangente:=cos(x)/sin(x);
end;

function secante(x:double):double;
begin
	secante:=1/cos(x);
end;

function cosecante(x:double):double;
begin
	cosecante:=1/sin(x);
end;

function pow(mantisa,exponente:double):double;
begin
	if exponente=0 then
		pow:=1
	else
		pow:=exp(exponente*ln(mantisa));
end;

function cubica(num:double):double;
begin
	cubica:=pow(num,1/3);
end;

function asin(x:double):double;
begin
	if x<0 then
		asin:=-asin(-x)
	else
		if x=1 then
			asin:=pi/2
		else
			asin:=ArcTan(x/sqrt(1-x*x))
end;

function acos(x:double):double;
begin
	if x<0 then
		acos:=pi-acos(-x)
	else
		if x=0 then
			acos:=pi/2
		else
			acos:=ArcTan(sqrt(1-x*x)/x)
end;

function arcocotangente(x:double):double;
begin
	arcocotangente:=1.570796-ArcTan(x);
end;

function arcocosecante(x:double):double;
begin
	arcocosecante:=ArcTan(1/sqrt(pow(x,2)-1))+ord(x<0)*pi;
end;

function arcosecante(x:double):double;
begin
	arcosecante:=ArcTan(sqrt(pow(x,2)-1))+ord(x<0)*pi;
end;

function radianes(grados:double):double;
begin
	radianes:=(grados*pi)/180;
end;

function grados(radianes:double):double;
begin
	grados:=(radianes*180)/(pi);
end;

function FindSqrt(numero:LongInt):word;ASSEMBLER;
ASM
	MOV			SI,WORD(numero)
	MOV			DI,WORD(numero+2)

	XOR			DX,DX
	MOV			BX,DX
	MOV			AX,1
	MOV			CX,2
											{Bucle desenrrollado 6 veces}
@BUCLE:
	SUB     SI,AX
	SBB     DI,DX
	JC      @SREXIT
	ADD     AX,CX
	ADC     DX,BX

	SUB     SI,AX
	SBB     DI,DX
	JC      @SREXIT
	ADD     AX,CX
	ADC     DX,BX

	SUB     SI,AX
	SBB     DI,DX
	JC      @SREXIT
	ADD     AX,CX
	ADC     DX,BX

	SUB     SI,AX
	SBB     DI,DX
	JC      @SREXIT
	ADD     AX,CX
	ADC     DX,BX

	SUB     SI,AX
	SBB     DI,DX
	JC      @SREXIT
	ADD     AX,CX
	ADC     DX,BX

	SUB     SI,AX
	SBB     DI,DX
	JC      @SREXIT
	ADD     AX,CX
	ADC     DX,BX

	SUB     SI,AX
	SBB     DI,DX
	JC      @SREXIT
	ADD     AX,CX
	ADC     DX,BX

	SUB     SI,AX
	SBB     DI,DX
	JC      @SREXIT
	ADD     AX,CX
	ADC     DX,BX

	JMP			@BUCLE

@SREXIT:
	RCR			DX,1
	RCR			AX,1
END;

function Int2Fixed(n:LongInt):LongInt;
begin
	Int2Fixed:=n shl 16;
end;

function Fixed2Int(n:LongInt):integer;
begin
	Fixed2Int:=n shr 16;
end;

function Float2Fixed(n:double):LongInt;
begin
	Float2Fixed:=round(n*65536);
end;

function Fixed2Float(n:LongInt):double;
begin
	Fixed2Float:=n/65536;
end;

function FixedMul(n1,n2:LongInt):LongInt;ASSEMBLER;
ASM
	DB		_386;MOV		AX,WORD(n1)
	DB		_386;IMUL  	WORD(n2)
	DB		$66,5;DD		$8000			{ADD EAX,$8000}
	DB		_386;ADC		DX,0
	DB		$66,$F,$AC,$D0,$10		{SHRD EAX,EDX,16}
END;

function FixedDiv(n1,n2:LongInt):LongInt;ASSEMBLER;
ASM
	DB		_386;XOR 		AX,AX
	DB		_386;MOV		DX,WORD(n1)
	DB		$66,$F,$AC,$D0,$10		{SHRD EAX,EDX,16}
	DB		_386;SAR		DX,16
	DB		_386;IDIV		WORD(n2)
END;

function Atan2(y,x:double):double;{}
var
	tmp:double;

begin
	ASM
		FLD	y
		FLD	x
		FPATAN
		FSTP tmp
	END;
	Atan2:=tmp;
end;

procedure ModifyCopro;ASSEMBLER;
const
	mask:LongInt=not $300;

var
	MemVar:word;

ASM
	FSTCW	MemVar
	MOV		AX,MemVar
	DB		_386;AND	 AX,WORD(mask)
	MOV		MemVar,AX
	FLDCW	MemVar
END;

function sgn(valor:integer):integer;
begin
	if valor<0 then
		sgn:=-1
	else
		if valor=0 then
			sgn:=0
		else
			sgn:=1;
end;

function round(n:double):LongInt;{}
begin
	while abs(n)>MaxLongInt do n:=n/2;
	round:=system.round(n);
end;

function LensToFov(lens:double):double;
const
	table:array[0..8] of record
		lens,fov:double;
	end=(
		(lens:15;fov:115),(lens:20;fov:94.28571),(lens:24;fov:84),(lens:28;fov:76.36364),
		(lens:35;fov:63),(lens:50;fov:46),(lens:85;fov:28),(lens:135;fov:18),
		(lens:200;fov:12)
		);

var
	i:integer;

begin
	for i:=0 to 8 do
		if lens=table[i].lens then
			begin
				LensToFov:=table[i].fov;
				exit;
			end;
	LensToFov:=15/lens*160;
end;


begin
	ModifyCopro;
end.