title   lzdcmp - file decompressor using limpel-ziev algorithm
.386
.MODEL TPASCAL

;Tom Pfau
;Digital Equipment Corporation
;Parsippany, NJ

;Modified by Antonio Tejada, 1996
;Universidad de las Islas Baleares
;SPAIN

.DATA
;Constants
clear           equ     256
eof             equ     257
first_free      equ     258
maxmax          equ     4096
.CODE

hread   macro   handle,buf,siz
				ifdif   <bx>,<handle>
				mov     bx,handle
				endif
				lea     dx,buf
				ifdif   <cx>,<siz>
				mov     cx,siz
				endif
				mov     ah,3fh
				int     21h
				endm

loadpointers macro
				les     di,DWORD PTR ds:[TDF.output_pointer]
				mov     si,WORD PTR ds:[TDF.Output_base]
        mov     cx,WORD PTR ds:[TDF.Output_offset]
        mov     bx,WORD PTR ds:[TDF.Count]
endm

savepointers macro OBase
        mov     WORD PTR ds:[TDF.output_pointer],di
        mov     WORD PTR ds:[TDF.Output_base],OBase
        mov     WORD PTR ds:[TDF.Output_offset],cx
        mov     WORD PTR ds:[TDF.count],bx
endm

index           macro
        lea     bx,[ebx+ebx*2]
;        mov     bp,bx                   ;bx = bx * 3 (3 byte entries)
;        shl     bx,1                    ;bp = bx
;        add     bx,bp                   ;bx = bx * 2 + bp
endm

.DATA
;Hash table entry
hash_rec        struc
next    dw      ?                       ; prefix code
char    db      ?                       ; suffix char
hash_rec        ends

;Start coding
TDF struc
		;Data Frame for each compressed and open file
		input_handle    dw      ?
		hash            LABEL hash_rec
										db      768*16 dup (?)
		cur_code        dw      ?
		old_code        dw      ?
		in_code         dw      ?
		free_code       dw      first_free
		stack_count     dw      0
		nbits           dw      9
		max_code        dw      512
		fin_char        db      ?
		k               db      ?
		output_offset   dw      0 ;Nmero de caracteres en Output_buffer
		output_base     dw      0 ;Indice al caracter actual
		output_buffer   db      4096 dup (?)
		masks           dw      1ffh,3ffh,7ffh,0fffh
		input_buffer    db      1024 dup (?)
		bit_offset      dw      0   ;Inicializar a 1024*8
    lzeof           db      0
    count           dw      0
    output_pointer  dd      0
TDF ends

.CODE

PUBLIC Decompress

Decompress      proc    NEAR data_frame:WORD
        push ds                         ;Save TP's Data Frame
				push bp
;				mov ds,[bp+6]
                                mov  ds, WORD PTR data_frame ;Init LZW data frame

        ;Transferimos desde Output_buffer[Output_base] hasta Output_Pointer
        loadpointers

        test cx,cx         ; Miramos si hay caracteres en Output_buffer
        jz DecompressNext
        XFer:
					mov al,BYTE PTR [si][TDF.Output_buffer]
          mov BYTE PTR es:[di],al  ; Transferimos al buffer definitivo
          inc si           ; Apuntamos a la siguiente posicin de Output_buffer
          inc di           ; Apuntamos a la siguiente posicin de Ouptut_pointer
          dec cx           ; Decrementamos el nmero de bytes disponibles en el buffer
          dec bx           ; Hemos acabado de transferir?
          jz EndXFer       ; SI -> Salta
          test cx,cx       ; Miramos si hemos agotado Output_buffer
          jz DecompressNext ; En ese caso, descomprimimos ms
        jmp XFer
        EndXFer:

        ; Actualizamos Output_Size y Output_offset
        savePointers si
        pop bp
        pop ds
        ret

        DecompressNext:
        ; Actualizamos Output_Offset, Output_base, count y Output_Pointer
        savePointers 0

        mov     ax, WORD PTR ds:[TDF.bit_offset]
        cmp     ax, 1024*8 ; Miramos si hay que leer en el
        jne     NoReadBuf                  ; Buffer de lectura
        hread   ds:[TDF.input_handle],ds:[TDF.input_buffer],1024  ;Read from input
        mov     WORD PTR ds:[TDF.bit_offset],0   ;Inicializamos bit_offset
        NoReadBuf:
l1:     call    read_code               ;Get a code
        cmp     ax,eof                  ;End of file?
        jne     l2                      ;no
        mov     BYTE PTR ds:[TDF.lzEOF],255
l1a:    pop bp
        pop ds
        ret                             ;done
l2:     cmp     ax,clear                ;Clear code?
        jne     l7                      ;no
        call    init_tab                ;Initialize table
        call    read_code               ;Read next code
        mov     WORD PTR ds:[TDF.cur_code],ax    ;Initialize variables
        mov     WORD PTR ds:[TDF.old_code],ax
        mov     BYTE PTR ds:[TDF.k],al
        mov     BYTE PTR ds:[TDF.fin_char],al
				mov     al,BYTE PTR ds:[TDF.k]
				call    write_char              ;Write character

				loadpointers

				jmp     XFer                    ;Copiamos al buffer

l7:     mov     WORD PTR ds:[TDF.cur_code],ax    ;Save new code
				mov     WORD PTR ds:[TDF.in_code],ax

				cmp     ax,WORD PTR ds:[TDF.free_code]       ;Code in table? (k<w>k<w>k)
				jl      l11                     ;yes
				mov     ax,WORD PTR ds:[TDF.old_code]    ;get previous code
				mov     WORD PTR ds:[TDF.cur_code],ax    ;make current
				mov     al,BYTE PTR ds:[TDF.fin_char]    ;get old last char
				push    ax                      ;push it
				inc     ds:[TDF.stack_count]
l11:    cmp     ds:[TDF.cur_code],255   ;Code or character?
				jle     l15                     ;Char
				mov     bx,ds:[TDF.cur_code]    ;Convert code to address
				index
;*      mov     al,ds:2[bx]             ;Get suffix char
				mov     al,BYTE PTR ds:[bx+2][TDF.hash]
				push    ax                      ;push it
				inc     ds:[TDF.stack_count]
;*      mov     ax,ds:[bx]              ;Get prefix code
				mov     ax,WORD PTR ds:[bx][TDF.hash]
				mov     ds:[TDF.cur_code],ax    ;Save it
				jmp     l11                     ;Translate again
l15:;*  push    ds                      ;Restore seg reg
		;*  pop     es
				mov     ax,ds:[TDF.cur_code]    ;Get code
				mov     ds:[TDF.fin_char],al    ;Save as final, k
        mov     ds:[TDF.k],al
        push    ax                      ;Push it
        inc     WORD PTR ds:[TDF.stack_count]
        mov     cx,WORD PTR ds:[TDF.stack_count] ;Pop stack
        jcxz    l18                     ;If anything there
l17:    pop     ax
        call    write_char
        loop    l17
l18:    mov     WORD PTR ds:[TDF.stack_count],cx ;Clear count on stack
        call    add_code                ;Add new code to table
        mov     ax,WORD PTR ds:[TDF.in_code]     ;Save input code
        mov     WORD PTR ds:[TDF.old_code],ax
				mov     bx,WORD PTR ds:[TDF.free_code]   ;Hit table limit?
				cmp     bx,WORD PTR ds:[TDF.max_code]
				jl      l23                     ;Less means no
				cmp     WORD PTR ds:[TDF.nbits],12       ;Still within twelve bits?
				je      l23                     ;no (next code should be clear)
				inc     WORD PTR ds:[TDF.nbits]          ;Increase code size
				shl     WORD PTR ds:[TDF.max_code],1     ;Double max code
l23:
				loadpointers
				jmp     XFer                     ;Seguimos transfiriendo
decompress      endp

read_code       proc    near
				mov     ax,ds:[TDF.bit_offset]  ;Get bit offset
				add     ax,ds:[TDF.nbits]       ;Adjust by code size
				xchg    ds:[TDF.bit_offset],ax  ;Swap
				mov     dx,ax                   ;Calculate byte offset
				and     dx,7
				shr     ax,3
				cmp     ax,1021                 ;Approaching end of buffer?
				jl      rd0                     ;no
				push    dx                      ;Save offset in byte
				add     dx,ds:[TDF.nbits]       ;Calculate new bit offset
				mov     ds:[TDF.bit_offset],dx
				mov     cx,1024                 ;1k buffer
				mov     bp,ax                   ;save byte offset
				sub     cx,ax                   ;Calculate bytes left
				add     ax,offset TDF.input_buffer  ;Point to char
				mov     si,ax
				push ds
				pop es
				lea     di,ds:[TDF.input_buffer];Point to beginning of buffer
				rep     movsb                           ;Move last chars down
				hread   ds:[TDF.input_handle],[di],bp    ;Fill rest of buffer
				xor     ax,ax                   ;Clear ax
				pop     dx                      ;Restore offset in byte
rd0:    add     ax,offset TDF.input_buffer  ;Point to char
				mov     si,ax
				lodsw                           ;Get word
				mov     bx,ax                   ;Save in AX
				lodsb                           ;Next byte
				mov     cx,dx                   ;Offset in byte
;				jcxz    rd2                     ;If zero, skip shifts
				shrd    bx,ax,cl
; rd1:   shr     al,1                    ;Put code in low (code size) bits of BX
;			rcr     bx,1
;			loop    rd1
rd2:    mov     ax,bx                   ;put code in ax
				mov     bx,ds:[TDF.nbits]       ;mask off unwanted bits
				sub     bx,9
				shl     bx,1
				and     ax,ds:[TDF.masks][bx]
				ret
read_code       endp

init_tab        proc    near
				mov     WORD PTR ds:[TDF.nbits],9                 ;Initialize variables
				mov     WORD PTR ds:[TDF.max_code],512
				mov     WORD PTR ds:[TDF.free_code],first_free
				ret
init_tab        endp

write_char      proc    near
				mov     di,ds:[TDF.output_offset]        ;Get offset in buffer
				mov     ds:[TDF.output_buffer[di]],al
				inc     ds:[TDF.output_offset]  ;Increment number of chars in buffer
				ret
write_char      endp

add_code        proc    near
				mov     bx,ds:[TDF.free_code]   ;Get new code
				index                   ;convert to address
				mov     al,ds:[TDF.k]              ;get suffix char
				mov     ds:[bx][TDF.Hash].char,al
				mov     ax,ds:[TDF.old_code]    ;get prefix code
				mov     ds:[bx][TDF.Hash].next,ax
				inc     WORD PTR ds:[TDF.free_code]      ;set next code
				ret
add_code        endp

				end
