unit keys;

INTERFACE


type
	TKey=(K_NIL,K_ESC,K_1,K_2,K_3,K_4,K_5,K_6,K_7,K_8,K_9,K_0,
				K_INTERROGANTE,K_ADMIRACION,K_DEL,K_TAB,
				K_Q,K_W,K_E,K_R,K_T,K_Y,K_U,K_I,K_O,K_P,
				K_ABRE_CORCHETE,K_CIERRA_CORCHETE,K_RETURN,K_CTRL,
				K_A,K_S,K_D,K_F,K_G,K_H,K_J,K_K,K_L,
				K_ENYE,K_OPEN_KEY,K_INVERTIDA,K_L_SHIFT,K_CLOSE_KEY,
				K_Z,K_X,K_C,K_V,K_B,K_N,K_M,
				K_COMA,K_POINT,K_DIV,K_R_SHIFT,K_MULT,K_ALT,K_SPACE,K_BLOQ_MAY,
				K_F1,K_F2,K_F3,K_F4,K_F5,K_F6,K_F7,K_F8,K_F9,K_F10,
				K_BLOQ_NUM,K_BLOQ_DESP,K_HOME,K_UP,K_RE_PAGE,K_LESS,
				K_LEFT,K_FIVE_NUM,K_RIGHT,K_MORE,K_END,K_DOWN,K_AV_PAGE,
				K_INSERT,K_SUPR,K_NIL_84,K_NIL_85,K_MORE_LESS,K_F11,K_F12,
				K_NIL_90,K_NIL91,K_NIL92,K_NIL93,K_NIL94,K_NIL95,K_NIL96,K_NIL97,
				K_NIL98,K_NIL99,K_NIL100,K_NIL101,K_NIL102);

const
	KeyPressed:TKey=K_NIL;

var
	inkey:array[TKey] of boolean;
	shit:array[0..24] of byte;

procedure init;
{Inicializa el sistema de teclado, se puede leer a traves del ARRAY booleano inkeys[]}
procedure done;
{Acaba el sistema}
function ReadKey:TKey;
{Espera a una pulsacin de tecla y la devuelve}
function GetChar(k:TKey):char;
{Devuelve el carcter de la tecla apretada}
procedure ClearKeys;

IMPLEMENTATION

uses DOS;

const
	INT_TECLADO=9;

	VecIntTec:pointer=NIL;

	cKey:array[TKey] of char=(
		#0,#0,'1','2','3','4','5','6','7','8','9','0','?','!',#0,#0,
		'Q','W','E','R','T','Y','U','I','O','P','[',']',#0,#0,
		'A','S','D','F','G','H','J','K','L','','{','\',#0,'}',
		'Z','X','C','V','B','N','M',',','.','/',#0,'*',#0,#0,#0,
		#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,'-',
		#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0);

procedure INT;ASSEMBLER;
ASM
	PUSHF
	PUSH		AX
	PUSH		BX
	PUSH		DS

	MOV			AX,SEG @DATA
	MOV			DS,AX

	IN			AL,$60
	DB			$0F,$B6,$D8					{MOVZX BX,AL}
	TEST		BX,10000000b
	JNZ			@UNPRESS

	MOV			BYTE(inkey[BX]),TRUE
	MOV			KeyPressed,AL
	JMP			@END

@UNPRESS:
	MOV			BYTE(inkey[BX-128]),FALSE
	MOV			KeyPressed,K_NIL

@END:
	MOV			AL,$20
	OUT			$20,AL							{EOI}
	STI

	POP			DS									{Fin interrucin}
	POP			BX
	POP			AX
	POPF
	IRET
END;

procedure init;
begin
	if VecIntTec=NIL then
		begin
			GetIntVec(INT_TECLADO,VecIntTec);
			SetIntVec(INT_TECLADO,@INT);
			ClearKeys;
		end;
end;

procedure done;
begin
	if VecIntTec<>NIL then
		begin
			SetIntVec(INT_TECLADO,VecIntTec);
			VecIntTec:=NIL;
		end;
end;

function ReadKey:TKey;
begin
	while KeyPressed<>K_NIL do;
	while KeyPressed=K_NIL do;

	ReadKey:=KeyPressed;
end;

function GetChar(k:TKey):char;
begin
	GetChar:=cKey[k];
end;

procedure ClearKeys;
begin
	FillChar(inkey,SizeOf(inkey),K_NIL);
end;

end.