unit joystick;

INTERFACE

type
	TJoy=record
		up,down,left,right,
		b1,b2,b3,b4:boolean;
		x,y,
		CenterX1,CenterX2,
		CenterY1,CenterY2:integer;
	end;

const
	STANDARD=60;

function init(var j:TJoy):boolean;
{TRUE si hay joystick}
procedure read(var j:TJoy);
{Devuelve en j los valores del joystick y la posicin movida}
procedure calibrate(var j:TJoy;error:integer);
{Calibra automticamente el joystick, con %error de margen}

IMPLEMENTATION

uses MyDOS,OP386,speed;

const
	JOY_PORT=$201;

procedure read(var j:TJoy);ASSEMBLER;
ASM
	DB			_386;XOR		BX,BX
	MOV			CX,BX                       {x=y=0}

	LES			DI,j
	DB			_386;MOV		WORD(ES:TJoy[DI].up),BX 		{Borramos j}
{	MOV			joy.down,FALSE
	MOV			WORD(joy.left),AX
	MOV			joy.right,FALSE}
	DB			_386;MOV		WORD(ES:TJoy[DI].b1),BX
{	MOV			joy.button2,FALSE
	MOV			WORD(joy.button3),AX
	MOV			joy.button4,FALSE}

	CLI                                 {Fuera interrupciones (IMPORTANTE :?) }
	MOV			DX,JOY_PORT
	MOV			AH,TRUE

	IN			AL,DX
	TEST		AL,00010000b                {Bit 4=1 botn 1 apretado}
	JNZ			@NO_PULSADO1
	MOV			ES:TJoy[DI].b1,AH

@NO_PULSADO1:
	TEST		AL,00100000b                {Bit 5=1 botn 2 apretado}
	JNZ			@NO_PULSADO2
	MOV			ES:TJoy[DI].b2,AH

@NO_PULSADO2:
	TEST		AL,01000000b                {Bit 6=1 botn 3 apretado}
	JNZ			@NO_PULSADO3
	MOV			ES:TJoy[DI].b3,AH

@NO_PULSADO3:
	TEST		AL,10000000b                {Bit 7=1 botn 4 apretado}
	JNZ			@NO_PULSADO4
	MOV			ES:TJoy[DI].b4,AH

@NO_PULSADO4:
	OUT			DX,AL                       {Ponemos cachondo el joystick...:) }

@LEE_EJES:
	IN			AL,DX
	TEST		AL,00000001b                {Eje X (bit 0) movido?}
	JZ			@EJE_X_FIN                  {No, miramos eje y}
	INC			BX                          {S, incrementamos X}

@EJE_X_FIN:
	TEST		AL,00000010b                {Eje Y (bit 1) movido?}
	JZ			@EJE_Y_FIN                  {No, miramos si seguimos leyendo}
	INC			CX                          {S, incrementamos Y}

@EJE_Y_FIN:
	TEST		AL,00000011b                {Se siguen moviendo los ejes XY?}
	JNZ			@LEE_EJES                   {Si...}
	STI                                 {...No / Interrupciones permitidas}

	CMP			BX,ES:TJoy[DI].CenterX1            	{X es menor que CentroX-error%...}
	JB			@LEFT                  	{...si}

	CMP			BX,ES:TJoy[DI].CenterX2            	{X es mayor que CentroX+error%...}
	JB			@SIGUE                 	{...no}

	MOV			ES:TJoy[DI].right,AH
	JMP			@SIGUE

@LEFT:
	MOV			ES:TJoy[DI].left,AH

@SIGUE:
	CMP			CX,ES:TJoy[DI].CenterY1            {Y es menor que centroY-error%...}
	JB			@UP                   	{...si}

	CMP			CX,ES:TJoy[DI].CenterY2            {Y es mayor que centroY+error%...}
	JB			@FIN										{...no}

	MOV			ES:TJoy[DI].down,AH
	JMP			@FIN

@UP:
	MOV			ES:TJoy[DI].up,AH

@FIN:
	MOV			ES:TJoy[DI].x,BX
	MOV			ES:TJoy[DI].y,CX
END;

function init(var j:TJoy):boolean;

	function exist:boolean;ASSEMBLER;
ASM
	MOV			AL,0
	MOV			DX,JOY_PORT
	OUT			DX,AL

	MOV			BX,0
	MOV			CX,0

	CLI

@ESP_EJES:
	IN			AL,DX
	TEST		AL,00000001b
	JZ			@EJE_X_FIN
	INC			BX
	JZ			@ERROR

@EJE_X_FIN:
	TEST		AL,00000010b
	JZ			@EJE_Y_FIN
	INC			CX
	JZ			@ERROR

@EJE_Y_FIN:
	TEST		AL,00000011b
	JNZ			@ESP_EJES

	MOV			AL,TRUE
	JMP			@FIN

@ERROR:
	MOV			AL,FALSE

@FIN:
	STI
END;

begin
	init:=FALSE;
	if not exist then exit;

	FillChar(j,SizeOf(j),0);
	calibrate(j,STANDARD);

	init:=TRUE;
end;

procedure calibrate(var j:TJoy;error:integer); {Evitando error%}
begin
	read(j);
	with j do
		begin
			CenterX1:=x-PorCiento(x,error);CenterX2:=x+PorCiento(x,error);
			CenterY1:=y-PorCiento(y,error);CenterY2:=y+PorCiento(y,error);
		end;
end;

end.