unit boton;

INTERFACE

type
	pos=(IZQUIERDA,CENTRO,DERECHA);
  EXE=procedure;

function init:boolean;
procedure done;
procedure On(numero:byte;xx,yy,an:integer;
									donde:pos;titulo:string;salto:EXE);
procedure Off(numero:byte);

IMPLEMENTATION

uses
	cadenas,graph,mouse;

const
	TOTAL=255;

	num:byte=1;

type
	TBoton=record
		x,y,ancho,alto:integer;
		rutina:EXE;
		buffer,fondo:^byte;
		activo:boolean;
	end;

var
	botones:array[0..TOTAL] of TBoton;
	tarjeta,modo:integer;

{$F+}
procedure comienzo (iBP,DeltaY,DeltaX,iDS,iES,posx,posy,
										boton,condicion,iIP,iCS,pseudoflags:word);INTERRUPT;
var
	x,y,n,cx,cy,an,al:integer;
	b:mouse.TBoton;
	t:ViewPortType;

begin
	GetViewSettings(t);
	SetViewPort(0,0,GetMaxX,GetMaxY,FALSE);

	for n:=1 to num do with botones[n] do if activo then
		begin
			cx:=x;cy:=y;
			an:=ancho;al:=alto;

			if (cx+an>posx) and (posx>cx) and (cy+al>posy) and (posy>cy) then
				begin
					mouse.off;
					PutImage(cx+1,cy+1,buffer^,NormalPut);
					SetColor(GRIS_OSCURO);
					line(cx,cy,cx+an,cy);
					line(cx,cy+1,cx+an,cy+1);
					line(cx,cy,cx,cy+al);
					line(cx+1,cy,cx+1,cy+al);

					mouse.on;
					repeat
						mouse.read(x,y,b);
					until (b=NINGUNO) or
						(not ((cx+an>x) and (x>cx) and (cy+al>y) and (y>cy)));

					mouse.off;
					PutImage(cx,cy,buffer^,NormalPut);
					mouse.on;

					if (cx+an>x) and (x>cx) and (cy+al>y) and (y>cy) then
						begin
							SetViewPort(t.x1,t.y1,t.x2,t.y2,t.clip);
							rutina;
						end;
					break;
				end;
		end;

		SetViewPort(t.x1,t.y1,t.x2,t.y2,t.clip);
		ASM										{Para volver con RETF y no con IRET}
			MOV			AX,iDS
			MOV			DS,AX
			ADD			BP,16
			MOV			SP,BP
			POP			BP
			RETF
		END;
end;
{$F-}

function init:boolean;
begin
	init:=FALSE;
	if not mouse.init then exit;

	tarjeta:=9;modo:=2;
	InitGraph(tarjeta,modo,'C:\BP7\BGI');
	mouse.window(0,0,639,479);
	mouse.success(LEFT_BUTTON_PRESSED,@comienzo);
	Mouse.XY(320,240);
	mouse.on;
	init:=TRUE;
end;

procedure done;
begin
	mouse.off;
	closegraph;
end;

procedure on(numero:byte;xx,yy,an:integer;
						 donde:pos;titulo:string;salto:EXE);

var
	al:integer;

begin
	an:=(an*8)+16+xx;
	al:=TextHeight(titulo)+10+yy;

	with botones[numero] do
		begin
			GetMem(fondo,ImageSize(xx,yy,an,al));
			GetImage(xx,yy,an,al,fondo^);

			SetFillStyle(SolidFill,GRIS_CLARO);
			bar(xx,yy,an,al);
			SetColor(GRIS_OSCURO);
			line(xx,al,an,al);
			line(an,al,an,yy);

			line(xx,al-1,an,al-1);
			line(an-1,al,an-1,yy);
			SetColor(AZUL);
				case donde of
					IZQUIERDA:OutTextXY(xx+5,yy+5,titulo);
					CENTRO:OutTextXY(xx+((an-xx) div 2)-TextWidth(titulo) div 2,yy+5,titulo);
					DERECHA:OutTextXY(an-TextWidth(titulo)-30,yy+5,titulo);
				end;

			GetMem(buffer,ImageSize(xx,yy,an-1,al-1));
			GetImage(xx,yy,an-1,al-1,buffer^);

			x:=xx;y:=yy;
			ancho:=an-xx;alto:=al-yy;
			rutina:=salto;
			activo:=TRUE;
		end;

	if num<numero then num:=numero;
end;

procedure off(numero:byte);
var
	xx,yy,an,al:integer;
	long:word;

begin
	with botones[numero] do
		begin
			xx:=x;yy:=y;
			an:=ancho;al:=alto;
			long:=ImageSize(xx,yy,an,al);
			PutImage(xx,yy,fondo^,0);

			FreeMem(fondo,long);
			FreeMem(buffer,long);

			activo:=FALSE;
		end;
end;

begin
	FillChar(botones,SizeOf(botones),0);
end.
