unit AnimaX;

INTERFACE

const
	INACTIVO=-1;

type
	Tsprite=record
		x,y,n,IncX,Incy:integer;
		life:byte;
		activate:boolean;
		nada:LongInt;
	end;

{$I SPRITEX.DAT}

function LoadSprites:boolean;
{Inicializa y carga la base de sprites}

procedure FreeSprites;
{Acaba y libera la memoria de los sprites}

function LoadSprite(n:integer):boolean;
{Carga el sprite N}

procedure FreeSprite(n:integer);
{Libera la memoria ocupada por el sprite N}


procedure PutSpriteMask(var s:Tsprite);
{Put el sprite N con mscara (sin Putr los 0) en XY y pgina activa}

procedure PutSpriteMaskBack(var s:Tsprite);
{Put el sprite N con mscara (sin Putr los 0) en XY y pgina Back}

procedure PutSprite(var s:Tsprite);
{Put el sprite N sin mscara en XY y pgina activa}

procedure PutSpriteBack(var s:Tsprite);
{Put el sprite N sin mscara en XY y pgina Back}

function collision(var s1,s2:Tsprite):boolean;
{Si el sprite N1 en X1Y1 y el sprite N2 en X2Y2, han chocado, TRUE}

IMPLEMENTATION

uses
	ModeX,MyDOS,
{$IFDEF _LZ_}
	megafich;
{$ELSE}
	files;
{$ENDIF}

var
	nada:integer;	{?}
	paso,IncY1,IncY2,tamanyo:word;
	IncAlto,PlanosRestantes:byte;

function LoadSprites:boolean;
var
	m,l,d:word;
	f:Tfile;
	p:^byte;

begin
	LoadSprites:=FALSE;

	if open(f,'SPRITEX.BIN',RO)>0 then exit;

	for m:=1 to high(Sdim) do with Sdim[m] do
		begin
			l:=ancho*alto;
			GetMem(Psprite,l);
			read(f,Psprite^,l,d);
		end;

	LoadSprites:=TRUE;
end;

procedure FreeSprites;
var
	n:integer;

begin
	for n:=1 to high(Sdim) do FreeSprite(n);
end;

function LoadSprite(n:integer):boolean;
var
	p:^byte;
	a:LongInt;
	b:integer;
	d,l:word;
	f:Tfile;

begin
	LoadSprite:=FALSE;
	if open(f,'SPRITEX.BIN',RO)>0 then exit;

	a:=0;
	for b:=1 to n-1 do with Sdim[b] do
		begin
			l:=ancho*alto;
			inc(a,l);
		end;

	with Sdim[n] do
		begin
			l:=ancho*alto;
			GetMem(Psprite,l);
			seek(f,a);
			read(f,Psprite^,l,d);
		end;

	LoadSprite:=TRUE;
	close(f);
end;

procedure FreeSprite(n:integer);
begin
	with Sdim[n] do FreeMem(Psprite,ancho*alto);
end;

procedure PutSpriteMask(var s:Tsprite);ASSEMBLER;
ASM
	PUSH		DS
	PUSH		BP

	LES			DI,s
	MOV			AX,ES:Tsprite[DI].n
	CMP			AX,INACTIVO
	JZ			@SALIR

	CMP			AX,type(Sdim)
	JA			@SALIR

	LEA			SI,Sdim
	SHL			AX,3
	ADD			SI,AX

	MOV			AX,DS
	DW			MOV_GS_AX

	MOV			IncAlto,0
	MOV			IncY1,0
	MOV			IncY2,0

	MOV			DX,region.yul
	MOV			BX,ES:Tsprite[DI].y
	MOV			AX,BX
	ADD			AX,WORD(Tdim[SI].alto)
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			IncAlto,AL      {...dec(alto,abs(region.yul-y);}

	MOV			CX,WORD(Tdim[SI].ancho)
	SHR			CX,2
	IMUL		CX              {...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JGE			@SALIR

	MOV			AX,BX
	ADD			AX,WORD(Tdim[SI].alto)
	CMP			AX,DX   							{if y+alto>region.ylr then...}
	JL			@SIGUE_Y2
	SUB			AX,DX
	MOV			IncAlto,AL      			{dec(alto,(y+alto)-region.ylr}

	MOV			CX,WORD(Tdim[SI].ancho)
	SHR			CX,2
	IMUL		CX              			{inc(IncDir,region.ylr-(y+alto))*ancho}
	MOV			IncY2,AX

@SIGUE_Y2:
	MOV			AX,ES:Tsprite[DI].x
	PUSH		AX                    {Guardo x}
	SHR			AX,2             	 		{x=x/4}
	ADD			BX,BX
	ADD			AX,WORD(MultBy80[BX]) {y=y*80}
	LES     DI,vRAM
	ADD			DI,AX             		{DI=x+y}

	MOV			BX,WORD(Tdim[SI].ancho)
	SHR			BX,2                  {ancho=ancho/4}
	MOV			BP,80
	SUB			BP,BX									{paso=320-ancho}
	MOV			paso,BP

	MOV			BH,BYTE(Tdim[SI].alto)
	SUB			BH,IncAlto
	MOV			tamanyo,BX        		{BX=ancho y alto}
	MOV			PlanosRestantes,4

	LDS			SI,DWORD(Tdim[SI].Psprite)

	POP			CX                    {Recupero x}
	AND			CL,3
	MOV			AH,$11
	SHL			AH,CL         				{AH=plano actual}

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	OUT			DX,AL
	INC			DX

@PLANO:
	DB			GS;ADD			SI,IncY1
	PUSH		DI

	MOV			AL,AH
	OUT			DX,AL

	DB			GS;MOV			BH,BYTE(tamanyo+1)	{MOV BH,alto}

@Y:
	MOV			CL,BL				{CL=ancho/4}

@X:
	MOV			AL,[SI]
	TEST		AL,AL
	JZ			@CERO
	MOV			ES:[DI],AL

@CERO:
	INC			SI
	INC			DI
	DEC			CL
	JNZ			@X

	DB			GS;ADD			DI,paso
	DEC			BH
	JNZ			@Y

	POP			DI          {Recupera direccin inicial de escritura}
	ROL			AH,1
	ADC			DI,0				{Si el plano actual es el 4, pasamos a los
											4 puntos del plano siguiente}
	DB			GS;ADD			SI,IncY2
	DB			GS;DEC			PlanosRestantes
	JNZ			@PLANO

@SALIR:
	POP			BP
	POP			DS
END;

procedure PutSpriteMaskBack(var s:Tsprite);
var
	guarda:pointer;

begin
	guarda:=vRAM;
	vRAM:=ptr(SegA000,desplazamiento[BACK_PAGE]);

	PutSpriteMask(s);
	vRAM:=guarda;
end;

procedure PutSprite(var s:Tsprite);ASSEMBLER;
ASM
	PUSH		DS
	PUSH		BP

	LES			DI,s
	MOV			AX,ES:Tsprite[DI].n
	CMP			AX,INACTIVO
	JZ			@SALIR

	CMP			AX,type(Sdim)
	JA			@SALIR

	LEA			SI,Sdim
	SHL			AX,3
	ADD			SI,AX

	MOV			AX,DS
	DW			MOV_GS_AX

	MOV			IncAlto,0
	MOV			IncY1,0
	MOV			IncY2,0

	MOV			DX,region.yul
	MOV			BX,ES:Tsprite[DI].y
	MOV			AX,BX
	ADD			AX,WORD(Tdim[SI].alto)
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			IncAlto,AL      {...dec(alto,abs(region.yul-y);}

	MOV			CX,WORD(Tdim[SI].ancho)
	SHR			CX,2
	IMUL		CX              {...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JGE			@SALIR

	MOV			AX,BX
	ADD			AX,WORD(Tdim[SI].alto)
	CMP			AX,DX   				{if y+alto>region.ylr then...}
	JL			@SIGUE_Y2
	SUB			AX,DX
	MOV			IncAlto,AL      {dec(alto,(y+alto)-region.ylr}

	MOV			CX,WORD(Tdim[SI].ancho)
	SHR			CX,2
	IMUL		CX              {inc(IncDir,region.ylr-(y+alto))*ancho}
	MOV			IncY2,AX

@SIGUE_Y2:
	MOV			AX,ES:Tsprite[DI].x
	PUSH		AX										{Guardo x}
	SHR			AX,2             	 		{x=x/4}
	ADD			BX,BX
	ADD			AX,WORD(MultBy80[BX]) {y=y*80}

	LES     DI,vRAM
	ADD			DI,AX             		{DI=x+y}

	MOV			BX,WORD(Tdim[SI].ancho)
	SHR			BX,2                  {ancho=ancho/4}
	MOV			BP,80
	SUB			BP,BX									{paso=320-ancho}
	MOV			paso,BP

	MOV			BH,BYTE(Tdim[SI].alto)
	SUB			BH,IncAlto
	MOV			tamanyo,BX        {BX=ancho y alto}
	MOV			PlanosRestantes,4

	LDS			SI,DWORD(Tdim[SI].Psprite)

	POP			CX                    {Recupero x}
	AND			CL,3
	MOV			AH,$11
	SHL			AH,CL         				{AH=plano actual}

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	OUT			DX,AL
	INC			DX

@PLANO:
	DB			GS;ADD			SI,IncY1
	PUSH		DI

	MOV			AL,AH
	OUT			DX,AL

	DB			GS;MOV			BH,BYTE(tamanyo+1)	{MOV BH,alto}

@Y:
	DB			$F,$B6,$CB	{CX=ancho/4		[MOVZX CX,BL]}
	REP			MOVSB

	DB			GS;ADD			DI,paso
	DEC			BH
	JNZ			@Y

	POP			DI                    {Recupera direccin inicial de escritura}
	ROL			AH,1
	ADC			DI,0									{Si el plano actual es el 4, pasamos a los
																{4 puntos del plano siguiente}
	DB			GS;ADD			SI,IncY2
	DB			GS;DEC			PlanosRestantes
	JNZ			@PLANO

@SALIR:
	POP			BP
	POP			DS
END;

procedure PutSpriteBack(var s:Tsprite);
var
	guarda:pointer;

begin
	guarda:=vRAM;
	vRAM:=ptr(SegA000,desplazamiento[BACK_PAGE]);

	PutSprite(s);
	vRAM:=guarda;
end;

function collision(var s1,s2:Tsprite):boolean;ASSEMBLER;
var
	x1,y1:integer;
	X1Ancho1,Y1Alto1:integer;

ASM
	PUSH			FALSE

	LES				DI,s1
	MOV				AX,ES:Tsprite[DI].n	{if n1=INACTIVO then exit}
	CMP				AX,INACTIVO
	JZ				@FIN

	CMP				AX,type(Sdim)
	JA				@FIN

	LEA				SI,Sdim
	SHL				AX,3
	ADD				SI,AX

	MOV				BX,Tdim[SI].ancho
	MOV				CX,Tdim[SI].alto

	MOV				AX,ES:Tsprite[DI].x
	MOV       x1,AX
	ADD				AX,BX
	MOV				X1Ancho1,AX

	MOV				AX,ES:Tsprite[DI].y
	MOV       y1,AX
	ADD				AX,CX
	MOV       Y1Alto1,AX

	LES				DI,s2
	MOV				AX,ES:Tsprite[DI].n	{if n2=INACTIVO then exit}
	CMP				AX,INACTIVO
	JZ				@FIN

	LEA				SI,Sdim
	SHL				AX,3
	ADD				SI,AX

	MOV				BX,Tdim[SI].ancho
	MOV				CX,Tdim[SI].alto

	MOV				AX,ES:Tsprite[DI].x
	MOV				SI,AX
	ADD				SI,BX

	MOV				DX,ES:Tsprite[DI].y
	MOV				DI,DX
	ADD				DI,CX

	CMP				X1Ancho1,AX
	JLE				@FIN

	CMP				SI,x1
	JLE				@FIN

	CMP      	Y1Alto1,DX
	JLE				@FIN

	CMP				DI,y1
	JLE				@FIN

	PUSH			TRUE

{	collision:=(x1+ancho1>x2) and (x2+ancho2>x1) and
					(y1+alto1>y2) and (y2+alto2>y1);}

@FIN:
	POP				AX
END;

end.
