unit AnimaC;

INTERFACE

const
	MAX_SPRITES=255;

type
	Tsprite=record
		grafico:pointer;
		ancho,alto,ancho1,alto1,
		x,y,x1,y1:integer;
		primera,activo:boolean;
		rutina,buffer:^byte;
		nada:word;
	end;

var
	sprite:array[0..MAX_SPRITES] of Tsprite;

procedure init(total:integer);
{inicializa el total de sprite}

procedure done;
{Acaba las animaciones}

procedure anima;
{anima los sprite}

IMPLEMENTATION

uses
	Mode13,MyDOS;

const
	inicializado:boolean=FALSE;
	TotalSprites:word=0;

var
	numero:integer;
	DirLast:word;

procedure init(total:integer);

	procedure compila(n:byte);
var
	salto,x,y:word;
	direccion:^word;
	guarda:pointer;

begin                    {6=MOV [SI+nn],xxxx}
	GetMem(sprite[n].rutina,(6*sprite[n].alto*sprite[n].ancho)+1);
	guarda:=sprite[n].rutina;
	direccion:=sprite[n].grafico;
	salto:=0;
	for y:=1 to sprite[n].alto do
		begin
			for x:=1 to sprite[n].ancho div 2 do
				begin
					sprite[n].rutina^:=$C7;inc(sprite[n].rutina);
					sprite[n].rutina^:=$84;inc(sprite[n].rutina);
					sprite[n].rutina^:=lo(salto);inc(sprite[n].rutina);
					sprite[n].rutina^:=hi(salto);inc(sprite[n].rutina);
					sprite[n].rutina^:=lo(direccion^);inc(sprite[n].rutina);
					sprite[n].rutina^:=hi(direccion^);inc(sprite[n].rutina);

					inc(direccion);
					inc(salto,2);		{MOV [SI+salto],WORD(direccion^)}
				end;

			inc(salto,320-sprite[n].ancho);
		end;

	sprite[n].rutina^:=$CB;	{RETF}
	sprite[n].rutina:=guarda;
end;

var
	n:integer;
	p:^byte;

begin
	for n:=1 to total do
		begin
			compila(n);
			GetMem(sprite[n].buffer,sprite[n].ancho*sprite[n].alto);
{			freemem(sprite[n].grafico,sprite[n].ancho*sprite[n].alto);}

			sprite[n].x1:=-32767;
			sprite[n].y1:=-32767;

			sprite[n].ancho1:=0;
			sprite[n].alto1:=1;

			sprite[n].primera:=TRUE;
		end;

	GetMem(p,64000);
	vRAM:=seg(p^);
	TotalSprites:=total;
	DirLast:=ofs(sprite[TotalSprites]);
end;

procedure anima;ASSEMBLER;
var
	_SI,_DS,_CX:word;

ASM
	MOV			DX,$3DA

@RASTER_LO:
	IN			AL,DX
	TEST		AL,8
	JZ			@RASTER_LO

@RASTER_HI:
	IN			AL,DX
	TEST		AL,8
	JNZ			@RASTER_HI

	MOV			CX,TotalSprites
	MOV			SI,DirLast  			{Offset del ltimo ndice del array}

	MOV			_CX,CX
	MOV			_SI,SI
	MOV			_DS,DS

@RECUPERA:
	TEST		Tsprite[SI].primera,NOT 0     {if sprite[num].primera then pinta}
	JZ			@SI

	TEST		Tsprite[SI].activo,NOT 0 			{if sprite[num].activo then}
	JZ			@SIGUIENTE_R

@SI:
	MOV			DX,Tsprite[SI].ancho1 				{DX=ancho1}
	MOV			CX,Tsprite[SI].alto1 					{CX=alto1}
	MOV			DI,Tsprite[SI].x1 						{DI=x1}
	MOV			BX,Tsprite[SI].y1 						{BX=y1}
	LDS			SI,Tsprite[SI].buffer      		{DS:SI=puntero al buffer}

	MOV			ES,_DS

	ADD			BX,BX
	ADD			DI,ES:WORD(MultBy320[BX])

	MOV			AH,CL													{AH=alto1}
	MOV			BX,320                        {BX=320-ancho1}
	SUB			BX,DX

	MOV			ES,ES:vRAM

@BUCLE_R:
	MOV			CX,DX
	SHR			CX,2
	REP			;DB _386;MOVSW
	MOV			CX,DX
	AND			CX,3
	REP			MOVSB

	ADD			DI,BX
	DEC			AH
	JNZ			@BUCLE_R

@SIGUIENTE_R:
	MOV			DS,_DS
	MOV     SI,_SI

	TEST		Tsprite[SI].activo,NOT 0
	JNZ			@SIGUE
	MOV			Tsprite[SI].primera,TRUE

@SIGUE:
	SUB			SI,TYPE(Tsprite)
	MOV			_SI,SI
	DEC			_CX
	JNZ			@RECUPERA

{---------------------------------------------------------------------}

		{Guarda los fondos en el buffer}

	MOV			CX,TotalSprites
	MOV			_CX,CX
	MOV			DI,DirLast
	MOV			_SI,DI

@GUARDA:
	TEST		Tsprite[DI].activo,NOT 0 			{if sprite[num].activo then}
	JZ			@SIGUIENTE_G

	MOV			DX,Tsprite[DI].ancho
	MOV			CX,Tsprite[DI].alto
	MOV			SI,Tsprite[DI].x       				{SI=x}
	MOV			BX,Tsprite[DI].y       				{BX=y}
	LES			DI,Tsprite[DI].buffer      		{ES:DI=puntero al buffer}

	ADD			BX,BX
	ADD			SI,WORD(MultBy320[BX])

	MOV			BX,320                      	{BX=320-ancho}
	SUB			BX,DX

	MOV			AH,CL      										{AH=alto}
	MOV			DS,vRAM

@BUCLE_G:
	MOV			CX,DX
	SHR			CX,2
	REP			;DB _386;MOVSW
	MOV			CX,DX
	AND			CX,3
	REP			MOVSB

	ADD			SI,BX
	DEC			AH
	JNZ			@BUCLE_G

@SIGUIENTE_G:
	MOV			DS,_DS
	MOV			DI,_SI
	SUB			DI,TYPE(Tsprite)
	MOV			_SI,DI
	DEC			_CX
	JNZ			@GUARDA

{---------------------------------------------------------------------}
		{Pinto todos los sprites}

	MOV			ES,_DS

	MOV			CX,TotalSprites
	MOV			DI,DirLast  									{Offset del ltimo ndice del array}
	MOV			DS,vRAM

@ESCRIBE:
	TEST		ES:Tsprite[DI].activo,NOT 0		{if sprite[num].activo then}
	JZ			@FIN

	MOV			BX,ES:Tsprite[DI].y       		{BX=Y}
	ADD			BX,BX

	MOV			SI,ES:Tsprite[DI].x       		{SI=X}
	ADD			SI,WORD(ES:MultBy320[BX])

	CALL		ES:Tsprite[DI].rutina

@FIN:
	TEST		ES:Tsprite[DI].activo,NOT 0  	{est activo?}
	JZ			@NO_ACTUALIZA

	MOV			AX,ES:Tsprite[DI].x    				{x1=x}
	MOV			ES:Tsprite[DI].x1,AX

	MOV			AX,ES:Tsprite[DI].y    				{y1=y}
	MOV			ES:Tsprite[DI].y1,AX

	MOV			AX,ES:Tsprite[DI].ancho    		{ancho1=ancho}
	MOV			ES:Tsprite[DI].ancho1,AX

	MOV			AX,ES:Tsprite[DI].alto    		{alto1=alto}
	MOV			ES:Tsprite[DI].alto1,AX

	MOV			ES:Tsprite[DI].primera,FALSE

@NO_ACTUALIZA:
	SUB			DI,TYPE(Tsprite)
	DEC			CX
	JNZ			@ESCRIBE

	MOV			DS,_DS
	MOV			DS,vRAM
	MOV			ES,SegA000
	XOR			DI,DI
	MOV			SI,DI
	MOV			CX,64000/4
	REP			;DB _386;MOVSW
	MOV			DS,_DS

@SALIR:
END;

procedure done;
var
	n:integer;

begin
	if not inicializado then exit;
	for n:=1 to TotalSprites do
		freemem(sprite[n].rutina,(6*sprite[n].ancho*sprite[n].alto)+1);
end;

var
	n:integer;

begin
	FillChar(sprite,SizeOf(sprite),0);
end.