unit Anima13;

INTERFACE

uses Mode13,colors;

const
	SPR_OFF=0;
	NO_ATRIBUTE=0;

	NO_TILE=0;

	A_ANI_FINISH=-1;
	A_HIDDEN_TILE=2;
	A_HAVE_ANI=4;
	A_ANI_AUTO=8;
	A_SOLID_TILE=16;
	A_CHILD_TILE=32;
	A_TRANSPARENT_TILE=128;

	MAX_SCROLLS=5;
	MAX_TILES_X=175;MAX_TILES_Y=175;
	MAX_TILES=255;
	MAX_TILE_SIZE=256;
	MAX_SPR=8190;

	C_NOP=0;
	C_UP=1;
	C_RIGHT=2;
	C_UP_RIGHT=3;
	C_DOWN=4;
	C_DOWN_RIGHT=6;
	C_LEFT=8;
	C_UP_LEFT=9;
	C_DOWN_LEFT=12;

	ShadowColor:byte=0;

type
	TForm=(F_NORMAL,F_CLIPPED,F_MASKED,F_MASKED_CLIPPED);
	TPos=(BACKGROUND,FOREGROUND,REPEAT_BACK,REPEAT_FRONT);

	TAni=record
		add:ShortInt;
		tiles:^ShortInt;				{0..-1}
	end;

	PMap=^TMap;

	TCallBack=procedure(m:PMap;x,y,a:integer;var ani:TAni);	{When the tile is not auto-movible this function is called}

	PCell=^TCell;
	TCell=record
		tile,atribute:byte;	{,data,child}
	end;

	TMap=record
		px,py,   						{x y pos of map}
		tx,ty,  	 					{tiles in x y of map}
		TotalTiles,   			{total tiles in map}
		TotalAnimationTiles,{Total tiles animations in map}
		dim,scale:integer; 	{Dim of tiles in map, escale in ^2 for fast shl/shr}
		sx,sy:word;         {size in pixels of map}
		position:TPos;      {Map in background or foreground}
		tiles:array[0..MAX_TILES] of pointer;
		ani:array[0..MAX_TILES] of TAni;
		map:array[0..MAX_TILES_Y,0..MAX_TILES_X] of TCell;
		CallBack:TCallBack;
	end;

	TSprite=record
		active:boolean;
		n,
		x,y,x1,y1,x2,y2,
		IncX,IncY,
		width,height,
		life:integer;
		points:LongInt;
		angle,radius:double;
		map:PMap;
	end;
	PSprite=^TSprite;

	TSprInfo=record
		width,height:word;
		PSprite:^byte;
	end;
	TASprInfo=array[0..MAX_SPR] of TSprInfo;

var
	SprInfo:^TASprInfo;
	TotalSpr:integer;

function init:boolean;
{Inicializa el sistema de sprites}
procedure done;
{Libera la memoria ocupada por la libera}

function NewMap(var m:PMap;p:TPos):boolean;
{Crea un nuevo mapa en background o foreground}
procedure FreeMap(var m:PMap);
{Destruye el mapa m}
function GetMapBack(n:integer):PMap;
{Devuelve el mapa n por detrs de los sprites}
function GetMapFront(n:integer):PMap;
{Devuelve el mapa n por delante de los sprites}
procedure ClearMap(m:PMap);
{Limpia el mapa}
procedure DecMap(m:PMap);
{Borra, pero no libera la memoria del mapa m}
function LoadMap(m:PMap;n:string;var p:Tpal):boolean;
{Carga el mapa n}
function SaveMap(m:PMap;n,fc:string):boolean;
{Salva el mapa fc=fichero de cromos}
procedure SetCallBack(m:PMap;p:TCallBack);

function GetAtribute(m:PMap;x,y:integer):integer;
{Devuelve el atributo del mapa}
procedure SetAtribute(m:PMap;x,y,a:integer);
{Pone el atributo del mapa}

function GetNumOfScrolls:integer;
{Devuelve el nmero de scrolls activos}
function GetNumOfScrollsBack:integer;
{Devuelve el nmero de scrolls activos detrs de los sprites}
function GetNumOfScrollsFront:integer;
{Devuelve el nmero de scrolls activos delante de los sprites}
procedure MakeScroll(m:PMap;NoTransparentMap:boolean);
{Hace un scroll desde ScrollX+320 y ScrollY+200}

function LoadTiles(m:PMap;s:string;var p:Tpal):boolean;
{Carga todos los cromos, si FALSE error en fichero}
procedure FreeTiles(var m:PMap);
{Libera todos los cromos}
procedure MakeCloneTiles(f,d:PMap);
{Activa los cromos de un mapa a otro}
function GetTileOfMap(n:string):string;
function LoadAniTiles(m:PMap;n:string):boolean;

procedure PutTile(m:PMap;x,y:integer;n:word);
{Pinta un cromo}
procedure PutTileClipped(m:PMap;x,y:integer;n:word);
{Pinta un cromo con clipping}
procedure PutTileMask(m:PMap;x,y:integer;n:word);
{Pinta un cromo con mscara}
procedure PutTileClippedMask(m:PMap;x,y:integer;n:word);
{Pinta un cromo con mscara y clipping}

procedure SetTile(m:PMap;x,y,t:integer);
{Devuelve el cromo del mapa}
function GetTile(m:PMap;x,y:integer):integer;
{Activa el cromo del mapa}

function SetSprite(var s:TSprite;n:integer):boolean;
function LoadSprites(s:string;var p:Tpal):boolean;
{Inicializa y carga la base de sprites}
function LoadMoreSprites(s:string;var p:Tpal):boolean;
{Carga ms sprites por encima de los cargados anteriormente}
procedure FreeSprites;
{Acaba y libera la memoria de los sprites}
function CaptureSprite(x1,y1,x2,y2:integer):integer;
{Captura un sprite de la pantalla y lo deja activo}
procedure FreeCaptureSprite(n:integer);
{Libera un sprite de la pantalla y lo deja activo como N}

procedure PutSprite(var s:TSprite;m:PMap);
{Escribe un grfico}
procedure PutSpriteClipped(var s:TSprite;m:PMap);
{Escribe un grfico con clipping}
procedure PutSpriteMask(var s:TSprite;m:PMap);
{Escribe un grfico con mscara}
procedure PutSpriteMaskClipped(var s:TSprite;m:PMap);
{Escribe un grfico con mscara y clipping}

procedure PutSpriteBack(var s:TSprite);
{Escribe un grfico en la pgina de fondo}
procedure PutSpriteClippedBack(var s:TSprite);
{Escribe un grfico con clipping en la pgina de fondo}
procedure PutSpriteMaskBack(var s:TSprite);
{Escribe un grfico con mscara en la pgina de fondo}
procedure PutSpriteMaskClippedBack(var s:TSprite);
{Escribe un grfico con mscara y clipping en la pgina de fondo}

procedure PutShadowSprite(var s:TSprite;m:PMap);
{Pinta el sprite en "ShadowColor"}
procedure PutShadowSpriteClipped(var s:TSprite;m:PMap);
{Pinta el sprite en "ShadowColor" con clipping}

function collision(var s1,s2:TSprite):integer;
{Si el sprite s1 y el sprite s2 han chocado}
function PixelCollision(var s1,s2:TSprite):boolean;
function InitCollision:boolean;
procedure DoneCollision;

procedure PutScaleSpriteClipped(n,x1,y1,x2,y2:integer);
{Pone el sprite n en la caja x1y1 x2y2}
procedure PutScaleSpriteClippedMask(n,x1,y1,x2,y2:integer);
{Pone el sprite n con mscara en la caja x1y1 x2y2}
procedure PutScaleSprite(n,x1,y1,x2,y2:integer);
{Pone el sprite n en la caja x1y1 x2y2}
procedure PutScaleSpriteMask(n,x1,y1,x2,y2:integer);
{Pone el sprite n con mscara en la caja x1y1 x2y2}

procedure PutBoxSprite(n,x,y,f:integer);
procedure PutBoxSpritemask(n,x,y,f:integer);

function AddAnimation(map:PMap;x,y:integer;key:pointer;f,sxi,syi:integer):integer;
function AddSeekAnimation(map:PMap;s,key:pointer;f:integer):integer;
function AddPingPongSeekAnimation(map:PMap;s,key:pointer;f:integer):integer;
function ProcessAnimations:integer;
function AnimationFinish(h:integer):boolean;
procedure ClearAnimations;
procedure DeleteAnimation(h:integer);

procedure PutSpriteOverScroll(var s:TSprite;f:TForm);
procedure OverScroll;

IMPLEMENTATION

uses
{$IFDEF _LZ_}
	LZFiles,
{$ELSE}
	{$IFDEF _RLE_}
	RLEFiles,
	{$ELSE}
	files,
{$ENDIF}
{$ENDIF}
	OP386,mem,MyDOS,speed;

const
	MAX_SPR_ANI=50;
	MAX_ANI_TILES=128;

	NScrolls:integer=0;
	NScrollsB:integer=0;
	NScrollsF:integer=0;

type
	TRMap=record
		magic:array[0..2] of char; {MAP}
		name:string[13];
		tx,ty:integer;
	end;

	PLSpr=^TLSpr;
	TLSpr=record
		x,y,n:integer;
		t:TForm;
		last:PLSpr;
	end;

var
	LastSpr,FirstSpr:PLSpr;

	DecHeight,
	IncLeft,IncRight,
	IncY1:integer;
	AMapF,AMapB:array[0..MAX_SCROLLS] of pointer;

	SprAni:array[0..MAX_SPR_ANI] of record
		t:(NORMAL,FOLLOW,PING_PONG);
		active:boolean;
		spr:TSprite;
		m:PMap;
		add,xi,yi,
		frames:integer;
		buffer:^integer;
		daddy:PSprite;
	end;

function init:boolean;
begin
	init:=GetMem(SprInfo,SizeOf(TASprInfo));
	FillChar(SprInfo^,SizeOf(TASprInfo),0);
end;

procedure done;
begin
	FreeMem(SprInfo,SizeOf(TASprInfo));
end;

function GetNumOfScrolls:integer;
begin
	GetNumOfScrolls:=NScrolls;
end;

function GetNumOfScrollsBack:integer;
begin
	GetNumOfScrollsBack:=NScrollsB;
end;

function GetNumOfScrollsFront:integer;
begin
	GetNumOfScrollsFront:=NScrollsF;
end;

function LoadAniTiles(m:PMap;n:string):boolean;{}
type
	TRTileAni=record
		magic:array[0..2] of char; {TILEANI}
		total:integer;
	end;

var
	f:TFile;
	a,t:integer;
	l:word;
	cab:TRTileAni;
	tmp:^ShortInt;

begin
	LoadAniTiles:=FALSE;
	if pos('.',n)=0 then n:=n+'.ANI';
	if open(f,n,RO)>0 then exit;

	read(f,cab,SizeOf(cab),l);
	if cab.magic<>'TILEANI' then
		begin
			close(f);
			exit;
		end;

	for a:=1 to cab.total do
		begin
			read(f,t,2,l);
			if not GetMem(m^.ani[a].tiles,t+1) then
				begin
					close(f);
					exit;
				end;
			m^.ani[a].add:=1;
			read(f,m^.ani[a].tiles^,t,l);
			tmp:=pointer(m^.ani[a].tiles);
			inc(tmp,t+1);
			tmp^:=A_ANI_FINISH;
		end;
	m^.TotalAnimationTiles:=cab.total;

	LoadAniTiles:=TRUE;
end;

procedure MakeAniTiles(m:PMap;x,y:integer;var ani:TAni);
var
	t:ShortInt;

begin
	if ani.tiles^=A_ANI_FINISH then
		begin
			ani.add:=-ani.add;
			inc(ani.tiles,ani.add);
		end;
	t:=ani.tiles^;
	m^.map[y,x].tile:=t;
end;

procedure FreeAniTiles(m:PMap);
var
	n:integer;
	tmp:^ShortInt;

begin
	with m^ do
		begin
			for n:=1 to TotalAnimationTiles do
				begin
					tmp:=pointer(ani[n].tiles);
					while tmp^<>A_ANI_FINISH do inc(tmp);
					FreeMem(ani[n].tiles,ofs(tmp)-ofs(ani[n].tiles));
				end;
			TotalAnimationTiles:=0;
		end;
end;

function NewMap(var m:PMap;p:TPos):boolean;
begin
	NewMap:=FALSE;

	if not GetMem(m,SizeOf(TMap)) then exit;
	with m^ do
		begin
			TotalTiles:=0;
			TotalAnimationTiles:=0;
			scale:=0;
			px:=0;py:=0;
			dim:=128;
			tx:=MAX_TILES_X;ty:=MAX_TILES_Y;
			sx:=(tx-1)*dim;sy:=(ty-1)*dim;
			position:=p;
			CallBack:=NIL;
			FillChar(ani,SizeOf(TAni),0);
		end;
	ClearMap(m);

	case p of
		BACKGROUND,REPEAT_BACK:
			begin
				inc(NScrollsB);
				AMapB[NScrollsB]:=m;
			end;

		FOREGROUND,REPEAT_FRONT:
			begin
				inc(NScrollsF);
				AMapF[NScrollsF]:=m;
			end;
	end;

	inc(NScrolls);

	NewMap:=TRUE;
end;

function GetMapBack(n:integer):PMap;
begin
	GetMapBack:=AMapB[n];
end;

function GetMapFront(n:integer):PMap;
begin
	GetMapFront:=AMapF[n];
end;

procedure ClearMap(m:PMap);
begin
	FillChar(m^.map,(MAX_TILES_X+1)*(MAX_TILES_Y+1)*SizeOf(TCell),0);
end;

procedure DecMap(m:PMap);
begin
	case m^.position of
		BACKGROUND,REPEAT_BACK:
			begin
				AMapB[NScrollsB]:=NIL;
				dec(NScrollsB);
			end;

		FOREGROUND,REPEAT_FRONT:
			begin
				AMapF[NScrollsF]:=NIL;
				dec(NScrollsF);
			end;
	end;
	dec(NScrolls);

	m^.TotalTiles:=0;
	m^.dim:=0;
	m^.scale:=0;
end;

procedure FreeMap(var m:PMap);
begin
	DecMap(m);

	FreeTiles(m);
	FreeMem(m,SizeOf(TMap));
end;

function LoadMap(m:PMap;n:string;var p:Tpal):boolean;
var
	f:TFile;
	i,l:word;
	cab:TRMap;

begin
	LoadMap:=FALSE;

	if pos('.',n)=0 then n:=n+'.MAP';
	if open(f,n,RO)>0 then exit;
	read(f,cab,SizeOf(cab),l);
	if (cab.magic<>'MAP') or (not LoadTiles(m,cab.name,p)) then
		begin
			close(f);
			exit;
		end;

	with m^ do
		begin
			tx:=cab.tx;ty:=cab.ty;
			sx:=tx*dim;sy:=ty*dim;
		end;
	ClearMap(m);
	for i:=0 to m^.ty do read(f,m^.map[i,0],m^.tx*SizeOf(TCell),l);

	close(f);
	LoadMap:=TRUE;
end;

function SaveMap(m:PMap;n,fc:string):boolean;
var
	f:TFile;
	i,l:word;
	cab:TRMap;

begin
	SaveMap:=FALSE;

	if ReWrite(f,n)>0 then exit;
	cab.magic:='MAP';
	cab.name:=fc;
	cab.tx:=m^.tx;cab.ty:=m^.ty;
	write(f,cab,SizeOf(cab),l);
	for i:=0 to m^.ty do write(f,m^.map[i,0],m^.tx*SizeOf(TCell),l);
	close(f);

	SaveMap:=TRUE;
end;

procedure SetCallBack(m:PMap;p:TCallBack);
begin
	m^.CallBack:=p;
end;

procedure MakeScroll(m:PMap;NoTransparentMap:boolean);
var
	cell:PCell;
	d,e,
	ClipX,ClipY,
	i,j,ii,
	x,y,gx:integer;

begin
	with m^ do
		begin
			d:=dim;
			e:=scale;

			i:=px shr e;
			gx:=-px+(i shl e);
			if (position in [REPEAT_BACK,REPEAT_FRONT]) and (abs(i)>=tx) then i:=i mod m^.tx;
			ii:=i;
			ClipX:=region.xlr-d;

			j:=py shr e;
			y:=-py+(j shl e);
			if (position in [REPEAT_BACK,REPEAT_FRONT]) and (abs(j)>=ty) then j:=j mod m^.ty;
			ClipY:=region.ylr-d;

			repeat
				x:=gx;
				repeat
					cell:=@map[j,i];
					if cell^.tile<>NO_TILE then
						if (word(x)<ClipX) and (word(y)<ClipY) then
							if (cell^.atribute<A_TRANSPARENT_TILE) or (NoTransparentMap) then
								PutTile(m,x,y,cell^.tile)
							else
								PutTileMask(m,x,y,cell^.tile)
						else
							if (cell^.atribute<A_TRANSPARENT_TILE) or (NoTransparentMap) then
								PutTileClipped(m,x,y,cell^.tile)
							else
								PutTileClippedMask(m,x,y,cell^.tile);

					inc(i);
					if (position in [REPEAT_BACK,REPEAT_FRONT]) and (i>=tx) then i:=0;
					inc(x,d);
				until x>region.xlr;
				i:=ii;
				inc(j);
				if (position in [REPEAT_BACK,REPEAT_FRONT]) and (j>=ty) then j:=0;
				inc(y,d);
			until y>region.ylr;
		end;
end;

function GetAtribute(m:PMap;x,y:integer):integer;
begin
	with m^ do GetAtribute:=map[y shr scale,x shr scale].atribute and 127;
end;

procedure SetAtribute(m:PMap;x,y,a:integer);
begin
	with m^ do map[y shr scale,x shr scale].atribute:=a;
end;

function LoadTiles(m:PMap;s:string;var p:TPal):boolean;
type
	TRTile=record
		magic:array[0..3] of char; {TILE}
		total,dim:integer;
		pal:Tpal;
	end;

var
	f:TFile;
	n,l,dim:word;
	cab:TRTile;

begin
	LoadTiles:=FALSE;

	if pos('.',s)=0 then s:=s+'.TIL';
	if open(f,s,RO)>0 then exit;

	read(f,cab,SizeOf(cab),l);
	if (cab.magic<>'TILE') or (cab.dim>MAX_TILE_SIZE) or
		 (cab.total>MAX_TILES) then
		begin
			close(f);
			exit;
		end;
	p:=cab.pal;

	m^.TotalTiles:=cab.total;
	m^.dim:=cab.dim;
	m^.tx:=MAX_TILES_X;
	m^.ty:=MAX_TILES_Y;
	m^.sx:=(m^.tx-1)*m^.dim;
	m^.sy:=(m^.ty-1)*m^.dim;

	n:=FindShl(m^.dim);
	if n=-1 then
		begin
			close(f);
			exit;
		end;

	m^.scale:=n;
	dim:=sqr(m^.dim);
	for n:=1 to m^.TotalTiles do
		begin
			if not GetMem(m^.tiles[n],dim+m^.dim) then	{Una lnea ms por historias de clipping optimizado :)}
				begin
					close(f);
					exit;
				end;
			read(f,m^.tiles[n]^,dim,l);
		end;
	close(f);

	LoadTiles:=TRUE;
end;

procedure FreeTiles(var m:PMap);
var
	n:integer;

begin
	for n:=1 to m^.TotalTiles do FreeMem(m^.tiles[n],sqr(m^.dim)+m^.dim);
	m^.TotalTiles:=0;
	m^.dim:=0;
	m^.scale:=0;
end;

procedure SetTile(m:PMap;x,y,t:integer);
begin
	with m^ do map[y shr scale,x shr scale].tile:=t;
end;

function GetTile(m:PMap;x,y:integer):integer;
begin
	with m^ do GetTile:=map[y shr scale,x shr scale].tile;
end;

procedure MakeCloneTiles(f,d:PMap);
var
	a:integer;

begin
	d^.TotalTiles:=f^.TotalTiles;
	d^.dim:=f^.dim;
	for a:=1 to f^.TotalTiles do d^.tiles[a]:=f^.tiles[a];
end;

function GetTileOfMap(n:string):string;
var
	f:TFile;
	cab:TRMap;
	l:word;

begin
	GetTileOfMap:='';
	if open(f,n,RO)>0 then exit;
	read(f,cab,SizeOf(cab),l);
	close(f);
	GetTileOfMap:=cab.name;
end;

function SetSprite(var s:TSprite;n:integer):boolean;
begin
	SetSprite:=FALSE;
	with SprInfo^[n] do
		begin
			if PSprite=NIL then exit;
			s.width:=width;
			s.height:=height;
			s.n:=n;
			s.active:=TRUE;
		end;
	SetSprite:=TRUE;
end;

function LoadSprites(s:string;var p:Tpal):boolean;
type
	TRSpr=record
		magic:array[0..2] of char; {SPR}
		total:integer;
		pal:Tpal;
	end;

var
	m,l,d:word;
	f:TFile;
	cab:TRSpr;

begin
	LoadSprites:=FALSE;

	if pos('.',s)=0 then s:=s+'.SPR';
	if open(f,s,RO)>0 then exit;

	read(f,cab,SizeOf(cab),d);
	if cab.magic<>'SPR' then
		begin
			close(f);
			exit;
		end;
	p:=cab.pal;
	TotalSpr:=cab.total;
	for m:=1 to TotalSpr do with SprInfo^[m] do
		begin
			read(f,width,2,d);
			read(f,height,2,d);
			l:=width*height;
			if l=0 then continue;
			if not GetMem(PSprite,l+width) then	{Una lnea ms por razones dispares}
				begin
					close(f);
					exit;
				end;
			read(f,PSprite^,l,d);
		end;
	close(f);

	LoadSprites:=TRUE;
end;

function LoadMoreSprites(s:string;var p:Tpal):boolean;
type
	TRSpr=record
		magic:array[0..2] of char; {SPR}
		total:integer;
		pal:Tpal;
	end;

var
	m,l,d:word;
	f:TFile;
	cab:TRSpr;

begin
	LoadMoreSprites:=FALSE;

	if pos('.',s)=0 then s:=s+'.SPR';
	if open(f,s,RO)>0 then exit;

	read(f,cab,SizeOf(cab),d);
	if cab.magic<>'SPR' then
		begin
			close(f);
			exit;
		end;
	p:=cab.pal;
	for m:=TotalSpr to TotalSpr+cab.total do with SprInfo^[m] do
		begin
			read(f,width,2,d);
			read(f,height,2,d);
			l:=width*height;
			if l=0 then continue;
			if not GetMem(PSprite,l+width) then	{Una lnea ms por razones dispares}
				begin
					close(f);
					exit;
				end;
			read(f,PSprite^,l,d);
		end;
	close(f);
	inc(TotalSpr,cab.total);

	LoadMoreSprites:=TRUE;
end;

procedure FreeSprites;
var
	n:integer;

begin
	for n:=1 to TotalSpr do with SprInfo^[n] do FreeMem(PSprite,(width*height)+width);
end;

function CaptureSprite(x1,y1,x2,y2:integer):integer;
var
	n,width,height:integer;

begin
	CaptureSprite:=-1;

	n:=TotalSpr+1;
	while SprInfo^[n].PSprite<>NIL do inc(n);
	with SprInfo^[n] do
		begin
			width:=x2-x1;height:=y2-y1+1;
			inc(width,width mod 4);
			if not GetMem(PSprite,(width*height)+height) then exit;
		end;

	ASM
		PUSH	DS

		MOV		AX,n
		SHL		AX,3
		LES		DI,SprInfo
		ADD		DI,AX
		MOV		BX,ES:TSprInfo[DI].width
		MOV		DX,ES:TSprInfo[DI].height
		LES		DI,ES:TSprInfo[DI].PSprite

		MOV		SI,y1
		ADD		SI,SI
		MOV		SI,WORD(MultByWidth[SI])
		ADD		SI,x1
		MOV		DS,vRAM

		MOV		AX,320
		SUB		AX,BX

@Y:
		MOV		CX,BX
		SHR		CX,2
		REP;	DB _386;MOVSW    {REP MOVSD}
		ADD		SI,AX

		DEC		DX
		JNZ		@Y

		POP		DS
	END;

	CaptureSprite:=n;
end;

procedure FreeCaptureSprite(n:integer);
begin
	with SprInfo^[n] do
		begin
			FreeMem(PSprite,width*height);
			PSprite:=NIL;
		end;
end;

procedure PutTile(m:PMap;x,y:integer;n:word);ASSEMBLER;
ASM
	MOV			DX,n
{	CMP			DX,TYPE(tiles)/4
	JA			@SALIR{}

	LES			DI,m
	MOV		 	AX,ES:TMap[DI].dim
	LEA		 	SI,ES:TMap[DI].tiles
	SHL			DX,2
	ADD			SI,DX

	MOV			DI,x
	MOV			BX,y
	ADD			BX,BX
	ADD			DI,WORD(MultByWidth[BX])

	MOV			BX,320
	SUB			BX,AX
	MOV			AH,AL

	MOV			CX,vRAM

	PUSH		DS
	LDS		 	SI,ES:[SI]
	MOV			ES,CX

	MOV			CH,0

@Y:                  {ALIGN 16}
	MOV			CL,AH
	SHR			CL,2
	REP;		DB _386;MOVSW   {REP MOVSD}

	ADD			DI,BX
	DEC			AL
	JNZ     @Y

	POP			DS

@SALIR:
END;

procedure PutTileMask(m:PMap;x,y:integer;n:word);ASSEMBLER;
ASM
	MOV			AX,n
{	CMP			AX,TYPE(tiles)/4
	JA			@SALIR}

	LES			DI,m
	MOV		 	DX,ES:TMap[DI].dim
	LEA		 	SI,ES:TMap[DI].tiles
	SHL			AX,2
	ADD			SI,AX

	MOV			DI,x
	MOV			BX,y
	ADD			BX,BX
	ADD			DI,WORD(MultByWidth[BX])

	MOV			BX,320
	SUB			BX,DX
	MOV			DH,DL

	MOV			CX,vRAM

	PUSH		DS
	LDS		 	SI,ES:[SI]
	MOV			ES,CX

@Y:                  {ALIGN 16}
	MOV			CL,DH

@X:
	MOV			AL,[SI]
	INC			SI
	TEST		AL,AL
	JZ			@CERO
	MOV			ES:[DI],AL

@CERO:
	INC			DI
	DEC			CL
	JNZ			@X

	ADD			DI,BX
	DEC			DL
	JNZ     @Y

	POP			DS

@SALIR:
END;

procedure PutTileClipped(m:PMap;x,y:integer;n:word);ASSEMBLER;
var
	d:integer;
	e:byte;

ASM
	PUSH		DS
	PUSH		BP

	MOV			BX,n
{	CMP			BX,TYPE(tiles)/4
	JA			@SALIR}

	MOV			AX,0
	MOV			DecHeight,AX
	MOV			IncY1,AX
	MOV			IncLeft,AX
	MOV			IncRight,AX

	LES			DI,m
	LEA			SI,ES:TMap[DI].tiles
	SHL			BX,2
	ADD			SI,BX

	MOV			AX,ES:TMap[DI].dim
	MOV			d,AX
	MOV			AX,ES:TMap[DI].scale
	MOV			e,AL

	MOV			DX,region.xul
	MOV			CX,x
	MOV			AX,CX
	ADD			AX,d
	CMP			AX,DX						{if x+ancho<region.xul then goto fin}
	JLE			@SALIR

	CMP			CX,DX   				{if x<region.xul then...}
	JGE			@SIGUE_X1

	MOV			AX,DX           {x:=region.xul;}
	SUB			AX,CX
	MOV			IncLeft,AX    {...dec(ancho,abs(region.xul-x);}

	MOV			CX,DX						{CX=x=region.xul}
	JMP			@SIGUE_X2

@SIGUE_X1:
	MOV			DX,region.xlr
	CMP			CX,DX   				{if x>region.xlr then goto fin}
	JGE			@SALIR

	CMP			AX,DX   				{if x+ancho>region.xlr then...}
	JL			@SIGUE_X2
	SUB			AX,DX
	MOV			IncRight,AX   	{dec(ancho,(x+ancho)-region.xlr}

@SIGUE_X2:
	MOV			DX,region.yul
	MOV			BX,y
	MOV			AX,BX
	ADD			AX,d
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			DecHeight,AX      {...dec(alto,abs(region.yul-y);}
	MOV			DL,CL
	MOV			CL,e
	SHL			AX,CL
	MOV			CL,DL						{...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JG			@SALIR

	MOV			AX,BX
	ADD			AX,d
	CMP			AX,DX   				{if y+alto>region.ylr then...}
	JLE			@SIGUE_Y2
	SUB			AX,DX
	DEC			AX
	MOV			DecHeight,AX 		{dec(alto,(y+alto)-region.ylr}
	JMP			@SIGUE_Y2

@SIGUE_Y2:      {BX=y, CX=x}
	MOV			AX,d
	SUB			AX,DecHeight
	JLE			@SALIR

	ADD			BX,BX
	MOV			DI,CX
	ADD			DI,WORD(MultByWidth[BX])

	MOV			BX,d
	SUB			BX,IncLeft
	SUB			BX,IncRight
	MOV			AH,BL

	MOV			BP,320
	SUB			BP,BX

	MOV			BX,IncLeft
	ADD			BX,IncRight

	MOV			CX,IncY1
	ADD			CX,IncLeft

	MOV			DX,vRAM
	LDS			SI,ES:[SI]
	ADD			SI,CX
	MOV			ES,DX

	MOV			CH,0

@Y:                  				{ALIGN 16}
	MOV			CL,AH

	MOV			DL,CL
	AND			DL,3
	SHR			CX,2
	REP;		DB _386;MOVSW    	{REP MOVSD}
	MOV			CL,DL
	REP			MOVSB

	ADD			SI,BX
	ADD			DI,BP
	DEC			AL
	JNZ     @Y

@SALIR:
	POP			BP
	POP			DS
END;

procedure PutTileClippedMask(m:PMap;x,y:integer;n:word);ASSEMBLER;
var
	d:integer;
	e:byte;

ASM
	MOV			BX,n
{	CMP			BX,TYPE(tiles)/4
	JA			@SALIR}

	PUSH		DS
	PUSH		BP

	MOV			AX,0
	MOV			DecHeight,AX
	MOV			IncY1,AX
	MOV			IncLeft,AX
	MOV			IncRight,AX

	LES			DI,m
	LEA			SI,ES:TMap[DI].tiles
	SHL			BX,2
	ADD			SI,BX

	MOV			AX,ES:TMap[DI].dim
	MOV			d,AX
	MOV			AX,ES:TMap[DI].scale
	MOV			e,AL

	MOV			DX,region.xul
	MOV			CX,x
	MOV			AX,CX
	ADD			AX,d
	CMP			AX,DX						{if x+ancho<region.xul then goto fin}
	JLE			@SALIR

	CMP			CX,DX   				{if x<region.xul then...}
	JGE			@SIGUE_X1

	MOV			AX,DX           {x:=region.xul;}
	SUB			AX,CX
	MOV			IncLeft,AX    {...dec(ancho,abs(region.xul-x);}

	MOV			CX,DX						{CX=x=region.xul}
	JMP			@SIGUE_X2

@SIGUE_X1:
	MOV			DX,region.xlr
	CMP			CX,DX   				{if x>region.xlr then goto fin}
	JGE			@SALIR

	CMP			AX,DX   				{if x+ancho>region.xlr then...}
	JL			@SIGUE_X2
	SUB			AX,DX
	MOV			IncRight,AX   	{dec(ancho,(x+ancho)-region.xlr}

@SIGUE_X2:
	MOV			DX,region.yul
	MOV			BX,y
	MOV			AX,BX
	ADD			AX,d
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			DecHeight,AX      {...dec(alto,abs(region.yul-y);}
	MOV			DL,CL
	MOV			CL,e
	SHL			AX,CL
	MOV			CL,DL						{...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JG			@SALIR

	MOV			AX,BX
	ADD			AX,d
	CMP			AX,DX   				{if y+alto>region.ylr then...}
	JLE			@SIGUE_Y2
	SUB			AX,DX
	DEC			AX
	MOV			DecHeight,AX  		{dec(alto,(y+alto)-region.ylr}
	JMP			@SIGUE_Y2

@SIGUE_Y2:      {BX=y, CX=x}
	MOV			AX,d
	SUB			AX,DecHeight
	JLE			@SALIR
	MOV			AH,AL

	ADD			BX,BX
	MOV			DI,CX
	ADD			DI,WORD(MultByWidth[BX])

	MOV			BX,d
	SUB			BX,IncLeft
	SUB			BX,IncRight

	MOV			BP,320
	SUB			BP,BX

	MOV			DX,IncLeft
	ADD			DX,IncRight

	MOV			CX,IncY1
	ADD			CX,IncLeft

	PUSH		vRAM
	LDS			SI,ES:[SI]
	ADD			SI,CX
	POP			ES

@Y:                  {ALIGN 16}
	MOV			CL,BL

@X:
	MOV			AL,[SI]
	INC			SI
	TEST		AL,AL
	JZ			@CERO
	MOV			ES:[DI],AL

@CERO:
	INC			DI
	DEC			CL
	JNZ			@X

	ADD			SI,DX
	ADD			DI,BP
	DEC			AH
	JNZ     @Y

@SALIR:
	POP			BP
	POP			DS
END;

procedure PutSprite(var s:TSprite;m:PMap);ASSEMBLER;
ASM
	LES			DI,s
	CMP			ES:TSprite[DI].active,FALSE
	JZ			@SALIR
	MOV			AX,ES:TSprite[DI].n

	MOV			CX,0
	MOV			DX,CX
	DB			_386;MOV		 BX,WORD(m)
	DB			_386;MOV		 WORD(ES:TSprite[DI].map),BX
	DB			_386;TEST		 BX,BX
	JZ			@NO_SCROLL

	PUSH		ES
	LES			SI,m
	MOV			CX,ES:TMap[SI].py
	MOV			DX,ES:TMap[SI].px
	POP			ES

@NO_SCROLL:
	MOV			BX,ES:TSprite[DI].y
	SUB			BX,CX

	MOV			DI,ES:TSprite[DI].x
	SUB			DI,DX

	ADD			BX,BX
	ADD			DI,WORD(MultByWidth[BX])

	LES			SI,SprInfo
	SHL			AX,3
	ADD			SI,AX

	MOV			AX,ES:TSprInfo[SI].height
	MOV			BX,ES:TSprInfo[SI].width

	PUSH		DS
	PUSH		BP

	MOV			BP,320
	SUB			BP,BX

	MOV			CX,vRAM
	LDS			SI,ES:TSprInfo[SI].PSprite
	MOV			ES,CX

@Y:                  {ALIGN 16}
	MOV			CX,BX

	MOV			DL,CL
	AND			DL,3
	SHR			CX,2
	REP;		DB _386;MOVSW    {REP MOVSD}
	MOV			CL,DL
	REP			MOVSB

	ADD			DI,BP
	DEC			AX
	JNZ     @Y

	POP			BP
	POP			DS

@SALIR:
END;

procedure PutSpriteClipped(var s:TSprite;m:PMap);ASSEMBLER;
var
	ScrollX,ScrollY:integer;

ASM
	PUSH		BP
	LES			DI,s
	CMP			ES:TSprite[DI].active,FALSE
	JZ			@SALIR

	MOV			BX,ES:TSprite[DI].n
	PUSH		BX

	MOV			CX,0
	MOV			DecHeight,CX
	MOV			IncY1,CX
	MOV			IncLeft,CX
	MOV			IncRight,CX
	MOV			AX,CX
	MOV			DX,CX
	DB			_386;MOV		 BX,WORD(m)
	DB			_386;MOV		 WORD(ES:TSprite[DI].map),BX
	DB			_386;TEST		 BX,BX
	JZ			@NO_SCROLL

	PUSH		ES
	LES			SI,m
	MOV			AX,ES:TMap[SI].py
	MOV			DX,ES:TMap[SI].px
	POP			ES

@NO_SCROLL:
	MOV			ScrollY,AX
	MOV			ScrollX,DX

	MOV			AX,WORD(SprInfo+2)
	DW			MOV_GS_AX
	MOV			SI,WORD(SprInfo)
	POP			BX
	SHL			BX,3
	ADD			SI,BX

	MOV			DX,region.xul
	MOV			CX,ES:TSprite[DI].x
	SUB			CX,ScrollX

	MOV			AX,CX
	DB			GS;ADD		AX,TSprInfo[SI].width
	CMP			AX,DX						{if x+ancho<region.xul then goto fin}
	JLE			@SALIR

	CMP			CX,DX   				{if x<region.xul then...}
	JGE			@SIGUE_X1

	MOV			AX,DX           {x:=region.xul;}
	SUB			AX,CX
	MOV			IncLeft,AX     {...dec(ancho,abs(region.xul-x);}

	MOV			CX,DX						{CX=x=region.xul}
	JMP			@SIGUE_X2

@SIGUE_X1:
	MOV			DX,region.xlr
	CMP			CX,DX   				{if x>region.xlr then goto fin}
	JGE			@SALIR

	CMP			AX,DX   				{if x+ancho>region.xlr then...}
	JL			@SIGUE_X2
	SUB			AX,DX
	MOV			IncRight,AX   	{dec(ancho,(x+ancho)-region.xlr}

@SIGUE_X2:
	MOV			DX,region.yul
	MOV			BX,ES:TSprite[DI].y
	SUB			BX,ScrollY

	MOV			AX,BX
	DB			GS;ADD		AX,TSprInfo[SI].height
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			DecHeight,AX      {...dec(alto,abs(region.yul-y);}
	DB			GS;MOV		BP,TSprInfo[SI].width
	IMUL		BP              {...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JGE			@SALIR

	MOV			AX,BX
	DB			GS;ADD		AX,TSprInfo[SI].height
	CMP			AX,DX   				{if y+alto>region.ylr then...}
	JLE			@SIGUE_Y2
	SUB			AX,DX
	DEC			AX
	MOV			DecHeight,AX  		{dec(alto,(y+alto)-region.ylr}
	JMP			@SIGUE_Y2

@SIGUE_Y2:      {BX=y, CX=x}
	DB			GS;MOV		AX,TSprInfo[SI].height
	SUB			AX,DecHeight
	JLE			@SALIR
	MOV			DI,CX

	ADD			BX,BX
	ADD			DI,WORD(MultByWidth[BX])

	DB			GS;MOV		BX,TSprInfo[SI].width
	SUB			BX,IncLeft
	SUB			BX,IncRight
	MOV			BP,320
	SUB			BP,BX

	{$IFDEF __BPPROT__}
	MOV			CX,CS
	ADD			CX,SelectorInc
	MOV			ES,CX
	MOV			CX,IncLeft
	ADD			CX,IncRight
	MOV			WORD(ES:@I_LR+2),CX
	{$ELSE}
	MOV			CX,IncLeft
	ADD			CX,IncRight
	MOV			WORD(CS:@I_LR+2),CX
	{$ENDIF}

	MOV			CX,IncY1
	ADD			CX,IncLeft

	MOV			ES,vRAM
	PUSH		DS
	DB			GS;LDS		SI,TSprInfo[SI].PSprite
	ADD			DI,CX

@Y:                  {ALIGN 16}
	MOV			CX,BX

	MOV			DL,CL
	AND			DL,3
	SHR			CX,2
	REP;		DB _386;MOVSW    {REP MOVSD}
	MOV			CL,DL
	REP			MOVSB

@I_LR:
	ADD			SI,$FFFF
	ADD			DI,BP
	DEC			AX
	JNZ     @Y

	POP			DS

@SALIR:
	POP			BP
END;

procedure PutSpriteMask(var s:TSprite;m:PMap);ASSEMBLER;
ASM
	LES			DI,s
	CMP			ES:TSprite[DI].active,FALSE
	JZ			@SALIR

	MOV			AX,ES:TSprite[DI].n
(*	CMP			AX,TYPE(SprInfo)/TYPE(TSprInfo) {if n>TotalSprites then goto fin}
	JA			@SALIR*)
	PUSH		DS
	PUSH		BP

	MOV			CX,0
	MOV			DX,CX
	DB			_386;MOV		 BX,WORD(m)
	DB			_386;MOV		 WORD(ES:TSprite[DI].map),BX
	DB			_386;TEST		 BX,BX
	JZ			@NO_SCROLL

	PUSH		ES
	LES			SI,m
	MOV			CX,ES:TMap[SI].py
	MOV			DX,ES:TMap[SI].px
	POP			ES

@NO_SCROLL:
	MOV			BP,ES:TSprite[DI].y
	SUB			BP,CX
	MOV			DI,ES:TSprite[DI].x
	SUB			DI,DX

	ADD			BP,BP
	ADD			DI,WORD(DS:MultByWidth[BP])

	LES			SI,SprInfo
	SHL			AX,3
	ADD			SI,AX
	MOV			BX,ES:TSprInfo[SI].height
	MOV			DX,ES:TSprInfo[SI].width
	MOV			BP,320
	SUB			BP,DX

	MOV			CX,vRAM
	LDS			SI,ES:TSprInfo[SI].PSprite
	MOV			ES,CX

@Y:
	MOV			CX,DX

@X:               {ALIGN 16}
	MOV			AL,[SI]
	INC			SI
	TEST		AL,AL
	JZ			@CERO
	MOV			ES:[DI],AL

@CERO:
	INC			DI
	DEC			CX
	JNZ			@X

	ADD			DI,BP
	DEC			BX
	JNZ     @Y

	POP			BP
	POP			DS

@SALIR:
END;

procedure PutSpriteMaskClipped(var s:TSprite;m:PMap);ASSEMBLER;
var
	ScrollX,ScrollY:integer;

ASM
	PUSH		BP
	LES			DI,s
	CMP			ES:TSprite[DI].active,FALSE
	JZ			@SALIR

	MOV			DX,ES:TSprite[DI].n

	MOV			CX,0
	MOV			ScrollX,CX
	MOV			ScrollY,CX
	MOV			DecHeight,CX
	MOV			IncY1,CX
	MOV			IncLeft,CX
	MOV			IncRight,CX
	DB			_386;MOV		 BX,WORD(m)
	DB			_386;MOV		 WORD(ES:TSprite[DI].map),BX
	DB			_386;TEST		 BX,BX
	JZ			@NO_SCROLL

	PUSH		ES
	LES			SI,m
	MOV			AX,ES:TMap[SI].py
	MOV			ScrollY,AX
	MOV			AX,ES:TMap[SI].px
	MOV			ScrollX,AX
	POP			ES

@NO_SCROLL:
	MOV			AX,WORD(SprInfo+2)
	DW			MOV_GS_AX
	MOV			SI,WORD(SprInfo)
	SHL			DX,3
	ADD			SI,DX

	MOV			DX,region.xul
	MOV			CX,ES:TSprite[DI].x
	SUB			CX,ScrollX
	MOV			AX,CX
	DB			GS;ADD		AX,TSprInfo[SI].width
	CMP			AX,DX						{if x+ancho<region.xul then goto fin}
	JLE			@SALIR

	CMP			CX,DX   				{if x<region.xul then...}
	JGE			@SIGUE_X1

	MOV			AX,DX           {x:=region.xul;}
	SUB			AX,CX
	MOV			IncLeft,AX     {...dec(ancho,abs(region.xul-x);}

	MOV			CX,DX						{CX=x=region.xul}
	JMP			@SIGUE_X2

@SIGUE_X1:
	MOV			DX,region.xlr
	CMP			CX,DX   				{if x>region.xlr then goto fin}
	JGE			@SALIR

	CMP			AX,DX   				{if x+ancho>region.xlr then...}
	JL			@SIGUE_X2
	SUB			AX,DX
	MOV			IncRight,AX   	{dec(ancho,(x+ancho)-region.xlr}

@SIGUE_X2:
	MOV			DX,region.yul
	MOV			BX,ES:TSprite[DI].y
	SUB			BX,ScrollY
	MOV			AX,BX
	DB			GS;ADD		AX,TSprInfo[SI].height
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			DecHeight,AX      {...dec(alto,abs(region.yul-y);}
	DB			GS;MOV		BP,TSprInfo[SI].width
	IMUL		BP              {...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JGE			@SALIR

	MOV			AX,BX
	DB			GS;ADD		AX,TSprInfo[SI].height
	CMP			AX,DX   				{if y+alto>region.ylr then...}
	JLE			@SIGUE_Y2
	SUB			AX,DX
	DEC			AX
	MOV			DecHeight,AX  		{dec(alto,(y+alto)-region.ylr}
	JMP			@SIGUE_Y2

@SIGUE_Y2:      {BX=y, CX=x}
	DB			GS;MOV		DX,TSprInfo[SI].height
	SUB			DX,DecHeight
	JLE			@SALIR

	ADD			BX,BX
	MOV			DI,CX
	ADD			DI,WORD(MultByWidth[BX])

	DB			GS;MOV		BX,TSprInfo[SI].width
	SUB			BX,IncLeft
	SUB			BX,IncRight
	MOV			BP,320
	SUB			BP,BX

	{$IFDEF __BPPROT__}
	MOV			CX,CS
	ADD			CX,SelectorInc
	MOV			ES,CX
	MOV			CX,IncLeft
	ADD			CX,IncRight
	MOV			WORD(ES:@I_LR+2),CX
	{$ELSE}
	MOV			CX,IncLeft
	ADD			CX,IncRight
	MOV			WORD(CS:@I_LR+2),CX
	{$ENDIF}

	MOV			CX,IncY1
	ADD     CX,IncLeft
	MOV			ES,vRAM
	PUSH		DS
	DB			GS;LDS		SI,TSprInfo[SI].PSprite
	ADD			SI,CX

@Y:
	MOV			CX,BX

@X:               {ALIGN 16}
	MOV			AL,[SI]
	INC			SI
	TEST		AL,AL
	JZ			@CERO
	MOV			ES:[DI],AL

@CERO:
	INC			DI
	DEC			CX
	JNZ			@X

@I_LR:
	ADD			SI,$FFFF
	ADD			DI,BP
	DEC			DX
	JNZ     @Y

	POP			DS

@SALIR:
	POP			BP
END;

procedure PutSpriteBack(var s:TSprite);
var
	g:word;

begin
	g:=vRAM;
	vRAM:=BackPage;
	PutSprite(s,NIL);
	vRAM:=g;
end;

procedure PutSpriteMaskBack(var s:TSprite);
var
	g:word;

begin
	g:=vRAM;
	vRAM:=BackPage;
	PutSpriteMask(s,NIL);
	vRAM:=g;
end;

procedure PutSpriteClippedBack(var s:TSprite);
var
	g:word;

begin
	g:=vRAM;
	vRAM:=BackPage;
	PutSpriteClipped(s,NIL);
	vRAM:=g;
end;

procedure PutSpriteMaskClippedBack(var s:TSprite);
var
	g:word;

begin
	g:=vRAM;
	vRAM:=BackPage;
	PutSpriteMaskClipped(s,NIL);
	vRAM:=g;
end;

procedure PutShadowSprite(var s:TSprite;m:PMap);ASSEMBLER;
ASM
	LES			DI,s
	MOV			AX,ES:TSprite[DI].n
{	CMP			AX,SPR_OFF
	JLE			@SALIR}

	PUSH		DS
	PUSH		BP

	DB			_386;XOR		 CX,CX
	MOV			DX,CX
	DB			_386;CMP		 WORD(m),CX
	JZ			@NO_SCROLL

	PUSH		ES
	LES			SI,m
	MOV			CX,ES:TMap[SI].py
	MOV			DX,ES:TMap[SI].px
	POP			ES

@NO_SCROLL:
	MOV			BP,ES:TSprite[DI].y
	SUB			BP,CX
	MOV			DI,ES:TSprite[DI].x
	SUB			DI,DX

	ADD			BP,BP
	ADD			DI,WORD(DS:MultByWidth[BP])

	LES			SI,SprInfo
	SHL			AX,3
	ADD			SI,AX
	MOV			BX,ES:TSprInfo[SI].height
	MOV			DX,ES:TSprInfo[SI].width

	MOV			BP,320
	SUB			BP,DX

	MOV			AL,ShadowColor
	MOV			CX,vRAM
	LDS			SI,ES:TSprInfo[SI].PSprite
	MOV			ES,CX

@Y:
	MOV			CX,DX

@X:               {ALIGN 16}
	TEST		BYTE([SI]),NOT 0  {CMP [SI],0}
	JZ			@CERO
	MOV			BYTE(ES:[DI]),AL

@CERO:
	INC			SI
	INC			DI
	DEC			CX
	JNZ			@X

	ADD			DI,BP
	DEC			BX
	JNZ     @Y

	POP			BP
	POP			DS

@SALIR:
END;

procedure PutShadowSpriteClipped(var s:TSprite;m:PMap);ASSEMBLER;
var
	ScrollX,ScrollY:integer;

ASM
	PUSH		BP
	LES			DI,s
	MOV			BX,ES:TSprite[DI].n
{	CMP			BX,SPR_OFF
	JLE			@SALIR}

	DB			_386;XOR		 CX,CX
	MOV			ScrollX,CX
	MOV			ScrollY,CX
	MOV			DecHeight,CX
	MOV			IncY1,CX
	MOV			IncLeft,CX
	MOV			IncRight,CX
	DB			_386;CMP		 WORD(m),CX
	JZ			@NO_SCROLL

	PUSH		ES
	LES			SI,m
	MOV			AX,ES:TMap[SI].py
	MOV			ScrollY,AX
	MOV			AX,ES:TMap[SI].px
	MOV			ScrollX,AX
	POP			ES

@NO_SCROLL:
	MOV			AX,WORD(SprInfo+2)
	DW			MOV_GS_AX
	MOV			SI,WORD(SprInfo)
	SHL			BX,3
	ADD			SI,BX

	MOV			DX,region.xul
	MOV			CX,ES:TSprite[DI].x
	SUB			CX,ScrollX
	MOV			AX,CX
	DB			GS;ADD		AX,TSprInfo[SI].width
	CMP			AX,DX						{if x+ancho<region.xul then goto fin}
	JLE			@SALIR

	CMP			CX,DX   				{if x<region.xul then...}
	JGE			@SIGUE_X1

	MOV			AX,DX           {x:=region.xul;}
	SUB			AX,CX
	MOV			IncLeft,AX     {...dec(ancho,abs(region.xul-x);}

	MOV			CX,DX						{CX=x=region.xul}
	JMP			@SIGUE_X2

@SIGUE_X1:
	MOV			DX,region.xlr
	CMP			CX,DX   				{if x>region.xlr then goto fin}
	JGE			@SALIR

	CMP			AX,DX   				{if x+ancho>region.xlr then...}
	JL			@SIGUE_X2
	SUB			AX,DX
	MOV			IncRight,AX   	{dec(ancho,(x+ancho)-region.xlr}

@SIGUE_X2:
	MOV			DX,region.yul
	MOV			BX,ES:TSprite[DI].y
	SUB			BX,ScrollY
	MOV			AX,BX
	DB			GS;ADD		AX,TSprInfo[SI].height
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			DecHeight,AX      {...dec(alto,abs(region.yul-y);}
	DB			GS;MOV		BP,TSprInfo[SI].width
	IMUL		BP              {...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JGE			@SALIR

	MOV			AX,BX
	DB			GS;ADD		AX,TSprInfo[SI].height
	CMP			AX,DX   				{if y+alto>region.ylr then...}
	JLE			@SIGUE_Y2
	SUB			AX,DX
	DEC			AX
	MOV			DecHeight,AX  		{dec(alto,(y+alto)-region.ylr}
	JMP			@SIGUE_Y2

@SIGUE_Y2:      {BX=y, CX=x}
	DB			GS;MOV		DX,TSprInfo[SI].height
	SUB			DX,DecHeight
	JLE			@SALIR
	MOV			DI,CX

	ADD			BX,BX
	ADD			DI,WORD(MultByWidth[BX])

	DB			GS;MOV		BX,TSprInfo[SI].width
	SUB			BX,IncLeft
	SUB			BX,IncRight
	MOV			BP,320
	SUB			BP,BX

	{$IFDEF __BPPROT__}
	MOV			CX,CS
	ADD			CX,SelectorInc
	MOV			ES,CX
	MOV			CX,IncLeft
	ADD			CX,IncRight
	MOV			WORD(ES:@I_LR+2),CX
	{$ELSE}
	MOV			CX,IncLeft
	ADD			CX,IncRight
	MOV			WORD(CS:@I_LR+2),CX
	{$ENDIF}

	MOV			AL,ShadowColor
	MOV			ES,vRAM
	MOV			CX,IncY1
	ADD			CX,IncLeft
	PUSH		DS
	DB			GS;LDS		SI,TSprInfo[SI].PSprite
	ADD			SI,CX

@Y:
	MOV			CX,BX

@X:               			{ALIGN 16}
	TEST		BYTE([SI]),NOT 0
	JZ			@CERO
	MOV			BYTE(ES:[DI]),AL

@CERO:
	INC			SI
	INC			DI
	DEC			CX
	JNZ			@X

@I_LR:
	ADD			SI,$FFFF
	ADD			DI,BP
	DEC			DX
	JNZ     @Y

	POP			DS

@SALIR:
	POP			BP
END;

function collision(var s1,s2:TSprite):integer;ASSEMBLER;
var
	out,x1,y1:integer;
	m:PMap;

ASM
	LES			DI,s1
	CMP			ES:TSprite[DI].active,FALSE
	JZ			@FIN

	DB			_386;MOV		AX,WORD(ES:TSprite[DI].map)
	DB			_386;MOV		WORD(m),AX

	MOV			BX,ES:TSprite[DI].n
	CMP			BX,SPR_OFF
	JLE			@FIN
	MOV			AX,WORD(SprInfo+2)
	DW			MOV_GS_AX
	MOV			SI,WORD(SprInfo)
	SHL			BX,3
	ADD			SI,BX

	MOV			AX,ES:TSprite[DI].y
	MOV     y1,AX
	MOV     CX,AX
	DB			GS;ADD		CX,TSprInfo[SI].height

	MOV			AX,ES:TSprite[DI].x
	MOV     x1,AX
	MOV			BX,AX
	DB			GS;ADD		BX,TSprInfo[SI].width

{----------------------------------------------------------------------------}

	LES			DI,s2
	CMP			ES:TSprite[DI].active,FALSE
	JZ			@FIN

	DB			_386;MOV		AX,WORD(m)
	DB			_386;CMP		AX,WORD(ES:TSprite[DI].map)
	JNZ			@FIN        {if s1.map<>s2.map then exit;}

	MOV			AX,ES:TSprite[DI].n
	CMP			AX,SPR_OFF
	JLE			@FIN
	MOV			SI,WORD(SprInfo)
	SHL			AX,3
	ADD			SI,AX

	MOV			AX,ES:TSprite[DI].x
	CMP			BX,AX
	JLE			@FIN
	CMP			x1,AX
	JG			@RIGHT
	MOV			out,C_LEFT
	JMP			@1
@RIGHT:
	MOV			out,C_RIGHT

@1:
	MOV			DX,ES:TSprite[DI].y
	CMP     CX,DX
	JLE			@FIN
	CMP			y1,DX
	JG			@DOWN
	ADD			out,C_UP
	JMP			@2
@DOWN:
	ADD			out,C_DOWN

@2:
	MOV			DI,DX
	DB			GS;ADD		DI,TSprInfo[SI].height
	CMP			DI,y1
	JLE			@FIN

	DB			GS;MOV		SI,TSprInfo[SI].width
	ADD			SI,AX
	CMP			SI,x1
	JLE			@FIN

	MOV			AX,out
	JMP			@GO

@FIN:
	MOV			AX,C_NOP

@GO:
{	collision:=	(x1+ancho1>x2) and (x2+ancho2>x1) and
							(y1+alto1>y2) and (y2+alto2>y1);}
END;

var
	_ancho,_alto,columnas,filas,AddLine,_ofs:word;
	_sy,i,j:LongInt;

procedure PutScaleSpriteClipped(n,x1,y1,x2,y2:integer);ASSEMBLER;
ASM
	MOV   AX,n
	LES		SI,SprInfo
	SHL		AX,3
	ADD		SI,AX

	MOV		AX,ES:TSprInfo[SI].height
	MOV		_alto,AX
	MOV		AX,ES:TSprInfo[SI].width
	MOV		_ancho,AX
	LES		DI,ES:TSprInfo[SI].PSprite
	MOV		_ofs,DI

	DB		_386;XOR	SI,SI
	MOV		SI,y2
	SUB		SI,y1
	INC		SI
	JLE		@FIN
	MOV		filas,SI                 	{filas:=y2-y1;}

	DB		_386;MOV	DI,SI
	MOV		DI,x2
	SUB		DI,x1
	INC		DI
	JLE		@FIN
	MOV		columnas,DI              	{columnas:=x2-x1;}

	MOV		AX,_ancho
	DB		_386;SHL 	AX,16
	DW		CDQ
	DB		_386;IDIV	DI
	DB		_386;MOV	BX,AX 					{BX:=columnas shl 16 div (x2-x1)}

	MOV		AX,_alto
	DB		_386;SHL 	AX,16
	DW		CDQ
	DB		_386;IDIV	SI
	DB		_386;MOV	WORD(_sy),AX   	{sy:=filas shl 16 div (y2-y1)}

	DB		_386;XOR	AX,AX
	DB		_386;MOV	WORD(i),AX
	MOV		CX,y1
	MOV		DI,region.yul
	CMP		CX,DI
	JGE		@Y_MAYOR
	MOV		AX,DI
	SUB		AX,CX
	DB		_386;IMUL	WORD(_sy)
	DB		_386;MOV	WORD(i),AX
	MOV		AX,DI
	SUB		DI,CX
	SUB		filas,DI
	MOV		y1,AX

@Y_MAYOR:
	CMP		CX,region.ylr
	JG		@FIN

	MOV		CX,y2
	CMP		CX,region.ylr
	JLE		@Y_MENOR
	SUB		CX,region.ylr
	SUB		filas,CX

@Y_MENOR:
	CMP		CX,region.yul
	JLE		@FIN

	DB		_386;XOR	AX,AX
	DB		_386;MOV	WORD(j),AX
	MOV		CX,x1
	MOV		DI,region.xul
	CMP		CX,DI
	JGE		@X_MAYOR
	MOV		AX,DI
	SUB		AX,CX
	DB		_386;IMUL	BX
	DB		_386;ROL	AX,16
	DB		_386;MOV	WORD(j),AX
	MOV		AX,DI
	SUB		DI,CX
	SUB		columnas,DI
	MOV		x1,AX

@X_MAYOR:
	CMP		CX,region.xlr
	JGE		@FIN

	MOV		CX,x2
	CMP		CX,region.xlr
	JLE		@X_MENOR
	SUB		CX,region.xlr
	SUB		columnas,CX

@X_MENOR:
	CMP		CX,region.xul
	JLE		@FIN

	MOV		AX,320
	SUB		AX,columnas
	MOV		AddLine,AX               	{AddLine:=320-columnas}

	MOV		SI,y1
	ADD		SI,SI
	MOV		DI,WORD(MultByWidth[SI])   	{DirPant:=y*320+x}
	ADD		DI,x1

	PUSH  BP
	PUSH  DS

	DB		_386;ROL	BX,16
	DB		_386;MOV	BP,WORD(i)     	{cy=i}
	MOV		AX,DS
	DW		MOV_GS_AX
	MOV		DS,vRAM

@Y:
	DB		$66,$F,$A4,$E8,$10			 	{SHLD EAX,EBP,16}
	DB		GS;IMUL		_ancho
	DD		MOVSX_ESI_AX
	DB		GS;ADD		SI,_ofs        	{ESI=cx:=(cy*ancho)+OFFSET[sprite]}
	DW    GS_386;ADD	SI,WORD(j)

	DB		GS;MOV 		CX,columnas
	CLC

@X:                       {ALIGN 16}
	MOV 	AL,ES:[SI]
	DB		_386;ADC 	SI,BX					 	{inc(cx,sx)}

	MOV		[DI],AL
	INC		DI

	DEC		CX
	JNZ		@X

	DB		GS;ADD 		DI,AddLine     	{inc(DirPant,AddLine}
	DW		GS_386;ADD	BP,WORD(_sy) 	{inc(cy,sy)}
	DB		GS;DEC 		filas
	JNZ 	@Y

	POP		DS
	POP		BP

@FIN:
END;

procedure PutScaleSpriteClippedMask(n,x1,y1,x2,y2:integer);ASSEMBLER;
ASM
	MOV   AX,n
	LES		SI,SprInfo
	SHL		AX,3
	ADD		SI,AX

	MOV		AX,ES:TSprInfo[SI].height
	MOV		_alto,AX
	MOV		AX,ES:TSprInfo[SI].width
	MOV		_ancho,AX
	LES		DI,ES:TSprInfo[SI].PSprite
	MOV		_ofs,DI

	DB		_386;XOR	SI,SI
	MOV		SI,y2
	SUB		SI,y1
	INC		SI
	JLE		@FIN
	MOV		filas,SI                 	{filas:=y2-y1;}

	DB		_386;MOV	DI,SI
	MOV		DI,x2
	SUB		DI,x1
	INC		DI
	JLE		@FIN
	MOV		columnas,DI              	{columnas:=x2-x1;}

	MOV		AX,_ancho
	DB		_386;SHL 	AX,16
	DW		CDQ
	DB		_386;IDIV	DI
	DB		_386;MOV	BX,AX 					{BX:=columnas shl 16 div (x2-x1)}

	MOV		AX,_alto
	DB		_386;SHL 	AX,16
	DW		CDQ
	DB		_386;IDIV	SI
	DB		_386;MOV	WORD(_sy),AX   	{sy:=filas shl 16 div (y2-y1)}

	DB		_386;XOR	AX,AX
	DB		_386;MOV	WORD(i),AX
	MOV		CX,y1
	MOV		DI,region.yul
	CMP		CX,DI
	JGE		@Y_MAYOR
	MOV		AX,DI
	SUB		AX,CX
	DB		_386;IMUL	WORD(_sy)
	DB		_386;MOV	WORD(i),AX
	MOV		AX,DI
	SUB		DI,CX
	SUB		filas,DI
	MOV		y1,AX

@Y_MAYOR:
	CMP		CX,region.ylr
	JG		@FIN

	MOV		CX,y2
	CMP		CX,region.ylr
	JLE		@Y_MENOR
	SUB		CX,region.ylr
	SUB		filas,CX

@Y_MENOR:
	CMP		CX,region.yul
	JLE		@FIN

	DB		_386;XOR	AX,AX
	DB		_386;MOV	WORD(j),AX
	MOV		CX,x1
	MOV		DI,region.xul
	CMP		CX,DI
	JGE		@X_MAYOR
	MOV		AX,DI
	SUB		AX,CX
	DB		_386;IMUL	BX
	DB		_386;ROL	AX,16
	DB		_386;MOV	WORD(j),AX
	MOV		AX,DI
	SUB		DI,CX
	SUB		columnas,DI
	MOV		x1,AX

@X_MAYOR:
	CMP		CX,region.xlr
	JGE		@FIN

	MOV		CX,x2
	CMP		CX,region.xlr
	JLE		@X_MENOR
	SUB		CX,region.xlr
	SUB		columnas,CX

@X_MENOR:
	CMP		CX,region.xul
	JLE		@FIN

	MOV		AX,320
	SUB		AX,columnas
	MOV		AddLine,AX               	{AddLine:=320-columnas}

	MOV		SI,y1
	ADD		SI,SI
	MOV		DI,WORD(MultByWidth[SI])   	{DirPant:=y*320+x}
	ADD		DI,x1

	PUSH  BP
	PUSH  DS

	DB		_386;ROL	BX,16
	DB		_386;MOV	BP,WORD(i)     	{cy=i}
	MOV		AX,DS
	DW		MOV_GS_AX
	MOV		DS,vRAM

@Y:
	DB		$66,$F,$A4,$E8,$10			 	{SHLD EAX,EBP,16}
	DB		GS;IMUL		_ancho
	DD		MOVSX_ESI_AX
	DB		GS;ADD		SI,_ofs        	{ESI=cx:=(cy*ancho)+OFFSET[sprite]}
	DW    GS_386;ADD	SI,WORD(j)

	DB		GS;MOV 		CX,columnas
	CLC

@X:                       {ALIGN 16}
	MOV 	AL,ES:[SI]
	DB		_386;ADD 	SI,BX					 	{inc(cx,sx)}
	ADC		SI,0
	TEST	AL,AL
	JZ		@CERO
	MOV		[DI],AL

@CERO:
	INC		DI
	DEC		CX
	JNZ		@X

	DB		GS;ADD 		DI,AddLine     	{inc(DirPant,AddLine}
	DW		GS_386;ADD	BP,WORD(_sy) 	{inc(cy,sy)}
	DB		GS;DEC 		filas
	JNZ 	@Y

	POP		DS
	POP		BP

@FIN:
END;

procedure PutScaleSpriteMask(n,x1,y1,x2,y2:integer);ASSEMBLER;
ASM
	MOV   AX,n
	LES		SI,SprInfo
	SHL		AX,3
	ADD		SI,AX

	MOV		AX,ES:TSprInfo[SI].height
	MOV		_alto,AX
	MOV		AX,ES:TSprInfo[SI].width
	MOV		_ancho,AX

	LES		DI,ES:TSprInfo[SI].PSprite
	MOV		_ofs,DI

	DB		_386;XOR	SI,SI
	MOV		SI,y2
	SUB		SI,y1
	INC		SI
	JLE		@FIN
	MOV		filas,SI
																 {filas:=y2-y1;}
	DB		_386;MOV	DI,SI
	MOV		DI,x2
	SUB		DI,x1
	INC		DI
	JLE		@FIN
	MOV		columnas,DI              {columnas:=x2-x1;}

	MOV		BX,320
	SUB		BX,DI
	MOV		AddLine,BX               {AddLine:=320-columnas}

	MOV		AX,_ancho
	DB		_386;SHL 	AX,16
	DW		CDQ
	DB		_386;IDIV	DI
	DB		_386;ROL	AX,16
	DB		_386;MOV	BX,AX    			 {BX=sx:=columnas shl 16 div (x2-x1)}

	MOV		AX,_alto
	DB		_386;SHL 	AX,16
	DW		CDQ
	DB		_386;IDIV	SI
	DB		_386;MOV	WORD(_sy),AX    {sy:=filas shl 16 div (y2-y1)}

	MOV		SI,y1
	ADD		SI,SI
	MOV		DI,WORD(MultByWidth[SI])   {DirPant:=y*320+x}
	ADD		DI,x1

	PUSH  BP
	PUSH  DS

	DB		_386;XOR 	BP,BP   			 {cy=0}
	MOV		AX,DS
	DW		MOV_GS_AX
	MOV		DS,vRAM

@Y:
	DB		$66,$F,$A4,$E8,$10			 {SHLD EAX,EBP,16}
	DB		GS;IMUL		_ancho
	DD		MOVSX_ESI_AX
	DB		GS;ADD		SI,_ofs        {SI=(cy*ancho)+OFFSET[sprite]}

	DB		GS;MOV 		CX,columnas
	CLC

@X:                       {ALIGN 16}
	MOV 	AL,ES:[SI]
	DB		_386;ADD 	SI,BX					 {inc(cy,sx)}
	ADC 	SI,0

	TEST	AL,AL
	JZ		@CERO
	MOV		[DI],AL

@CERO:
	INC		DI

	DEC		CX
	JNZ		@X

	DB		GS;ADD 		DI,AddLine     {inc(DirPant,AddLine}
	DW		GS_386;ADD	BP,WORD(_sy)	 {inc(cy,sy)}
	DB		GS;DEC 		filas
	JNZ 	@Y

	POP		DS
	POP		BP

@FIN:
END;

procedure PutScaleSprite(n,x1,y1,x2,y2:integer);ASSEMBLER;
ASM
	MOV   AX,n
	LES		SI,SprInfo
	SHL		AX,3
	ADD		SI,AX

	MOV		AX,ES:TSprInfo[SI].height
	MOV		_alto,AX
	MOV		AX,ES:TSprInfo[SI].width
	MOV		_ancho,AX

	LES		DI,ES:TSprInfo[SI].PSprite
	MOV		_ofs,DI

	DB		_386;XOR	SI,SI
	MOV		SI,y2
	SUB		SI,y1
	INC		SI
	JLE		@FIN
	MOV		filas,SI
																 {filas:=y2-y1;}
	DB		_386;MOV	DI,SI
	MOV		DI,x2
	SUB		DI,x1
	INC		DI
	JLE		@FIN
	MOV		columnas,DI              {columnas:=x2-x1;}

	MOV		BX,320
	SUB		BX,DI
	MOV		AddLine,BX               {AddLine:=320-columnas}

	MOV		AX,_ancho
	DB		_386;SHL 	AX,16
	DW		CDQ
	DB		_386;IDIV	DI
	DB		_386;ROL	AX,16
	DB		_386;MOV	BX,AX    			 {BX=sx:=columnas shl 16 div (x2-x1)}

	MOV		AX,_alto
	DB		_386;SHL 	AX,16
	DW		CDQ
	DB		_386;IDIV	SI
	DB		_386;MOV	WORD(_sy),AX    {sy:=filas shl 16 div (y2-y1)}

	MOV		SI,y1
	ADD		SI,SI
	MOV		DI,WORD(MultByWidth[SI])   {DirPant:=y*320+x}
	ADD		DI,x1

	PUSH  BP
	PUSH  DS

	DB		_386;XOR 	BP,BP   			 {cy=0}
	MOV		AX,DS
	DW		MOV_GS_AX
	MOV		DS,vRAM

@Y:
	DB		$66,$F,$A4,$E8,$10			 {SHLD EAX,EBP,16}
	DB		GS;IMUL		_ancho
	DD		MOVSX_ESI_AX
	DB		GS;ADD		SI,_ofs        {SI=(cy*ancho)+OFFSET[sprite]}

	DB		GS;MOV 		CX,columnas
	CLC

@X:                       {ALIGN 16}
	MOV 	AL,ES:[SI]
	DB		_386;ADC 	SI,BX					 	{inc(cy,sx)}
	MOV		[DI],AL
	INC		DI
	DEC		CX
	JNZ		@X

	DB		GS;ADD 		DI,AddLine     	{inc(DirPant,AddLine}
	DW		GS_386;ADD	BP,WORD(_sy)	{inc(cy,sy)}
	DB		GS;DEC 		filas
	JNZ 	@Y

	POP		DS
	POP		BP

@FIN:
END;

procedure PutBoxSprite(n,x,y,f:integer);
var
	w,h:integer;

begin
	with SprInfo^[n] do
		begin
			w:=PorCiento(f,width);
			h:=PorCiento(f,height);
			PutScaleSpriteClipped(n,x,y,x+w,y+h+(h*round(h/w)));
		end;
end;

procedure PutBoxSpriteMask(n,x,y,f:integer);
var
	w,h:integer;

begin
	with SprInfo^[n] do
		begin
			w:=PorCiento(f,width);
			h:=PorCiento(f,height);
			PutScaleSpriteClippedMask(n,x,y,x+w,y+h+(h*round(h/w)));
		end;
end;

var
	ColZone:^byte;

function InitCollision:boolean;
begin
	InitCollision:=GetMem(ColZone,vRAMSize);
end;

procedure DoneCollision;
begin
	FreeMem(ColZone,vRAMSize);
end;

function PixelCollision(var s1,s2:TSprite):boolean;
var
	result:boolean;
	ScrollX,ScrollY:integer;
	xx,yy:integer;
	s:word;
	p1,p2:PSprite;
	l1,l2:word;

begin
	PixelCollision:=FALSE;
	if collision(s1,s2)=C_NOP then exit;

	result:=FALSE;
	with SprInfo^[s2.n] do l1:=width*height;
	with SprInfo^[s1.n] do l2:=width*height;
	if l1>l2 then
		begin
			p1:=@s2;
			p2:=@s1;
		end
	else
		begin
			p1:=@s1;
			p2:=@s2;
		end;

	xx:=s2.x;
	yy:=s2.y;
	with p2^ do
		if map<>NIL then
			begin
				dec(xx,map^.px);
				dec(yy,map^.py);
			end;

	s:=vRAM;
	vRAM:=seg(ColZone^);
	with p2^ do rectangle(xx,yy,xx+SprInfo^[n].width,yy+SprInfo^[n].height,0);

	with p1^ do
		if (word(x)<region.xlr-width) and (word(y-map^.py)<region.ylr-height) then
			PutSprite(p1^,map)
		else
			PutSpriteClipped(p1^,map);
	vRAM:=s;

	ASM
		PUSH		DS
		PUSH		BP
		LES			DI,p2
		MOV			DX,ES:TSprite[DI].n

		MOV			CX,0
		MOV			ScrollX,CX
		MOV			ScrollY,CX
		MOV			DecHeight,CX
		MOV			IncY1,CX
		MOV			IncLeft,CX
		MOV			IncRight,CX

		DB			_386;MOV		BX,WORD(ES:TSprite[DI].map)
		DB			_386;TEST		BX,BX
		JZ			@NO_SCROLL

		PUSH		ES
		LES			SI,ES:TSprite[DI].map
		MOV			AX,ES:TMap[SI].py
		MOV			ScrollY,AX
		MOV			AX,ES:TMap[SI].px
		MOV			ScrollX,AX
		POP			ES

@NO_SCROLL:
		MOV			AX,WORD(SprInfo+2)
		DW			MOV_GS_AX
		MOV			SI,WORD(SprInfo)
		SHL			DX,3
		ADD			SI,DX

		MOV			DX,region.xul
		MOV			CX,ES:TSprite[DI].x
		SUB			CX,ScrollX
		MOV			AX,CX
		DB			GS;ADD		AX,TSprInfo[SI].width
		CMP			AX,DX						{if x+ancho<region.xul then goto fin}
		JLE			@SALIR

		CMP			CX,DX   				{if x<region.xul then...}
		JGE			@SIGUE_X1

		MOV			AX,DX           {x:=region.xul;}
		SUB			AX,CX
		MOV			IncLeft,AX     {...dec(ancho,abs(region.xul-x);}

		MOV			CX,DX						{CX=x=region.xul}
		JMP			@SIGUE_X2

@SIGUE_X1:
		MOV			DX,region.xlr
		CMP			CX,DX   				{if x>region.xlr then goto fin}
		JGE			@SALIR

		CMP			AX,DX   				{if x+ancho>region.xlr then...}
		JL			@SIGUE_X2
		SUB			AX,DX
		MOV			IncRight,AX   	{dec(ancho,(x+ancho)-region.xlr}

@SIGUE_X2:
		MOV			DX,region.yul
		MOV			BX,ES:TSprite[DI].y
		SUB			BX,ScrollY
		MOV			AX,BX
		DB			GS;ADD		AX,TSprInfo[SI].height
		CMP			AX,DX						{if y+alto<region.yul then goto fin}
		JLE			@SALIR

		CMP			BX,DX   				{if y<region.yul then...}
		JGE			@SIGUE_Y1
		MOV			AX,DX           {y:=region.yul;}
		SUB			AX,BX
		MOV			DecHeight,AX      {...dec(alto,abs(region.yul-y);}
		DB			GS;MOV		BP,TSprInfo[SI].width
		IMUL		BP              {...inc(IncY1,abs(region.yul-y)*ancho);}
		MOV			IncY1,AX
		MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
		MOV			DX,region.ylr
		CMP			BX,DX   				{if y>region.ylr then goto fin}
		JGE			@SALIR

		MOV			AX,BX
		DB			GS;ADD		AX,TSprInfo[SI].height
		CMP			AX,DX   				{if y+alto>region.ylr then...}
		JLE			@SIGUE_Y2
		SUB			AX,DX
		DEC			AX
		MOV			DecHeight,AX  		{dec(alto,(y+alto)-region.ylr}
		JMP			@SIGUE_Y2

@SIGUE_Y2:      {BX=y, CX=x}
		DB			GS;MOV		DX,TSprInfo[SI].height
		SUB			DX,DecHeight
		JLE			@SALIR
		MOV			DI,CX

		ADD			BX,BX
		ADD			DI,WORD(MultByWidth[BX])

		DB			GS;MOV		BX,TSprInfo[SI].width
		SUB			BX,IncLeft
		SUB			BX,IncRight
		MOV			BP,320
		SUB			BP,BX

		MOV			AX,IncLeft
		ADD			AX,IncRight
		MOV			CX,IncY1
		ADD			CX,IncLeft

		MOV			ES,WORD(ColZone+2)
		DB			GS;LDS		SI,TSprInfo[SI].PSprite
		ADD			SI,CX

@Y:
		MOV			CX,BX

@X:               {ALIGN 16}
		TEST		BYTE([SI]),NOT 0
		JZ			@CERO
		TEST		BYTE(ES:[DI]),NOT 0
		JNZ			@CHOQUE

@CERO:
		INC			SI
		INC			DI
		DEC			CX
		JNZ			@X

		ADD			SI,AX
		ADD			DI,BP
		DEC			DX
		JNZ     @Y

		MOV			AL,FALSE
		JMP			@SALIR

@CHOQUE:
		MOV			AL,TRUE

@SALIR:
		POP			BP
		POP			DS

		MOV			result,AL
	END;

	PixelCollision:=result;
end;

function AddAnimation(map:PMap;x,y:integer;key:pointer;f,sxi,syi:integer):integer;
var
	n:integer;

begin
	AddAnimation:=-1;
	for n:=0 to MAX_SPR_ANI do with SprAni[n] do
		if not active then
			begin
				active:=TRUE;
				frames:=f;
				buffer:=key;
				xi:=sxi;
				yi:=syi;
				t:=NORMAL;
				spr.x:=x;
				spr.y:=y;
				spr.active:=TRUE;
				m:=map;
				add:=1;
				AddAnimation:=n;
				exit;
			end;
end;

function AddSeekAnimation(map:PMap;s,key:pointer;f:integer):integer;
var
	n:integer;
	tmp:pointer;

begin
	AddSeekAnimation:=-1;
	for n:=0 to MAX_SPR_ANI do with SprAni[n] do
		if not active then
			begin
				active:=TRUE;
				frames:=f;
				buffer:=key;
				daddy:=s;
				daddy^.map:=m;
				t:=FOLLOW;
				spr.active:=TRUE;
				add:=1;
	{			spr.IncX:=random(TSprite(s).width div 2);
				spr.IncY:=random(TSprite(s).height div 2);}
				m:=map;
				AddSeekAnimation:=n;
				exit;
			end;
end;

function AddPingPongSeekAnimation(map:PMap;s,key:pointer;f:integer):integer;
var
	n:integer;
	tmp:pointer;

begin
	AddPingPongSeekAnimation:=-1;
	for n:=0 to MAX_SPR_ANI do with SprAni[n] do
		if not active then
			begin
				active:=TRUE;
				frames:=f;
				buffer:=key;
				daddy:=s;
				m:=map;
				daddy^.map:=m;
				t:=PING_PONG;
				spr.active:=TRUE;
				add:=1;
	{			spr.IncX:=random(TSprite(s).width div 2);
				spr.IncY:=random(TSprite(s).height div 2);}
				AddPingPongSeekAnimation:=n;
				exit;
			end;
end;

function ProcessAnimations:integer;
var
	n,total:integer;

begin
	total:=0;
	for n:=0 to MAX_SPR_ANI do with SprAni[n] do
		if active then
			begin
				if buffer^<=SPR_OFF then
					case t of
						NORMAL,FOLLOW:
							begin
								active:=FALSE;
								continue;
							end;

						PING_PONG:
							begin
								add:=-add;
								inc(buffer,add);
							end;
					end;
				spr.n:=buffer^;

				case t of
					NORMAL:
						begin
							PutSpriteMaskClipped(spr,m);
							inc(spr.x,xi);
							inc(spr.y,yi);
						end;

					FOLLOW,PING_PONG:
						with daddy^ do
							begin
								spr.x:=x{+spr.IncX};
								spr.y:=y{+spr.IncY};
								PutSpriteMaskClipped(spr,m);
							end;
				end;
				if MyFrames mod frames=0 then inc(buffer,add);
				inc(total);
			end;
	ProcessAnimations:=total;
end;

function AnimationFinish(h:integer):boolean;
begin
	if h=-1 then
		AnimationFinish:=FALSE
	else
		AnimationFinish:=not SprAni[h].active;
end;

procedure ClearAnimations;
begin
	FillChar(SprAni,SizeOf(SprAni),0);
end;

procedure DeleteAnimation(h:integer);
begin
	SprAni[h].active:=FALSE;
end;

procedure PutSpriteOverScroll(var s:TSprite;f:TForm);
var
	spr:PLSpr;

begin
	new(spr);
	with spr^ do
		begin
			last:=LastSpr;
			x:=s.x;
			y:=s.y;
			n:=s.n;
			t:=f;
		end;
	LastSpr:=spr;
end;

procedure OverScroll;
var
	spr,tmp:PLSpr;
	s:TSprite;

begin
	spr:=LastSpr;
	while spr<>NIL do with spr^ do
		begin
			s.x:=x;
			s.y:=y;
			s.n:=n;
			case t of
				F_NORMAL:PutSprite(s,NIL);
				F_MASKED:PutSpriteMask(s,NIL);
				F_CLIPPED:PutSpriteClipped(s,NIL);
				F_MASKED_CLIPPED:PutSpriteMaskClipped(s,NIL);
			end;
			tmp:=last;
			dispose(spr);
			spr:=tmp;
			LastSpr:=spr;
		end;
end;

begin
	ClearAnimations;
	LastSpr:=NIL;
	TotalSpr:=0;
end.