unit wave;

INTERFACE

procedure go;

IMPLEMENTATION

uses Mode13,colors,OP386,keys,Engine3D,mem,main,MyMidas;

var
	sinus:array[0..255] of byte;
	x,y,px,py,
	frame:word;
	Bseg,Bseg3:^byte;
	xx,yy:integer;
	n:byte;

procedure DrawPic;ASSEMBLER;
var
	x,y:integer;

ASM
	MOV		AX,WORD(Bseg3+2)
	DW		MOV_GS_AX
	MOV		AX,WORD(Bseg+2)
	DW		MOV_FS_AX

	MOV		ES,vRAM
	MOV		DI,320+1

	MOV		BX,YMAX-1

@Y:
	MOV		DX,320-2

@X:
	DB		FS;MOV	 AL,[DI-320]
	DB		FS;SUB	 AL,[DI+320]
	CBW
	MOV		SI,BX
	ADD		SI,AX
	ADD		SI,SI
	MOV		SI,WORD(MultByWidth[SI])
	ADD		SI,DX

	DB		FS;MOV	 AL,[DI+1]
	DB		FS;SUB	 AL,[DI-1]
	CBW
	ADD		SI,AX
	DB		GS;MOV	 AL,[SI]

	MOV		ES:[DI],AL
	INC		DI

	DEC		DX
	JNZ		@X

	ADD		DI,2
	DEC		BX
	JNZ		@Y
END;


procedure DrawWave;ASSEMBLER;
ASM
	PUSH	BP
	MOV		BP,frame

	MOV		CX,CS
	ADD		CX,SelectorInc
	MOV		ES,CX
	MOV		CL,n
	MOV		BYTE(ES:@CHANGE+2),CL

	LES		DI,Bseg
	MOV		y,YMAX

@Y:
	MOV		BX,xx
	MOV		AX,y
	SUB		AX,yy
	CWD
	IMUL	AX
	MOV		CX,320

@X:
	DEC		BX
	ADD		AX,BX
	MOV		SI,AX

@CHANGE:
	SAR		SI,8
	ADD		SI,BP
	AND		SI,255
	MOV		DL,BYTE(sinus[SI])
	MOV		ES:[DI],DL
	INC		DI

	DEC		CX
	JNZ		@X

	DEC		y
	JNZ		@Y

	POP		BP
END;


procedure go;
var
	a,b:integer;
	p,pp,rojo,verde:Tpal;
	s:TScene;
	d:boolean;
	cam:TCamera;

begin
	StartCrono;
	ClearVideo;
	SetTransferMode(COPY);

	GetMem(Bseg,vRAMSize);
	GetMem(Bseg3,SizeOf(Tsegment));
	for a:=0 to 255 do sinus[a]:=round(cos(2*pi*a/256)*64);

	if not LoadIMG('FONDO3',Bseg3,p) then Ferror('FONDO3.IMG');
	InkAllRed(0,255,p,rojo);
	InkAllYellow(0,255,p,verde);
	GetPal(pp,0,255,white);
	InitDifumine2(0,255,pp,p);

	NewScene(s,MAX_FACES_IN_SCENE);
	ResetCamera(cam);
	SetSceneSort(s,_NO_SORT_);
	SetUnColor(ball,ALL_CHILDS,GetNearColor(white,p));
	ball^.world.z:=100000;

	xx:=160;yy:=100;
	n:=12;
	d:=FALSE;

	SkipFrames:=StartFrame;
	inc(MyFrames);
	repeat
		SetCamera(s,cam);
		difumine;

		if ball^.world.z>ZMAX then
			ball^.world.z:=ball^.world.z-(ZMAX div 2)
		else
			if not d then
				begin
					sf:=GetSemaphore(13);
					if sf=FLASH then
					 case random(2) of
						0:InitDifumine2(0,255,rojo,p);
						1:InitDifumine2(0,255,verde,p);
					 end;
				end;

		DrawWave;
		DrawPic;
		dec(frame,5);

		MoveBall(s);
		RenderScene(s);

		if (MyFrames and 127=0) and (n>5) then dec(n);
		DrawH(0,YMAX-1,XMAX,0);
		box(0,0,XMAX,YMAX,0);

		SkipFrames:=anima;
		if inkey[K_ESC] then halt;
		if (ToFinish<25) and (not d) then
			begin
				GetPal(rojo,0,255,red);
				InitDifumine(0,255,rojo);
				d:=TRUE;
			end;
		if d then difumine;
	until finish;

	FreeScene(s);
	FreeMem(Bseg,vRAMSize);
	FreeMem(Bseg3,SIzeOf(Tsegment));
end;

end.
