unit plasma;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,Mode13,colors,keys,OP386,mem,MyDOS,math,Engine3D,MyMidas,
{$IFDEF _RLE_}
	RLEFiles
{$ELSE}
	{$IFDEF _LZ_}
	LZFiles
	{$ELSE}
	files
	{$ENDIF}
{$ENDIF}
	;

type
	Traiz=array[0..65534] of byte;

var
	raiz:^Traiz;
	d,y,yy:integer;

procedure go;
const
	plasma:array[1..4] of record
		name:string[8];
		texture:Ptexture;
		pal:^Tpal;
		shade:^byte;
	end=(
			(name:'TUNEL4'),
			(name:'TUNEL3'),
			(name:'TUNEL2'),
			(name:'TUNEL1'));

	pantallas:array[0..5] of record
		name:string[8];
		p:^byte;
		pal:^Tpal;
	end=
		((name:'X'),
		 (name:'TB'),
		 (name:'MAS'),
		 (name:'CARETO'),
		 (name:'LEFFY'),
		 (name:'MJB'));

var
	i,
	a,b,c,
	wait,n:word;
	f:Tfile;
	t:Ptexture;
	blanco:byte;
	dd,x,xi:integer;
	sine:array[0..360+90] of integer;

begin
	StartCrono;
	SetTransferMode(SHADE);

	for a:=0 to high(pantallas) do with pantallas[a] do
		begin
			GetMem(p,vRAMSize);
			GetMem(pal,SizeOf(Tpal));
			if not LoadIMG(name,p,pal^) then fError(name+'.IMG');
		end;

	for n:=high(plasma) DownTo 1 do with plasma[n] do
		begin
			GetMem(pal,SizeOf(Tpal));
			if not LoadTexture(name,texture,pal^) then Ferror(name+'TEX');
			SetShade(0.9,pal^);
			GetMem(shade,255);
			move(ShadeTable,shade^,SizeOf(ShadeTable));
		end;

	GetMem(raiz,SizeOf(Traiz));
	if open(f,'RAIZ.BIN',RO)>0 then fError('RAIZ.BIN');
	read(f,raiz^,SizeOf(Traiz),n);
	close(f);

	for n:=0 to high(sine) do	sine[n]:=round(n*sin(n*RAD));

	d:=0;i:=2;

	InitDifumine(0,255,plasma[1].pal^);
	t:=plasma[1].texture;
	c:=1;
	wait:=256;

	blanco:=GetNearColor(white,plasma[1].pal^);
	xi:=10;x:=xi;
	dd:=0;

	SkipFrames:=StartFrame;
	inc(MyFrames);
	repeat
		difumine;
		sf:=GetSemaphore(13);
		if sf=FLASH then
			begin
				if (x<abs(xi)) or (x>XMAX-64-abs(xi)) then xi:=-xi;
				inc(x,xi);
			end;

		inc(d,i);
		if word(d)>DEG then i:=-i;
		ASM
			LES		DI,PvRAM
			MOV		y,YMAX

			MOV		AX,WORD(raiz+2)
			DW		MOV_GS_AX

			MOV		AX,WORD(t+2)
			DW		MOV_FS_AX

@V:
			MOV		AX,CENTERY
			SUB		AX,y
			IMUL	AX
			MOV		yy,AX

			MOV		CX,320

@H:
			MOV		AX,CENTERX
			SUB		AX,CX
			IMUL	AX
			ADD		AX,yy
			MOV		BX,AX
			DB		GS;MOV	 BL,BYTE(Traiz[BX])

			MOV		SI,CX
			ADD		SI,SI
			MOV   DX,WORD(sine[SI])

			MOV		AX,y
			IMUL	DX
			SAR		AX,8
			ADD		AX,CX
			SUB		AX,d
			MOV		BH,AL

			DB		FS;MOV	 AL,[BX]
			TEST	AL,AL
			JZ		@CERO
			MOV		ES:[DI],AL
@CERO:
			INC		DI
			DEC		CX
			JNZ		@H

			DEC		y
			JNZ		@V
		END;

		if (MyFrames and 7=0) and (wait<256) then inc(i);
		b:=MyFrames mod wait;
		if b=wait-1 then
			begin
				d:=random(high(pantallas)+1);
				move(pantallas[d].p^,PvRAM^,vRAMSize);
				InkAllRGB(0,255,pantallas[d].pal^);
				dd:=dd xor 1;
				if dd=1 then
					ASM
						LES		DI,raiz
						MOV		CX,65535
@BUCLE:
						SHL		BYTE(ES:[DI]),1
						INC		DI
						DEC		CX
						JNZ		@BUCLE
					END
				else
					ASM
						LES		DI,raiz
						MOV		CX,65535
@BUCLE:
						SHR		BYTE(ES:[DI]),1
						INC		DI
						DEC		CX
						JNZ		@BUCLE
					END
			end;
		if b=0 then
			begin
				a:=c;
				repeat
					c:=random(high(plasma))+1;
				until a<>c;
				with plasma[c] do
					begin
						t:=texture;
						InkAllRGB(0,255,pal^);
						move(shade^,ShadeTable,SizeOf(ShadeTable));
						blanco:=GetNearColor(white,pal^);
					end;

				wait:=aleatorio(3,64);
				i:=1;
			end;

		if inkey[K_ESC] then halt;

		DrawH(0,0,XMAX,0);
		DrawH(0,YMAX,XMAX,0);
		reduce(x,round(x*0.6),blanco);

		SkipFrames:=anima;
	until finish;
	WhitePal;

	for n:=1 to high(plasma) do with plasma[n] do
		begin
			FreeTexture(texture);
			FreeMem(pal,SizeOf(Tpal));
			FreeMem(shade,255);
		end;
	for a:=0 to high(pantallas) do
		begin
			FreeMem(pantallas[a].p,vRAMSize);
			FreeMem(pantallas[a].pal,SizeOf(Tpal));
		end;
	FreeMem(raiz,SizeOf(Traiz));
end;

end.