unit main;

INTERFACE

uses colors,math,Engine3D;

const
	DEMONAME='SIRIO';

	_CODE_=1;
	_GFX_=_CODE_+1;
	_MUSIC_=_GFX_+1;

	FIRST_LETTER=_MUSIC_+1;
	LAST_LETTER=FIRST_LETTER+29-1;

	ZMIN=400;ZMAX=650;
	ZSPEED=25;

var
	translate:array[char] of byte;
	FontPal:Tpal;
	TotalTicks,ticks:LongInt;
	sf,
	SkipFrames:integer;
	ball:P3D;
	{$IFDEF _DEBUG_}
	fich:text;
	{$ENDIF}

procedure init;
procedure done;

procedure Ferror(n:string);
procedure error(n:string);

procedure ClearVideo;

function print(x,y:integer;c:string):integer;

procedure InitDifumine(p,u:integer;var c:Tpal);
procedure InitDifumine2(p,u:integer;var cf,cd:Tpal);
function difumine:boolean;

procedure MoveBall(var s:Tscene);

function finish:boolean;
function ToFinish:integer;
procedure StartCrono;
procedure reduce(x,y:integer;color:byte);
procedure CopyBitmap(x,y:integer);

IMPLEMENTATION

uses launch,Anima13,Mode13,keys,MyMidas,MyDOS,DOS,OP386,speed
{$IFDEF _LZ_}
	,LzFiles
{$ELSE}
	{$IFDEF _RLE_}
	,RLEFiles
	{$ENDIF}
{$ENDIF}
;

const
	message:string=DEMONAME+' by The Banner'+#13+#10+#13+#10+'MIDAS by Sahara Surfers';

	CSS=4;
	C_SPEED=1 shl CSS;

var
	CallOld8:procedure;

	OldProc:pointer;
	ini:boolean;

	cc,f,l:integer;
	work,vieja:Tpal;
	pal:^Tpal;

procedure Myint8;INTERRUPT;
begin
	PUSHF;
	CallOld8;
	inc(TotalTicks);
	inc(ticks);
	STI;
END;

procedure init;
var
	n:integer;

begin
	ini:=FALSE;

	{$IFDEF _LZ_}
		{$IFNDEF _DEBUG_}
	if LzInit(DEMONAME+'.EXE')<>0 then Ferror(DEMONAME+'.EXE');
		{$ELSE}
	if LzInit(DEMONAME+'.DAT')<>0 then Ferror(DEMONAME+'.DAT');
		{$ENDIF}
	{$ELSE}
		{$IFDEF _RLE_}
	if not RLEFiles.init(DEMONAME+'.DAT') then FError(DEMONAME+'.DAT');
		{$ENDIF}
	{$ENDIF}

	{$IFDEF __BPPROT__}
	if MemAvail<2000*1024 then error('Need 2 MB free');
	{$ENDIF}

	if Test8086<2 then error('Need a 386+');
	if Test8087<3 then error('Need a 387+');

	{$IFDEF __BPPROT__}
	if not Mymidas.init(15) then halt;
	{$ENDIF}
	keys.init;

	if not Mode13.init(COPY_BACKGROUND) then error('Need a VGA');

	{$IFDEF __BPPROT__}
	if not LoadModule(DEMONAME+'.MOD') then Ferror(DEMONAME+'.MOD');
	if not PlayModule then error('Error playing');
	{$ENDIF}

	Anima13.init;
	if not LoadSprites(DEMONAME+'.SPR',FontPal) then fError(DEMONAME+'.SPR');
	if not Load3D(ball,'BOLA') then Ferror('BOLA.3D');
	ball^.world.z:=ZMAX;
	SetRenderType(ball,ALL_CHILDS,_WIRE_);

	GetIntVec(8,@CallOld8);
	SetIntVec(8,@MyInt8);
	ini:=TRUE;
end;

{$F+}
procedure done;
var
	n:integer;

begin
	{$IFDEF _LZ_}
	LzDeInit;
	{$ELSE}
		{$IFDEF _RLE_}
		RLEFiles.done;
		{$ENDIF}
	{$ENDIF}

	{$IFDEF _DEBUG_}
	system.close(fich);
	{$ENDIF}

	if ini then
		begin
			SetIntVec(8,@CallOld8);

			{$IFDEF __BPPROT__}
			if isPlaying then StopModule;
			MyMidas.done;
			{$ENDIF}
		end;

	keys.done;
	Mode13.done;
	Anima13.done;

	WriteLn(message);
	ExitProc:=OldProc;
end;
{$F-}

procedure Ferror(n:string);
begin
	message:='Error in file '+n;
	halt;
end;

procedure error(n:string);
begin
	message:=n;
	halt;
end;

procedure ClearVideo;
begin
	FillChar(PBackPage^,vRAMSize,0);
	FillChar(PvRAM^,vRAMSize,0);
	FillChar(VGA^,vRAMSize,0);
end;

function print(x,y:integer;c:string):integer;
var
	n:integer;
	s:Tsprite;
	m:char;

begin
	for n:=1 to length(c) do
		begin
			m:=c[n];
			if m<>' ' then
				begin
					s.n:=translate[m];
					s.x:=x;s.y:=y;
					PutSpriteMaskClipped(s,NIL);
				end;
			inc(x,SprInfo^[FIRST_LETTER].width);
		end;
	print:=x;
end;

procedure InitDifumine(p,u:integer;var c:Tpal);
begin
	f:=p;l:=u;
	pal:=@c;
	cc:=0;

	GetAllRGB(f,l,vieja);
end;

procedure InitDifumine2(p,u:integer;var cf,cd:Tpal);
begin
	f:=p;l:=u;
	pal:=@cd;
	cc:=0;

	vieja:=cf;
end;

function difumine:boolean;
var
	n:integer;
	v,p,w:^TRGB;

begin
	difumine:=FALSE;
	if cc>=C_SPEED then
		begin
			difumine:=TRUE;
			exit;
		end;
	inc(cc);

	v:=@vieja[f];
	p:=@pal^[f];
	w:=@work[f];
	for n:=f to l do
		begin
			with w^ do
				begin
					red:=
						((v^.red*(C_SPEED-cc))+
						 (p^.red*cc)) shr CSS;

					green:=
						((v^.green*(C_SPEED-cc))+
						 (p^.green*cc)) shr CSS;

					blue:=
						((v^.blue*(C_SPEED-cc))+
						 (p^.blue*cc)) shr CSS;
				end;
			inc(w);
			inc(v);
			inc(p);
		end;

	InkAllRGB(f,l,work);
end;

procedure MoveBall(var s:Tscene);
var
	a:integer;

begin
	with ball^ do
		begin
			if sf=FLASH then
				world.z:=ZMIN
			else
				if world.z<ZMAX then world.z:=world.z+ZSPEED;

			for a:=1 to SkipFrames do with angle do
				begin
					caida:=caida+0.5;
					if caida>DEG then caida:=caida-DEG;

					balanza:=balanza-1;
					if balanza<0 then balanza:=balanza+DEG;

					deriva:=deriva+1.25;
					if deriva>DEG then deriva:=deriva-DEG;
				end;
			PutAll3D(s,ball);
		end;
end;

function finish:boolean;
begin
	finish:=ticks>=time[routine].time;
end;

function ToFinish:integer;
begin
	ToFinish:=time[routine].time-ticks;
end;

procedure StartCrono;
begin
	ticks:=0;
end;

procedure reduce(x,y:integer;color:byte);
begin
	ASM
		PUSH		DS
		MOV			BX,y
		ADD			BX,BX
		MOV			DI,WORD(MultByWidth[BX])
		ADD			DI,x
		LDS			SI,PvRAM
		MOV			DX,200/5

@Y:
		MOV			CX,320/5
		PUSH		DI

@X:
		MOV			AL,[SI]
		ADD			SI,5
		MOV			[DI],AL
		INC			DI
		DEC			CX
		JNZ			@X

		POP			DI
		ADD			DI,320
		ADD			SI,320*(5-1)
		DEC			DX
		JNZ			@Y

		POP			DS
	END;
	box(x,y,x+64,y+40,color);
end;

procedure CopyBitmap(x,y:integer);ASSEMBLER;
ASM
	PUSH	DS
	LES		DI,PvRAM
	MOV		BX,y
	ADD		BX,BX
	MOV		BX,WORD(MultByWidth[BX])
	ADD		BX,x
	ADD		DI,BX
	LDS		SI,PvRAM

	MOV		BX,41
@Y:
	PUSH	SI
	PUSH	DI
	MOV		CX,64/4
	REP;	DB _386;MOVSW
	POP		DI
	POP		SI
	ADD		SI,320
	ADD		DI,320
	DEC		BX
	JNZ		@Y

	POP		DS
END;

var
	n:char;
	m:integer;

begin
	OldProc:=ExitProc;
	ExitProc:=@done;

	randomize;

	m:=FIRST_LETTER;
	for n:='A' to 'Z' do
		begin
			translate[n]:=m;
			inc(m);
		end;
	for n:='1' to '3' do
		begin
			translate[n]:=m;
			inc(m);
		end;

	init;

	{$IFDEF _DEBUG_}
	assign(fich,DEMONAME+'.DBG');
	system.ReWrite(fich);
	{$ENDIF}
end.