unit donut;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,colors,math,Engine3D,Mode13,keys,MyMidas,speed;

procedure go;
var
	s:Tscene;
	donut,bola:P3D;
	l1,l2,l3,
	x,y,
	a,f,n:integer;
	rojo,amarillo,azul,c:Tpal;
	s1,s2:double;
	blanco:byte;
	mix:PMapLight;
	t1,t2:PTexture;
	camera:TCamera;
	light:TLight;

begin
	StartCrono;
	ClearVideo;
	SetTransferMode(COPY);
	SetSyncro(FALSE);

	if not LoadTexture('BURGN812',t1,c) then Ferror('BURGN812.TEX');
	if not LoadTexture('AZUL351',t2,c) then Ferror('AZUL351.TEX');
	InkAllRed(0,255,c,rojo);
	InkAllYellow(0,255,c,amarillo);
	InkAllBlue(0,255,c,azul);
	InitDifumine(0,255,c);
	blanco:=GetNearColor(white,c);

	if not LoadMapLight(mix,'MIX') then Ferror('MIX.LGT');

	if not Load3D(donut,'DONUT') then Ferror('DONUT.3DN');
	ScaleCoordinates(donut,ALL_CHILDS,-3.5);
	donut^.world.z:=410;donut^.world.y:=200;
	donut^.angle.balanza:=90;
	SetRenderType(donut,ALL_CHILDS,_TEXTURE_GOURAUD_);
	SetTexture(donut,ALL_CHILDS,t2);
	SetMapLight(donut,ALL_CHILDS,mix);

	if not Load3D(bola,'ROCA2') then Ferror('PIEDRA.3DN');
	UnScaleCoordinates(bola,ALL_CHILDS,2.25);
	bola^.world.z:=550;
	SetRenderType(bola,ALL_CHILDS,_TEXTURE_GOURAUD_);
	SetTexture(bola,ALL_CHILDS,t1);
	SetMapLight(bola,ALL_CHILDS,mix);

	NewScene(s,MAX_FACES_IN_SCENE);
	light.from.x:=-50;light.from.y:=50;light.from.z:=-100;
	f:=NewLight(s,_FOCUS_);
	l1:=180;l2:=90;l3:=240;
	s1:=0.1;s2:=0;

	ResetCamera(camera);

	a:=0;
	SkipFrames:=StartFrame;
	inc(MyFrames);
	repeat
{		sf:=GetSemaphore(13);}
		difumine;
		if MyFrames and 63=0 then
			case random(3) of
				0:InitDifumine2(0,255,rojo,c);
				1:InitDifumine2(0,255,amarillo,c);
				2:InitDifumine2(0,255,azul,c);
			end;

		for n:=1 to SkipFrames do
			begin
				light.where.x:=256*sin(l1*RAD);
				inc(l1);
				if l1>DEG then dec(l1,DEG);

				light.where.y:=512*cos(l2*RAD);
				inc(l2,2);
				if l2>DEG then dec(l2,DEG);

				light.where.z:=1024*sin(l3*RAD);
				inc(l3,3);
				if l3>DEG then dec(l3,DEG);

				if MyFrames and 31=0 then
					begin
						s1:=s1+0.25;
						s2:=s2+0.075;
					end;
				with camera.where do
					begin
						balanza:=balanza+s2;
						if balanza>DEG then balanza:=balanza-DEG;
					end;
				with donut^ do
					begin
						if (MyFrames>70*5) and (world.y>-200) then world.y:=world.y-2;
						angle.deriva:=angle.deriva-s1;
						if angle.deriva<0 then angle.deriva:=DEG;
					end;

				with bola^ do
					begin
						world.x:=light.where.x/16;
						world.y:=light.where.y/16;

						angle.caida:=angle.caida+2;
						if angle.caida>DEG then angle.caida:=angle.caida-DEG;

						angle.balanza:=angle.balanza+4;
						if angle.balanza>DEG then angle.balanza:=angle.balanza-DEG;

						angle.deriva:=angle.deriva+6;
						if angle.deriva>DEG then angle.deriva:=angle.deriva-DEG;
					end;
			end;

		SetCamera(s,camera);
		SetLight(s,f,light);
		PutAll3d(s,donut);
		PutAll3d(s,bola);
		RenderScene(s);

		if inkey[K_ESC] then halt;

		x:=CENTERX-32+round(64*sin(a*RAD));
		y:=CENTERY-20+round(64*cos(a*RAD));
		inc(a,3);
		if a>DEG then dec(a,DEG);
		reduce(x,y,blanco);
		SkipFrames:=anima;
	until finish;
	WhitePal;

	FreeLight(s,f);
	FreeTexture(t1);
	FreeTexture(t2);
	FreeMapLight(mix);
	Free3D(donut);
	Free3D(bola);
	FreeScene(s);
	SetSyncro(TRUE);
end;

end.