unit cueva;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,colors,math,Engine3D,Mode13,keys,MyMidas,speed;

procedure go;
var
	s:Tscene;
	o,p1,p2:P3D;
	h,
	a,b,c,n:integer;
	pal:Tpal;
	m:boolean;
	map:PMapLight;
	t1,t2:PTexture;
	camera:TCamera;
	light:TLight;
	ad,al:double;

begin
	StartCrono;
	SetTransferMode(COPY);
	SetSyncro(FALSE);

	NewScene(s,MAX_FACES_IN_SCENE);
	ResetCamera(camera);
	camera.from.z:=6000;

	if not LoadTexture('PLATEOX2',t1,pal) then fError('PLATEOX.TEX');
	if not LoadTexture('TUNEL4',t2,pal) then fError('TUNEL4.TEX');
	InkAllRGB(0,255,pal);
	SetShade(0.9,pal);

	if not LoadMapLight(map,'MIX2') then fError('MIX2.LGT');

	if not Load3D(o,'CUEVA') then fError('CUEVA.3DN');
	o^.world.z:=6500;
	SetRenderType(o,ALL_CHILDS,_TEXTURE_GOURAUD_);
	SetTexture(o,ALL_CHILDS,t1);
	SetMapLight(o,ALL_CHILDS,map);

	if not Load3D(p1,'ROCA2') then fError('ROCA2.3DN');
	p1^.world.z:=6500;
	ScaleCoordinates(p1,ALL_CHILDS,2);
	UnScaleMapping(p1,ALL_CHILDS,2);
	SetRenderType(p1,ALL_CHILDS,_TEXTURE_GOURAUD_);
	SetTexture(p1,ALL_CHILDS,t2);
	SetMapLight(p1,ALL_CHILDS,map);

	MakeClone3D(p1,p2);
	p2^.world.z:=6250;

	light.from.x:=50;light.from.y:=-50;light.from.z:=-100;
	h:=NewLight(s,_FOCUS_);

	ad:=s.DistanceFromEye;
	s.DistanceFromEye:=128;
	al:=s.AmbientLight;
	s.AmbientLight:=-128;

	m:=FALSE;
	a:=0;c:=0;
	b:=90;
	SkipFrames:=StartFrame;

	repeat
		SetCamera(s,camera);
		SetLight(s,h,light);
		if s.AmbientLight<al then s.AmbientLight:=s.AmbientLight+8.25;

		for n:=1 to SkipFrames do
			begin
				RotateCamera(camera,0.4,0.85,-1.95);

				with camera.from do
					begin
						x:=1024*sin(a*RAD);
						inc(a,2);
						if a>DEG then dec(a,DEG);

						y:=256*cos(a*RAD);
						dec(c);
						if c<0 then inc(c,DEG);
					end;

				with light.where do
					begin
						x:=256*sin(a*RAD);
						y:=512*cos(a*RAD);
						z:=1024*sin(b*RAD);
						inc(b,2);
						if b>DEG then dec(b,DEG);
					end;

				Rotate3D(p1,DADDY,1,2,3);
				with p1^ do
					begin
						world.x:=light.where.z;
						world.y:=light.where.z/2;
					end;

				Rotate3D(p2,DADDY,3,2,1);
				with p2^ do
					begin
						world.x:=-(light.where.z/2);
						world.y:=-(light.where.z);
					end;
			end;

		if inkey[K_ESC] then halt;

		PutAll3D(s,o);
		PutAll3D(s,p1);
		PutAll3D(s,p2);
		RenderScene(s);

		SkipFrames:=anima;
	until ToFinish<500;

	SetSyncro(TRUE);
	WhitePal;
	InkAllRGB(0,255,pal);
	SetTransferMode(SHADE);

	repeat
		with camera.where do
			begin
				if caida>0 then caida:=caida-5;
				if balanza>0 then balanza:=balanza-5;
				if deriva>0 then deriva:=deriva-5;
			end;

		with camera.from do
			begin
				if x>0 then x:=x-10;
				if x<0 then x:=x+10;

				if y>0 then y:=y-10;
				if y<0 then y:=y+10;
			end;

		Rotate3D(p1,DADDY,2,4,6);
		with p1^ do
			begin
				if world.x>250 then world.x:=world.x-50;
				if world.x<250 then world.x:=world.x+50;

				if world.y>100 then world.y:=world.y-50;
				if world.y<100 then world.y:=world.y+50;
			end;

		Rotate3D(p2,DADDY,6,4,2);
		with p2^ do
			begin
				if world.x>-100 then world.x:=world.x-50;
				if world.x<-100 then world.x:=world.x+50;

				if world.y>-50 then world.y:=world.y-50;
				if world.y<-50 then world.y:=world.y+50;
			end;

		with light.where do
			begin
				x:=256*sin(a*RAD);
				y:=512*cos(a*RAD);
				z:=1024*sin(b*RAD);

				inc(b,2);
				if b>DEG then dec(b,DEG);

				inc(a,2);
				if a>DEG then dec(a,DEG);
			end;

		SetLight(s,h,light);
		SetCamera(s,camera);
		PutAll3D(s,p1);
		PutAll3D(s,p2);
		RenderScene(s);

		if inkey[K_ESC] then halt;
		SkipFrames:=anima;
	until finish;
	WhitePal;

	FreeMapLight(map);
	FreeTexture(t1);
	FreeTexture(t2);
	FreeLight(s,h);
	FreeScene(s);
	Free3D(o);
	FreeClone3D(p2);
	Free3D(p1);

	s.DistanceFromEye:=ad;
end;

end.