unit tunel;

INTERFACE

procedure init;
procedure done;
procedure go;

IMPLEMENTATION

uses main,OP386,Mode13,Engine3D,colors,MyDOS,mem,files;

const
	TX=159;TY=99;

type
	T=array[0..TY,0..TX] of byte;

var
	x,y:^t;
	handle:PTexture;
	l1,l2:byte;
	da,db:integer;

procedure init;
var
	f:Tfile;
	l:word;
	pal:TPal;

begin
	GetMem(x,SizeOf(t));
	GetMem(y,SizeOf(t));
	if open(f,'TUNEL.BIN',RO)>0 then FError('TUNEL.BIN');
	read(f,x^,SizeOf(t),l);
	read(f,y^,SizeOf(t),l);
	close(f);
	if not LoadTexture('JUXTA929',handle,pal) then FError('JUXTA929.TEX');

	l1:=0;l2:=0;
	l:=1;
	da:=aleatorio(-2,2);
	db:=aleatorio(-2,2);
end;

procedure done;
begin
	FreeMem(x,SizeOf(t));
	FreeMem(y,SizeOf(t));
	FreeTexture(handle);
end;

procedure go;
begin
	if random(50)=1 then
		begin
			da:=aleatorio(-2,2);
			db:=aleatorio(-2,2);
		end;
	inc(l1,da);
	inc(l2,db);
	ASM
		PUSH		BP
		PUSH		DS
		MOV			ES,vRAM

		MOV			DL,l1
		MOV			DH,l2
		MOV			DI,0

		MOV			AX,WORD(x+2)
		DW			MOV_GS_AX

		MOV			AX,WORD(y+2)
		DW			MOV_FS_AX

		MOV			DS,WORD(handle+2)
		MOV			BP,TY*160

		MOV			CH,TY+1

@Y:
		MOV			CL,TX

@X:
		XOR			AH,AH
		MOV			AL,CL

		MOV			SI,BP     						{OFFSET=m*160+n}
		ADD			SI,AX

		DB			GS;MOV		BH,[SI]     {AH=y^[m,n]}
		ADD			BH,DL                 {rota}

		DB			FS;MOV		BL,[SI]     {AL=x^[m,n]}
		ADD			BL,DH                 {z}

		MOV			AL,[BX]               {AL=texture^[AH,AL]}

		MOV			AH,AL
		MOV			ES:[DI],AX
		MOV			ES:[DI+320],AX
		ADD			DI,2

		DEC     CL
		JNZ			@X

		SUB			BP,160								{Next y^ line}
		ADD			DI,322								{Next VGA line}

		DEC			CH
		JNZ			@Y

		POP			DS
		POP			BP
	END;
end;

end.