unit puntos;

INTERFACE

procedure init;
procedure done;
procedure go1;
procedure go2;
procedure go3;

IMPLEMENTATION

uses colors,Mode13,Old3D,MyDOS,OP386,main;

const
	L_TOTAL=1000;
	L_ZMAX=5000;
	MAX_POINTS=25000;

type
	Tlines=record
		x1,y1,x2,
		y2,x3,y3,
		z:integer;
	end;
	AL=array[0..L_TOTAL] of Tlines;

const
	P_TOTAL=5000;

type
	Txyz=record
		x,y,z:LongInt;
	end;
	Axyz=array[0..P_TOTAL] of Txyz;

var
	p:^Axyz;
	m:integer;

	l:^AL;
	x1,y1,x2,
	y2,x3,y3:integer;
	v,vv:PObject;
	a,d,ang:integer;

procedure nuevo(n:integer);
begin
	with l^[n] do
		begin
			x1:=aleatorio(-400,400);
			y1:=aleatorio(-400,400);

			x2:=x1+aleatorio(-400,400);
			y2:=y1+aleatorio(-400,400);

			x3:=x2+aleatorio(-400,400);
			y3:=y2+aleatorio(-400,400);

			z:=L_ZMAX;
		end;
end;

procedure lines(x1,y1,x2,y2,x3,y3:integer);
begin
	if Mode13.Clip2D(x1,y1,x2,y2) then Mode13.draw(c_x1,c_y1,c_x2,c_y2,GlobalW);
	if Mode13.Clip2D(x2,y2,x3,y3) then Mode13.draw(c_x1,c_y1,c_x2,c_y2,GlobalW);
end;

procedure init;
var
	n:integer;

begin
	GetMem(l,SizeOf(AL));
	for n:=0 to L_TOTAL do nuevo(n);
	for n:=0 to L_TOTAL do l^[n].z:=random(L_ZMAX);
	GetMem(v,SizeOf(TObject));
	ResetObject(v);
	v^.wz:=500;
	a:=0;d:=0;
	ang:=0;

	GetMem(p,SizeOf(Axyz));
	for n:=0 to P_TOTAL do with p^[n] do
		begin
			x:=round(n*sin(n));
			y:=round(n*cos(n));
			z:=round(n*(sin(n)/cos(n)));
		end;
	GetMem(vv,SizeOf(Tobject));
	ResetObject(vv);
	vv^.caida:=90;
	vv^.wz:=5000;
	n:=0;
end;

procedure done;
begin
	FreeMem(v,SizeOf(Tobject));
	FreeMem(vv,SizeOf(Tobject));

	FreeMem(p,SizeOf(Axyz));
	FreeMem(l,SizeOf(AL));
end;

procedure go1;
var
	n:integer;

begin
	Precalc12Mult(v);

	v^.wx:=512*sine[ang] div ESCALE;
	v^.wy:=256*sine[COSINE+ang] div ESCALE;

	inc(ang);
	if ang>DEG then dec(ang,DEG);

	for n:=0 to d do
		begin
			v^.x:=l^[n].x1;v^.y:=l^[n].y1;
			v^.z:=l^[n].z;
			RotateVertex12Mult(v);
			x1:=v^.sx;y1:=v^.sy;

			v^.x:=l^[n].x2;v^.y:=l^[n].y2;
			v^.z:=l^[n].z;
			RotateVertex12Mult(v);
			x2:=v^.sx;y2:=v^.sy;

			v^.x:=l^[n].x3;v^.y:=l^[n].y3;
			v^.z:=l^[n].z;
			RotateVertex12Mult(v);
			x3:=v^.sx;y3:=v^.sy;

			dec(l^[n].z,100);
			if l^[n].z<1 then nuevo(n);
			lines(x1,y1,x2,y2,x3,y3);
		end;

		inc(v^.balanza,a);
		if v^.balanza>DEG then v^.balanza:=0;
		if v^.balanza<0 then v^.balanza:=DEG;

		if MyFrames and 127=0 then
			begin
				a:=-a*2;
				if a=0 then a:=1;
			end;
		if (MyFrames and 15=0) and (d<L_TOTAL) then inc(d);
end;

procedure go2;
begin
	Precalc12Mult(vv);
	ASM
		PUSH		BP

		MOV			AX,WORD(vv+2)
		DW			MOV_GS_AX

		MOV			AX,WORD(p+2)
		DW			MOV_FS_AX
		MOV			SI,WORD(p)

		MOV		 	m,P_TOTAL

@BUCLE:
			MOV		BX,WORD(vv)
			DW		FS_386;MOV		AX,WORD(Txyz[SI].x)
			DW		GS_386;MOV		WORD(Tobject[BX].x),AX
			DW		FS_386;MOV		AX,WORD(Txyz[SI].y)
			DW		GS_386;MOV		WORD(Tobject[BX].y),AX
			DW		FS_386;MOV		AX,WORD(Txyz[SI].z)
			DW		GS_386;MOV		WORD(Tobject[BX].z),AX

			PUSH		SI
			DW			PUSH_GS
			PUSH		BX
			CALL		RotateVertex12Mult
			POP			SI

			TEST		AL,AL
			JZ			@MAYOR

			DB			GS;MOV			BP,Tobject[BX].sy
			CMP			BP,YMAX-2
			JA			@MAYOR

			DB			GS;MOV			DI,Tobject[BX].sx
			CMP			DI,XMAX-1
			JA			@MAYOR

				MOV			ES,vRAM
				INC			BP
				ADD			BP,BP
				ADD			DI,WORD(DS:MultByWidth[BP])
				MOV			AL,BYTE(GlobalW)
				MOV			BYTE(ES:[DI+320]),AL
				MOV			BYTE(ES:[DI-320]),AL
				MOV			BYTE(ES:[DI-1]),AL
				MOV			BYTE(ES:[DI+1]),AL
				MOV			BYTE(ES:[DI]),AL

@MAYOR:
		ADD			SI,TYPE(Txyz)
		DEC			m
		JNZ			@BUCLE

		POP			BP
	END;

	with vv^ do
		begin
{			inc(caida);
			if caida>DEG then dec(caida,DEG);}

			dec(balanza,2);
			if balanza<0 then inc(balanza,DEG);

{			inc(deriva,3);
			if deriva>DEG then dec(deriva,DEG);}
		end;
end;

procedure go3;
var
	n:word;
	x,y:integer;

begin
	x:=random(XMAX);
	y:=random(YMAX);
	for n:=0 to MAX_POINTS do
		begin
			x:=x+aleatorio(-1,1);
			y:=y+aleatorio(-1,1);
			plot(x,y,GlobalW);
		end;
end;

end.