unit objects;

INTERFACE

procedure init;
procedure done;
procedure go;

IMPLEMENTATION

uses main,Mode13,colors,math,Engine3D;

var
	o:P3D;
	texture,EnvMap:PTexture;
	s:TScene;
	c:TCamera;

procedure init;
var
	pal:TPal;

begin
	if not Load3D(o,'DRAGNEW') then FError('DRAGNEW.3DN');
	if not LoadTexture('ORO',EnvMap,pal) then FError('ORO.TEX');
	if not LoadTexture('LITE654',texture,pal) then FError('LITE654.TEX');
	SetEnvMap(o,ALL_CHILDS,EnvMap);
	SetTexture(o,ALL_CHILDS,texture);
	SetRenderType(o,ALL_CHILDS,_TEXTURE_ENVMAP_);
	SetMapLight(o,ALL_CHILDS,GlobalMapLight);
	o^.world.z:=1500;

	NewScene(s,MAX_FACES_IN_SCENE);
	ResetCamera(c);
end;

procedure done;
begin
	Free3D(o);
	FreeScene(s);
	FreeTexture(EnvMap);
	FreeTexture(texture);
end;

procedure go;
begin
	SetCamera(s,c);
	Rotate3D(o,DADDY,1,2,-1);
	PutAll3D(s,o);
	RenderScene(s);
end;

end.