const
	PUNTOS_CIRCULO=50;  	{Puntos por crculo}
	TOTAL_CIRCULOS=64;    {Nmero de crculos}
	ZMAX=256;
	MOVIMIENTOS_TUNEL=360;     					{Movimientos del tnel}

	cambia:boolean=FALSE;	{Cambia la distancia del tunel}

type
	Tdatos=record
		x,y:integer;
	end;

	Tcoordenadas=record
		x,y:integer;
		dir:word;
	end;
	Tstars=array[0..PUNTOS_CIRCULO] of Tcoordenadas;

var
	stars:array[0..TOTAL_CIRCULOS] of Tstars;
	datos:array[0..TOTAL_CIRCULOS] of Tdatos;
	z:array[0..TOTAL_CIRCULOS] of integer;
	add:array[0..MOVIMIENTOS_TUNEL] of Tdatos;
	n0,n1,n2,r,zz:integer;
	DirDatos,pc:word;
	MultByLenStars:array[0..TOTAL_CIRCULOS] of word;

const
	LEN_DATOS=SizeOf(Tdatos);
	LEN_COORDENADAS=SizeOf(Tcoordenadas);
	LEN_STARS=SizeOf(Tstars);

	CIRCUNFERENCIA=360;

	seno:array[1..TOTAL_CIRCULOS+CIRCUNFERENCIA] of ShortInt=(		{*100}
		21,22,3,-19,-24,-7,16,24,10,-13,-25,-13,10,24,16,-7,-24,-18,3,22,
		21,0,-21,-22,-3,19,24,6,-16,-24,-10,13,25,13,-10,-24,-16,7,24,18,
		-4,-23,-20,0,21,22,3,-19,-23,-6,16,24,10,-14,-25,-13,11,24,16,-7,
		-24,-18,4,23,20,0,-21,-22,-2,19,23,6,-17,-24,-9,14,25,12,-11,-24,
		-15,7,24,18,-4,-23,-20,1,21,22,2,-19,-23,-6,17,24,9,-14,-25,-12,
		11,24,15,-8,-24,-18,4,23,20,-1,-21,-22,-2,19,23,6,-17,-24,-9,14,
		25,12,-11,-25,-15,8,24,18,-4,-23,-20,1,21,22,2,-19,-23,-5,17,24,
		9,-14,-25,-12,11,25,15,-8,-24,-17,5,23,20,-1,-21,-22,-2,20,23,5,
		-17,-24,-8,14,25,12,-12,-25,-15,8,24,17,-5,-23,-20,1,22,22,1,-20,
		-23,-5,17,24,8,-15,-25,-12,12,25,14,-8,-24,-17,5,23,20,-2,-22,-21,
		-1,20,23,5,-17,-24,-8,15,25,11,-12,-25,-14,9,24,17,-5,-23,-19,2,
		22,21,1,-20,-23,-4,18,24,8,-15,-25,-11,12,25,14,-9,-24,-17,6,23,
		19,-2,-22,-21,-1,20,23,4,-18,-24,-8,15,24,11,-12,-25,-14,9,24,17,
		-6,-23,-19,2,22,21,1,-20,-23,-4,18,24,7,-15,-24,-11,12,25,14,-9,
		-24,-17,6,23,19,-2,-22,-21,0,20,23,4,-18,-24,-7,16,24,11,-13,-25,
		-14,10,24,16,-6,-23,-19,3,22,21,0,-20,-23,-4,18,24,7,-16,-24,-10,
		13,25,13,-10,-24,-16,6,24,19,-3,-22,-21,0,21,22,3,-18,-24,-7,16,
		24,10,-13,-25,-13,10,24,16,-7,-24,-19,3,22,21,0,-21,-22,-3,19,24,
		7,-16,-24,-10,13,25,13,-10,-24,-16,7,24,18,-3,-22,-21,0,21,22,3,
		-19,-24,-6,16,24,10,-13,-25,-13,10,24,16,-7,-24,-18,4,23,20,0,-21,
		-22,-3,19,23,6,-16,-24,-10,14,25,13,-11,-24,-16,7,24,18,-4,-23,-20,
		0,21,22,2);

	coseno:array[1..TOTAL_CIRCULOS+CIRCUNFERENCIA] of ShortInt=( 		{*160}
		21,-16,-39,-26,11,38,30,-5,-36,-33,0,33,36,5,-30,-38,-11,26,39,16,
		-22,-40,-21,17,39,26,-11,-38,-30,6,36,33,0,-34,-36,-5,30,38,10,-26,
		-39,-16,22,40,21,-17,-39,-25,12,38,29,-6,-36,-33,1,34,36,4,-30,-38,
		-10,27,39,15,-22,-40,-20,17,39,25,-12,-38,-29,6,36,33,-1,-34,-35,-4,
		31,38,10,-27,-39,-15,22,40,20,-18,-39,-25,12,38,29,-7,-37,-32,1,34,
		35,4,-31,-37,-9,27,39,15,-23,-40,-20,18,39,24,-13,-38,-29,7,37,32,
		-2,-34,-35,-3,31,37,9,-27,-39,-14,23,40,19,-18,-39,-24,13,39,28,-8,
		-37,-32,2,34,35,3,-31,-37,-9,28,39,14,-23,-40,-19,18,39,24,-13,-39,
		-28,8,37,32,-2,-35,-35,-3,32,37,8,-28,-39,-14,24,40,19,-19,-40,-24,
		14,39,28,-8,-37,-32,3,35,35,2,-32,-37,-8,28,39,13,-24,-39,-18,19,
		40,23,-14,-39,-28,9,37,31,-3,-35,-34,-2,32,37,8,-28,-39,-13,24,39,
		18,-19,-40,-23,14,39,27,-9,-37,-31,3,35,34,2,-32,-37,-7,29,38,13,
		-24,-39,-18,20,40,23,-15,-39,-27,9,38,31,-4,-35,-34,-1,32,37,7,-29,
		-38,-12,25,39,18,-20,-40,-22,15,39,27,-10,-38,-31,4,35,34,1,-33,-36,
		-6,29,38,12,-25,-39,-17,20,40,22,-15,-39,-27,10,38,30,-4,-36,-34,-1,
		33,36,6,-29,-38,-12,25,39,17,-21,-40,-22,16,39,26,-10,-38,-30,5,36,
		34,0,-33,-36,-6,30,38,11,-26,-39,-17,21,40,22,-16,-39,-26,11,38,30,
		-5,-36,-33,0,33,36,5,-30,-38,-11,26,39,16,-21,-40,-21,16,39,26,-11,
		-38,-30,5,36,33,0,-33,-36,-5,30,38,11,-26,-39,-16,22,40,21,-17,-39,
		-26,11,38,30,-6,-36,-33,0,34,36,5,-30,-38,-10,26,39,16,-22,-40,-21,
		17,39,25,-12,-38,-29,6,36,33,-1,-34,-36,-4,30,38,10,-27,-39,-15,22,
		40,20,-17,-39);

	sin:array[1..90+(CIRCUNFERENCIA*2)] of ShortInt=(
		2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
		2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
		1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
		-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
		-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
		-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
		-2,-2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
		2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
		2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,
		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
		-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
		-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
		-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
		1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
		2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
		2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
		1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

procedure _tunel;
begin
	SpeedFillChar(datos,sizeof(datos),0);
	MakeGrayScale(0,CMAX);
	InkRGB(0,negro);

	for n0:=1 to TOTAL_CIRCULOS do		{Posicin de los puntos en el espacio 3d}
		begin
			n2:=(n0 div 2)+1;
			z[n0]:=ZMAX-(n0*ZMAX div TOTAL_CIRCULOS);
			for n1:=1 to PUNTOS_CIRCULO do
				begin
					stars[n0,n1].x:=coseno[n2]*6;		{estn /4 para ocupar 1 byte}
					stars[n0,n1].y:=seno[n2]*6;
					stars[n0,n1].dir:=0;
					inc(n2,CIRCUNFERENCIA div PUNTOS_CIRCULO);
				end;
		end;

	for n0:=1 to MOVIMIENTOS_TUNEL do {Camino a recorrer, en incrementos X e Y}
		begin
			add[n0].x:=-sin[n0*2]*2;      {*2, hace un 8 en vez de un O}
			add[n0].y:=-sin[90+n0];
		end;

	for n0:=1 to TOTAL_CIRCULOS do MultByLenStars[n0]:=n0*LEN_STARS;

	ASM
		PUSH		BP
		MOV 		ES,vram
	END;

	n1:=1;r:=1;
	repeat for n2:=MOVIMIENTOS_TUNEL downto 1 do
		begin
			frame;
			if (not cambia) and (n1>3) then
				begin
					cambia:=TRUE;
					InkRGB(0,blanco);
					frame;
					InkRGB(0,negro);
				end;

			DirDatos:=ofs(datos[1]);
			for n0:=1 to TOTAL_CIRCULOS do
				begin
					ASM
						MOV			BX,n0
						ADD			BX,BX
						MOV			CX,WORD(z[BX])
						MOV			zz,CX
					END;

					if zz>0 then
						begin
							ASM
								TEST		cambia,NOT 0
								JZ			@CONTINUA
								MOV			BYTE(@CAMBIAX+2),5		{SHL AX,6 por SHL AX,5}
								MOV			BYTE(@CAMBIAY+2),5

@CONTINUA:
								MOV			SI,OFFSET[stars+LEN_COORDENADAS]
								ADD			SI,WORD(MultByLenStars[BX])

								MOV			BP,DirDatos
								MOV			pc,PUNTOS_CIRCULO
												{zz esta en CX}
@BUCLE:
									MOV			DI,Tcoordenadas[SI].dir
									MOV			BYTE(ES:[DI]),0

									MOV			AX,Tcoordenadas[SI].y
@CAMBIAY:
									SHL			AX,6
									CWD
									IDIV		CX
									ADD			AX,CENTERY
									ADD			AX,DS:Tdatos[BP].y
									MOV			BX,AX			{BX=AX=y}

									MOV			AX,Tcoordenadas[SI].x
@CAMBIAX:
									SHL			AX,6
									CWD
									IDIV		CX
									ADD			AX,CENTERX
									ADD			AX,DS:Tdatos[BP].x
									MOV			DI,AX

									CMP   	DI,XMAX
									JA     	@MAYOR
									CMP			BX,YMAX
									JA			@MAYOR

										ADD				BX,BX
										ADD				DI,WORD(MultBy320[BX])
										MOV				BYTE(ES:[DI]),CL
										MOV     	Tcoordenadas[SI].dir,DI

@MAYOR:
									ADD			SI,LEN_COORDENADAS
									DEC			pc
									JNZ			@BUCLE
							END;
						end else
							begin
								z[n0]:=ZMAX-1;
								datos[n0].x:=datos[r].x+add[n2].x;
								datos[n0].y:=datos[r].y+add[n2].y;
								r:=n0;
							end;

					dec(z[n0],2);
					inc(DirDatos,LEN_DATOS);
				end;
		end;
	inc(n1);
	until n1=6;

	ASM POP	BP END;
end;