unit rotar;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,Mode13,colors,keys,vector,MyDOS,MyMidas;

const
	ANCHO=$100;ALTO=$100;

var
	sprite:Ptexture;
	seno,CosX,SinX,CosY,SinY:array[0..DEG+COSINE] of integer;
	distancia,rotacion:integer;

procedure rota;ASSEMBLER;
ASM
	PUSH		BP

	MOV			CX,distancia
	MOV			DI,rotacion
	ADD			DI,DI

	MOV			AX,WORD(seno[DI+(DEG/2)])
	IMUL		CX
	MOV			BL,AH
	MOV			BH,DL               {cosine:=(seno[rotacion+90]*distancia)/256}

	MOV			AX,WORD(seno[DI])
	IMUL		CX
	MOV			CL,AH
	MOV			CH,DL               {sine:=(seno[rotacion]*distancia)/256}

	DB $66,$F,$AC,$CE,$10				{SHRD ESI,ECX,16}
	MOV			SI,BX								{ESI=sine:cosine}


	MOV			AX,WORD(CosX[DI])
	SUB			AX,WORD(SinY[DI]) 	{ddy=CosX-SinY}

	MOV			DX,WORD(CosY[DI])
	ADD			DX,WORD(SinX[DI]) 	{ddx=CosY+SinX}

	DB			_386;SHL	DX,16
	MOV			DX,AX								{EDX=ddx:ddy}


	XOR			DI,DI
	MOV			BP,YMAX/2							{for y:=YMAX DownTo 0 do}

	MOV			ES,vRAM

	PUSH		DS
	MOV			DS,WORD(sprite+2)

@Y:
		DB			_386;PUSH	DX      {Guardo ddx y ddy}
		MOV			CH,320/4					{for x:=XMAX/2 DownTo 0 do}

@X:
			DB $66,$0F,$A4,$D3,$10	{SHLD EBX,EDX,16 BH=ddx/256}
			MOV 		BL,DH						{BL=ddy/256}
			DB			_386;SUB	DX,SI {dec(ddx,seno);dec(ddy,coseno)}
			MOV			AL,[BX]

			DB $66,$0F,$A4,$D3,$10	{SHLD EBX,EDX,16}
			MOV 		BL,DH
			DB			_386;SUB	DX,SI
			MOV			AH,[BX]

			MOV			ES:[DI],AX
			ADD			DI,2						{plot(x,y,SpriteR[ddx/256,ddy/256]);}

			DEC			CH          		{Bucle X}
			JNZ			@X

		ADD			DI,160
		DB			_386;POP	DX      {Recupero ddx y ddy}

		DB 			_386;ROL	SI,16
		NEG			SI
{		ADD			SI,2}
		DB 			_386;ROL	SI,16

		NEG			DX
{		SUB			DX,2}
		DB 			_386;ROL 	DX,16
		MOV			AX,DX
		DB 			_386;ADD	DX,SI  	{inc(ddy,sine);}

		MOV			DX,AX
		SUB 		DX,SI             {dec(ddx,cosine);}
		DB 			_386;ROL	DX,16

		DEC			BP
		JNZ			@Y       					{Bucle Y}

	XOR			SI,SI
	MOV			DI,319
	MOV			DX,100

	MOV			AX,ES
	MOV			DS,AX

@V:
		MOV			CX,160/2
		SUB			DI,2
@H:
		MOV			AX,[SI]
		XCHG		AH,AL
		MOV			ES:[DI],AX

		ADD			SI,2
		SUB			DI,2
		DEC			CX
		JNZ			@H

		ADD			DI,320+160+2
		ADD			SI,160

		DEC			DX
		JNZ			@V


		XOR			SI,SI
		MOV			DI,320*196
		MOV			DX,100

@V1:
		MOV			CX,80
		REP;		DB _386;MOVSW
		SUB			DI,320*2
		DEC			DX
		JNZ			@V1

	POP			DS
	POP			BP
END;

procedure go;
var
	d,s:integer;
	n,m:word;
	c,c1:Tpal;
	o:Pobject;

begin
	StartCrono;
	ClearVideo;
	SetTransferMode(COPY);

	for n:=0 to high(seno) do	seno[n]:=round(256*sin(n*RAD));
	for n:=0 to DEG do
		begin
			CosX[n]:=seno[COSINE+n]*ANCHO;
			SinY[n]:=seno[n]*ALTO;
			SinX[n]:=seno[n]*ANCHO;
			CosY[n]:=seno[COSINE+n]*ALTO;
		end;

	if not LoadTexture(sprite,'PLASMA.RAW',c) then error('PLASMA.RAW');

{	p:=@sprite^;
	for m:=0 to 65535 do
		begin
			p^:=(p^ and 127)+128;
			inc(p);
		end;}
	ASM
		LES		DI,sprite
		MOV		CX,65535

@BUCLE:
		MOV		AL,ES:[DI]
		AND		AL,127
		ADD		AL,128
		MOV		ES:[DI],AL
		INC		DI
		DEC		CX
		JNZ		@BUCLE
	END;

	if not LoadObject(o,'FUTUFLAS.3D') then error('FUTUFLAS.3D');
	o^.mz:=1500;

	if not LoadPal(c,'ROTAR.RGB') then error('ROTAR.RGB');
	if not LoadTextureObject(o,'ENVMAP10.RAW',c1) then error('ENVMAP10.RAW');
	for n:=1 to 127 do c[n]:=c1[n];
	InkAllRGB(0,255,c);

	SkipFrames:=StartFrame;
	n:=0;main.i:=FALSE;
	rotacion:=180;distancia:=25;
	repeat
		s:=GetSemaphore(15);
		if (s=FLASH) or (s=FADE) then
			blanking
		else
			if not main.i then InkAllRGB(0,255,c);

		for d:=1 to SkipFrames do
			begin
				inc(rotacion);
				if rotacion=DEG then rotacion:=0;
				inc(distancia);

				with o^ do
					begin
						inc(caida);
						if caida>DEG then caida:=0;

						dec(balanza,3);
						if balanza<0 then inc(balanza,DEG);

						dec(deriva,2);
						if deriva<0 then inc(deriva,DEG);
					end;

				inc(n);
			end;

		rota;
		PutEnvMapObject(o,TRUE);

		if inkey[K_ESC] then halt;

		if (n>200) and not (main.i) then
			begin
				InitDifumine(0,255,BlackPal);
				main.i:=TRUE;
			end;
		if (main.i) and (main.difumine) then break;

		SkipFrames:=anima;
	until StopCrono>times[main.ROTAR];
	{$IFDEF _DEBUG_}
	WriteLn(fich,'ROTAR: ',StopCrono);
	{$ENDIF}

	FreeObject(o);
	FreeTextureObject(o);

	FreeTexture(sprite);
end;

end.