unit plasma;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,Mode13,vector,MyDOS,colors,MyMidas,keys,
{$IFDEF _LZ_}
	lzFiles;
{$ELSE}
	files;
{$ENDIF}

procedure go;
const
	TX=159;TY=99;

	MAGIC=round(2.7*256);

type
	T=array[0..TY,0..TX] of byte;

var
	x,y:^t;
	f:Tfile;
	d,l:word;
	texture:Ptexture;
	c:Tpal;

begin
	StartCrono;
	ClearVideo;
	SetTransferMode(NOP);

	new(x);
	new(y);
	if open(f,'TUNEL.BIN',RO)>0 then error('TUNEL.BIN');
	read(f,x^,SizeOf(t),l);
	read(f,y^,SizeOf(t),l);
	close(f);

	if not LoadTexture(texture,'PLASMA.RAW',c) then error('PLASMA.RAW');

	InkAllRGB(0,255,c);

	SkipFrames:=StartFrame;
	l:=0;
	repeat
		ASM
			PUSH		BP
			PUSH		DS
			MOV			ES,vRAM

			MOV			DX,l
			MOV			DH,DL
			XOR			DI,DI

			MOV			AX,WORD(x+2)
			DW			MOV_GS_AX

			MOV			AX,WORD(y+2)
			DW			MOV_FS_AX

			MOV			DS,WORD(texture+2)
			MOV			BP,TY*160

			MOV			CH,TY

@Y:
			MOV			CL,TX

@X:
			XOR			AH,AH
			MOV			AL,CL

			MOV			SI,BP     						{OFFSET=m*160+n}
			ADD			SI,AX

			DB			GS;MOV		BH,[SI]     {AH=y^[m,n]}
			SUB			BH,DL                 {rota}
			ADD			BH,CL

			DB			FS;MOV		BL,[SI]     {AL=x^[m,n]}
			ADD			BL,DH                 {z}
			ADD			BL,CH

			MOV			AL,[BX]               {AL=texture^[AH,AL]}

			MOV			AH,AL
			MOV			ES:[DI],AX
			MOV			ES:[DI+320],AX
			ADD			DI,2

			DEC     CL
			JNZ			@X

			SUB			BP,160								{Next y^ line}
			ADD			DI,322								{Next VGA line}

			DEC			CH
			JNZ			@Y

			POP			DS
			POP			BP
		END;

		if inkey[K_ESC] then halt;

		for d:=1 to SkipFrames do dec(l);

		SkipFrames:=anima;
	until StopCrono>times[main.PLASMA1];

	{$IFDEF _DEBUG_}
	WriteLn(fich,'PLASMA1: ',StopCrono);
	{$ENDIF}

	StartCrono;
	blanking;
	anima;
	anima;
	InkAllRGB(0,255,c);
	anima;

	SkipFrames:=StartFrame;
	l:=0;
	repeat
		ASM
			PUSH		BP
			PUSH		DS
			MOV			ES,vRAM

			MOV			DX,l
			MOV			DH,DL
			XOR			DI,DI

			MOV			AX,WORD(x+2)
			DW			MOV_GS_AX

			MOV			AX,WORD(y+2)
			DW			MOV_FS_AX

			MOV			DS,WORD(texture+2)
			MOV			BP,TY*160

			MOV			CH,TY

@Y:
			MOV			CL,TX

@X:
			XOR			AH,AH
			MOV			AL,CL

			MOV			SI,BP     						{OFFSET=m*160+n}
			ADD			SI,AX

			DB			GS;MOV		BH,[SI]     {AH=y^[m,n]}
			SUB			BH,DL                 {rota}

			DB			FS;MOV		BL,[SI]     {AL=x^[m,n]}
			ADD			BL,CH                 {z}

			MOV			AL,[BX]               {AL=texture^[AH,AL]}

			MOV			AH,AL
			MOV			ES:[DI],AX
			MOV			ES:[DI+320],AX
			ADD			DI,2

			DEC     CL
			JNZ			@X

			SUB			BP,160								{Next y^ line}
			ADD			DI,322								{Next VGA line}

			DEC			CH
			JNZ			@Y

			POP			DS
			POP			BP
		END;

		if inkey[K_ESC] then halt;

		for d:=1 to SkipFrames do dec(l);

		SkipFrames:=anima;
	until StopCrono>times[main.PLASMA2];

	{$IFDEF _DEBUG_}
	WriteLn(fich,'PLASMA2: ',StopCrono);
	{$ENDIF}

	StartCrono;
	blanking;
	anima;
	anima;
	InkAllRGB(0,255,c);
	anima;

	SkipFrames:=StartFrame;
	l:=0;
	repeat
		ASM
			PUSH		BP
			PUSH		DS
			MOV			ES,vRAM

			MOV			DX,l
			MOV			DH,DL
			XOR			DI,DI

			MOV			AX,WORD(x+2)
			DW			MOV_GS_AX

			MOV			AX,WORD(y+2)
			DW			MOV_FS_AX

			MOV			DS,WORD(texture+2)
			MOV			BP,TY*160

			MOV			CH,TY

@Y:
			MOV			CL,TX

@X:
			XOR			AH,AH
			MOV			AL,CL

			MOV			SI,BP     						{OFFSET=m*160+n}
			ADD			SI,AX

			DB			GS;MOV		BH,[SI]     {AH=y^[m,n]}
			ADD			BH,CL                 {rota}

			DB			FS;MOV		BL,[SI]     {AL=x^[m,n]}
			SUB			BL,DH                 {z}

			MOV			AL,[BX]               {AL=texture^[AH,AL]}

			MOV			AH,AL
			MOV			ES:[DI],AX
			MOV			ES:[DI+320],AX
			ADD			DI,2

			DEC     CL
			JNZ			@X

			SUB			BP,160								{Next y^ line}
			ADD			DI,322								{Next VGA line}

			DEC			CH
			JNZ			@Y

			POP			DS
			POP			BP
		END;

		if inkey[K_ESC] then halt;

		for d:=1 to SkipFrames do dec(l);

		SkipFrames:=anima;
	until StopCrono>times[main.PLASMA3];

	{$IFDEF _DEBUG_}
	WriteLn(fich,'PLASMA3: ',StopCrono);
	{$ENDIF}

	StartCrono;
	blanking;
	anima;
	anima;
	InkAllRGB(0,255,c);
	anima;

	SkipFrames:=StartFrame;
	l:=0;
	repeat
		ASM
			PUSH		BP
			PUSH		DS
			MOV			ES,vRAM

			MOV			DX,l
			MOV			DH,DL
			XOR			DI,DI

			MOV			AX,WORD(x+2)
			DW			MOV_GS_AX

			MOV			AX,WORD(y+2)
			DW			MOV_FS_AX

			MOV			DS,WORD(texture+2)
			MOV			BP,TY*160

			MOV			CH,TY

@Y:
			MOV			CL,TX

@X:
			XOR			AH,AH
			MOV			AL,CL

			MOV			SI,BP     						{OFFSET=m*160+n}
			ADD			SI,AX

			DB			GS;MOV		BH,[SI]     {AH=y^[m,n]}
			SUB			BH,DL                 {rota}
			OR			BH,CL

			DB			FS;MOV		BL,[SI]     {AL=x^[m,n]}
			ADD			BL,DH                 {z}
			OR			BL,CH

			MOV			AL,[BX]               {AL=texture^[AH,AL]}

			MOV			AH,AL
			MOV			ES:[DI],AX
			MOV			ES:[DI+320],AX
			ADD			DI,2

			DEC     CL
			JNZ			@X

			SUB			BP,160								{Next y^ line}
			ADD			DI,322								{Next VGA line}

			DEC			CH
			JNZ			@Y

			POP			DS
			POP			BP
		END;

		if inkey[K_ESC] then halt;

		for d:=1 to SkipFrames do dec(l);

		SkipFrames:=anima;
	until StopCrono>times[main.PLASMA4];
	{$IFDEF _DEBUG_}
	WriteLn(fich,'PLASMA4: ',StopCrono);
	{$ENDIF}

	StartCrono;
	blanking;
	anima;
	anima;
	InkAllRGB(0,255,c);
	anima;

	SkipFrames:=StartFrame;
	l:=0;
	repeat
		ASM
			PUSH		BP
			PUSH		DS
			MOV			ES,vRAM

			MOV			DX,l
			MOV			DH,DL
			XOR			DI,DI

			MOV			AX,WORD(x+2)
			DW			MOV_GS_AX

			MOV			AX,WORD(y+2)
			DW			MOV_FS_AX

			MOV			DS,WORD(texture+2)
			MOV			BP,TY*160

			MOV			CH,TY

@Y:
			MOV			CL,TX

@X:
			XOR			AH,AH
			MOV			AL,CL

			MOV			SI,BP     						{OFFSET=m*160+n}
			ADD			SI,AX

			DB			GS;MOV		BH,[SI]     {AH=y^[m,n]}
			OR			BH,DL
			SUB			BH,CL

			DB			FS;MOV		BL,[SI]     {AL=x^[m,n]}
			OR			BL,DH
			ADD			BL,CH

			MOV			AL,[BX]               {AL=texture^[AH,AL]}

			MOV			AH,AL
			MOV			ES:[DI],AX
			MOV			ES:[DI+320],AX
			ADD			DI,2

			DEC     CL
			JNZ			@X

			SUB			BP,160								{Next y^ line}
			ADD			DI,322								{Next VGA line}

			DEC			CH
			JNZ			@Y

			POP			DS
			POP			BP
		END;

		if inkey[K_ESC] then halt;

		for d:=1 to SkipFrames do dec(l);

		SkipFrames:=anima;
	until StopCrono>times[main.PLASMA5];
	{$IFDEF _DEBUG_}
	WriteLn(fich,'PLASMA5: ',StopCrono);
	{$ENDIF}

	DifumineToColor(0,255,black);

	dispose(x);
	dispose(y);
	FreeTexture(texture);
end;

end.