unit meteor;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,Mode13,vector,colors,keys,MyDOS,MyMidas;

const
	MAX=50;{}
	TOPEX=1000;
	TOPEY=1000;
	TOPEZ=6000;

type
	Tpos=record
		b,d,c,
		x,y,z,
		v,s:integer;
	end;

var
	pos:array[0..MAX] of Tpos;

procedure Qsort(m:integer);

	procedure sort(l,r:integer);
var
	i,j,x:integer;
	y:Tpos;
	pi,pj:^Tpos;

begin
	i:=l;j:=r;
	x:=pos[(i+j) div 2].z;

	pi:=@pos[i];
	pj:=@pos[j];
	repeat
		while pi^.z>x do
			begin
				inc(i);
				inc(pi);
			end;
		while x>pj^.z do
			begin
				dec(j);
				dec(pj);
			end;

		if i<=j then
			begin
				y:=pi^;
				pi^:=pj^;
				pj^:=y;

				inc(i);
				dec(j);
			end;
	until i>j;

	if l<j then sort(l,j);
	if i<r then sort(i,r);
end;

begin
	sort(0,m);
end;

procedure go;
var
	n,mm:boolean;
	c,c1:Tpal;
	f:LongInt;
	a,b,d,s:integer;
	o,m:Pobject;

begin
	StartCrono;
	ClearVideo;
	SetTransferMode(COPY_BACKGROUND);

	if not LoadObject(m,'METEOR.3D') then error('METEOR.3D');
	m^.mz:=8000;

	if not LoadObject(o,'PIEDRA.3D') then error('PIEDRA.3D');
	o^.ZClipMin:=100;

	if not LoadIMG('METEOR.IMG',BackPage,c) then error('METEOR.IMG');

	if not LoadPal(c1,'METEOR.RGB') then error('METEOR.RGB');
	for b:=128 to 255 do c[b-128]:=c1[b];
	InkAllRGB(0,255,c);

	if not LoadTextureObject(m,'ENVMAP10.RAW',c1) then error('ENVMAP10.RAW');

	for b:=0 to MAX do with pos[b] do
		begin
			x:=aleatorio(-TOPEX,TOPEX);
			y:=aleatorio(-TOPEY,TOPEY);
			z:=1000+random(5000);

			s:=aleatorio(50,100);

			b:=random(DEG);
			d:=random(DEG);
			c:=random(DEG);
		end;

	PutGouraudLight(-10,-10,-10);
	SkipFrames:=StartFrame;
	main.i:=FALSE;mm:=FALSE;
	a:=MAX;
	f:=0;
	repeat
		s:=GetSemaphore(15);
		if (s=FLASH) or (s=FADE) then
			blanking
		else
			if not main.i then InkAllRGB(0,255,c);

		if mm then
			begin
				PutEnvMapObject(m,TRUE);

				for d:=1 to SkipFrames do
					with m^ do
						begin
							if mz>800 then dec(mz,100);

							inc(caida);
							if caida>DEG then caida:=0;

							dec(balanza,2);
							if balanza<0 then inc(balanza,DEG);

							dec(deriva);
							if deriva<0 then deriva:=DEG;
						end;

				inc(f);
				if (f>7000) and not (main.i) then
					begin
						FillChar(BlackPal,SizeOf(BlackPal),0);{}
						InitDifumine(0,255,BlackPal);
						main.i:=TRUE;
					end;
			end;

		if (a<2) and (not mm) then
			begin
				for b:=1 to 127 do c[b]:=c1[b];
				InkAllRGB(0,255,c);
				a:=0;
				mm:=TRUE;
			end;

		if a>0 then
			begin
				qsort(a);

				for b:=0 to MAX do
					begin
						for d:=1 to SkipFrames do
							with pos[b] do if z>0 then
								begin
									o^.mx:=x;
									o^.my:=y;
									o^.mz:=z;

									o^.balanza:=b;
									o^.deriva:=d;
									o^.caida:=c;

									inc(c,2);
									if c>DEG then dec(c,DEG);

									inc(b,4);
									if b>DEG then dec(b,DEG);

									inc(d,8);
									if d>DEG then dec(d,DEG);

									if z>s then
										dec(z,s)
									else
										if f<5000 then
											begin
												x:=aleatorio(-TOPEX,TOPEX);
												y:=aleatorio(-TOPEY,TOPEY);
												z:=TOPEZ;
											end
										else
											begin
												dec(a);
												z:=0;
											end;

									inc(v);
									n:=v and 7=0;

									inc(f);
								end;

						PutGouraudObject(o,n);
					end;
			end;

		if inkey[K_ESC] then halt;

		if (main.i) and (main.difumine) then break;

		SkipFrames:=anima;
	until StopCrono>times[main.METEOR];

	{$IFDEF _DEBUG_}
	WriteLn(fich,'METEOR: ',StopCrono,' ',f);
	{$ENDIF}

	FreeObject(m);
	FreeObject(o);
end;

end.