unit main;

INTERFACE

uses colors;

const
	_CODE_=1;
	_GFX_=_CODE_+1;
	_MUSIC_=_GFX_+1;

	FIRST_LETTER=_MUSIC_+1;
	LAST_LETTER=FIRST_LETTER+29-1;

type
	demo=(FESTY,S3,AVALANCE,DEFORMACION,PRESENT1,PRESENT2,ESTRELLA,MANTA,METEOR,
				MISTOS,TUNNEL,ROTAR,HORMIGA,TUNEL1,TUNEL2,ESPERMA1,ESPERMA2,CHINCHE,
				MERDUSCO,PLASMA1,PLASMA2,PLASMA3,PLASMA4,PLASMA5,BOBS,GRIFO,BLOBS,
				CUEVA,CREDITS);

const
	times:array[demo] of word=(	700,577,620,1359,255,300,1220,2050,2200,2550,
															380,1300,2023,800,1600,1500,679,1750,1925,178,
															180,180,180,180,1200,2892,1200,2300,6820);

type
	Tdir=(HORIZONTAL,VERTICAL,DIAGONAL);

var
	SkipFrames:integer;
	i:boolean;
	{$IFDEF _DEBUG_}
	fich:text;
	{$ENDIF}

procedure init;
procedure done;

procedure error(n:string);
procedure err(n:string);

procedure ClearVideo;

procedure print(x,y:integer;c:string);
procedure InitCortina(dir:Tdir;var c:Tpal;color:TRGB);
function cortina:boolean;

procedure InitDifumine(p,u:integer;var c:Tpal);
function difumine:boolean;

procedure StartCrono;
function StopCrono:word;

procedure Blanking;

IMPLEMENTATION

uses Anima13,Mode13,keys,MyDOS,CRT,cadenas,DOS,MyMidas,speed
{$IFDEF _LZ_}
	,LzFiles
{$ENDIF}

{$IFDEF _EMS_}
	,MyEMS
{$ENDIF}
	;

const
	message:string='Anubis by The Banner'+#13+#10+#13+#10+
								 'MIDAS by Sahara Surfers';

var
	OldProc:pointer;

	translate:array[char] of byte;

	cc,f,l,nc:integer;
	pw,work,vieja:Tpal;
	pal:^Tpal;

	Old8:pointer;
	first:boolean;

	Ticks:word;

	cd:Tdir;

	old:LongInt;

procedure Myint8;INTERRUPT;
begin
	PUSHF;
	ASM CALL Old8	END;

{	sf:=GetSemaphore(3);}

	inc(ticks);

	STI;
END;

procedure init;
begin
	first:=FALSE;
	randomize;
	{$IFDEF _LZ_}

	{$IFNDEF _DEBUG_}
	if LzInit('ANUBIS.EXE')<>0 then error('Error in file ANUBIS.EXE');
	{$ELSE}
	if LzInit('ANUBIS.DAT')<>0 then error('Error in file ANUBIS.DAT');
	{$ENDIF}

	{$ENDIF}

	{$IFDEF __BPPROT__}
	if MemAvail<2000*1024 then error('Need 2 MB free');
	{$ELSE}
	if not MyEMS.init then error('No EMS memory');
	if MyEMS.MemAvail*16<2000*1024 then error('Need 2 MB of EMS');
	{$ENDIF}

	if Test8086<2 then error('Need a 386+');
	if Test8087<3 then error('Need a 387+');

	if not Mymidas.init(16) then error('Anubis by the Banner');	{ESC}
	first:=TRUE;
	keys.init;

	if not Mode13.init(COPY_BACKGROUND) then error('Need a VGA');
	if not LoadModule('ANUBIS.MOD') then error('Error in file ANUBIS.MOD');

	PlayModule;		{with timer syncro{}

	GetIntVec(8,Old8);
	SetIntVec(8,@MyInt8);

	delay(1);
end;

{$F+}
procedure done;
begin
	{$IFDEF _LZ_}
	LzDeInit;
	{$ENDIF}

	{$IFDEF _DEBUG_}
	system.close(fich);
	{$ENDIF}

	if first then
		begin
			SetIntVec(8,Old8);

			StopModule;
			MyMidas.done;
		end;

	keys.done;
	Mode13.done;

	WriteLn(message);

	ExitProc:=OldProc;
end;
{$F-}

procedure error(n:string);
begin
	message:='Error in file '+n;
	halt;
end;

procedure err(n:string);
begin
	message:='Error in file '+n;
	halt;
end;

procedure ClearVideo;
begin
	FillChar(PvRAM^,vRAMSize,0);
	FillChar(PBackPage^,vRAMSize,0);
	FillChar(VGA^,vRAMSize,0);
end;

procedure print(x,y:integer;c:string);
var
	n:integer;
	s:Tsprite;
	m:char;

begin
	for n:=1 to length(c) do
		begin
			m:=c[n];
			if m<>' ' then
				begin
					s.n:=translate[m];
					s.x:=x;s.y:=y;
					PutSpriteMask(s,NIL);
				end;
			inc(x,Sdim[FIRST_LETTER].width);
		end;
end;

procedure InitCortina(dir:Tdir;var c:Tpal;color:RGB);
begin
	c[255]:=color;
	InkAllRGB(0,255,c);
	nc:=0;
	if dir=DIAGONAL then nc:=2;

	cd:=dir;
end;

function cortina:boolean;
var
	n,m:integer;

begin
	cortina:=FALSE;

	case cd of
		HORIZONTAL:
			begin
				for n:=0 to nc do for m:=0 to 19 do DrawH(0,n+(m*12),XMAX,255);

				inc(nc);
				if nc>15 then cortina:=TRUE;
			end;

		VERTICAL:
			begin
				for n:=0 to nc do for m:=0 to 19 do DrawV(n+(m*16),0,YMAX,255);

				inc(nc);
				if nc>15 then cortina:=TRUE;
			end;

		DIAGONAL:
			begin
				for n:=0 to nc do draw(0,YMAX-1,n,0,255);
				for n:=0 to nc-XMAX-1 do draw(0,YMAX-1,XMAX-1,n,255);

				inc(nc,6);
				if nc>XMAX-1+YMAX-1 then cortina:=TRUE;
			end;
	end;
end;

procedure InitDifumine(p,u:integer;var c:Tpal);
begin
	f:=p;l:=u;
	pal:=@c;
	cc:=0;

	GetAllRGB(f,l,vieja);
end;

function difumine:boolean;
var
	n:integer;
	v,p,w:^RGB;

begin
	difumine:=FALSE;
	if cc>=32 then
		begin
			difumine:=TRUE;
			exit;
		end;
	inc(cc);

	v:=@vieja[f];
	p:=@pal^[f];
	w:=@work[f];
	for n:=f to l do
		begin
			with w^ do
				begin
					red:=
						((v^.red*(32-cc))+
						 (p^.red*cc)) shr 5;

					green:=
						((v^.green*(32-cc))+
						 (p^.green*cc)) shr 5;

					blue:=
						((v^.blue*(32-cc))+
						 (p^.blue*cc)) shr 5;
				end;

			inc(w);
			inc(v);
			inc(p);
		end;

	InkAllRGB(f,l,work);
end;

procedure StartCrono;
begin
	ticks:=0;
end;

function StopCrono:word;
begin
	StopCrono:=ticks;
end;

procedure blanking;
begin
	InkAllRGB(0,255,pw);
end;

var
	n:char;
	m:integer;

begin
	OldProc:=ExitProc;
	ExitProc:=@done;

	m:=FIRST_LETTER;
	for n:='A' to 'Z' do
		begin
			translate[n]:=m;
			inc(m);
		end;
	for n:='1' to '3' do
		begin
			translate[n]:=m;
			inc(m);
		end;

	init;

	FillChar(pw,SizeOf(pw),63);

	{$IFDEF _DEBUG_}
	assign(fich,'ANUBIS.TIM');
	system.ReWrite(fich);
	{$ENDIF}
end.