unit cueva;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,Mode13,vector,colors,keys,MyMidas;

procedure go;
var
	o:Pobject;
	c:Tpal;
	a,d,l,m,s,x,y,z:integer;

begin
	StartCrono;
	ClearVideo;
	SetTransferMode(COPY);	{COPY_CLEAR}

	if not LoadObject(o,'CUEVA.3D') then error('CUEVA.3D');
	with o^ do
		begin
			mz:=7000;ZclipMin:=200;
		end;
	RemapColors(o,0,15);

	if not LoadLightObject(o,'CUEVA.LGT') then error('CUEVA.LGT');

	if not LoadTextureObject(o,'CUEVA.RAW',c) then error('CUEVA.RAW');
	FillChar(c[128],128*3,0);
	InkAllRGB(0,255,c);

	SkipFrames:=StartFrame;
	main.i:=FALSE;
	a:=0;m:=0;l:=90;
	repeat
		s:=GetSemaphore(15);
		if (s=FLASH) or (s=FADE) then
			blanking
		else
			InkAllRGB(0,255,c);

		for d:=1 to SkipFrames do
			begin
				x:=32*sine[l] div ESCALE;
				y:=16*sine[l+COSINE] div ESCALE;
				z:=64*sine[l] div ESCALE;
				inc(l,4);
				if l>DEG then dec(l,DEG);

				with o^ do
					begin
						mx:=(1024*sine[a]) div ESCALE;
						inc(a,2);
						if a>DEG then dec(a,DEG);

						inc(deriva);
						if deriva>DEG then dec(deriva,DEG);
					end;

				inc(m);
				if m=1050 then
					begin
						InitCortina(HORIZONTAL,c,black);
						main.i:=TRUE;
					end;
			end;

		PutGouraudLight(x,y,z);
		PutTextureGouraudObject(o,TRUE);

		if (main.i) and (cortina) then break;

		if inkey[K_ESC] then halt;

		SkipFrames:=anima;
	until StopCrono>times[main.CUEVA];
	{$IFDEF _DEBUG_}
	WriteLn(fich,'CUEVA: ',StopCrono);
	{$ENDIF}

	FreeTextureObject(o);
	FreeObject(o);
end;

end.