#version 330
#extension GL_ARB_explicit_uniform_location : enable

in vec2 uv;
out vec4 fragcolor;
uniform float t;
uniform sampler2D tex;
uniform sampler2D blurtex;
  
mat2 rotate2d(float angle)
{
    return mat2(cos(angle),-sin(angle),
                sin(angle),cos(angle));
}

float rand(float n){return fract(sin(n) * 43758.5453123);}

void main ()
{
  vec4 res, blur;
      
  res = texture(tex, uv.xy);
  blur = texture(blurtex, uv.xy);
  
  float cdist = sqrt(1 - sqrt((uv.x-0.5) * (uv.x-0.5) + (uv.y-0.5)*(uv.y-0.5))/0.7);
  
  mat2 r = rotate2d(t * 5 + rand(uv.x+uv.y*uv.y)*1000);
  
  vec4 blurred;
  int i;
  vec2 v = vec2(0.5,0);
  for (i = 0; i < 16; i++)
  {
    blurred = max(blurred,texture(tex, uv.xy - (r * v * i) / 1024.0));
  }
  
  res = res * 0.5 + blurred * 0.5;
  res = max(res, blur);
  res = res * cdist * cdist;
  
  fragcolor = res;
}