#version 330
#extension GL_ARB_explicit_uniform_location : enable

layout(location = 1) in vec4 vertexposition;
layout(location = 3) in vec4 vertexnormal;

uniform mat4 mvp;
uniform mat4 mv;
uniform vec4 incolor;
uniform float time;

out vec4 color;
out vec4 coord;
out vec4 normal;

void main()
{
    vec4 vp = vertexposition + vertexnormal * sin(time * 3.14 * 0.2) * 0.04;    
    vp.w = vertexposition.w;
	gl_Position = mvp * vp;
	color = incolor;
	coord = mv * vp;
	normal = mv * vertexnormal;
}