#version 330
#extension GL_ARB_explicit_uniform_location : enable

in vec2 uv;
in vec4 coord;

out vec4 fragcolor;
uniform sampler2D tex1, tex2, tex3, tex4;
uniform float scrollamount;

mat2 rotate2d(float angle)
{
    return mat2(cos(angle),-sin(angle),
                sin(angle),cos(angle));
}

void main()
{	
    float s = scrollamount * 2;
    vec2 uv0 = uv - 0.5;
    vec2 uv1 = rotate2d(s * -0.2) * uv0.xy + 0.5 + vec2(s *  0.2, 0);
    vec2 uv2 = rotate2d(s *  0.1) * uv0.xy + 0.5 + vec2(0,        s * 0.1);
    vec2 uv3 = rotate2d(s * -0.3) * uv0.xy + 0.5 + vec2(s * -0.1, s * 0.1);
    vec2 uv4 = rotate2d(s *  0.4) * uv0.xy + 0.5 + vec2(s * -0.1, 0); 
  
    float c = (texture(tex1, uv1.xy) *
               texture(tex2, uv2.xy) *
               texture(tex3, uv3.xy) *
               texture(tex4, uv4.xy)).x * 10;    

    c = (clamp(c * c, 0.5, 0.7) - 0.5) * 2.5;

    if (uv.x < 0.05) c *= uv.x * 20;
    if (uv.x > 0.95) c *= (1 - uv.x) * 20;
   
   if (c < 0.2) discard;
   
    fragcolor = vec4(1,1,1,1);
}