#version 330
#extension GL_ARB_explicit_uniform_location : enable

in vec4 coord;
in vec4 color;
out vec4 fragcolor;
uniform sampler2D shadowmap;
uniform mat4 shadowmatrix;

float getshadowsample(vec4 coord)
{
    float shadowdepth = texture(shadowmap, coord.xy).r;

    if (coord.w > 0.0 && 
        shadowdepth < coord.z &&
        coord.x > 0.0 &&
        coord.y > 0.0 &&
        coord.x < 1.0 &&
        coord.y < 1.0)
    {
        return 0.0;
    }
    return 1.0;
}

vec2 poissonDisk[16] = vec2[](
vec2( -0.94201624, -0.39906216 ),
vec2( 0.94558609, -0.76890725 ),
vec2( -0.094184101, -0.92938870 ),
vec2( 0.34495938, 0.29387760 ),
vec2( -0.91588581, 0.45771432 ),
vec2( -0.81544232, -0.87912464 ),
vec2( -0.38277543, 0.27676845 ),
vec2( 0.97484398, 0.75648379 ),
vec2( 0.44323325, -0.97511554 ),
vec2( 0.53742981, -0.47373420 ),
vec2( -0.26496911, -0.41893023 ),
vec2( 0.79197514, 0.19090188 ),
vec2( -0.24188840, 0.99706507 ),
vec2( -0.81409955, 0.91437590 ),
vec2( 0.19984126, 0.78641367 ),
vec2( 0.14383161, -0.14100790 )
);

// Returns a random number based on a vec3 and an int.
float random(vec3 seed, int i)
{
    vec4 seed4 = vec4(seed, i);
    float dot_product = dot(seed4, vec4(12.9898,78.233,45.164,94.673));
    return fract(sin(dot_product) * 43758.5453);
}

void main()
{	
    vec4 s = vec4(1,1,1,1);
    vec4 shadowcoord = shadowmatrix * coord;
    shadowcoord /= shadowcoord.w;
    
    float shade = 0;
    for (int i = 0; i < 16; i++)
    {
        //int index = int(16.0*random(floor(origcoord.xyz*1000.0), i))%16;
        vec4 temp = shadowcoord;
        temp.xy += poissonDisk[i]/400.0;
        shade += getshadowsample(temp);
    }
    shade = shade / 16.0;
    shade = (1.0 + shade * 3.0) / 4.0;
        
    s = vec4(shade,shade,shade,1);

	fragcolor = color * s;
/*
if (shade > 0)
    fragcolor = vec4(1,0,0,1);
    else
    fragcolor = color;
    */
}