class Color
{
public:
	float  fRedValue, fGreenValue, fBlueValue;
	USHORT iValue;
	USHORT iRedValue, iGreenValue, iBlueValue;
	unsigned short getInteger(unsigned char r,unsigned char v,unsigned char b)
	{
	//  0 to 31 intensity
		iRedValue   = (unsigned short)(r<<8) & 0xf800;
		iGreenValue =(unsigned short)(v<<3) & 0x7c0;
		iBlueValue  =(unsigned short)b>>3;
		iValue = iRedValue | iGreenValue | iBlueValue;

		iRedValue = r;
		iGreenValue = v;
		iBlueValue = b;
		return(iValue);
	}

	void isBlack()
	{
		fRedValue = 0;
		fGreenValue = 0;
		fBlueValue = 0;
		iValue = 0;
		iRedValue = 0;
		iGreenValue = 0;
		iBlueValue = 0;
	}

	void allIntensityNoclip(float it)
	{
		fRedValue   *= it;
		fGreenValue *= it;
		fBlueValue  *= it;

		iRedValue   = (USHORT)(255*(it * ((float)iRedValue/255.0f)));
		iGreenValue = (USHORT)(255*(it * ((float)iGreenValue/255.0f)));
		iBlueValue  = (USHORT)(255*(it * ((float)iBlueValue/255.0f)));
		iValue = iRedValue | iGreenValue | iBlueValue;
	}
	void toFloat()
	{
		fRedValue   = (float)iRedValue   / 255.0f;
		fGreenValue = (float)iGreenValue / 255.0f;
		fBlueValue  = (float)iBlueValue  / 255.0f;
	}

	void to16Bits()
	{
		iValue = ((iRedValue & 0xf8)<<8) | ((iGreenValue & 0xfc)<<3) | (iBlueValue>>3);
	}

	float GetRed(unsigned short color)
	{
		return(	0.03125F* (float)(color>>11) ); 
	}
	
	float GetGreen(unsigned short color)
	{
		return(	0.015625F* (float)((color & 0x7ff)>>5) );
	}

	float GetBlue(unsigned short color)
	{
		return(	0.03125F* (float)(color & 0x1f) ); 
	}

	unsigned short GetiRed(unsigned short color)
	{
		return( (color >> 8) & 0x00f8); 
	}

	unsigned short GetiGreen(unsigned short color)
	{
		return( (color >> 3) & 0x00fc); 
	}

	unsigned short GetiBlue(unsigned short color)
	{
		return( (color << 3) & 0x00ff); 
	}

};