// Object oriented OpenGL engine
// (c)'00+'01 by SquoQuo
// All code done by Hopper/SquoQuo
// 01/01/26
//
// *** class part dispatcher ***
// This class offers the functions to access all part functions
// It reads the project file

#include <stdlib.h>		// for NULL definition
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "Scene.h"
// Example scripting engine
// written based on Obs engine
// (c)'01 by SquoQuo
// All code done by Hopper/SquoQuo

#include "Part.h"

#ifndef __ENGINE_PART_DISPATCHER
#define __ENGINE_PART_DISPATCHER

#define MAX_SCENES 40
#define MAX_PARTS 1000
typedef unsigned char byte;

class PartDispatcher
{
public:
	// constructor
	PartDispatcher();

	// destructor
	~PartDispatcher();

	// tries to get the function given by the name (e.g. "part1.render")
	// if successful the pointer to that function is returned
	void (*getFunctionByName(Scene *scene, char *name))(void *tthis, float time, void **p);

	// tries to get the scene pointer give by the name (e.g. "part1.render")
	void *getThisByName(char *name);

	// registers the scene for later call
	void registerScene(Scene *scene);

	// loads the project given by the filename
	// check fileformat.txt of the Demo Editor
	void loadProject(char *filename);

	// Executes all parts, that are active at the given time
	void execute(float time);

	// Executes all past parts
	void executeOldParts(void);

private:
	Scene **scenes;			// all registered scenes
	int sCount;					// counter for the scenes array
	FILE *in;					// file which holds the project infos
	Part **parts;				// all parts from the project file
	int actualFirstPart;		// number of the first part, that is already active (i.e. hasn't finished yet)
	float totalTime;			// total time of the demo
	float startTime;

	// private functions, that read special types from the file
	float readFloat();
	int readInt();
	byte readByte();
	bool readBool();
	char* readString();
	void readPart(int num);
};

#endif