/**********************************************

	PTAB - Crea y maneja TAB controls sin usar
	la MFC de mierda
	code: pK

  http://solstice.scenesp.org

 Linkear con comctl32.lib. Los dialogs que se le acoplen 
 debe ser "CHILD" y sin borde

 **********************************************/

#include <commctrl.h>

#define PTAB_MAXPANELS	10
#define WM_UPDATEDGI		WM_USER+2

typedef struct
{

	HWND hdwnd;			// Handle de la tab
	HWND hdwndChild;	// Handle del dialog que esta mostrando
	HINSTANCE hInst;	// Instancia
	int LastPanelIndex;	// Ultimo panel establecido

	RECT		panrect;	// Area del panel

	HWND		DialogHandle[PTAB_MAXPANELS]; // Guarda los hwnd de los dialogs
	DLGPROC		DialogProc[PTAB_MAXPANELS];	
	LPCSTR		DialogResName[PTAB_MAXPANELS];	// Guarda el nombre del resource
	DLGTEMPLATE	*Dialog[PTAB_MAXPANELS];

} tPTAB;

DLGTEMPLATE * WINAPI DoLockDlgRes(HINSTANCE hInst, LPCSTR lpszResName) 
{ 
	HRSRC hrsrc = FindResource(NULL, lpszResName, RT_DIALOG); 
	HGLOBAL hglb = LoadResource(hInst, hrsrc); 
	return (DLGTEMPLATE *) LockResource(hglb); 
} 

bool PTAB_ShowPanel(tPTAB *tab, int PanelIndex)
{


	if (PanelIndex == tab->LastPanelIndex) { return true; }

	ShowWindow(tab->hdwndChild, SW_HIDE); // Ocultamos el actual

	tab->hdwndChild = tab->DialogHandle[PanelIndex];

	RECT r;

	GetClientRect(tab->hdwnd, &r);

	// Ajustamos la dimension del dialog al panel
	//SetWindowPos(tab->DialogHandle[PanelIndex], tab->hdwnd, 2, 25, tab->panrect.left+tab->panrect.right-25, tab->panrect.top+tab->panrect.bottom-50, SWP_NOZORDER);
	SetWindowPos(tab->DialogHandle[PanelIndex], tab->hdwnd, r.left+3, r.top+25, r.right-r.left-5, r.bottom-r.top-30, SWP_NOZORDER);

	ShowWindow(tab->DialogHandle[PanelIndex], SW_SHOWNORMAL);

	SendMessage(tab->DialogHandle[PanelIndex], WM_UPDATEDGI, 0, 0);	

	tab->LastPanelIndex = PanelIndex;

	return true;

}

/*
	PTAB_Create
	Crea una nueva tab y devuelve su handle
*/
HWND WINAPI PTAB_Create(HINSTANCE hInstance, tPTAB *tab, HWND hwndParent, int x, int y, int width, int height) 
{ 


    RECT rcClient; 
    HWND hwndTab;      

	rcClient.left = x;
	rcClient.top = y;
	rcClient.right = x+width;
	rcClient.bottom = y+height;

	tab->panrect = rcClient;

    InitCommonControls(); 

    hwndTab = CreateWindow( 
        WC_TABCONTROL, "", 
        WS_CHILD | WS_CLIPSIBLINGS | WS_VISIBLE, 
        rcClient.left, rcClient.top, rcClient.right-rcClient.left, rcClient.bottom-rcClient.top, 
        hwndParent, NULL, hInstance, NULL 
        ); 

    if (hwndTab == NULL) { return NULL; }
	
	tab->hdwnd = hwndTab;
	tab->hInst = hInstance;
	tab->LastPanelIndex = -1;
 
    return hwndTab; 
} 

int PTAB_InsertPanel(tPTAB *tab, int PanelIndex, char *text, LPCSTR DlgResourceName, DLGPROC DialogProc)
{

	TCITEM tie;

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = text; 

	TabCtrl_InsertItem(tab->hdwnd, PanelIndex, &tie);

	tab->Dialog[PanelIndex] = DoLockDlgRes(tab->hInst, MAKEINTRESOURCE(DlgResourceName)); 
	
	tab->hdwndChild = tab->DialogHandle[0]; // Siempre se muestra por defecto el primero

	tab->DialogProc[PanelIndex] = (DLGPROC)DialogProc;
	tab->DialogResName[PanelIndex] = DlgResourceName;

	HWND d = CreateDialogIndirect(tab->hInst, tab->Dialog[PanelIndex], tab->hdwnd, (DLGPROC)DialogProc); 			
	tab->DialogHandle[PanelIndex] = d; // Store dialog handle

	// Ajustamos la dimension del dialog al panel
	SetWindowPos(d, tab->hdwnd, 10, 25, tab->panrect.left+tab->panrect.right, tab->panrect.top+tab->panrect.bottom, SWP_NOZORDER);	
	
	PTAB_ShowPanel(tab, 0);	

	// DoEvents
	MSG		msg;
	if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
	{
		TranslateMessage(&msg);				
		DispatchMessage(&msg);				
	}

	//Sleep(500);

	return 0;
}

// Inserta una ventana ya creada (queno sea un resource dialog)
int PTAB_InsertPanelFromHandle(tPTAB *tab, int PanelIndex, char *text, HWND Handle, DLGPROC DialogProc)
{

	TCITEM tie;

	tie.mask = TCIF_TEXT | TCIF_IMAGE; 
	tie.iImage = -1; 
	tie.pszText = text; 

	TabCtrl_InsertItem(tab->hdwnd, PanelIndex, &tie);	
	
	tab->hdwndChild = tab->DialogHandle[0]; // Siempre se muestra por defecto el primero

	//tab->DialogProc[PanelIndex] = (DLGPROC)DialogProc;
	//tab->DialogResName[PanelIndex] = DlgResourceName;

	//HWND d = CreateDialogIndirect(tab->hInst, tab->Dialog[PanelIndex], tab->hdwnd, (DLGPROC)DialogProc); 			
	tab->DialogHandle[PanelIndex] = Handle; // Store dialog handle

	// Ajustamos la dimension del dialog al panel
	SetWindowPos(Handle, tab->hdwnd, 10, 25, tab->panrect.left+tab->panrect.right, tab->panrect.top+tab->panrect.bottom, SWP_NOZORDER);	

	PTAB_ShowPanel(tab, 0);

	return 0;
}
