/******************************

	Editor I/O
	code: pK

	Carga y Salva proyectos

 ******************************/

bool DoLoadProyect(char *filename)
{

	FILE *in;	
	char id[3];

	igtObjSphere		sphere;
	igtObjTorus			torus;
	igtObjCone			cone;
	igtObjDisc			disc;
	igtObjCylinder		cylinder;
	igtCamera			camera;
	igtVector3	pos;
	igtVector3	rot;

	DDEBUG_Write("Abriendo proyecto");

	if ( (in = fopen(filename, "rb")) == NULL) { return false; }

		fseek(in, 0L, SEEK_END);
		int total_size = ftell(in);
		int curr_offset=0;
		fseek(in, 0L, SEEK_SET);		

		// Cabecera
		curr_offset += fread(&id, 3*sizeof(char), 1, in);		

		if (strcmp(id, "IGT"))
		{			
			DDEBUG_Write("\tEl fichero no es de tipo IGT!");
			MessageBox(GetForegroundWindow(), "El archivo no es un fichero vlido de proyecto o esta corrupto!", "LoadProyect", MB_OK | MB_ICONERROR);
			return false;
		}

		DDEBUG_Write("\tInfo del editor");

		// Posicion y rotacion de la ventana de render
		curr_offset += fread(&GlobalRender_PosicionX, sizeof(float), 1, in);				
		curr_offset += fread(&GlobalRender_PosicionY, sizeof(float), 1, in);				
		curr_offset += fread(&GlobalRender_PosicionZ, sizeof(float), 1, in);				

		curr_offset += fread(&GlobalRender_RotacionX, sizeof(float), 1, in);				
		curr_offset += fread(&GlobalRender_RotacionY, sizeof(float), 1, in);				

		DDEBUG_Write("\tObjetos (tamao fichero: %d bytes, posicion: %d)", total_size, ftell(in));

		bool	done=false;
		char	toDo;
		char	objType;		

		while ( (ftell(in) < total_size) )	// Leemos la informacion de los objetos a generar
		{

			DDEBUG_Write("BUCLE");

			curr_offset += fread(&toDo, sizeof(unsigned char), 1, in); // Que hay que hacer?			
			DDEBUG_Write("\t\tACCION: %d", toDo);

			if (toDo == IGT_CREATE_OBJ) // Crear un objeto
			{
				DDEBUG_Write("Crear objeto");				
				curr_offset += fread(&objType, sizeof(unsigned char), 1, in);  // Que objeto es?				

				/*
					IGT_OBJTYPE_SPHERE
					IGT_OBJTYPE_TORUS
					IGT_OBJTYPE_CONE
					IGT_OBJTYPE_DISC
					IGT_OBJTYPE_CYLINDER
					IGT_OBJTYPE_CAMERA
				*/

				switch (objType)
				{
					case IGT_OBJTYPE_SPHERE:
					{						

						curr_offset += fread(&sphere, sizeof(igtObjSphere), 1, in);				
						curr_offset += fread(&pos, sizeof(igtVector3), 1, in);				
						curr_offset += fread(&rot, sizeof(igtVector3), 1, in);										

						igtAddSphere(&GlobalScene, sphere.radio, sphere.segmentos_alto, sphere.segmentos_ancho);
						SceneInfo_AddSphere(&GlobalSceneInfo, sphere.radio, sphere.segmentos_alto, sphere.segmentos_ancho);

						// Posicion y rotacion
						GlobalScene.Object[GlobalScene.NumObjects-1].Posicion.x = pos.x;
						GlobalScene.Object[GlobalScene.NumObjects-1].Posicion.y = pos.y;
						GlobalScene.Object[GlobalScene.NumObjects-1].Posicion.z = pos.z;

						GlobalScene.Object[GlobalScene.NumObjects-1].Rotacion.x = rot.x;
						GlobalScene.Object[GlobalScene.NumObjects-1].Rotacion.y = rot.y;
						GlobalScene.Object[GlobalScene.NumObjects-1].Rotacion.z = rot.z;

						DDEBUG_Write("Radio: %f, seg1: %d seg2: %d", sphere.radio, sphere.segmentos_alto, sphere.segmentos_ancho);
						DDEBUG_Write("pos: %f, %f, %f", pos.x, pos.y, pos.z);
						DDEBUG_Write("rot: %f, %f, %f", rot.x, rot.y, rot.z);

						EditorSelectedListAdd(EDITOR_TYPE_OBJECT, GlobalScene.NumObjects-1, "Esfera%02d", NumEsferas);
						NumEsferas++;						

					}
					break;

					case IGT_OBJTYPE_TORUS:
					{
						curr_offset += fread(&torus, sizeof(igtObjTorus), 1, in);				
						curr_offset += fread(&pos, sizeof(igtVector3), 1, in);				
						curr_offset += fread(&rot, sizeof(igtVector3), 1, in);				

						igtAddTorus(&GlobalScene, torus.radio_interior, torus.radio_exterior, torus.segmentos_alto, torus.segmentos_ancho);
						SceneInfo_AddTorus(&GlobalSceneInfo, torus.radio_interior, torus.radio_exterior, torus.segmentos_alto, torus.segmentos_ancho);

						// Posicion y rotacion
						GlobalScene.Object[GlobalScene.NumObjects-1].Posicion = pos;
						GlobalScene.Object[GlobalScene.NumObjects-1].Rotacion = rot;
						
						EditorSelectedListAdd(EDITOR_TYPE_OBJECT, GlobalScene.NumObjects-1, "Torus%02d", NumTorus);
						NumTorus++;						
					}
					break;

					case IGT_OBJTYPE_CONE:
					{
						curr_offset += fread(&cone, sizeof(igtObjCone), 1, in);				
						curr_offset += fread(&pos, sizeof(igtVector3), 1, in);				
						curr_offset += fread(&rot, sizeof(igtVector3), 1, in);				

						igtAddCone(&GlobalScene, cone.radio, cone.alto, cone.segmentos_alto, cone.segmentos_ancho);
						//SceneInfo_AddCone(&GlobalSceneInfo, cone.radio, cone.segmentos_alto, cone.segmentos_ancho);

						// Posicion y rotacion
						GlobalScene.Object[GlobalScene.NumObjects-1].Posicion = pos;
						GlobalScene.Object[GlobalScene.NumObjects-1].Rotacion = rot;
						
						EditorSelectedListAdd(EDITOR_TYPE_OBJECT, GlobalScene.NumObjects-1, "Cono%02d", NumConos);
						NumConos++;						
					}
					break;

					case IGT_OBJTYPE_DISC:
					{

					}
					break;

					case IGT_OBJTYPE_CYLINDER:
					{
						curr_offset += fread(&cylinder, sizeof(igtObjCylinder), 1, in);				
						curr_offset += fread(&pos, sizeof(igtVector3), 1, in);				
						curr_offset += fread(&rot, sizeof(igtVector3), 1, in);				

						igtAddCylinder(&GlobalScene, cylinder.radio, cylinder.alto, cylinder.segmentos_alto, cylinder.segmentos_ancho);						

						// Posicion y rotacion
						GlobalScene.Object[GlobalScene.NumObjects-1].Posicion = pos;
						GlobalScene.Object[GlobalScene.NumObjects-1].Rotacion = rot;
						
						EditorSelectedListAdd(EDITOR_TYPE_OBJECT, GlobalScene.NumObjects-1, "Cylindro%02d", NumConos);
						NumConos++;						
					}
					break;

					case IGT_OBJTYPE_CAMERA:
					{

					}
					break;

				}
			}

			DDEBUG_Write("curr_offset: %d", curr_offset);
		}

	fclose(in);

	return true;

}

bool DoSaveProyect(char *filename)
{

	int i;
	FILE *out;

	DDEBUG_Write("Guardando proyecto...");

	if ( (out = fopen(filename, "wb")) == NULL) { return false; }

		// ID del archivo ;)
		fprintf(out, "IGT");

		// Guardamos algunas cosas del editor
		fwrite(&GlobalRender_PosicionX, 1, sizeof(float), out);		// Render: Posicion y rotacion
		fwrite(&GlobalRender_PosicionY, 1, sizeof(float), out);
		fwrite(&GlobalRender_PosicionZ, 1, sizeof(float), out);

		fwrite(&GlobalRender_RotacionX, 1, sizeof(float), out);
		fwrite(&GlobalRender_RotacionY, 1, sizeof(float), out);		

		// Guardamos los objetos en el mismo orden en el que se crearon
		int total_obj = GlobalScene.NumObjects + GlobalScene.NumCameras;
		for (i=0 ; i<total_obj ; i++)
		{
			if (EditorSelectionInfo[i].type == EDITOR_TYPE_OBJECT)
			{
				DDEBUG_Write("Objeto %d:", i);
				if (GlobalScene.Object[EditorSelectionInfo[i].index].type == IGT_OBJTYPE_SPHERE)			
				{
					DDEBUG_Write("Esfera");
					DDEBUG_Write("radio: %f", GlobalSceneInfo.Sphere[EditorSelectionInfo[i].index].radio);					

					fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
					fputc(IGT_OBJTYPE_SPHERE, out); // Tipo de objeto			
					fwrite(&GlobalSceneInfo.Sphere[EditorSelectionInfo[i].index], 1, sizeof(igtObjSphere), out);									// Info del objeto

					fwrite(&GlobalScene.Object[EditorSelectionInfo[i].index].Posicion, 1, sizeof(igtVector3), out);	// Posicion
					fwrite(&GlobalScene.Object[EditorSelectionInfo[i].index].Rotacion, 1, sizeof(igtVector3), out);	// Rotacion				
				}

				if (GlobalScene.Object[EditorSelectionInfo[i].index].type == IGT_OBJTYPE_TORUS)
				{
					DDEBUG_Write("Torus");
					DDEBUG_Write("radio1: %f", GlobalSceneInfo.Torus[EditorSelectionInfo[i].index].radio_exterior);

					fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
					fputc(IGT_OBJTYPE_TORUS, out); // Tipo de objeto			
					fwrite(&GlobalSceneInfo.Torus[EditorSelectionInfo[i].index], 1, sizeof(igtObjTorus), out);	// Info del objeto			

					fwrite(&GlobalScene.Object[EditorSelectionInfo[i].index].Posicion, 1, sizeof(igtVector3), out);	// Posicion
					fwrite(&GlobalScene.Object[EditorSelectionInfo[i].index].Rotacion, 1, sizeof(igtVector3), out);	// Rotacion
				}

				if (GlobalScene.Object[EditorSelectionInfo[i].index].type == IGT_OBJTYPE_CONE)
				{
					DDEBUG_Write("Cono");

					fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
					fputc(IGT_OBJTYPE_CONE, out); // Tipo de objeto			
					fwrite(&GlobalSceneInfo.Cone[EditorSelectionInfo[i].index], 1, sizeof(igtObjCone), out);	// Info del objeto

					fwrite(&GlobalScene.Object[EditorSelectionInfo[i].index].Posicion, 1, sizeof(igtVector3), out);	// Posicion
					fwrite(&GlobalScene.Object[EditorSelectionInfo[i].index].Rotacion, 1, sizeof(igtVector3), out);	// Rotacion
				}
			}
		}

/*
		// Ahora guardamos la info de todos los objetos
		for (i=0 ; i<GlobalSceneInfo.NumEsferas ; i++)
		{

			DDEBUG_Write("\t\tEsfera%02d", i);

			fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
			fputc(IGT_OBJTYPE_SPHERE, out); // Tipo de objeto			
			fwrite(&GlobalSceneInfo.Sphere[i], 1, sizeof(igtObjSphere), out);									// Info del objeto

			fwrite(&GlobalScene.Object[GlobalSceneInfo.Sphere[i].index].Posicion, 1, sizeof(igtVector3), out);	// Posicion
			fwrite(&GlobalScene.Object[GlobalSceneInfo.Sphere[i].index].Rotacion, 1, sizeof(igtVector3), out);	// Rotacion

		}

		for (i=0 ; i<GlobalSceneInfo.NumTorus ; i++)
		{
			fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
			fputc(IGT_OBJTYPE_TORUS, out); // Tipo de objeto			
			fwrite(&GlobalSceneInfo.Torus[i], 1, sizeof(igtObjTorus), out);	// Info del objeto			

			fwrite(&GlobalScene.Object[GlobalSceneInfo.Torus[i].index].Posicion, 1, sizeof(igtVector3), out);	// Posicion
			fwrite(&GlobalScene.Object[GlobalSceneInfo.Torus[i].index].Rotacion, 1, sizeof(igtVector3), out);	// Rotacion
		}

		for (i=0 ; i<GlobalSceneInfo.NumConos ; i++)
		{
			fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
			fputc(IGT_OBJTYPE_CONE, out); // Tipo de objeto			
			fwrite(&GlobalSceneInfo.Cone[i], 1, sizeof(igtObjCone), out);	// Info del objeto

			fwrite(&GlobalScene.Object[GlobalSceneInfo.Cone[i].index].Posicion, 1, sizeof(igtVector3), out);	// Posicion
			fwrite(&GlobalScene.Object[GlobalSceneInfo.Cone[i].index].Rotacion, 1, sizeof(igtVector3), out);	// Rotacion
		}

		for (i=0 ; i<GlobalSceneInfo.NumDiscos ; i++)
		{
			fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
			fputc(IGT_OBJTYPE_DISC, out); // Tipo de objeto			
			fwrite(&GlobalSceneInfo.Disc[i], 1, sizeof(igtObjDisc), out);	// Info del objeto

			fwrite(&GlobalScene.Object[GlobalSceneInfo.Disc[i].index].Posicion, 1, sizeof(igtVector3), out);	// Posicion
			fwrite(&GlobalScene.Object[GlobalSceneInfo.Disc[i].index].Rotacion, 1, sizeof(igtVector3), out);	// Rotacion
		}

		for (i=0 ; i<GlobalSceneInfo.NumCilindros ; i++)
		{
			fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
			fputc(IGT_OBJTYPE_CYLINDER, out); // Tipo de objeto			
			fwrite(&GlobalSceneInfo.Cylinder[i], 1, sizeof(igtObjCylinder), out);	// Info del objeto

			fwrite(&GlobalScene.Object[GlobalSceneInfo.Cylinder[i].index].Posicion, 1, sizeof(igtVector3), out);	// Posicion
			fwrite(&GlobalScene.Object[GlobalSceneInfo.Cylinder[i].index].Rotacion, 1, sizeof(igtVector3), out);	// Rotacion
		}

		// Camaras
		for (i=0 ; i<GlobalSceneInfo.NumCamaras ; i++)
		{
			fputc(IGT_CREATE_OBJ, out); // Creamos un objeto
			fputc(IGT_OBJTYPE_CAMERA, out); // Tipo de objeto			
			fwrite(&GlobalSceneInfo.Camera[i], 1, sizeof(igtCamera), out);	// Info del objeto

			fwrite(&GlobalScene.Camera[GlobalSceneInfo.Camera[i].index].Position, 1, sizeof(igtVector3), out);	// Posicion
			fwrite(&GlobalScene.Camera[GlobalSceneInfo.Camera[i].index].Target, 1, sizeof(igtVector3), out);	// Objetivo
		}
*/
	fclose(out);

	return true;

}

bool DoExport_ASC(char *filename)
{

	int i;
	int j;
	FILE *out;

	DDEBUG_Write("Guardando proyecto...");

	if ( (out = fopen(filename, "w+")) == NULL) { return false; }

		// ID del archivo ;)
		fprintf(out, "IGT Scene\n");

		// Ahora guardamos la info de todos los objetos
		for (i=0 ; i<GlobalScene.NumObjects; i++)
		{
			
			fprintf(out, "\nObjeto%02d\n", i);

			fprintf(out, "Vertices: %d\n", GlobalScene.Object[i].NumVertex);
			for (j=0 ; j<GlobalScene.Object[i].NumVertex ; j++)
			{
				fprintf(out, "%f %f %f\n", GlobalScene.Object[i].Vertex[j].x, GlobalScene.Object[i].Vertex[j].y, GlobalScene.Object[i].Vertex[j].z);
			}

			fprintf(out, "\nNormales: %d\n", GlobalScene.Object[i].NumVertex);
			for (j=0 ; j<GlobalScene.Object[i].NumVertex ; j++)
			{
				fprintf(out, "%f %f %f\n", GlobalScene.Object[i].Normal[j].x, GlobalScene.Object[i].Normal[j].y, GlobalScene.Object[i].Normal[j].z);
			}

			fprintf(out, "\nUV: %d\n", GlobalScene.Object[i].NumVertex);
			for (j=0 ; j<GlobalScene.Object[i].NumVertex ; j++)
			{
				fprintf(out, "%f %f\n", GlobalScene.Object[i].TexCoord[j].x, GlobalScene.Object[i].TexCoord[j].y);
			}

		}

	fclose(out);

	return true;

}