/**************************************************

	64kb Intro Generation Tool
	Base structure

 **************************************************/

#ifndef _BASE3D_H_
	#define _BASE3D_H_

#include <math.h>

// Acciones a realizar
#define	IGT_CREATE_OBJ				0		// Crear un objeto

// Tipos de objeto
#define IGT_OBJTYPE_SPHERE			0
#define IGT_OBJTYPE_TORUS			1
#define IGT_OBJTYPE_CONE			2
#define IGT_OBJTYPE_DISC			3
#define IGT_OBJTYPE_CYLINDER		4
#define IGT_OBJTYPE_PLANE			5
#define IGT_OBJTYPE_TERRAIN			6
#define IGT_OBJTYPE_CUBE			7
#define IGT_OBJTYPE_CAMERA			8

#define M_2PI 6.283185307179586476925286766559
#define M_PI 3.141592653589793238462643383279

typedef unsigned short int WORD;
typedef unsigned long int DWORD;
typedef unsigned char BYTE;

typedef struct
{
	float x;
	float y;	

} igtVector2;

typedef struct
{
	float x;
	float y;
	float z;

} igtVector3;

typedef struct
{

	DWORD time;
	igtVector3	v;

} igtKeyframe3;

// Importante clase de interpolacion
class CSpline
{
	public:
		CSpline(); // Contructor
		~CSpline(); // Destructor

		bool			AddKey(DWORD uTime, igtVector3 p);		
		void			ModifyKey(DWORD uTime, igtVector3 v);
		int				GetKeyCount();							// Devuelve el numero de keys totales
		igtKeyframe3	GetKey(int index);						// Devuelve un key

		int				GenerateCurve(int DivFactor);			// Genera la curva. Devuelve el numero total de puntos interpolados
		int				GetCurveCount();						// Devuelve el total de puntos en la curva
		igtVector3		GetCurve(int index);					// Devuelve un valor de la curva (unitario)

	private:
		int				numKeys;
		igtKeyframe3	*key;			// Puntos a interpolar

		int				curvePoints;	// numero de puntos en la curva
		igtKeyframe3	*curve;			// puntos de la curva interpolada

		float Interpolate(float a, float b, float x);		// Interpolacion (de momento lineal... :P)
};

typedef struct
{

	char type;				// Tipo de objeto

	int			NumVertex;
	igtVector3	*Vertex;
	igtVector3	*Normal;	
	igtVector2	*TexCoord;	

	int			NumFaces;
	int			*Faces;

	igtVector3	Posicion;
	igtVector3	Rotacion;

	// Splines de animacion
	CSpline		kPosicion;
	CSpline		kRotacion;
	CSpline		kScale;

} igtObject;

typedef struct
{

	int			index;		// Indice del objeto en el array geometrico

	igtVector3	Position;
	igtVector3	Target;

} igtCamera;

typedef struct
{

	int			index;

	float radio;
	char segmentos_alto;
	char segmentos_ancho;

} igtObjSphere;

typedef struct
{

	int			index;

	float radio_interior;
	float radio_exterior;
	char segmentos_alto;
	char segmentos_ancho;

} igtObjTorus;

typedef struct
{

	int			index;

	float radio;
	float alto;
	char segmentos_alto;
	char segmentos_ancho;

} igtObjCone;

typedef struct
{

	int			index;

	float radio;
	char segmentos;

} igtObjDisc;

typedef struct
{
	int			index;

	float radio;
	float alto;
	char segmentos_alto;
	char segmentos_ancho;

} igtObjCylinder;

typedef struct
{

	// Objetos geometricos
	int			NumObjects;	
	igtObject	*Object;				// Objetos geometricos

	int			NumCameras;				// Numero de camaras en la escena
	igtCamera	*Camera;				// Camaras, obiamente X)

} igtScene;

// Informacion para generar los objetos
typedef struct
{

	// Objetos NO geometricos
	int				NumEsferas;
	igtObjSphere	*Sphere;

	int				NumTorus;
	igtObjTorus		*Torus;

	int				NumConos;
	igtObjCone		*Cone;

	int				NumDiscos;
	igtObjDisc		*Disc;

	int				NumCilindros;
	igtObjCylinder	*Cylinder;

	// Objetos dinmicos
	int				NumCamaras;
	igtCamera		*Camera;

} igtSceneInfo;

#endif // _BASE3D_H_